/*
 * Decompiled with CFR 0.152.
 */
package circuit;

import circuit.Circuit;
import circuit.Common;
import circuit.Part;
import edu.davidson.tools.SApplet;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;

public class Battery
extends Part {
    public Battery(SApplet sApplet, Circuit circuit, int n, int n2, int n3, int n4) {
        super(sApplet, circuit, n, n2, n3, n4);
        this.label = "V";
        this.voltRMS = 10.0;
        this.showV = true;
        this.showZ = false;
    }

    void drawLabel(Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.label == null) {
            return;
        }
        Font font = graphics.getFont();
        graphics.setFont(this.f);
        graphics.setColor(Color.black);
        graphics.drawString(this.label, n - 4, n2 + 5);
        graphics.setFont(font);
    }

    void drawSymbol(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        graphics.setColor(this.color);
        double d = n3 - n;
        double d2 = -(n4 - n2);
        double d3 = Math.sqrt(d * d + d2 * d2);
        if (d3 < (double)2) {
            return;
        }
        double d4 = d3 / 2.0 - (double)8;
        int n6 = (int)((double)n + d * d4 / d3);
        int n7 = (int)((double)n2 - d2 * d4 / d3);
        int n8 = (int)((double)n3 - d * d4 / d3);
        int n9 = (int)((double)n4 + d2 * d4 / d3);
        graphics.drawLine(n, n2, n6, n7);
        graphics.drawLine(n3, n4, n8, n9);
        d4 = (double)n5 / 10.0;
        double d5 = d4 * d / d3;
        double d6 = -(d4 * d2 / d3);
        graphics.drawLine((int)((double)n6 - 1.8 * d6), (int)((double)n7 + 1.8 * d5), (int)((double)n6 + 1.8 * d6), (int)((double)n7 - 1.8 * d5));
        graphics.drawLine((int)((double)n8 - d6), (int)((double)n9 + d5), (int)((double)n8 + d6), (int)((double)n9 - d5));
        Font font = graphics.getFont();
        graphics.setFont(this.f);
        graphics.setColor(Color.black);
        if (this.i1 * this.i1 + this.j1 * this.j1 < this.i2 * this.i2 + this.j2 * this.j2) {
            graphics.drawString("+", (int)((double)n6 - d6 - (double)14), (int)((double)n7 + d5) - 6);
        } else {
            graphics.drawString("+", (int)((double)n6 - d6), (int)((double)n7 + d5));
        }
        graphics.setFont(font);
    }

    String getHint() {
        if (this.customHint != null) {
            return this.customHint;
        }
        String string = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Common.BATTERY_EMF))).append(this.format.form(this.voltRMS)).append(" V")));
        return string;
    }
}

