/*
 * Decompiled with CFR 0.152.
 */
package circuit;

import circuit.Circuit;
import circuit.Part;
import edu.davidson.tools.SApplet;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;

public class Capacitor
extends Part {
    public Capacitor(SApplet sApplet, Circuit circuit, int n, int n2, int n3, int n4) {
        super(sApplet, circuit, n, n2, n3, n4);
        this.label = "C";
        this.voltRMS = 0.0;
        this.showC = true;
        this.showV = true;
        this.showR = false;
        this.showZ = false;
        this.showL = false;
    }

    void drawLabel(Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.label == null) {
            return;
        }
        Font font = graphics.getFont();
        graphics.setFont(this.f);
        graphics.setColor(Color.black);
        graphics.drawString(this.label, n - 4, n2 + 5);
        graphics.setFont(font);
    }

    void drawSymbol(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        graphics.setColor(this.color);
        double d = n3 - n;
        double d2 = -(n4 - n2);
        double d3 = Math.sqrt(d * d + d2 * d2);
        if (d3 < (double)2) {
            return;
        }
        double d4 = d3 / 2.0 - (double)6;
        int n6 = (int)((double)n + d * d4 / d3);
        int n7 = (int)((double)n2 - d2 * d4 / d3);
        int n8 = (int)((double)n3 - d * d4 / d3);
        int n9 = (int)((double)n4 + d2 * d4 / d3);
        graphics.drawLine(n, n2, n6, n7);
        graphics.drawLine(n3, n4, n8, n9);
        d4 = (double)n5 / 8.0;
        double d5 = d4 * d / d3;
        double d6 = -(d4 * d2 / d3);
        graphics.drawLine((int)((double)n6 - d6), (int)((double)n7 + d5), (int)((double)n6 + d6), (int)((double)n7 - d5));
        graphics.drawLine((int)((double)n8 - d6), (int)((double)n9 + d5), (int)((double)n8 + d6), (int)((double)n9 - d5));
    }
}

