/*
 * Decompiled with CFR 0.152.
 */
package circuit;

import circuit.Ammeter;
import circuit.Battery;
import circuit.Capacitor;
import circuit.Circuit_mouseMotionAdapter;
import circuit.Inductor;
import circuit.OnOffSwitch;
import circuit.Part;
import circuit.Resistor;
import circuit.SineWave;
import circuit.Transformer;
import circuit.Voltmeter;
import circuit.Wire;
import edu.davidson.graphics.HintPanel;
import edu.davidson.tools.SApplet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.image.ImageObserver;
import java.util.Vector;

public final class Circuit
extends HintPanel {
    private Image osi = null;
    private boolean osiInvalid = true;
    private int iwidth = 0;
    private int iheight = 0;
    private int xOffset;
    private int yOffset;
    private int pixPerCell = 60;
    private int preferredPixPerCell = 60;
    private int iGrid = 3;
    private int jGrid = 3;
    private Vector parts = new Vector();
    private int maxNumber = 50;
    private boolean noPreferredSize = false;
    SApplet owner;
    Boolean showV = null;
    Boolean showCurrent = null;
    Boolean showPhase = null;
    Boolean showF = null;
    Boolean showR = null;
    Boolean showC = null;
    Boolean showL = null;
    Boolean showZ = null;
    Vector dataSources = new Vector();

    public Circuit(SApplet sApplet) {
        this.owner = sApplet;
        ((Component)((Object)this)).addMouseMotionListener(new Circuit_mouseMotionAdapter(this));
        ((Component)((Object)this)).setBackground(new Color(225, 225, 225));
    }

    public Battery addBattery(int n, int n2, int n3, int n4) {
        if (this.parts.size() >= this.maxNumber) {
            return null;
        }
        Battery battery = new Battery(this.owner, this, n, n2, n3, n4);
        this.parts.addElement(battery);
        this.osiInvalid = true;
        ((Component)((Object)this)).repaint();
        this.setShowInfo(battery);
        return battery;
    }

    public Resistor addResistor(int n, int n2, int n3, int n4) {
        if (this.parts.size() >= this.maxNumber) {
            return null;
        }
        Resistor resistor = new Resistor(this.owner, this, n, n2, n3, n4);
        this.parts.addElement(resistor);
        this.osiInvalid = true;
        ((Component)((Object)this)).repaint();
        this.setShowInfo(resistor);
        return resistor;
    }

    public Capacitor addCapacitor(int n, int n2, int n3, int n4) {
        if (this.parts.size() >= this.maxNumber) {
            return null;
        }
        Capacitor capacitor = new Capacitor(this.owner, this, n, n2, n3, n4);
        this.parts.addElement(capacitor);
        this.osiInvalid = true;
        ((Component)((Object)this)).repaint();
        this.setShowInfo(capacitor);
        return capacitor;
    }

    public SineWave addSineWave(int n, int n2, int n3, int n4) {
        if (this.parts.size() >= this.maxNumber) {
            return null;
        }
        SineWave sineWave = new SineWave(this.owner, this, n, n2, n3, n4);
        this.parts.addElement(sineWave);
        this.osiInvalid = true;
        ((Component)((Object)this)).repaint();
        this.setShowInfo(sineWave);
        return sineWave;
    }

    public OnOffSwitch addOnOffSwitch(int n, int n2, int n3, int n4) {
        if (this.parts.size() >= this.maxNumber) {
            return null;
        }
        OnOffSwitch onOffSwitch = new OnOffSwitch(this.owner, this, n, n2, n3, n4);
        this.parts.addElement(onOffSwitch);
        this.osiInvalid = true;
        ((Component)((Object)this)).repaint();
        this.setShowInfo(onOffSwitch);
        return onOffSwitch;
    }

    public Inductor addInductor(int n, int n2, int n3, int n4) {
        if (this.parts.size() >= this.maxNumber) {
            return null;
        }
        Inductor inductor = new Inductor(this.owner, this, n, n2, n3, n4);
        this.parts.addElement(inductor);
        this.osiInvalid = true;
        ((Component)((Object)this)).repaint();
        this.setShowInfo(inductor);
        return inductor;
    }

    public Transformer addTransformer(int n, int n2, int n3, int n4, boolean bl) {
        if (this.parts.size() >= this.maxNumber) {
            return null;
        }
        Transformer transformer = new Transformer(this.owner, this, n, n2, n3, n4, bl);
        this.parts.addElement(transformer);
        this.osiInvalid = true;
        ((Component)((Object)this)).repaint();
        this.setShowInfo(transformer);
        return transformer;
    }

    public Part addPart(int n, int n2, int n3, int n4) {
        if (this.parts.size() >= this.maxNumber) {
            return null;
        }
        Part part = new Part(this.owner, this, n, n2, n3, n4);
        this.parts.addElement(part);
        this.osiInvalid = true;
        ((Component)((Object)this)).repaint();
        this.setShowInfo(part);
        return part;
    }

    public Wire addWire(int n, int n2, int n3, int n4) {
        if (this.parts.size() >= this.maxNumber) {
            return null;
        }
        Wire wire = new Wire(this.owner, this, n, n2, n3, n4);
        this.parts.addElement(wire);
        this.osiInvalid = true;
        ((Component)((Object)this)).repaint();
        this.setShowInfo(wire);
        return wire;
    }

    public Voltmeter addVoltmeter(int n, int n2, int n3, int n4) {
        if (this.parts.size() >= this.maxNumber) {
            return null;
        }
        Voltmeter voltmeter = new Voltmeter(this.owner, this, n, n2, n3, n4);
        this.parts.addElement(voltmeter);
        this.osiInvalid = true;
        ((Component)((Object)this)).repaint();
        this.setShowInfo(voltmeter);
        return voltmeter;
    }

    public Ammeter addAmmeter(int n, int n2, int n3, int n4) {
        if (this.parts.size() >= this.maxNumber) {
            return null;
        }
        Ammeter ammeter = new Ammeter(this.owner, this, n, n2, n3, n4);
        this.parts.addElement(ammeter);
        this.osiInvalid = true;
        ((Component)((Object)this)).repaint();
        this.setShowInfo(ammeter);
        return ammeter;
    }

    public Part getPartFromID(int n) {
        for (int i = 0; i < this.parts.size(); ++i) {
            Part part = (Part)this.parts.elementAt(i);
            if (part.getID() != n) continue;
            return part;
        }
        return null;
    }

    public Dimension getMinimumSize() {
        return new Dimension(20 * this.jGrid, 20 * this.iGrid);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.preferredPixPerCell * this.jGrid, this.preferredPixPerCell * this.iGrid);
    }

    Image getOsi() {
        return this.osi;
    }

    void forceRepaint() {
        this.osiInvalid = true;
        ((Component)((Object)this)).repaint();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (this.owner.destroyed) {
            return;
        }
        if (((Component)((Object)this)).getSize().width == 0 || ((Component)((Object)this)).getSize().height == 0) {
            return;
        }
        if (this.osi == null || this.osiInvalid || this.iwidth != ((Component)((Object)this)).getSize().width || this.iheight != ((Component)((Object)this)).getSize().height) {
            this.paintOSI();
        }
        graphics.drawImage(this.osi, 0, 0, (ImageObserver)((Object)this));
        this.paintHint(graphics);
    }

    public void paintGrid(Graphics graphics) {
        if (this.owner.destroyed) {
            return;
        }
        graphics.setColor(Color.black);
        for (int i = 0; i < this.iGrid; ++i) {
            for (int j = 0; j < this.jGrid; ++j) {
                graphics.drawLine(this.xOffset + this.pixPerCell * j, this.yOffset + this.pixPerCell * i, this.xOffset + this.pixPerCell * j, this.yOffset + this.pixPerCell * i);
            }
        }
    }

    public void paintParts(Graphics graphics) {
        if (this.owner.destroyed) {
            return;
        }
        for (int i = 0; i < this.parts.size(); ++i) {
            Part part = (Part)this.parts.elementAt(i);
            part.paint(graphics, this.pixPerCell, this.xOffset, this.yOffset);
        }
    }

    public void paintOSI() {
        if (this.owner.destroyed) {
            return;
        }
        if (this.osi == null || this.iwidth != ((Component)((Object)this)).getSize().width || this.iheight != ((Component)((Object)this)).getSize().height) {
            this.iwidth = ((Component)((Object)this)).getSize().width;
            this.iheight = ((Component)((Object)this)).getSize().height;
            this.osi = ((Component)((Object)this)).createImage(this.iwidth, this.iheight);
        }
        this.pixPerCell = this.preferredPixPerCell;
        if (this.iwidth < this.jGrid * this.pixPerCell) {
            this.pixPerCell = this.iwidth / this.jGrid;
        }
        if (this.iheight < this.iGrid * this.pixPerCell) {
            this.pixPerCell = this.iheight / this.iGrid;
        }
        this.xOffset = (this.iwidth - (this.jGrid - 1) * this.pixPerCell) / 2;
        this.yOffset = (this.iheight - (this.iGrid - 1) * this.pixPerCell) / 2;
        Graphics graphics = this.osi.getGraphics();
        graphics.setColor(((Component)((Object)this)).getBackground());
        graphics.fillRect(0, 0, this.iwidth, this.iheight);
        this.paintParts(graphics);
        graphics.dispose();
        this.osiInvalid = false;
    }

    boolean setBatteryEMF(int n, double d, boolean bl) {
        Part part = this.getPartFromID(n);
        if (part instanceof Battery) {
            part.setVoltRMS(d);
            part.showV = bl;
            return true;
        }
        return false;
    }

    boolean setCapacitance(int n, double d, boolean bl, boolean bl2, boolean bl3) {
        Part part = this.getPartFromID(n);
        if (part instanceof Capacitor) {
            part.setC(d);
            part.showC = bl;
            part.showV = bl2;
            part.showPhase = bl3;
            return true;
        }
        return false;
    }

    boolean setSwitchOn(int n, boolean bl) {
        Part part = this.getPartFromID(n);
        if (part instanceof OnOffSwitch) {
            part.setSwitchOn(bl);
            return true;
        }
        return false;
    }

    boolean setCurrent(int n, double d) {
        Part part = this.getPartFromID(n);
        part.setCurrentRMS(d);
        return true;
    }

    boolean setShowCurrent(int n, boolean bl) {
        Part part = this.getPartFromID(n);
        part.showCurrent = bl;
        return true;
    }

    boolean setPhaseDegree(int n, double d) {
        Part part = this.getPartFromID(n);
        part.setPhaseDegree(d);
        return true;
    }

    boolean setShowPhase(int n, boolean bl) {
        Part part = this.getPartFromID(n);
        part.showPhase = bl;
        return true;
    }

    boolean setVolt(int n, double d) {
        Part part = this.getPartFromID(n);
        part.setVoltRMS(d);
        return true;
    }

    boolean setShowV(int n, boolean bl) {
        Part part = this.getPartFromID(n);
        part.showV = bl;
        return true;
    }

    boolean setInductance(int n, double d, boolean bl, boolean bl2, boolean bl3) {
        Part part = this.getPartFromID(n);
        if (part instanceof Inductor) {
            part.setL(d);
            part.showL = bl;
            part.showV = bl2;
            part.showPhase = bl3;
            return true;
        }
        return false;
    }

    boolean setResistance(int n, double d, boolean bl, boolean bl2, boolean bl3) {
        Part part = this.getPartFromID(n);
        if (part instanceof Resistor) {
            part.setR(d);
            part.showR = bl;
            part.showV = bl2;
            part.showPhase = bl3;
            return true;
        }
        return false;
    }

    boolean setAmmeter(int n, double d, boolean bl) {
        Part part = this.getPartFromID(n);
        if (part instanceof Ammeter) {
            part.setCurrentRMS(d);
            part.showCurrent = bl;
            return true;
        }
        return false;
    }

    boolean setLabel(int n, String string) {
        Part part = this.getPartFromID(n);
        part.setLabel(string);
        return true;
    }

    boolean setHint(int n, String string) {
        Part part = this.getPartFromID(n);
        part.setCustomHint(string);
        return true;
    }

    boolean setMilliAmp(int n, boolean bl) {
        Part part = this.getPartFromID(n);
        part.milliAmp = bl;
        return true;
    }

    boolean setVoltage(int n, double d) {
        Part part = this.getPartFromID(n);
        part.setVoltRMS(d);
        return true;
    }

    boolean setVoltmeter(int n, double d, boolean bl) {
        Part part = this.getPartFromID(n);
        if (part instanceof Voltmeter) {
            part.setVoltRMS(d);
            part.showV = bl;
            return true;
        }
        return false;
    }

    Part isInside(int n, int n2) {
        for (int i = 0; i < this.parts.size(); ++i) {
            Part part = (Part)this.parts.elementAt(i);
            if (!part.isInside(n, n2, this.pixPerCell, this.xOffset, this.yOffset)) continue;
            return part;
        }
        return null;
    }

    void setShowInfo(Part part) {
        if (this.showV != null) {
            part.showV = this.showV;
        }
        if (this.showCurrent != null) {
            part.showCurrent = this.showCurrent;
        }
        if (this.showPhase != null) {
            part.showPhase = this.showPhase;
        }
        if (this.showF != null) {
            part.showF = this.showF;
        }
        if (this.showR != null) {
            part.showR = this.showR;
        }
        if (this.showC != null) {
            part.showC = this.showC;
        }
        if (this.showL != null) {
            part.showL = this.showL;
        }
        if (this.showZ != null) {
            part.showZ = this.showZ;
        }
    }

    void setDefault(int n) {
        this.setDefault();
        this.preferredPixPerCell = n;
    }

    void setDefault() {
        this.updateBubbleHelp(null);
        this.destroyHint();
        this.showV = null;
        this.showCurrent = null;
        this.showPhase = null;
        this.showF = null;
        this.showR = null;
        this.showC = null;
        this.showL = null;
        this.showZ = null;
        this.parts.removeAllElements();
    }

    void setShowV(boolean bl) {
        this.showV = new Boolean(bl);
    }

    void setShowCurrent(boolean bl) {
        this.showCurrent = new Boolean(bl);
    }

    void setShowPhase(boolean bl) {
        this.showPhase = new Boolean(bl);
    }

    void setShowF(boolean bl) {
        this.showPhase = new Boolean(bl);
    }

    void setShowR(boolean bl) {
        this.showR = new Boolean(bl);
    }

    void setShowC(boolean bl) {
        this.showC = new Boolean(bl);
    }

    void setShowL(boolean bl) {
        this.showL = new Boolean(bl);
    }

    void setShowZ(boolean bl) {
        this.showZ = new Boolean(bl);
    }

    void setPreferredPixPerCell(int n) {
        this.pixPerCell = n;
        this.preferredPixPerCell = n;
        ((Container)((Object)this)).invalidate();
        if (((Component)((Object)this)).getParent() != null) {
            ((Component)((Object)this)).getParent().validate();
        } else {
            ((Container)((Object)this)).validate();
        }
    }

    void setGridSize(int n, int n2) {
        this.iGrid = n;
        this.jGrid = n2;
        ((Container)((Object)this)).invalidate();
        if (((Component)((Object)this)).getParent() != null) {
            ((Component)((Object)this)).getParent().validate();
        } else {
            ((Container)((Object)this)).validate();
        }
    }

    void this_mouseMoved(MouseEvent mouseEvent) {
        ((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(1));
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        Part part = this.isInside(n, n2);
        if (part != null) {
            this.updateBubbleHelp(part.getHint());
        } else {
            this.updateBubbleHelp(null);
        }
    }

    void this_mouseDragged(MouseEvent mouseEvent) {
    }
}

