/*
 * Decompiled with CFR 0.152.
 */
package circuit;

import circuit.Ammeter;
import circuit.Battery;
import circuit.Capacitor;
import circuit.Circuit;
import circuit.Common;
import circuit.Inductor;
import circuit.OnOffSwitch;
import circuit.Part;
import circuit.Resistor;
import circuit.SineWave;
import circuit.Transformer;
import circuit.Voltmeter;
import circuit.Wire;
import edu.davidson.graphics.Box;
import edu.davidson.tools.SApplet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;

public final class CircuitApplet
extends SApplet {
    boolean showControls;
    int gridSize;
    int preferredPixPerCell = 80;
    private Circuit circuit = new Circuit(this);
    Box circuitBox = new Box((Component)((Object)this.circuit), Common.CIRCUIT);
    BorderLayout borderLayout1 = new BorderLayout();

    public void destroy() {
        this.circuit.forceBubbleHelp(null);
        super.destroy();
    }

    public void stop() {
        this.oneShotMsg = null;
        this.circuit.forceBubbleHelp(null);
        super.stop();
    }

    public void init() {
        this.initResources(null);
        try {
            this.showControls = Boolean.valueOf(this.getParameter("ShowControls", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.gridSize = Integer.parseInt(this.getParameter("GridSize", "3"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.preferredPixPerCell = Integer.parseInt(this.getParameter("PixPerCell", "30"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.circuitBox.setHint(Common.LEGEND_SELECT);
        this.circuit.setPreferredPixPerCell(this.preferredPixPerCell);
        this.circuit.setGridSize(this.gridSize, this.gridSize);
    }

    private void jbInit() throws Exception {
        ((Component)((Object)this)).setSize(new Dimension(293, 262));
        ((Container)((Object)this)).setLayout(this.borderLayout1);
        this.circuitBox.setTitle(Common.CIRCUIT);
        ((Container)((Object)this)).add((Component)this.circuitBox, "Center");
    }

    public final String getAppletInfo() {
        return "CircuitApplet by Wolfgang Christian, wochristian@davidson.edu";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"showControls", "boolean", "Show onscreen controls"}, {"gridSize", "int", "Number of X-Y Nodes"}, {"elementSize", "int", "Size in pix of one circuit element"}};
        return stringArray;
    }

    public void setDefault() {
        this.oneShotMsg = null;
        this.circuit.setDefault();
        this.circuit.setPreferredPixPerCell(this.preferredPixPerCell);
        this.circuit.setGridSize(this.gridSize, this.gridSize);
    }

    public void setGridSize(int n, int n2) {
        this.circuit.setGridSize(n, n2);
    }

    public void setTitle(String string) {
        this.circuitBox.setTitle(string);
        ((Component)((Object)this)).repaint();
    }

    public int addCapacitor(int n, int n2, int n3, int n4) {
        Capacitor capacitor = this.circuit.addCapacitor(n, n2, n3, n4);
        return capacitor.getID();
    }

    public boolean setCapacitance(int n, double d, boolean bl, boolean bl2, boolean bl3) {
        return this.circuit.setCapacitance(n, d, bl, bl2, bl3);
    }

    public int addInductor(int n, int n2, int n3, int n4) {
        Inductor inductor = this.circuit.addInductor(n, n2, n3, n4);
        return inductor.getID();
    }

    public boolean setInductance(int n, double d, boolean bl, boolean bl2, boolean bl3) {
        return this.circuit.setInductance(n, d, bl, bl2, bl3);
    }

    public int addResistor(int n, int n2, int n3, int n4) {
        Resistor resistor = this.circuit.addResistor(n, n2, n3, n4);
        return resistor.getID();
    }

    public int addPart(int n, int n2, int n3, int n4) {
        Part part = this.circuit.addPart(n, n2, n3, n4);
        return part.getID();
    }

    public boolean setResistance(int n, double d, boolean bl, boolean bl2, boolean bl3) {
        return this.circuit.setResistance(n, d, bl, bl2, bl3);
    }

    public int addBattery(int n, int n2, int n3, int n4) {
        Battery battery = this.circuit.addBattery(n, n2, n3, n4);
        return battery.getID();
    }

    public boolean setBatteryEMF(int n, double d, boolean bl) {
        return this.circuit.setBatteryEMF(n, d, bl);
    }

    public int addAmmeter(int n, int n2, int n3, int n4) {
        Ammeter ammeter = this.circuit.addAmmeter(n, n2, n3, n4);
        return ammeter.getID();
    }

    public boolean setAmmeter(int n, double d, boolean bl) {
        return this.circuit.setAmmeter(n, d, bl);
    }

    public int addVoltmeter(int n, int n2, int n3, int n4) {
        Voltmeter voltmeter = this.circuit.addVoltmeter(n, n2, n3, n4);
        return voltmeter.getID();
    }

    public boolean setVoltmeter(int n, double d, boolean bl) {
        return this.circuit.setVoltmeter(n, d, bl);
    }

    public boolean setVolt(int n, double d) {
        this.circuit.setShowV(n, true);
        return this.circuit.setVolt(n, d);
    }

    public boolean setCurrent(int n, double d) {
        this.circuit.setShowCurrent(n, true);
        return this.circuit.setCurrent(n, d);
    }

    public boolean setPhaseDegree(int n, double d) {
        this.circuit.setShowPhase(n, true);
        return this.circuit.setPhaseDegree(n, d);
    }

    public boolean setLabel(int n, String string) {
        return this.circuit.setLabel(n, string);
    }

    public boolean setHint(int n, String string) {
        return this.circuit.setHint(n, string);
    }

    public boolean setMilliAmp(int n, boolean bl) {
        return this.circuit.setMilliAmp(n, bl);
    }

    public int addOnOffSwitch(int n, int n2, int n3, int n4) {
        OnOffSwitch onOffSwitch = this.circuit.addOnOffSwitch(n, n2, n3, n4);
        return onOffSwitch.getID();
    }

    public boolean setSwitchOn(int n, boolean bl) {
        return this.circuit.setSwitchOn(n, bl);
    }

    public int addTransformer(int n, int n2, int n3, int n4, boolean bl) {
        Transformer transformer = this.circuit.addTransformer(n, n2, n3, n4, bl);
        return transformer.getID();
    }

    public int addWire(int n, int n2, int n3, int n4) {
        Wire wire = this.circuit.addWire(n, n2, n3, n4);
        return wire.getID();
    }

    public int addACSource(int n, int n2, int n3, int n4) {
        SineWave sineWave = this.circuit.addSineWave(n, n2, n3, n4);
        return sineWave.getID();
    }

    public void setPixPerCell(int n) {
        this.preferredPixPerCell = n;
        this.circuit.setPreferredPixPerCell(this.preferredPixPerCell);
    }
}

