/*
 * Decompiled with CFR 0.152.
 */
package circuit;

import circuit.Circuit;
import circuit.Common;
import circuit.IVApplet_checkbox1_itemAdapter;
import circuit.IVApplet_vNumber_actionAdapter;
import circuit.IVApplet_vSlider_adjustmentAdapter;
import circuit.Part;
import edu.davidson.display.SGraph;
import edu.davidson.display.SNumber;
import edu.davidson.display.SSlider;
import edu.davidson.graphics.EtchedBorder;
import edu.davidson.numerics.Parser;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SStepable;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.ItemEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;

public final class IVApplet
extends SApplet
implements SStepable {
    private Parser ivFunc = new Parser(2);
    private Parser phaseFunc = new Parser(1);
    static final double pi = Math.PI;
    static final double pi2 = Math.PI * 2;
    static final double sqrt2;
    double vmin;
    double vmax;
    double freqVal = 60.0;
    double tmax = 3.0 / this.freqVal;
    boolean showControls = true;
    boolean showCheckBox = true;
    boolean showGraph = true;
    boolean defaultCircuit = true;
    boolean showIV = false;
    boolean autoRefresh = true;
    double volt = 1.0;
    int preferredPixPerCell = 60;
    String currentStr = "V";
    String phaseStr = "0";
    EtchedBorder etchedBorder1 = new EtchedBorder();
    EtchedBorder etchedBorder2 = new EtchedBorder();
    SSlider vSlider = new SSlider();
    SNumber vNumber = new SNumber();
    private Circuit circuit = new Circuit(this);
    IVGraph graph = new IVGraph();
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout2 = new BorderLayout();
    BorderLayout borderLayout3 = new BorderLayout();
    private int xold;
    private int yold;
    private Part bat;
    private Part voltmeter;
    private Part ammeter;
    private Part part;
    Panel panel1 = new Panel();
    Label label1 = new Label();
    Checkbox checkbox1 = new Checkbox();

    boolean parseIVFunction() {
        this.ivFunc.defineVariable(1, "v");
        this.ivFunc.defineVariable(2, "f");
        this.ivFunc.define(this.currentStr.toLowerCase());
        this.ivFunc.parse();
        if (this.ivFunc.getErrorCode() != 0) {
            System.out.println("Failed to parse I(V,f): ".concat(String.valueOf(String.valueOf(this.currentStr))));
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Parse error: ").append(this.ivFunc.getErrorString()).append(" at IV function, position ").append(this.ivFunc.getErrorPosition()))));
            return false;
        }
        return true;
    }

    boolean parsePhaseFunction() {
        this.phaseFunc.defineVariable(1, "f");
        this.phaseFunc.define(this.phaseStr.toLowerCase());
        this.phaseFunc.parse();
        if (this.phaseFunc.getErrorCode() != 0) {
            System.out.println("Failed to parse phase(f): ".concat(String.valueOf(String.valueOf(this.phaseStr))));
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Parse error: ").append(this.phaseFunc.getErrorString()).append(" at phase function, position ").append(this.phaseFunc.getErrorPosition()))));
            return false;
        }
        return true;
    }

    void loadResources(String string) {
        if (string == null) {
            return;
        }
        try {
            Common.initResources(new URL(((Applet)((Object)this)).getCodeBase(), string).openStream());
            Common.setResources();
            return;
        }
        catch (Exception exception) {
            try {
                Common.initResources(new URL(((Applet)((Object)this)).getDocumentBase(), string).openStream());
                Common.setResources();
            }
            catch (Exception exception2) {
                System.out.println("Can't load resources! : ".concat(String.valueOf(String.valueOf(exception2.getMessage()))));
                return;
            }
            return;
        }
    }

    public void init() {
        this.initResources(null);
        String string = "";
        double d = 0.1;
        double d2 = 10.0;
        try {
            string = this.getParameter("Resources", "");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (string != null && !string.equals("")) {
            this.loadResources(string);
        }
        try {
            d2 = Double.valueOf(this.getParameter("FPS", "10"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            d = Double.valueOf(this.getParameter("dt", "0.1"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.defaultCircuit = Boolean.valueOf(this.getParameter("DefaultCircuit", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.currentStr = this.getParameter("Current", "2*V");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.phaseStr = this.getParameter("Phase", "0");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.vmin = Double.valueOf(this.getParameter("Vmin", "10"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.vmax = Double.valueOf(this.getParameter("Vmax", "1000"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.showControls = Boolean.valueOf(this.getParameter("ShowControls", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.showGraph = Boolean.valueOf(this.getParameter("ShowGraph", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.preferredPixPerCell = this.showGraph ? 60 : 200;
        try {
            this.showCheckBox = Boolean.valueOf(this.getParameter("ShowCheckBox", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.showIV = Boolean.valueOf(this.getParameter("IVGraphType", "false"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.preferredPixPerCell = Integer.parseInt(this.getParameter("PixPerCell", "".concat(String.valueOf(String.valueOf(this.preferredPixPerCell)))));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.clock.setDt(d);
        this.clock.setFPS((double)((int)d2));
        this.parseIVFunction();
        this.parsePhaseFunction();
        this.checkbox1.setState(!this.showIV);
        this.checkbox1.setVisible(this.showCheckBox);
        this.etchedBorder2.setVisible(this.showControls);
        this.graph.setBorders("0,10,10,5");
        this.graph.setMinMaxX(this.vmin, this.vmax);
        this.graph.setMinMaxY(-1.0, 1.0);
        this.graph.setEnableMouse(true);
        ((Component)((Object)this.graph)).setBackground(Color.white);
        this.vSlider.setDMax(Math.max(Math.abs(this.vmin), Math.abs(this.vmax)));
        this.vSlider.setDMin(0.0);
        this.volt = Math.min(this.volt, this.vmax);
        this.volt = Math.max(this.volt, this.vmin);
        this.vNumber.setValue(this.volt);
        this.vSlider.setDValue(this.volt);
        this.vNumber.addPropertyChangeListener((PropertyChangeListener)this.vSlider);
        this.vSlider.addPropertyChangeListener((PropertyChangeListener)this.vNumber);
        if (this.vmax < (double)10) {
            this.vNumber.setFormat("%6.1f");
        } else {
            this.vNumber.setFormat("%6.0f");
        }
        this.tmax = this.freqVal != 0.0 ? 3.0 / this.freqVal : 1.0;
        this.clock.addClockListener((SStepable)this);
    }

    private void firstTime() {
        if (this.showIV) {
            this.vSlider.setDMax(this.vmax);
            this.vSlider.setDMin(this.vmin);
            this.vSlider.setDValue(this.volt);
            this.graph.setAutoscaleY(true);
            this.graph.setLabelY(Common.CURRENT);
            this.graph.setLabelX(Common.VOLTAGE);
            this.graph.setMinMaxX(this.vmin, this.vmax);
        } else {
            this.volt = Math.abs(this.volt);
            this.vSlider.setDMax(Math.max(Math.abs(this.vmin), Math.abs(this.vmax)));
            this.vSlider.setDMin(0.0);
            this.vSlider.setDValue(this.volt);
            this.graph.setAutoscaleY(false);
            this.graph.setLabelY(Common.VOLTAGE_CURRENT);
            this.graph.setLabelX(Common.TIME);
            this.graph.setMinMaxX(0.0, this.tmax);
            this.graph.setMinMaxY(Math.min(1.1 * this.findYMin(), 0.9 * this.findYMin()), Math.max(1.2 * this.findYMax(), 0.8 * this.findYMax()));
        }
        if (this.defaultCircuit) {
            this.createCircuit();
            this.setCircuitValues();
            this.plotFunction();
            ((Component)((Object)this.graph)).setVisible(this.showGraph);
        } else {
            this.circuit.setPreferredPixPerCell(this.preferredPixPerCell);
            this.circuit.setGridSize(3, 2);
            this.showGraph = false;
            ((Component)((Object)this.graph)).setVisible(false);
        }
        this.graph.setOwner(this);
        this.graph.repaint();
    }

    private void jbInit() throws Exception {
        ((Component)((Object)this)).setBackground(Color.lightGray);
        ((Component)((Object)this)).setSize(new Dimension(740, 390));
        this.vSlider.setDMax(10.0);
        this.vNumber.addActionListener(new IVApplet_vNumber_actionAdapter(this));
        this.vSlider.addAdjustmentListener(new IVApplet_vSlider_adjustmentAdapter(this));
        this.panel1.setBackground(Color.lightGray);
        this.graph.setLabelY(Common.CURRENT);
        this.label1.setAlignment(2);
        this.label1.setText(Common.VOLTAGE);
        this.checkbox1.setLabel(Common.LEGEND_VTIME);
        this.checkbox1.addItemListener(new IVApplet_checkbox1_itemAdapter(this));
        this.graph.setSampleData(false);
        this.graph.setAutoscaleX(false);
        this.graph.setAutoscaleY(false);
        this.graph.setLabelX(Common.VOLTAGE);
        this.etchedBorder2.setLayout(this.borderLayout1);
        this.etchedBorder1.setLayout(this.borderLayout3);
        ((Container)((Object)this)).setLayout(this.borderLayout2);
        ((Container)((Object)this)).add((Component)this.etchedBorder1, "Center");
        this.etchedBorder1.add((Component)((Object)this.circuit), "West");
        this.etchedBorder1.add((Component)((Object)this.graph), "Center");
        ((Container)((Object)this)).add((Component)this.etchedBorder2, "South");
        this.etchedBorder2.add((Component)this.vSlider, "Center");
        this.etchedBorder2.add((Component)this.vNumber, "East");
        this.etchedBorder2.add((Component)this.panel1, "West");
        this.panel1.add((Component)this.checkbox1, null);
        this.panel1.add((Component)this.label1, null);
    }

    public void destroy() {
        this.circuit.forceBubbleHelp(null);
        this.graph.destroy();
        super.destroy();
    }

    public void start() {
        if (this.firstTime) {
            this.firstTime = false;
            this.firstTime();
        } else {
            this.graph.repaint();
        }
        super.start();
    }

    public void stop() {
        this.oneShotMsg = null;
        this.circuit.forceBubbleHelp(null);
        super.stop();
    }

    public void forward() {
        this.circuit.forceBubbleHelp(null);
        super.forward();
    }

    protected void stoppingClock() {
        this.circuit.forceBubbleHelp(this.oneShotMsg);
    }

    protected void cyclingClock() {
        this.clock.setTime(0.0);
        this.part.setTime(0.0);
        this.clearAllData();
    }

    public final String getAppletInfo() {
        return "IVApplet by Wolfgang Christian, wochristian@davidson.edu";
    }

    public final int getUnknownID() {
        return this.part.getID();
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"Current", "String", "Current: I(V,f)"}, {"Phase", "String", "Phase: P(f)"}, {"Vmin", "double", "Minimum voltage"}, {"VMax", "double", "Maximum voltage."}, {"ShowControls", "boolean", "Show the slider."}, {"ShowCheckBox", "boolean", "Show the check box."}, {"IVGraphType", "boolean", "Plot I(V) graph instead of I(t) and V(t)."}};
        return stringArray;
    }

    private void createCircuit() {
        this.circuit.setPreferredPixPerCell(this.preferredPixPerCell);
        this.circuit.setGridSize(3, 2);
        this.bat = this.circuit.addSineWave(0, 0, 0, 1);
        this.bat.setVoltRMS(this.volt);
        this.bat.showPhase = false;
        this.bat.showF = false;
        this.bat.showV = false;
        this.part = this.circuit.addPart(1, 0, 1, 1);
        this.part.setLabel("  ?");
        this.part.showR = false;
        this.part.showV = false;
        this.part.showZ = false;
        this.part.showPhase = false;
        this.circuit.addWire(0, 0, 1, 0);
        this.ammeter = this.circuit.addAmmeter(0, 1, 1, 1);
        this.circuit.addWire(1, 0, 2, 0);
        this.circuit.addWire(1, 1, 2, 1);
        this.voltmeter = this.circuit.addVoltmeter(2, 0, 2, 1);
        if (this.freqVal == 0.0) {
            this.bat.setLabel(" ".concat(String.valueOf(String.valueOf(Common.LEGEND_V))));
            this.ammeter.setLabel(Common.LEGEND_A);
            this.voltmeter.setLabel(Common.LEGEND_V);
            this.bat.showF = false;
        } else {
            this.bat.setLabel(Common.LEGEND_VAC);
            this.ammeter.setLabel(Common.LEGEND_A);
            this.voltmeter.setLabel(Common.LEGEND_V);
            this.bat.showF = true;
        }
    }

    private void setCircuitValues() {
        if (this.bat == null) {
            return;
        }
        double d = this.phaseFunc.evaluate(this.freqVal);
        this.bat.setVoltRMS(this.volt);
        this.bat.setF(this.freqVal);
        this.part.setVoltRMS(this.volt);
        this.voltmeter.setVoltRMS(this.volt);
        this.ammeter.setCurrentRMS(this.calcCurrentRMS());
        double d2 = this.clock.getTime();
        double d3 = Math.PI * 2 * this.freqVal;
        double d4 = this.part.getPhaseRadian();
        double d5 = this.volt * sqrt2 * Math.sin(d3 * d2 - d);
        double d6 = this.ivFunc.evaluate(sqrt2 * this.volt * Math.sin(d3 * d2), this.freqVal);
        this.part.setTime(d2);
        this.part.setVoltInstantaneous(d5);
        this.part.setCurrentInstantaneous(d6);
        this.part.setPhaseRadian(d);
    }

    final double calcCurrentRMS() {
        double d;
        if (this.freqVal == 0.0) {
            return this.ivFunc.evaluate(this.volt, this.freqVal);
        }
        double d2 = sqrt2 * this.volt;
        int n = 32;
        double d3 = 1.0 / ((double)n - 1.0);
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = d = this.ivFunc.evaluate(d5, this.freqVal);
        for (int i = 0; i < n - 2; ++i) {
            d5 = d2 * Math.sin(Math.PI * 2 * (d4 += d3));
            d = this.ivFunc.evaluate(d5, this.freqVal);
            d6 += d * d;
        }
        d6 = Math.sqrt(d6 / (double)(n - 1));
        return d6;
    }

    final void plotFunction() {
        if (this.showIV) {
            this.plotIV();
        } else {
            this.plotV();
        }
    }

    public void step(double d, double d2) {
        double d3 = Math.PI * 2 * this.freqVal * d2;
        if (this.part == null) {
            return;
        }
        double d4 = this.part.getPhaseRadian();
        double d5 = this.volt * sqrt2 * Math.sin(d3 - this.part.getPhaseRadian());
        double d6 = this.ivFunc.evaluate(sqrt2 * this.volt * Math.sin(d3), this.freqVal);
        this.part.setTime(d2);
        this.part.setVoltInstantaneous(d5);
        this.part.setCurrentInstantaneous(d6);
        this.updateDataConnections();
    }

    final void plotV() {
        int n = 200;
        double d = this.tmax / (double)(n - 1);
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        double d2 = Math.PI * 2 * this.freqVal;
        double d3 = this.phaseFunc.evaluate(this.freqVal);
        for (int i = 0; i < n; ++i) {
            dArray[i] = (double)i * d;
            dArray2[i] = this.volt * sqrt2 * Math.sin(d2 * dArray[i] - d3);
            dArray3[i] = this.ivFunc.evaluate(sqrt2 * this.volt * Math.sin(d2 * dArray[i]), this.freqVal);
        }
        this.graph.setAutoReplaceData(1, true);
        this.graph.setAutoReplaceData(2, true);
        this.graph.clearSeriesData(1);
        this.graph.clearSeriesData(2);
        this.graph.addData(1, dArray, dArray2);
        this.graph.addData(2, dArray, dArray3);
        this.graph.setSeriesStyle(1, Color.black, true, 0);
        this.graph.setSeriesStyle(2, Color.red, true, 0);
        this.graph.setSeriesLegend(1, Color.black, 75, 20, Common.LEGEND_V);
        this.graph.setSeriesLegend(2, Color.red, 125, 20, Common.LEGEND_I);
    }

    double findYMax() {
        double d = this.ivFunc.evaluate(0.0, this.freqVal);
        d = Math.max(d, this.ivFunc.evaluate(this.vmin, this.freqVal));
        d = Math.max(d, this.ivFunc.evaluate(this.vmax, this.freqVal));
        d = Math.max(d, this.ivFunc.evaluate(-this.vmin, this.freqVal));
        d = Math.max(d, this.ivFunc.evaluate(-this.vmax, this.freqVal));
        d = Math.max(d, -this.vmax);
        return Math.max(d * sqrt2, this.vmax * sqrt2);
    }

    double findYMin() {
        double d = this.ivFunc.evaluate(0.0, this.freqVal);
        d = Math.min(d, this.ivFunc.evaluate(this.vmin, this.freqVal));
        d = Math.min(d, this.ivFunc.evaluate(this.vmax, this.freqVal));
        d = Math.min(d, this.ivFunc.evaluate(-this.vmin, this.freqVal));
        d = Math.min(d, this.ivFunc.evaluate(-this.vmax, this.freqVal));
        d = Math.min(d, -this.vmax);
        return Math.min(d * sqrt2, this.vmax * sqrt2);
    }

    void plotIV() {
        int n = 200;
        double d = (this.vmax - this.vmin) / (double)(n - 1);
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.vmin + (double)i * d;
            dArray2[i] = this.ivFunc.evaluate(dArray[i], this.freqVal);
        }
        this.graph.clearSeriesData(1);
        this.graph.clearSeriesData(2);
        this.graph.addData(1, dArray, dArray2);
        this.graph.setSeriesStyle(1, Color.red, true, 0);
        this.xold = -100;
        this.yold = -100;
    }

    void adjustVoltage(double d) {
        this.volt = d;
        if (this.volt < this.vmin) {
            this.volt = this.vmin;
            this.vSlider.setDValue(this.volt);
        }
        if (this.volt > this.vmax) {
            this.volt = this.vmax;
            this.vSlider.setDValue(this.volt);
        }
        this.setCircuitValues();
        if (!this.showIV) {
            this.plotV();
            return;
        }
        int n = this.graph.pixFromX(this.volt);
        int n2 = this.graph.pixFromY(this.ivFunc.evaluate(this.volt, this.freqVal));
        Graphics graphics = ((Component)((Object)this.graph)).getGraphics();
        graphics.setColor(Color.green);
        graphics.setXORMode(Color.red);
        graphics.fillOval(this.xold - 5, this.yold - 5, 10, 10);
        graphics.fillOval(n - 5, n2 - 5, 10, 10);
        this.xold = n;
        this.yold = n2;
        graphics.setPaintMode();
        graphics.dispose();
    }

    void vSlider_adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.adjustVoltage(this.vSlider.getDValue());
    }

    void vNumber_actionPerformed(ActionEvent actionEvent) {
        if (this.vNumber.isValid()) {
            this.adjustVoltage(this.vNumber.getValue());
        }
    }

    public void setSourceVoltage(double d, boolean bl) {
        this.volt = d;
        this.bat.showV = bl;
        this.adjustVoltage(this.volt);
    }

    public void setDefault() {
        this.oneShotMsg = null;
        this.deleteDataConnections();
        this.clock.stopClock();
        this.clock.setTime(0.0);
        this.freqVal = 60.0;
        this.tmax = 3.0 / this.freqVal;
        this.phaseStr = "0";
        this.parsePhaseFunction();
        this.currentStr = "0";
        this.parseIVFunction();
        this.circuit.setDefault(this.preferredPixPerCell);
        this.createCircuit();
        this.setCircuitValues();
        this.graph.setTitle(null);
        ((Component)((Object)this.graph)).setVisible(this.showGraph);
        if (this.autoRefresh) {
            this.setShowIV(this.showIV);
        }
    }

    public void setAutoRefresh(boolean bl) {
        if (this.autoRefresh == bl) {
            return;
        }
        this.autoRefresh = bl;
        this.graph.setAutoRefresh(bl);
        if (this.autoRefresh) {
            this.setShowIV(this.showIV);
        }
    }

    public void setTitle(String string) {
        this.graph.setTitle(string);
    }

    public void setCurrentFunction(String string) {
        this.currentStr = string;
        this.parseIVFunction();
        this.setCircuitValues();
        if (this.autoRefresh) {
            this.setShowIV(this.showIV);
        }
    }

    public void setPhaseFunction(String string) {
        this.phaseStr = string;
        this.parsePhaseFunction();
        this.setCircuitValues();
        if (this.autoRefresh) {
            this.setShowIV(this.showIV);
        }
    }

    public void setVoltage(double d) {
        this.volt = d;
        this.vSlider.setDValue(this.volt);
        this.adjustVoltage(this.volt);
    }

    public void setFrequency(double d) {
        this.freqVal = d;
        if (this.freqVal == 0.0) {
            this.bat.setLabel(" ".concat(String.valueOf(String.valueOf(Common.LEGEND_V))));
            this.ammeter.setLabel(Common.LEGEND_A);
            this.voltmeter.setLabel(Common.LEGEND_V);
            this.bat.showF = false;
        } else {
            this.bat.setLabel(Common.LEGEND_VAC);
            this.ammeter.setLabel(Common.LEGEND_A);
            this.voltmeter.setLabel(Common.LEGEND_V);
            this.bat.showF = true;
        }
        if (this.autoRefresh) {
            this.setShowIV(this.showIV);
        }
    }

    public void setTMax(double d) {
        this.tmax = d;
        if (this.autoRefresh) {
            this.setShowIV(this.showIV);
        }
    }

    public void setShowControls(boolean bl) {
        this.etchedBorder2.setVisible(bl);
    }

    public void setShowCheckBox(boolean bl) {
        this.checkbox1.setVisible(bl);
    }

    public void setShowGraph(boolean bl) {
        if (((Component)((Object)this.graph)).isVisible() == bl) {
            return;
        }
        this.showGraph = bl;
        ((Component)((Object)this.graph)).setVisible(bl);
        ((Container)((Object)this)).invalidate();
        ((Container)((Object)this)).validate();
    }

    public void setPartLabel(String string) {
        this.part.setLabel(string);
    }

    public boolean setPartHint(String string) {
        return this.circuit.setHint(this.part.getID(), string);
    }

    public boolean setVoltmeterHint(String string) {
        return this.circuit.setHint(this.voltmeter.getID(), string);
    }

    public boolean setAmmeterHint(String string) {
        return this.circuit.setHint(this.ammeter.getID(), string);
    }

    public boolean setMilliAmp(boolean bl) {
        return this.circuit.setMilliAmp(this.ammeter.getID(), bl);
    }

    public boolean setACHint(String string) {
        return this.circuit.setHint(this.bat.getID(), string);
    }

    public void setPixPerCell(int n) {
        if (this.preferredPixPerCell == n) {
            return;
        }
        this.preferredPixPerCell = n;
        this.circuit.setPreferredPixPerCell(this.preferredPixPerCell);
    }

    public void setIVGraphType(boolean bl) {
        this.showIV = bl;
        if (this.autoRefresh) {
            this.setShowIV(this.showIV);
        }
    }

    void setShowIV(boolean bl) {
        this.showIV = bl;
        this.graph.setAutoRefresh(false);
        this.graph.deleteSeries(1);
        this.graph.deleteSeries(2);
        if (this.showIV) {
            this.vSlider.setDMinMaxAndValue(this.vmin, this.vmax, this.volt);
            this.graph.setAutoscaleY(true);
            this.xold = -100;
            this.yold = -100;
            this.graph.setLabelY(Common.CURRENT);
            this.graph.setLabelX(Common.VOLTAGE);
            this.graph.setMinMaxX(this.vmin, this.vmax);
            this.graph.setMinMaxY(0.0, this.volt);
        } else {
            this.volt = Math.abs(this.volt);
            this.vSlider.setDMinMaxAndValue(0.0, Math.max(Math.abs(this.vmin), Math.abs(this.vmax)), this.volt);
            this.graph.setAutoscaleY(false);
            this.graph.setLabelY(Common.VOLTAGE_CURRENT);
            this.graph.setLabelX(Common.TIME);
            this.graph.setMinMaxX(0.0, this.tmax);
            this.graph.setMinMaxY(Math.min(1.1 * this.findYMin(), 0.9 * this.findYMin()), Math.max(1.2 * this.findYMax(), 0.8 * this.findYMax()));
        }
        this.setCircuitValues();
        this.plotFunction();
        this.graph.setAutoRefresh(this.autoRefresh);
        this.graph.repaint();
    }

    void checkbox1_itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.setShowIV(false);
        } else {
            this.setShowIV(true);
        }
    }

    static {
        pi = Math.PI;
        pi2 = Math.PI * 2;
        sqrt2 = Math.sqrt(2.0);
    }

    class IVGraph
    extends SGraph {
        IVGraph() {
        }

        public void paintLast(Graphics graphics, Rectangle rectangle) {
            super.paintLast(graphics, rectangle);
            if (!IVApplet.this.showIV) {
                return;
            }
            graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(Color.green);
            graphics.setXORMode(Color.red);
            double d = IVApplet.this.vSlider.getDValue();
            IVApplet.this.xold = IVApplet.this.graph.pixFromX(d);
            IVApplet.this.yold = IVApplet.this.graph.pixFromY(IVApplet.this.ivFunc.evaluate(d, IVApplet.this.freqVal));
            graphics.fillOval(IVApplet.this.xold - 5, IVApplet.this.yold - 5, 10, 10);
            graphics.setPaintMode();
        }
    }
}

