/*
 * Decompiled with CFR 0.152.
 */
package circuit;

import circuit.Ammeter;
import circuit.Battery;
import circuit.Capacitor;
import circuit.Circuit;
import circuit.Common;
import circuit.IZApplet_checkbox1_itemAdapter;
import circuit.IZApplet_fNumber_actionAdapter;
import circuit.IZApplet_fSlider_adjustmentAdapter;
import circuit.Inductor;
import circuit.OnOffSwitch;
import circuit.Part;
import circuit.Resistor;
import circuit.SineWave;
import circuit.Transformer;
import circuit.Voltmeter;
import circuit.Wire;
import edu.davidson.display.SGraph;
import edu.davidson.display.SNumber;
import edu.davidson.display.SSlider;
import edu.davidson.graphics.EtchedBorder;
import edu.davidson.numerics.Parser;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SStepable;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.ItemEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;

public final class IZApplet
extends SApplet
implements SStepable {
    static final double pi = Math.PI;
    static final double pi2 = Math.PI * 2;
    static final double sqrt2;
    private Parser ivFunc = new Parser(2);
    private Parser phaseFunc = new Parser(1);
    private String labelY = null;
    double fmin;
    double fmax;
    double imax = 10.0;
    double freqVal = 60.0;
    double tmax = 0.1;
    boolean showControls = true;
    boolean showCheckBox = true;
    boolean showGraph = true;
    boolean showVoltage = true;
    boolean showCurrent = true;
    boolean customCircuit = false;
    boolean autoRefresh = true;
    boolean defaultCircuit = true;
    boolean showIF = false;
    double volt = 10.0;
    int preferredPixPerCell = 60;
    boolean showAmmeterPhase = false;
    String currentStr = "V";
    String phaseStr = "0";
    EtchedBorder etchedBorder1 = new EtchedBorder();
    EtchedBorder etchedBorder2 = new EtchedBorder();
    SSlider fSlider = new SSlider();
    SNumber fNumber = new SNumber();
    private Circuit circuit = new Circuit(this);
    IZGraph graph = new IZGraph();
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout2 = new BorderLayout();
    BorderLayout borderLayout3 = new BorderLayout();
    private int xold;
    private int yold;
    private Part bat;
    private Part voltmeter;
    private Part ammeter;
    private Part part;
    Panel panel1 = new Panel();
    Label label1 = new Label();
    Checkbox checkbox1 = new Checkbox();

    boolean parseIVFunction() {
        this.ivFunc.defineVariable(1, "v");
        this.ivFunc.defineVariable(2, "f");
        this.ivFunc.define(this.currentStr.toLowerCase());
        this.ivFunc.parse();
        if (this.ivFunc.getErrorCode() != 0) {
            System.out.println("Failed to parse I(V,f): ".concat(String.valueOf(String.valueOf(this.currentStr))));
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Parse error: ").append(this.ivFunc.getErrorString()).append(" at IV function, position ").append(this.ivFunc.getErrorPosition()))));
            return false;
        }
        this.setCircuitValues();
        this.calcCurrentIMax();
        return true;
    }

    boolean parsePhaseFunction() {
        this.phaseFunc.defineVariable(1, "f");
        this.phaseFunc.define(this.phaseStr.toLowerCase());
        this.phaseFunc.parse();
        if (this.phaseFunc.getErrorCode() != 0) {
            System.out.println("Failed to parse phase(f): ".concat(String.valueOf(String.valueOf(this.phaseStr))));
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Parse error: ").append(this.phaseFunc.getErrorString()).append(" at phase function, position ").append(this.phaseFunc.getErrorPosition()))));
            return false;
        }
        this.setCircuitValues();
        this.calcCurrentIMax();
        return true;
    }

    private void firstTime() {
        this.graph.setBorders("0,10,10,5");
        this.graph.setMinMaxX(this.fmin, this.fmax);
        this.graph.setMinMaxY(-1.0, 1.0);
        this.graph.setEnableMouse(true);
        ((Component)((Object)this.graph)).setBackground(Color.white);
        if (this.showIF) {
            this.fSlider.setDMinMaxAndValue(this.fmin, this.fmax, this.freqVal);
            this.graph.setAutoscaleY(true);
            if (this.labelY == null) {
                this.graph.setLabelY(Common.CURRENT);
            } else {
                this.graph.setLabelY(this.labelY);
            }
            this.graph.setLabelX(Common.FREQUENCY);
            this.graph.setMinMaxX(this.fmin, this.fmax);
        } else {
            this.volt = Math.abs(this.volt);
            this.fSlider.setDMinMaxAndValue(this.fmin, this.fmax, this.freqVal);
            this.graph.setAutoscaleY(false);
            if (this.labelY == null) {
                this.graph.setLabelY(Common.VOLTAGE_CURRENT);
            } else {
                this.graph.setLabelY(this.labelY);
            }
            this.graph.setLabelX(Common.TIME);
            this.graph.setMinMaxX(0.0, this.tmax);
            this.graph.setMinMaxY(Math.min(1.1 * this.findYMin(), 0.9 * this.findYMin()), Math.max(1.2 * this.findYMax(), 0.8 * this.findYMax()));
        }
        if (this.defaultCircuit) {
            this.createCircuit();
            this.setCircuitValues();
            this.plotFunction();
            ((Component)((Object)this.graph)).setVisible(this.showGraph);
        } else {
            this.circuit.setPreferredPixPerCell(this.preferredPixPerCell);
            this.circuit.setGridSize(3, 2);
            this.showGraph = false;
            ((Component)((Object)this.graph)).setVisible(false);
        }
        this.graph.setOwner(this);
        this.graph.repaint();
    }

    public void init() {
        this.initResources(null);
        double d = 0.1;
        double d2 = 10.0;
        String string = "";
        try {
            string = this.getParameter("Resources", "");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (string != null && !string.equals("")) {
            this.loadResources(string);
        }
        try {
            d2 = Double.valueOf(this.getParameter("FPS", "10"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            d = Double.valueOf(this.getParameter("dt", "0.1"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.defaultCircuit = Boolean.valueOf(this.getParameter("DefaultCircuit", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.currentStr = this.getParameter("Current", "2*V");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.phaseStr = this.getParameter("Phase", "0");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.fmin = Double.valueOf(this.getParameter("Fmin", "10"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.fmax = Double.valueOf(this.getParameter("Fmax", "500"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.showControls = Boolean.valueOf(this.getParameter("ShowControls", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.showGraph = Boolean.valueOf(this.getParameter("ShowGraph", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.preferredPixPerCell = this.showGraph ? 60 : 200;
        try {
            this.showCheckBox = Boolean.valueOf(this.getParameter("ShowCheckBox", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.showIF = Boolean.valueOf(this.getParameter("ImpedanceGraphType", "false"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.preferredPixPerCell = Integer.parseInt(this.getParameter("PixPerCell", "".concat(String.valueOf(String.valueOf(this.preferredPixPerCell)))));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.clock.setDt(d);
        this.clock.setFPS((double)((int)d2));
        this.fSlider.setDMax(this.fmax);
        this.fSlider.setDMin(this.fmin);
        this.freqVal = (this.fmax + this.fmin) / (double)2;
        this.fNumber.setValue(this.freqVal);
        this.fSlider.setDValue(this.freqVal);
        this.tmax = 10.0 / this.fmax;
        this.parseIVFunction();
        this.parsePhaseFunction();
        this.checkbox1.setState(!this.showIF);
        this.checkbox1.setVisible(this.showCheckBox);
        this.etchedBorder2.setVisible(this.showControls);
        this.fNumber.addPropertyChangeListener((PropertyChangeListener)this.fSlider);
        this.fSlider.addPropertyChangeListener((PropertyChangeListener)this.fNumber);
        if (this.fmax < (double)100) {
            this.fNumber.setFormat("%6.1f");
        } else {
            this.fNumber.setFormat("%6.0f");
        }
        this.tmax = this.freqVal != 0.0 ? 3.0 / this.freqVal : 1.0;
        this.clock.addClockListener((SStepable)this);
    }

    private void jbInit() throws Exception {
        ((Component)((Object)this)).setBackground(Color.lightGray);
        ((Component)((Object)this)).setSize(new Dimension(740, 390));
        this.fSlider.setDMax(10.0);
        this.fNumber.addActionListener(new IZApplet_fNumber_actionAdapter(this));
        this.fSlider.addAdjustmentListener(new IZApplet_fSlider_adjustmentAdapter(this));
        this.panel1.setBackground(Color.lightGray);
        this.graph.setLabelY(Common.CURRENT);
        this.label1.setAlignment(2);
        this.label1.setText(Common.FREQUENCY);
        this.checkbox1.setLabel(Common.LEGEND_VTIME);
        this.checkbox1.addItemListener(new IZApplet_checkbox1_itemAdapter(this));
        this.graph.setSampleData(false);
        this.graph.setAutoscaleX(false);
        this.graph.setAutoscaleY(false);
        this.graph.setLabelX(Common.FREQUENCY);
        this.etchedBorder2.setLayout(this.borderLayout1);
        this.etchedBorder1.setLayout(this.borderLayout3);
        ((Container)((Object)this)).setLayout(this.borderLayout2);
        ((Container)((Object)this)).add((Component)this.etchedBorder1, "Center");
        this.etchedBorder1.add((Component)((Object)this.circuit), "West");
        this.etchedBorder1.add((Component)((Object)this.graph), "Center");
        ((Container)((Object)this)).add((Component)this.etchedBorder2, "South");
        this.etchedBorder2.add((Component)this.fSlider, "Center");
        this.etchedBorder2.add((Component)this.fNumber, "East");
        this.etchedBorder2.add((Component)this.panel1, "West");
        this.panel1.add((Component)this.checkbox1, null);
        this.panel1.add((Component)this.label1, null);
    }

    void loadResources(String string) {
        if (string == null) {
            return;
        }
        try {
            Common.initResources(new URL(((Applet)((Object)this)).getCodeBase(), string).openStream());
            Common.setResources();
            return;
        }
        catch (Exception exception) {
            try {
                Common.initResources(new URL(((Applet)((Object)this)).getDocumentBase(), string).openStream());
                Common.setResources();
            }
            catch (Exception exception2) {
                System.out.println("Can't load resources! : ".concat(String.valueOf(String.valueOf(exception2.getMessage()))));
                return;
            }
            return;
        }
    }

    public void destroy() {
        if (this.debugLevel > 127) {
            System.out.println("begin IZApplet destroy");
        }
        this.circuit.forceBubbleHelp(null);
        this.circuit.destroyHint();
        this.graph.destroy();
        super.destroy();
        if (this.debugLevel > 127) {
            System.out.println("end IZApplet destroy");
        }
    }

    public void start() {
        if (this.debugLevel > 127) {
            System.out.println("begin IZApplet start");
        }
        if (this.firstTime) {
            this.firstTime = false;
            this.firstTime();
        } else {
            this.graph.repaint();
        }
        super.start();
        if (this.debugLevel > 127) {
            System.out.println("end IZApplet start");
        }
    }

    public void stop() {
        this.oneShotMsg = null;
        this.circuit.forceBubbleHelp(null);
        super.stop();
    }

    public void forward() {
        this.circuit.forceBubbleHelp(null);
        super.forward();
    }

    protected void stoppingClock() {
        this.circuit.forceBubbleHelp(this.oneShotMsg);
    }

    protected void cyclingClock() {
        this.clock.setTime(0.0);
        this.part.setTime(0.0);
        this.clearAllData();
    }

    public final String getAppletInfo() {
        return "IZApplet by Wolfgang Christian, wochristian@davidson.edu";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"Current", "String", "Current: I(V,f)"}, {"Phase", "String", "Phase: P(f)"}, {"Vmin", "double", "Minimum frequency"}, {"VMax", "double", "Maximum frequency."}, {"ShowControls", "boolean", "Show the slider."}, {"ShowCheckBox", "boolean", "Show the check box."}, {"ImpedanceGraphType", "boolean", "Plot I(f) graph instead of I(t) and V(t)."}};
        return stringArray;
    }

    public final int getUnknownID() {
        return this.part.getID();
    }

    private void createCustomCircuit() {
        this.circuit.setPreferredPixPerCell(this.preferredPixPerCell);
    }

    private void createCircuit() {
        if (this.customCircuit) {
            this.createCustomCircuit();
            return;
        }
        this.circuit.setPreferredPixPerCell(this.preferredPixPerCell);
        this.circuit.setGridSize(3, 2);
        this.bat = this.circuit.addSineWave(0, 0, 0, 1);
        this.bat.setVoltRMS(this.volt);
        this.bat.showPhase = false;
        this.bat.showF = true;
        this.bat.showV = false;
        this.part = this.circuit.addPart(1, 0, 1, 1);
        this.part.setLabel("  ?");
        this.part.showR = false;
        this.part.showV = false;
        this.part.showZ = false;
        this.part.showPhase = false;
        this.circuit.addWire(0, 0, 1, 0);
        this.ammeter = this.circuit.addAmmeter(0, 1, 1, 1);
        if (this.showAmmeterPhase) {
            this.ammeter.showPhase = true;
        }
        this.circuit.addWire(1, 0, 2, 0);
        this.circuit.addWire(1, 1, 2, 1);
        this.voltmeter = this.circuit.addVoltmeter(2, 0, 2, 1);
        if (this.freqVal == 0.0) {
            this.bat.setLabel(" V");
            this.ammeter.setLabel("A");
            this.voltmeter.setLabel("V");
            this.bat.showF = false;
        } else {
            this.bat.setLabel("Vac");
            this.ammeter.setLabel("A");
            this.voltmeter.setLabel("V");
            this.bat.showF = true;
        }
    }

    private void setCircuitValues() {
        if (this.customCircuit) {
            return;
        }
        if (this.bat == null) {
            return;
        }
        this.bat.setVoltRMS(this.volt);
        this.bat.setF(this.freqVal);
        this.voltmeter.setVoltRMS(this.volt);
        this.ammeter.setCurrentRMS(this.calcCurrentRMS());
        this.part.setVoltRMS(this.volt);
        double d = Math.PI * 2 * this.freqVal;
        double d2 = this.clock.getTime();
        double d3 = this.phaseFunc.evaluate(this.freqVal);
        double d4 = this.volt * sqrt2 * Math.sin(d * d2 - d3);
        double d5 = this.ivFunc.evaluate(this.volt * Math.sin(d * d2), this.freqVal);
        this.part.setVoltInstantaneous(d4);
        this.part.setCurrentInstantaneous(d5);
        this.part.setPhaseRadian(d3);
        this.part.setF(this.freqVal);
        if (this.showAmmeterPhase) {
            this.ammeter.setPhaseRadian(this.phaseFunc.evaluate(this.freqVal));
        }
    }

    final void calcCurrentIMax() {
        int n = 200;
        double d = (this.fmax - this.fmin) / (double)(n - 1);
        double d2 = this.fmin;
        this.imax = this.ivFunc.evaluate(this.volt, this.fmin);
        for (int i = 0; i < n; ++i) {
            this.imax = Math.max(this.imax, this.ivFunc.evaluate(this.volt, d2 += d));
        }
    }

    final double calcCurrentRMS() {
        double d;
        if (this.freqVal == 0.0) {
            return this.ivFunc.evaluate(this.volt, this.freqVal);
        }
        int n = 32;
        double d2 = 1.0 / ((double)n - 1.0);
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = d = this.ivFunc.evaluate(d4, this.freqVal);
        for (int i = 0; i < n - 2; ++i) {
            d4 = this.volt * Math.sin(Math.PI * 2 * (d3 += d2));
            d = this.ivFunc.evaluate(d4, this.freqVal);
            d5 += d * d;
        }
        d5 = Math.sqrt(d5 / (double)(n - 1));
        return d5;
    }

    public void step(double d, double d2) {
        if (this.part == null) {
            return;
        }
        double d3 = Math.PI * 2 * this.freqVal;
        double d4 = this.part.getPhaseRadian();
        double d5 = sqrt2 * this.volt * Math.sin(d3 * d2 - d4);
        double d6 = this.ivFunc.evaluate(sqrt2 * this.volt * Math.sin(d3 * d2), this.freqVal);
        this.part.setTime(d2);
        this.part.setVoltInstantaneous(d5);
        this.part.setCurrentInstantaneous(d6);
        this.updateDataConnections();
    }

    final void plotFunction() {
        if (this.showIF) {
            this.plotIF();
        } else {
            this.plotIT();
        }
    }

    final void plotIT() {
        int n = 200;
        double d = this.tmax / (double)(n - 1);
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        double d2 = Math.PI * 2 * this.freqVal;
        double d3 = this.phaseFunc.evaluate(this.freqVal);
        for (int i = 0; i < n; ++i) {
            dArray[i] = (double)i * d;
            dArray2[i] = this.volt * sqrt2 * Math.sin(d2 * dArray[i] - d3);
            dArray3[i] = this.ivFunc.evaluate(sqrt2 * this.volt * Math.sin(d2 * dArray[i]), this.freqVal);
        }
        this.graph.setAutoReplaceData(1, true);
        this.graph.setAutoReplaceData(2, true);
        this.graph.clearSeriesData(1);
        this.graph.clearSeriesData(2);
        if (this.showVoltage) {
            this.graph.addData(1, dArray, dArray2);
            this.graph.setSeriesStyle(1, Color.black, true, 0);
            if (this.labelY == null) {
                this.graph.setSeriesLegend(1, Color.black, 75, 20, Common.LEGEND_V);
            }
        }
        if (this.showCurrent) {
            this.graph.addData(2, dArray, dArray3);
            this.graph.setSeriesStyle(2, Color.red, true, 0);
            if (this.labelY == null) {
                this.graph.setSeriesLegend(2, Color.red, 125, 20, Common.LEGEND_I);
            }
        }
    }

    double findYMax() {
        double d = Math.abs(this.imax);
        return Math.max(d * sqrt2, this.volt * sqrt2);
    }

    double findYMin() {
        double d = -Math.abs(this.imax);
        return Math.min(d * sqrt2, -this.volt * sqrt2);
    }

    void plotIF() {
        int n = 200;
        double d = (this.fmax - this.fmin) / (double)(n - 1);
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.fmin + (double)i * d;
            dArray2[i] = this.ivFunc.evaluate(this.volt, dArray[i]);
        }
        this.graph.clearSeriesData(1);
        this.graph.clearSeriesData(2);
        this.graph.addData(1, dArray, dArray2);
        this.graph.setSeriesStyle(1, Color.red, true, 0);
        this.xold = -100;
        this.yold = -100;
    }

    void adjustFreq(double d) {
        this.freqVal = d;
        if (this.freqVal < this.fmin) {
            this.freqVal = this.fmin;
            this.fSlider.setDValue(this.freqVal);
        }
        if (this.freqVal > this.fmax) {
            this.freqVal = this.fmax;
            this.fSlider.setDValue(this.freqVal);
        }
        this.clock.setTime(0.0);
        this.clearAllData();
        this.setCircuitValues();
        if (!this.showIF) {
            this.plotIT();
            return;
        }
        int n = this.graph.pixFromX(this.freqVal);
        int n2 = this.graph.pixFromY(this.ivFunc.evaluate(this.volt, this.freqVal));
        Graphics graphics = ((Component)((Object)this.graph)).getGraphics();
        graphics.setColor(Color.green);
        graphics.setXORMode(Color.red);
        graphics.fillOval(this.xold - 5, this.yold - 5, 10, 10);
        graphics.fillOval(n - 5, n2 - 5, 10, 10);
        this.xold = n;
        this.yold = n2;
        graphics.setPaintMode();
        graphics.dispose();
    }

    void fSlider_adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.adjustFreq(this.fSlider.getDValue());
    }

    void fNumber_actionPerformed(ActionEvent actionEvent) {
        if (this.fNumber.isValid()) {
            this.adjustFreq(this.fNumber.getValue());
        }
    }

    public void setSourceVoltage(double d, boolean bl) {
        this.volt = d;
        this.bat.showV = bl;
        this.adjustFreq(this.freqVal);
    }

    public void setCustomCircuit(int n) {
        this.autoRefresh = false;
        this.customCircuit = true;
        this.setPixPerCell(n);
        this.setDefault();
    }

    public void setDefault() {
        this.oneShotMsg = null;
        this.deleteDataConnections();
        this.clock.stopClock();
        this.clock.setTime(0.0);
        this.labelY = null;
        this.showCurrent = true;
        this.showVoltage = true;
        this.phaseStr = "0";
        this.parsePhaseFunction();
        this.currentStr = "0";
        this.parseIVFunction();
        this.circuit.setDefault(this.preferredPixPerCell);
        this.createCircuit();
        this.setCircuitValues();
        this.graph.setTitle(null);
        if (((Component)((Object)this.graph)).isVisible() != this.showGraph) {
            ((Component)((Object)this.graph)).setVisible(this.showGraph);
        }
        if (this.autoRefresh) {
            this.setShowIF(this.showIF);
        }
    }

    public void setCurrentFunction(String string) {
        this.currentStr = string;
        this.parseIVFunction();
        if (this.autoRefresh) {
            this.setShowIF(this.showIF);
        }
    }

    public void setPhaseFunction(String string) {
        this.phaseStr = string;
        this.parsePhaseFunction();
        if (this.autoRefresh) {
            this.setShowIF(this.showIF);
        }
    }

    public void setVoltage(double d) {
        this.volt = d;
        this.calcCurrentIMax();
        this.adjustFreq(this.freqVal);
    }

    public void setFrequency(double d) {
        this.freqVal = d;
        this.fSlider.setDValue(d);
        if (this.customCircuit || this.ammeter == null) {
            this.adjustFreq(d);
            if (this.autoRefresh) {
                this.setShowIF(this.showIF);
            }
            return;
        }
        if (this.freqVal == 0.0) {
            this.bat.setLabel(" V");
            this.ammeter.setLabel("A");
            this.voltmeter.setLabel("V");
            this.bat.showF = false;
        } else {
            this.bat.setLabel("Vac");
            this.ammeter.setLabel("A");
            this.voltmeter.setLabel("V");
            this.bat.showF = true;
        }
        this.adjustFreq(d);
        if (this.autoRefresh) {
            this.setShowIF(this.showIF);
        }
    }

    public void setTitle(String string) {
        this.graph.setTitle(string);
    }

    public void setTMax(double d) {
        this.tmax = d;
        if (this.autoRefresh) {
            this.setShowIF(this.showIF);
        }
    }

    public void setShowControls(boolean bl) {
        this.etchedBorder2.setVisible(bl);
    }

    public void setShowCheckBox(boolean bl) {
        this.checkbox1.setVisible(bl);
    }

    public void setShowGraph(boolean bl) {
        if (((Component)((Object)this.graph)).isVisible() == bl) {
            return;
        }
        this.showGraph = bl;
        ((Component)((Object)this.graph)).setVisible(bl);
        ((Container)((Object)this)).invalidate();
        ((Container)((Object)this)).validate();
    }

    public void setPartLabel(String string) {
        this.part.setLabel(string);
    }

    public void setPartHint(String string) {
        this.part.setCustomHint(string);
    }

    public void setShowAmmeterPhase(boolean bl) {
        this.showAmmeterPhase = bl;
        if (this.ammeter != null) {
            this.ammeter.showPhase = bl;
        }
    }

    public void setPixPerCell(int n) {
        if (this.preferredPixPerCell == n) {
            return;
        }
        this.preferredPixPerCell = n;
        this.circuit.setPreferredPixPerCell(this.preferredPixPerCell);
    }

    public void setShowCurrent(boolean bl) {
        this.showCurrent = bl;
        this.plotFunction();
    }

    public void setShowVoltage(boolean bl) {
        this.showVoltage = bl;
        this.plotFunction();
    }

    public void setImpedanceGraphType(boolean bl) {
        this.showIF = bl;
        if (this.autoRefresh) {
            this.setShowIF(this.showIF);
        }
    }

    void setShowIF(boolean bl) {
        this.showIF = bl;
        this.graph.setAutoRefresh(false);
        this.graph.deleteSeries(1);
        this.graph.deleteSeries(2);
        if (this.showIF) {
            this.fSlider.setDMinMaxAndValue(this.fmin, this.fmax, this.freqVal);
            this.graph.setAutoscaleY(true);
            this.xold = -100;
            this.yold = -100;
            if (this.labelY == null) {
                this.graph.setLabelY(Common.CURRENT);
            } else {
                this.graph.setLabelY(this.labelY);
            }
            this.graph.setLabelX(Common.FREQUENCY);
            this.graph.setMinMaxX(this.fmin, this.fmax);
            this.graph.setMinMaxY(0.0, this.volt);
        } else {
            this.volt = Math.abs(this.volt);
            this.fSlider.setDMinMaxAndValue(this.fmin, this.fmax, this.freqVal);
            this.graph.setAutoscaleY(false);
            if (this.labelY == null) {
                this.graph.setLabelY(Common.VOLTAGE_CURRENT);
            } else {
                this.graph.setLabelY(this.labelY);
            }
            this.graph.setLabelX(Common.TIME);
            this.graph.setMinMaxX(0.0, this.tmax);
            this.graph.setMinMaxY(Math.min(1.1 * this.findYMin(), 0.9 * this.findYMin()), Math.max(1.2 * this.findYMax(), 0.8 * this.findYMax()));
        }
        this.setCircuitValues();
        this.plotFunction();
        this.graph.setAutoRefresh(this.autoRefresh);
        this.graph.repaint();
    }

    void checkbox1_itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.setShowIF(false);
        } else {
            this.setShowIF(true);
        }
    }

    public void setGridSize(int n, int n2) {
        this.circuit.setGridSize(n, n2);
    }

    public int addCapacitor(int n, int n2, int n3, int n4) {
        Capacitor capacitor = this.circuit.addCapacitor(n, n2, n3, n4);
        return capacitor.getID();
    }

    public boolean setCapacitance(int n, double d, boolean bl, boolean bl2, boolean bl3) {
        return this.circuit.setCapacitance(n, d, bl, bl2, bl3);
    }

    public int addInductor(int n, int n2, int n3, int n4) {
        Inductor inductor = this.circuit.addInductor(n, n2, n3, n4);
        return inductor.getID();
    }

    public boolean setInductance(int n, double d, boolean bl, boolean bl2, boolean bl3) {
        return this.circuit.setInductance(n, d, bl, bl2, bl3);
    }

    public int addResistor(int n, int n2, int n3, int n4) {
        Resistor resistor = this.circuit.addResistor(n, n2, n3, n4);
        return resistor.getID();
    }

    public boolean setResistance(int n, double d, boolean bl, boolean bl2, boolean bl3) {
        return this.circuit.setResistance(n, d, bl, bl2, bl3);
    }

    public int addPart(int n, int n2, int n3, int n4) {
        Part part = this.circuit.addPart(n, n2, n3, n4);
        return part.getID();
    }

    public int addBattery(int n, int n2, int n3, int n4) {
        Battery battery = this.circuit.addBattery(n, n2, n3, n4);
        return battery.getID();
    }

    public boolean setBatteryEMF(int n, double d, boolean bl) {
        return this.circuit.setBatteryEMF(n, d, bl);
    }

    public int addTransformer(int n, int n2, int n3, int n4, boolean bl) {
        Transformer transformer = this.circuit.addTransformer(n, n2, n3, n4, bl);
        return transformer.getID();
    }

    public int addAmmeter(int n, int n2, int n3, int n4) {
        Ammeter ammeter = this.circuit.addAmmeter(n, n2, n3, n4);
        return ammeter.getID();
    }

    public void setAutoRefresh(boolean bl) {
        if (this.autoRefresh == bl) {
            return;
        }
        this.autoRefresh = bl;
        this.graph.setAutoRefresh(bl);
        if (this.autoRefresh) {
            this.setShowIF(this.showIF);
        }
    }

    public boolean setAmmeter(int n, double d, boolean bl) {
        return this.circuit.setAmmeter(n, d, bl);
    }

    public int addVoltmeter(int n, int n2, int n3, int n4) {
        Voltmeter voltmeter = this.circuit.addVoltmeter(n, n2, n3, n4);
        return voltmeter.getID();
    }

    public int addACSource(int n, int n2, int n3, int n4) {
        SineWave sineWave = this.circuit.addSineWave(n, n2, n3, n4);
        return sineWave.getID();
    }

    public boolean setVoltmeter(int n, double d, boolean bl) {
        this.circuit.setShowV(n, true);
        return this.circuit.setVoltmeter(n, d, bl);
    }

    public boolean setVolt(int n, double d) {
        this.circuit.setShowV(n, true);
        return this.circuit.setVolt(n, d);
    }

    public boolean setPhaseDegree(int n, double d) {
        this.circuit.setShowPhase(n, true);
        return this.circuit.setPhaseDegree(n, d);
    }

    public boolean setCurrent(int n, double d) {
        this.circuit.setShowCurrent(n, true);
        return this.circuit.setCurrent(n, d);
    }

    public boolean setLabel(int n, String string) {
        return this.circuit.setLabel(n, string);
    }

    public boolean setHint(int n, String string) {
        return this.circuit.setHint(n, string);
    }

    public void setGraphLabelY(String string) {
        if (string.equals(this.labelY)) {
            return;
        }
        if (string.trim().equals("") && this.labelY == null) {
            return;
        }
        this.labelY = string.trim().equals("") ? null : string;
        if (this.autoRefresh) {
            this.setShowIF(this.showIF);
        }
    }

    public boolean setMilliAmp(int n, boolean bl) {
        return this.circuit.setMilliAmp(n, bl);
    }

    public int addOnOffSwitch(int n, int n2, int n3, int n4) {
        OnOffSwitch onOffSwitch = this.circuit.addOnOffSwitch(n, n2, n3, n4);
        return onOffSwitch.getID();
    }

    public boolean setSwitchOn(int n, boolean bl) {
        return this.circuit.setSwitchOn(n, bl);
    }

    public int addWire(int n, int n2, int n3, int n4) {
        Wire wire = this.circuit.addWire(n, n2, n3, n4);
        return wire.getID();
    }

    static {
        pi = Math.PI;
        pi2 = Math.PI * 2;
        sqrt2 = Math.sqrt(2.0);
    }

    class IZGraph
    extends SGraph {
        IZGraph() {
        }

        public void paintLast(Graphics graphics, Rectangle rectangle) {
            super.paintLast(graphics, rectangle);
            if (!IZApplet.this.showIF) {
                return;
            }
            graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(Color.green);
            graphics.setXORMode(Color.red);
            double d = IZApplet.this.fSlider.getDValue();
            IZApplet.this.xold = IZApplet.this.graph.pixFromX(d);
            IZApplet.this.yold = IZApplet.this.graph.pixFromY(IZApplet.this.ivFunc.evaluate(IZApplet.this.volt, d));
            graphics.fillOval(IZApplet.this.xold - 5, IZApplet.this.yold - 5, 10, 10);
            graphics.setPaintMode();
        }
    }
}

