/*
 * Decompiled with CFR 0.152.
 */
package circuit;

import circuit.Circuit;
import circuit.Common;
import circuit.LoadApplet_rNumber_actionAdapter;
import circuit.LoadApplet_rSlider_adjustmentAdapter;
import circuit.Part;
import edu.davidson.display.SGraph;
import edu.davidson.display.SNumber;
import edu.davidson.display.SSlider;
import edu.davidson.graphics.Box;
import edu.davidson.graphics.EtchedBorder;
import edu.davidson.tools.SApplet;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;

public class LoadApplet
extends SApplet {
    String currentStr;
    double rmin;
    double rmax;
    boolean showControls = true;
    boolean showGraph = true;
    boolean showPower = false;
    boolean defaultCircuit = true;
    int preferredPixPerCell = 60;
    EtchedBorder etchedBorder1 = new EtchedBorder();
    EtchedBorder etchedBorder2 = new EtchedBorder();
    SSlider rSlider = new SSlider();
    SNumber rNumber = new SNumber();
    private Circuit circuit = new Circuit(this);
    Box circuitBox = new Box((Component)((Object)this.circuit), Common.CIRCUIT);
    LoadGraph graph = new LoadGraph();
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout2 = new BorderLayout();
    BorderLayout borderLayout3 = new BorderLayout();
    Label label1 = new Label();
    private int xold;
    private int yold;
    private Part bat;
    private Part load;
    private Part meter;
    private Part unknown;
    private double loadRes;
    private double unknownRes = 20.0;
    private double batVolt = 12.0;

    public void init() {
        this.initResources(null);
        double d = 0.1;
        double d2 = 10.0;
        String string = "";
        try {
            string = this.getParameter("Resources", "");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (string != null && !string.equals("")) {
            this.loadResources(string);
        }
        try {
            d2 = Double.valueOf(this.getParameter("FPS", "10"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            d = Double.valueOf(this.getParameter("dt", "0.1"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.defaultCircuit = Boolean.valueOf(this.getParameter("DefaultCircuit", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.batVolt = Double.valueOf(this.getParameter("Battery", "12"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.unknownRes = Double.valueOf(this.getParameter("Unknown", "20"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.showGraph = Boolean.valueOf(this.getParameter("ShowGraph", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.preferredPixPerCell = this.showGraph ? 60 : 200;
        try {
            this.rmin = Double.valueOf(this.getParameter("Rmin", "0"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.rmax = Double.valueOf(this.getParameter("Rmax", "100"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.showControls = Boolean.valueOf(this.getParameter("ShowControls", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.showPower = Boolean.valueOf(this.getParameter("PowerGraphType", "false"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.preferredPixPerCell = Integer.parseInt(this.getParameter("PixPerCell", "".concat(String.valueOf(String.valueOf(this.preferredPixPerCell)))));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.clock.setDt(d);
        this.clock.setFPS((double)((int)d2));
        ((Component)((Object)this)).setBackground(Color.lightGray);
        this.etchedBorder2.setVisible(this.showControls);
        if (this.showPower) {
            this.graph.setLabelY(Common.LOAD_POWER);
        } else {
            this.graph.setLabelY(Common.VOLTAGE);
        }
        this.graph.deleteAllSeries();
        this.graph.setMinMaxX(this.rmin, this.rmax);
        this.graph.setMinMaxY(-1.0, 1.0);
        this.graph.setEnableMouse(true);
        ((Component)((Object)this.graph)).setBackground(Color.white);
        this.rSlider.setDMax(this.rmax);
        this.rSlider.setDMin(this.rmin);
        this.loadRes = (this.rmax + this.rmin) / (double)2;
        this.rSlider.setDValue(this.loadRes);
        this.rNumber.setValue(this.loadRes);
        this.loadRes = this.rNumber.getValue();
        this.rNumber.addPropertyChangeListener((PropertyChangeListener)this.rSlider);
        this.rSlider.addPropertyChangeListener((PropertyChangeListener)this.rNumber);
        if (this.rmax < (double)100) {
            this.rNumber.setFormat("%6.1f");
        } else {
            this.rNumber.setFormat("%6.0f");
        }
        if (this.defaultCircuit) {
            this.createCircuit();
            this.setCircuitValues();
            this.plotFunction();
            ((Component)((Object)this.graph)).setVisible(this.showGraph);
        } else {
            this.circuit.setPreferredPixPerCell(this.preferredPixPerCell);
            this.circuit.setGridSize(4, 2);
            this.showGraph = false;
            ((Component)((Object)this.graph)).setVisible(false);
        }
    }

    private void createCircuit() {
        this.circuit.setPreferredPixPerCell(this.preferredPixPerCell);
        this.circuit.setGridSize(4, 2);
        this.bat = this.circuit.addBattery(0, 1, 0, 0);
        this.unknown = this.circuit.addResistor(0, 1, 1, 1);
        this.unknown.setLabel("Rx");
        this.unknown.showR = false;
        this.unknown.showV = true;
        this.circuit.addWire(1, 1, 2, 1);
        this.circuit.addWire(0, 0, 2, 0);
        this.load = this.circuit.addResistor(2, 1, 2, 0);
        this.load.setLabel("Rl");
        this.load.showR = true;
        this.load.showV = true;
        this.circuit.addWire(2, 0, 3, 0);
        this.circuit.addWire(2, 1, 3, 1);
        this.meter = this.circuit.addVoltmeter(3, 0, 3, 1);
    }

    private void setCircuitValues() {
        this.bat.setVoltRMS(this.batVolt);
        this.unknown.setR(this.unknownRes);
        this.load.setR(this.loadRes);
        double d = this.outVolt(this.loadRes);
        double d2 = this.batVolt / (this.unknownRes + this.loadRes);
        this.meter.setVoltRMS(d);
        this.load.setVoltRMS(d);
        this.load.setVoltInstantaneous(d);
        this.load.setCurrentInstantaneous(d2);
        this.unknown.setVoltRMS(this.batVolt - d);
        this.unknown.setVoltInstantaneous(this.batVolt - d);
        this.unknown.setCurrentInstantaneous(d2);
        this.updateDataConnections();
    }

    private void jbInit() throws Exception {
        ((Component)((Object)this)).setBackground(Color.lightGray);
        ((Component)((Object)this)).setSize(new Dimension(740, 390));
        this.rSlider.setDMax(200.0);
        this.rNumber.addActionListener(new LoadApplet_rNumber_actionAdapter(this));
        this.rSlider.addAdjustmentListener(new LoadApplet_rSlider_adjustmentAdapter(this));
        this.circuitBox.setTitle(Common.CIRCUIT);
        this.graph.setLabelY(Common.LOAD_POWER);
        this.label1.setBackground(Color.lightGray);
        this.label1.setAlignment(1);
        this.label1.setText(Common.LOAD_RESISTOR);
        this.graph.setSampleData(false);
        this.graph.setAutoscaleX(false);
        this.graph.setAutoscaleY(true);
        this.graph.setLabelX(Common.LOAD_RESISTOR);
        this.etchedBorder2.setLayout(this.borderLayout1);
        this.etchedBorder1.setLayout(this.borderLayout3);
        ((Container)((Object)this)).setLayout(this.borderLayout2);
        ((Container)((Object)this)).add((Component)this.etchedBorder1, "Center");
        this.etchedBorder1.add((Component)this.circuitBox, "West");
        this.etchedBorder1.add((Component)((Object)this.graph), "Center");
        ((Container)((Object)this)).add((Component)this.etchedBorder2, "South");
        this.etchedBorder2.add((Component)this.rSlider, "Center");
        this.etchedBorder2.add((Component)this.rNumber, "East");
        this.etchedBorder2.add((Component)this.label1, "West");
    }

    void loadResources(String string) {
        if (string == null) {
            return;
        }
        try {
            Common.initResources(new URL(((Applet)((Object)this)).getCodeBase(), string).openStream());
            Common.setResources();
            return;
        }
        catch (Exception exception) {
            try {
                Common.initResources(new URL(((Applet)((Object)this)).getDocumentBase(), string).openStream());
                Common.setResources();
            }
            catch (Exception exception2) {
                System.out.println("Can't load resources! : ".concat(String.valueOf(String.valueOf(exception2.getMessage()))));
                return;
            }
            return;
        }
    }

    public void destroy() {
        this.circuit.forceBubbleHelp(null);
        this.graph.destroy();
        super.destroy();
    }

    public void start() {
        this.graph.setOwner(this);
        this.graph.repaint();
        super.start();
    }

    public void stop() {
        this.oneShotMsg = null;
        this.circuit.forceBubbleHelp(null);
        super.stop();
    }

    public void forward() {
        this.circuit.forceBubbleHelp(null);
        super.forward();
    }

    protected void stoppingClock() {
        this.circuit.forceBubbleHelp(this.oneShotMsg);
    }

    protected void cyclingClock() {
        this.clock.setTime(0.0);
        this.load.setTime(0.0);
        this.unknown.setTime(0.0);
        this.clearAllData();
    }

    public final int getUnknownID() {
        return this.unknown.getID();
    }

    public final int getLoadID() {
        return this.load.getID();
    }

    public final String getAppletInfo() {
        return "LoadApplet by Wolfgang Christian, wochristian@davidson.edu";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"Unknown", "double", "Internal resitance of battery."}, {"Battery", "double", "Battery emf."}, {"Vmin", "double", "Voltage min"}, {"Vmax", "double", "Voltage max"}, {"ShowControls", "boolean", "Show controls."}, {"PowerGraphType", "boolean", "Plot load power as a function of resistance."}};
        return stringArray;
    }

    private double plotFunc(double d) {
        if (this.showPower) {
            return this.batVolt * this.batVolt * d / (d + this.unknownRes) / (d + this.unknownRes);
        }
        return this.batVolt * d / (d + this.unknownRes);
    }

    private double outVolt(double d) {
        return this.batVolt * d / (d + this.unknownRes);
    }

    void plotFunction() {
        int n = 200;
        double d = (this.rmax - this.rmin) / (double)(n - 1);
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.rmin + (double)i * d;
            dArray2[i] = this.plotFunc(dArray[i]);
        }
        this.graph.setAutoReplaceData(3, true);
        this.graph.clearSeriesData(3);
        this.graph.addData(3, dArray, dArray2);
        this.graph.setSeriesStyle(3, Color.red, true, 0);
        this.xold = -100;
        this.yold = -100;
    }

    void adjustLoad(double d) {
        this.loadRes = d;
        if (this.loadRes < this.rmin) {
            this.loadRes = this.rmin;
            this.rSlider.setDValue(this.loadRes);
        }
        if (this.loadRes > this.rmax) {
            this.loadRes = this.rmax;
            this.rSlider.setDValue(this.loadRes);
        }
        double d2 = this.plotFunc(d);
        int n = this.graph.pixFromX(d);
        int n2 = this.graph.pixFromY(d2);
        Graphics graphics = ((Component)((Object)this.graph)).getGraphics();
        graphics.setColor(Color.green);
        graphics.setXORMode(Color.red);
        graphics.fillOval(this.xold - 5, this.yold - 5, 10, 10);
        graphics.fillOval(n - 5, n2 - 5, 10, 10);
        this.xold = n;
        this.yold = n2;
        graphics.setPaintMode();
        graphics.dispose();
        this.setCircuitValues();
    }

    void rSlider_adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.adjustLoad(this.rSlider.getDValue());
    }

    void rNumber_actionPerformed(ActionEvent actionEvent) {
        if (this.rNumber.isValid()) {
            this.adjustLoad(this.rNumber.getValue());
        }
    }

    public void setPixPerCell(int n) {
        this.preferredPixPerCell = n;
        this.circuit.setPreferredPixPerCell(this.preferredPixPerCell);
    }

    public void setDefault() {
        this.oneShotMsg = null;
        this.deleteDataConnections();
        this.circuit.setDefault(this.preferredPixPerCell);
        this.createCircuit();
        this.setCircuitValues();
        this.graph.setTitle(null);
        if (((Component)((Object)this.graph)).isVisible()) {
            this.plotFunction();
        }
    }

    public void setTitle(String string) {
        this.graph.setTitle(string);
    }

    public void setPowerGraphType(boolean bl) {
        this.showPower = bl;
        if (this.showPower) {
            this.graph.setLabelY(Common.LOAD_POWER);
        } else {
            this.graph.setLabelY(Common.VOLTAGE);
        }
        this.plotFunction();
        this.graph.repaint();
    }

    public void setShowGraph(boolean bl) {
        if (((Component)((Object)this.graph)).isVisible() == bl) {
            this.plotFunction();
            return;
        }
        this.showGraph = bl;
        ((Component)((Object)this.graph)).setVisible(bl);
        ((Container)((Object)this)).invalidate();
        ((Container)((Object)this)).validate();
        if (bl) {
            this.plotFunction();
        }
    }

    public void setUnknown(double d) {
        this.unknownRes = d;
        this.setCircuitValues();
        if (((Component)((Object)this.graph)).isVisible()) {
            this.plotFunction();
        }
    }

    public void setVoltage(double d) {
        this.batVolt = d;
        this.setCircuitValues();
        if (((Component)((Object)this.graph)).isVisible()) {
            this.plotFunction();
        }
    }

    public void setLoad(double d) {
        this.rSlider.setDValue(d);
        this.adjustLoad(d);
    }

    public boolean setBatteryHint(String string) {
        return this.circuit.setHint(this.bat.getID(), string);
    }

    public boolean setVoltmeterHint(String string) {
        return this.circuit.setHint(this.meter.getID(), string);
    }

    public boolean setLoadHint(String string) {
        return this.circuit.setHint(this.load.getID(), string);
    }

    public boolean setUnknownHint(String string) {
        return this.circuit.setHint(this.unknown.getID(), string);
    }

    class LoadGraph
    extends SGraph {
        LoadGraph() {
        }

        public void paintLast(Graphics graphics, Rectangle rectangle) {
            super.paintLast(graphics, rectangle);
            graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(Color.green);
            graphics.setXORMode(Color.red);
            double d = LoadApplet.this.rSlider.getDValue();
            LoadApplet.this.xold = LoadApplet.this.graph.pixFromX(d);
            LoadApplet.this.yold = LoadApplet.this.graph.pixFromY(LoadApplet.this.plotFunc(d));
            graphics.fillOval(LoadApplet.this.xold - 5, LoadApplet.this.yold - 5, 10, 10);
            graphics.setPaintMode();
        }
    }
}

