/*
 * Decompiled with CFR 0.152.
 */
package circuit;

import circuit.Circuit;
import circuit.Common;
import circuit.Part;
import edu.davidson.tools.SApplet;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;

public class OnOffSwitch
extends Part {
    public OnOffSwitch(SApplet sApplet, Circuit circuit, int n, int n2, int n3, int n4) {
        super(sApplet, circuit, n, n2, n3, n4);
        this.label = "";
        this.voltRMS = 0.0;
        this.switchOn = false;
        this.showC = false;
        this.showV = false;
        this.showR = false;
        this.showZ = false;
        this.showL = false;
    }

    void drawLabel(Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.label == null) {
            return;
        }
        Font font = graphics.getFont();
        graphics.setFont(this.f);
        graphics.setColor(Color.black);
        if (this.i1 == this.i2) {
            graphics.drawString(this.label, n - 4, n2 + 15);
        } else {
            graphics.drawString(this.label, n - 10, n2);
        }
        graphics.setFont(font);
    }

    void drawSymbol(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        graphics.setColor(this.color);
        double d = n3 - n;
        double d2 = -(n4 - n2);
        double d3 = Math.sqrt(d * d + d2 * d2);
        if (d3 < (double)2) {
            return;
        }
        double d4 = d3 / 2.0 - (double)6;
        int n6 = (int)((double)n + d * d4 / d3);
        int n7 = (int)((double)n2 - d2 * d4 / d3);
        int n8 = (int)((double)n3 - d * d4 / d3);
        int n9 = (int)((double)n4 + d2 * d4 / d3);
        graphics.drawLine(n, n2, n6, n7);
        graphics.drawLine(n3, n4, n8, n9);
        d4 = (double)n5 / 8.0;
        double d5 = d4 * d / d3;
        double d6 = -(d4 * d2 / d3);
        graphics.setColor(Color.red);
        if (this.switchOn) {
            graphics.drawLine(n6, n7, n8, n9);
            if (this.j1 == this.j2) {
                graphics.drawLine(n6 - 1, n7, n8 - 1, n9);
                graphics.drawLine(n6 + 1, n7, n8 + 1, n9);
            } else {
                graphics.drawLine(n6, n7 - 1, n8, n9 - 1);
                graphics.drawLine(n6, n7 + 1, n8, n9 + 1);
            }
            graphics.drawLine(n6, n7, (int)((double)n8 + d6), (int)((double)n9 - d5));
        } else {
            graphics.drawLine(n6, n7, (int)((double)n8 + d6), (int)((double)n9 - d5));
            if (this.j1 == this.j2) {
                graphics.drawLine(n6 - 1, n7, (int)((double)n8 + d6 - 1.0), (int)((double)n9 - d5));
                graphics.drawLine(n6 + 1, n7, (int)((double)n8 + d6 + 1.0), (int)((double)n9 - d5));
            } else {
                graphics.drawLine(n6, n7 - 1, (int)((double)n8 + d6), (int)((double)n9 - d5 - 1.0));
                graphics.drawLine(n6, n7 + 1, (int)((double)n8 + d6), (int)((double)n9 - d5 + 1.0));
            }
        }
    }

    String getHint() {
        if (this.customHint != null) {
            return this.customHint;
        }
        if (this.switchOn) {
            return Common.SWITCH_ON;
        }
        return Common.SWITCH_OFF;
    }
}

