/*
 * Decompiled with CFR 0.152.
 */
package circuit;

import circuit.Circuit;
import circuit.Common;
import circuit.Wire;
import edu.davidson.display.Format;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SDataSource;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;

public class Part
implements SDataSource {
    static char delta = (char)916;
    static char omega = (char)937;
    static char micro = (char)956;
    static char phi = (char)966;
    static char degree = (char)176;
    SApplet owner = null;
    Format format = new Format("%-+6.2f");
    Format format0 = new Format("%-+6.0f");
    Format format1 = new Format("%-+6.1f");
    Format format2 = new Format("%-+6.2f");
    Format format3 = new Format("%-+6.3f");
    Font f = new Font("Helvetica", 1, 12);
    Color color = new Color(0, 127, 0);
    int i1;
    int j1;
    int i2;
    int j2;
    int id = 0;
    String label = "Z";
    String customHint = null;
    boolean showV = false;
    boolean showCurrent = false;
    boolean showPhase = false;
    boolean showF = false;
    boolean showR = false;
    boolean showC = false;
    boolean showL = false;
    boolean showZ = true;
    boolean milliAmp = false;
    boolean switchOn = false;
    String[] varStrings = new String[]{"t", "r", "l", "c", "z", "v", "i", "re", "im", "f"};
    double[][] ds = new double[1][10];
    double voltRMS = 0.0;
    double currentRMS = 0.0;
    double voltInstantaneous = 0.0;
    double currentInstantaneous = 0.0;
    double freq = 1.0;
    double phase = 0.0;
    double radian = 0.0;
    double res = 0.0;
    double cap = 0.0;
    double ind = 0.0;
    double time = 0.0;
    Circuit circuit;

    public Part(SApplet sApplet, Circuit circuit, int n, int n2, int n3, int n4) {
        this.owner = sApplet;
        this.circuit = circuit;
        this.i1 = n;
        this.j1 = n2;
        this.i2 = n3;
        this.j2 = n4;
        try {
            SApplet.addDataSource((Object)this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public int getID() {
        return this.hashCode();
    }

    public void setOwner(SApplet sApplet) {
    }

    public SApplet getOwner() {
        return this.owner;
    }

    public String[] getVarStrings() {
        return this.varStrings;
    }

    public double[][] getVariables() {
        this.ds[0][0] = this.time;
        this.ds[0][1] = this.res;
        this.ds[0][2] = this.ind;
        this.ds[0][3] = this.cap;
        this.ds[0][4] = this.currentRMS == 0.0 ? 0.0 : Math.abs(this.voltRMS / this.currentRMS);
        this.ds[0][5] = this.voltInstantaneous;
        this.ds[0][6] = this.currentInstantaneous;
        this.ds[0][7] = this.ds[0][4] * Math.cos(this.phase);
        this.ds[0][8] = this.ds[0][4] * Math.sin(this.phase);
        this.ds[0][9] = this.freq;
        return this.ds;
    }

    String getMSHint() {
        double d = Math.PI * 2 * this.freq * this.ind;
        double d2 = Math.PI * -2 * this.cap;
        if (d2 != 0.0) {
            d2 = 0.0;
        }
        double d3 = d + d2;
        String string = "";
        if (this.showZ) {
            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("Z=").append(this.format1.form(this.res)).append(" + i").append(this.format1.form(d3)).append(" ").append(" ").append(Common.OHM).append(" "))))));
        }
        if (this.showR) {
            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("R=").append(this.format1.form(this.res)).append(" ").append(" ").append(Common.OHM).append("   "))))));
        }
        if (this.showC) {
            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("C=").append(this.format3.form(this.cap)).append(" ").append(" uF    "))))));
        }
        if (this.showL) {
            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("L=").append(this.format1.form(this.ind)).append(" mH    "))))));
        }
        if (this.showV) {
            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Common.LEGEND_DELTAV))).append(this.format1.form(this.voltRMS)).append(" ").append(Common.LEGEND_V).append("    "))))));
        }
        if (this.showPhase) {
            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Common.PHASE))).append("=").append((int)this.phase).append(" ").append(Common.DEG).append("  "))))));
        }
        if (this.showCurrent) {
            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("I=").append(this.format3.form(this.currentRMS)).append(" ").append(Common.LEGEND_I).append("    "))))));
        }
        if (string.trim().length() == 0) {
            string = Common.LEGEND_NOVALUE;
        }
        if (this instanceof Wire) {
            string = null;
        }
        return string;
    }

    String getHint() {
        if (this.customHint != null) {
            return this.customHint;
        }
        if (Part.isMicrosoft()) {
            return this.getMSHint();
        }
        double d = Math.PI * 2 * this.freq * this.ind;
        double d2 = Math.PI * -2 * this.cap;
        if (d2 != 0.0) {
            d2 = 0.0;
        }
        double d3 = d + d2;
        String string = "";
        if (this.showZ) {
            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("Z=").append(this.format1.form(this.res)).append(" + i").append(this.format1.form(d3)).append(" ").append(omega).append("  "))))));
        }
        if (this.showR) {
            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("R=").append(this.format1.form(this.res)).append(" ").append(omega).append("  "))))));
        }
        if (this.showC) {
            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("C=").append(this.format3.form(this.cap)).append(" ").append(micro).append("F  "))))));
        }
        if (this.showL) {
            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("L=").append(this.format1.form(this.ind)).append(" mH  "))))));
        }
        if (this.showV) {
            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(delta))).append(Common.LEGEND_VEQU).append(this.format1.form(this.voltRMS)).append(" ").append(Common.LEGEND_V).append("  "))))));
        }
        if (this.showPhase) {
            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(phi))).append("=").append((int)this.phase).append(degree).append("  "))))));
        }
        if (this.showCurrent && !this.milliAmp) {
            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("I=").append(this.format3.form(this.currentRMS)).append(" ").append(Common.LEGEND_A).append("  "))))));
        }
        if (this.showCurrent && this.milliAmp) {
            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("I=").append(this.format3.form(this.currentRMS)).append(" m").append(Common.LEGEND_A).append("  "))))));
        }
        if (string.trim().length() == 0) {
            string = Common.LEGEND_NOVALUE;
        }
        if (this instanceof Wire) {
            string = null;
        }
        return string;
    }

    boolean isInside(int n, int n2, int n3, int n4, int n5) {
        int n6 = n4 + n3 * this.j1;
        int n7 = n5 + n3 * this.i1;
        int n8 = n4 + n3 * this.j2;
        int n9 = n5 + n3 * this.i2;
        return Math.abs(n - (n6 + n8) / 2) < n3 / 4 && Math.abs(n2 - (n7 + n9) / 2) < n3 / 4;
    }

    void paint(Graphics graphics, int n, int n2, int n3) {
        int n4 = n2 + n * this.j1;
        int n5 = n3 + n * this.i1;
        int n6 = n2 + n * this.j2;
        int n7 = n3 + n * this.i2;
        this.drawSymbol(graphics, n4, n5, n6, n7, n);
        if (this.i1 == this.i2) {
            this.drawLabel(graphics, (n4 + n6) / 2, (n5 + n7) / 2, -n / 5, -5);
        } else if (this.j1 == this.j2) {
            this.drawLabel(graphics, (n4 + n6) / 2, (n5 + n7) / 2, -8, -5);
        } else {
            this.drawLabel(graphics, (n4 + n6) / 2, (n5 + n7) / 2, -8, -5);
        }
    }

    void drawLabel(Graphics graphics, int n, int n2) {
        this.drawLabel(graphics, n, n2, 0, 0);
    }

    void drawLabel(Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.label == null) {
            return;
        }
        Font font = graphics.getFont();
        graphics.setFont(this.f);
        graphics.setColor(Color.black);
        graphics.drawString(this.label, n + n3, n2 - n4);
        graphics.setFont(font);
    }

    void drawSymbol(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        graphics.setColor(this.color);
        double d = n3 - n;
        double d2 = -(n4 - n2);
        double d3 = Math.sqrt(d * d + d2 * d2);
        if (d3 < (double)2) {
            return;
        }
        double d4 = d3 / 2.0 - (double)n5 / 4.0;
        int n6 = (int)((double)n + d * d4 / d3);
        int n7 = (int)((double)n2 - d2 * d4 / d3);
        int n8 = (int)((double)n3 - d * d4 / d3);
        int n9 = (int)((double)n4 + d2 * d4 / d3);
        graphics.drawLine(n, n2, n6, n7);
        graphics.drawLine(n3, n4, n8, n9);
        d4 = (double)n5 / 8.0;
        double d5 = d4 * d / d3;
        double d6 = -(d4 * d2 / d3);
        graphics.drawLine((int)((double)n6 - d6), (int)((double)n7 + d5), (int)((double)n6 + d6), (int)((double)n7 - d5));
        graphics.drawLine((int)((double)n8 - d6), (int)((double)n9 + d5), (int)((double)n8 + d6), (int)((double)n9 - d5));
        graphics.drawLine((int)((double)n8 - d6), (int)((double)n9 + d5), (int)((double)n6 - d6), (int)((double)n7 + d5));
        graphics.drawLine((int)((double)n8 + d6), (int)((double)n9 - d5), (int)((double)n6 + d6), (int)((double)n7 - d5));
    }

    void setCurrentRMS(double d) {
        this.currentRMS = d;
    }

    double getCurrentRMS() {
        return this.currentRMS;
    }

    void setCurrentInstantaneous(double d) {
        this.currentInstantaneous = d;
    }

    double getCurrentInstantaneous() {
        return this.currentInstantaneous;
    }

    void setVoltRMS(double d) {
        this.voltRMS = d;
    }

    double getVoltRMS() {
        return this.voltRMS;
    }

    void setVoltInstantaneous(double d) {
        this.voltInstantaneous = d;
    }

    double getVoltInstantaneous() {
        return this.voltInstantaneous;
    }

    void setLabel(String string) {
        this.label = string;
        this.circuit.forceRepaint();
    }

    String getLabel() {
        return this.label;
    }

    void setCustomHint(String string) {
        this.customHint = string.trim().equals("") ? null : string;
    }

    String getCustomHint() {
        return this.customHint;
    }

    void setC(double d) {
        this.cap = d;
    }

    double getC() {
        return this.cap;
    }

    void setF(double d) {
        this.freq = d;
    }

    double getF() {
        return this.freq;
    }

    void setL(double d) {
        this.ind = d;
    }

    double getL() {
        return this.ind;
    }

    void setPhaseDegree(double d) {
        this.phase = d;
        this.radian = d * Math.PI / 180.0;
    }

    double getPhaseDegree() {
        return this.phase;
    }

    void setPhaseRadian(double d) {
        this.radian = d;
        this.phase = d * 180.0 / Math.PI;
    }

    double getPhaseRadian() {
        return this.radian;
    }

    void setR(double d) {
        this.res = d;
    }

    double getR() {
        return this.res;
    }

    void setTime(double d) {
        this.time = d;
    }

    double getTime() {
        return this.time;
    }

    final void setMilliAmp(boolean bl) {
        this.milliAmp = bl;
    }

    final void setSwitchOn(boolean bl) {
        this.switchOn = bl;
    }

    public static boolean isMicrosoft() {
        String string = System.getProperty("java.vendor").toLowerCase();
        return string.startsWith("microsoft");
    }
}

