/*
 * Decompiled with CFR 0.152.
 */
package circuit;

import circuit.Circuit;
import circuit.Common;
import circuit.Part;
import circuit.RCApplet_checkbox1_itemAdapter;
import circuit.RCApplet_fNumber_actionAdapter;
import circuit.RCApplet_fSlider_adjustmentAdapter;
import edu.davidson.display.SGraph;
import edu.davidson.display.SNumber;
import edu.davidson.display.SSlider;
import edu.davidson.graphics.Box;
import edu.davidson.graphics.EtchedBorder;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SStepable;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.ItemEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;

public final class RCApplet
extends SApplet
implements SStepable {
    static final double pi = Math.PI;
    static final double pi2 = Math.PI * 2;
    static final double sqrt2;
    double resVal;
    double capVal;
    double xc = 0.0;
    double fmin;
    double fmax;
    double tmax = 0.1;
    double freqVal;
    boolean showControls = true;
    boolean showCheckBox = true;
    boolean showGraph = true;
    boolean defaultCircuit = true;
    boolean showImpedance = false;
    boolean autoRefresh = true;
    int preferredPixPerCell = 60;
    String currentStr;
    EtchedBorder etchedBorder1 = new EtchedBorder();
    EtchedBorder etchedBorder2 = new EtchedBorder();
    SSlider fSlider = new SSlider();
    SNumber fNumber = new SNumber();
    private Circuit circuit = new Circuit(this);
    Box circuitBox = new Box((Component)((Object)this.circuit), Common.CIRCUIT);
    RCGraph graph = new RCGraph();
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout2 = new BorderLayout();
    BorderLayout borderLayout3 = new BorderLayout();
    private int xold;
    private int yold;
    private Part bat;
    private Part cap;
    private Part meter;
    private Part res;
    private double volt = 10.0;
    Panel panel1 = new Panel();
    Label label1 = new Label();
    Checkbox checkbox1 = new Checkbox();

    public void init() {
        this.initResources(null);
        double d = 0.1;
        double d2 = 10.0;
        String string = "";
        try {
            string = this.getParameter("Resources", "");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (string != null && !string.equals("")) {
            this.loadResources(string);
        }
        try {
            d2 = Double.valueOf(this.getParameter("FPS", "10"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            d = Double.valueOf(this.getParameter("dt", "0.1"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.defaultCircuit = Boolean.valueOf(this.getParameter("DefaultCircuit", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.resVal = Double.valueOf(this.getParameter("Resistor", "50"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.capVal = Double.valueOf(this.getParameter("Capacitor", "10"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.fmin = Double.valueOf(this.getParameter("Fmin", "10"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.fmax = Double.valueOf(this.getParameter("FMax", "1000"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.showControls = Boolean.valueOf(this.getParameter("ShowControls", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.showCheckBox = Boolean.valueOf(this.getParameter("ShowCheckBox", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.showImpedance = Boolean.valueOf(this.getParameter("ImpedanceGraphType", "false"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.showGraph = Boolean.valueOf(this.getParameter("ShowGraph", "true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.preferredPixPerCell = this.showGraph ? 60 : 200;
        try {
            this.preferredPixPerCell = Integer.parseInt(this.getParameter("PixPerCell", "".concat(String.valueOf(String.valueOf(this.preferredPixPerCell)))));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.clock.setDt(d);
        this.clock.setFPS((double)((int)d2));
        this.checkbox1.setState(!this.showImpedance);
        this.checkbox1.setVisible(this.showCheckBox);
        this.etchedBorder2.setVisible(this.showControls);
        this.volt *= sqrt2;
        this.capVal *= 1.0E-6;
        this.graph.deleteAllSeries();
        this.graph.setBorders("0,10,10,5");
        this.graph.setMinMaxX(this.fmin, this.fmax);
        this.graph.setMinMaxY(-1.0, 1.0);
        this.graph.setEnableMouse(true);
        ((Component)((Object)this.graph)).setBackground(Color.white);
        this.fSlider.setDMax(this.fmax);
        this.fSlider.setDMin(this.fmin);
        this.freqVal = (this.fmax + this.fmin) / (double)2;
        this.fNumber.setValue(this.freqVal);
        this.fSlider.setDValue(this.freqVal);
        this.fNumber.addPropertyChangeListener((PropertyChangeListener)this.fSlider);
        this.fSlider.addPropertyChangeListener((PropertyChangeListener)this.fNumber);
        if (this.fmax < (double)100) {
            this.fNumber.setFormat("%6.1f");
        } else {
            this.fNumber.setFormat("%6.0f");
        }
        this.tmax = 10.0 / this.fmax;
        if (this.showImpedance) {
            this.graph.setLabelY(Common.CURRENT_RMS_A);
            this.graph.setLabelX(Common.FREQUENCY_HZ);
            this.graph.setMinMaxX(this.fmin, this.fmax);
            this.graph.setMinMaxY(0.0, this.volt / this.resVal);
        } else {
            this.graph.setLabelY(Common.VOLTAGE_V);
            this.graph.setLabelX(Common.TIME_SEC);
            this.graph.setMinMaxX(0.0, this.tmax);
            this.graph.setMinMaxY(-1.1 * this.volt, 1.2 * this.volt);
        }
        if (this.defaultCircuit) {
            this.createCircuit();
            this.setCircuitValues();
            this.plotFunction();
            ((Component)((Object)this.graph)).setVisible(this.showGraph);
        } else {
            this.circuit.setPreferredPixPerCell(this.preferredPixPerCell);
            this.circuit.setGridSize(3, 2);
            this.showGraph = false;
            ((Component)((Object)this.graph)).setVisible(false);
        }
        this.clock.addClockListener((SStepable)this);
    }

    private void jbInit() throws Exception {
        ((Component)((Object)this)).setBackground(Color.lightGray);
        ((Component)((Object)this)).setSize(new Dimension(740, 390));
        this.fSlider.setDMax(200.0);
        this.fNumber.addActionListener(new RCApplet_fNumber_actionAdapter(this));
        this.fSlider.addAdjustmentListener(new RCApplet_fSlider_adjustmentAdapter(this));
        this.circuitBox.setTitle(Common.CIRCUIT);
        this.panel1.setBackground(Color.lightGray);
        this.graph.setLabelY(Common.CURRENT_RMS_A);
        this.label1.setAlignment(2);
        this.label1.setText(Common.FREQUENCY);
        this.checkbox1.setLabel(Common.VOLTAGE);
        this.checkbox1.addItemListener(new RCApplet_checkbox1_itemAdapter(this));
        this.graph.setLabelX(Common.FREQUENCY_HZ);
        this.graph.setSampleData(false);
        this.graph.setAutoscaleX(false);
        this.graph.setAutoscaleY(false);
        this.graph.setLabelX(Common.FREQUENCY);
        this.etchedBorder2.setLayout(this.borderLayout1);
        this.etchedBorder1.setLayout(this.borderLayout3);
        ((Container)((Object)this)).setLayout(this.borderLayout2);
        ((Container)((Object)this)).add((Component)this.etchedBorder1, "Center");
        this.etchedBorder1.add((Component)this.circuitBox, "West");
        this.etchedBorder1.add((Component)((Object)this.graph), "Center");
        ((Container)((Object)this)).add((Component)this.etchedBorder2, "South");
        this.etchedBorder2.add((Component)this.fSlider, "Center");
        this.etchedBorder2.add((Component)this.fNumber, "East");
        this.etchedBorder2.add((Component)this.panel1, "West");
        this.panel1.add((Component)this.checkbox1, null);
        this.panel1.add((Component)this.label1, null);
    }

    void loadResources(String string) {
        if (string == null) {
            return;
        }
        try {
            Common.initResources(new URL(((Applet)((Object)this)).getCodeBase(), string).openStream());
            Common.setResources();
            return;
        }
        catch (Exception exception) {
            try {
                Common.initResources(new URL(((Applet)((Object)this)).getDocumentBase(), string).openStream());
                Common.setResources();
            }
            catch (Exception exception2) {
                System.out.println("Can't load resources! : ".concat(String.valueOf(String.valueOf(exception2.getMessage()))));
                return;
            }
            return;
        }
    }

    public void destroy() {
        this.circuit.forceBubbleHelp(null);
        this.graph.destroy();
        super.destroy();
    }

    public void start() {
        this.graph.setOwner(this);
        this.graph.repaint();
        super.start();
    }

    public void stop() {
        this.oneShotMsg = null;
        this.circuit.forceBubbleHelp(null);
        super.stop();
    }

    public void forward() {
        this.circuit.forceBubbleHelp(null);
        super.forward();
    }

    protected void stoppingClock() {
        this.circuit.forceBubbleHelp(this.oneShotMsg);
    }

    protected void cyclingClock() {
        this.clock.setTime(0.0);
        this.res.setTime(0.0);
        this.cap.setTime(0.0);
        this.clearAllData();
    }

    public final String getAppletInfo() {
        return "RCApplet by Wolfgang Christian, wochristian@davidson.edu";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"Resistor", "double", "Resistance in Ohm."}, {"Capacitor", "double", "Capacitor value in micro-H."}, {"Fmin", "double", "Minimum frequency"}, {"FMax", "double", "Maximum frequency."}, {"ShowControls", "boolean", "Show the slider."}, {"ShowCheckBox", "boolean", "Show the check box."}, {"ImpedanceGraphType", "boolean", "Plot current, I(f), rather than time series, V(t)."}};
        return stringArray;
    }

    public final int getResistorID() {
        return this.res.getID();
    }

    public final int getCapacitorID() {
        return this.cap.getID();
    }

    public final int getSourceID() {
        return this.bat.getID();
    }

    private void createCircuit() {
        this.xc = Math.abs(Math.PI * 2 * this.freqVal * this.capVal);
        if (this.xc != 0.0) {
            this.xc = 1.0 / this.xc;
        }
        this.circuit.setPreferredPixPerCell(this.preferredPixPerCell);
        this.circuit.setGridSize(4, 2);
        this.bat = this.circuit.addSineWave(0, 0, 0, 1);
        this.bat.setVoltRMS(this.volt / sqrt2);
        this.bat.showPhase = false;
        this.res = this.circuit.addResistor(0, 1, 1, 1);
        this.res.setLabel(Common.LEGEND_R);
        this.res.setR(this.resVal);
        this.res.showR = true;
        this.res.showV = true;
        this.res.showPhase = true;
        this.circuit.addWire(1, 1, 2, 1);
        this.circuit.addWire(0, 0, 2, 0);
        this.cap = this.circuit.addCapacitor(2, 1, 2, 0);
        this.cap.setLabel(Common.LEGEND_C);
        this.cap.setC(this.capVal * 1000000.0);
        this.cap.showC = true;
        this.cap.showV = true;
        this.cap.showPhase = true;
        this.circuit.addWire(2, 0, 3, 0);
        this.circuit.addWire(2, 1, 3, 1);
        this.meter = this.circuit.addVoltmeter(3, 0, 3, 1);
    }

    private void setCircuitValues() {
        double d = this.volt / this.zMag(this.freqVal) / sqrt2;
        this.bat.setF(this.freqVal);
        this.bat.setCurrentRMS(d);
        this.res.setVoltRMS(this.vrMag(this.freqVal) / sqrt2);
        this.res.setCurrentRMS(d);
        this.res.setPhaseRadian(this.vrPhase(this.freqVal));
        this.meter.setVoltRMS(this.vrMag(this.freqVal) / sqrt2);
        this.cap.setVoltRMS(this.vcMag(this.freqVal) / sqrt2);
        this.cap.setCurrentRMS(d);
        this.cap.setPhaseRadian(this.vcPhase(this.freqVal));
        double d2 = this.clock.getTime();
        double d3 = this.vcMag(this.freqVal);
        double d4 = this.vrMag(this.freqVal);
        double d5 = Math.PI * 2 * this.freqVal * d2;
        double d6 = d4 * Math.sin(d5 + this.res.getPhaseRadian()) / this.resVal;
        this.bat.setTime(d2);
        this.bat.setVoltInstantaneous(this.volt * Math.sin(d5));
        this.bat.setCurrentInstantaneous(d6);
        this.res.setTime(d2);
        this.res.setVoltInstantaneous(d4 * Math.sin(d5 + this.res.getPhaseRadian()));
        this.res.setCurrentInstantaneous(d6);
        this.cap.setTime(d2);
        this.cap.setVoltInstantaneous(d3 * Math.sin(d5 + this.cap.getPhaseRadian()));
        this.cap.setCurrentInstantaneous(d6);
    }

    final double zMag(double d) {
        return Math.sqrt(this.resVal * this.resVal + this.xc * this.xc);
    }

    final double vcMag(double d) {
        return this.volt * this.xc / Math.sqrt(this.resVal * this.resVal + this.xc * this.xc);
    }

    final double vrMag(double d) {
        return this.volt * this.resVal / Math.sqrt(this.resVal * this.resVal + this.xc * this.xc);
    }

    final double vrPhase(double d) {
        return Math.atan2(this.xc, this.resVal);
    }

    final double vcPhase(double d) {
        return Math.atan2(-this.resVal, this.xc);
    }

    final void plotFunction() {
        if (this.showImpedance) {
            this.plotZ();
        } else {
            this.plotV();
        }
    }

    public void step(double d, double d2) {
        double d3 = Math.PI * 2 * this.freqVal * d2;
        double d4 = this.vcMag(this.freqVal);
        double d5 = this.vrMag(this.freqVal);
        double d6 = d5 * Math.sin(d3 + this.res.getPhaseRadian()) / this.resVal;
        this.bat.setTime(d2);
        this.bat.setVoltInstantaneous(this.volt * Math.sin(d3));
        this.bat.setCurrentInstantaneous(d6);
        this.res.setTime(d2);
        this.res.setVoltInstantaneous(d5 * Math.sin(d3 + this.res.getPhaseRadian()));
        this.res.setCurrentInstantaneous(d6);
        this.cap.setTime(d2);
        this.cap.setVoltInstantaneous(d4 * Math.sin(d3 + this.cap.getPhaseRadian()));
        this.cap.setCurrentInstantaneous(d6);
        this.updateDataConnections();
    }

    final void plotV() {
        int n = Math.max(150, ((Component)((Object)this.graph)).getBounds().width / 3);
        if (((Component)((Object)this.graph)).getBounds().width == 0) {
            n = 200;
        }
        this.graph.setAutoRefresh(false);
        double d = this.tmax / (double)(n - 1);
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        double[] dArray4 = new double[n];
        double d2 = this.vcMag(this.freqVal);
        double d3 = this.vrMag(this.freqVal);
        double d4 = this.vcPhase(this.freqVal);
        double d5 = this.vrPhase(this.freqVal);
        double d6 = Math.PI * 2 * this.freqVal;
        for (int i = 0; i < n; ++i) {
            dArray[i] = (double)i * d;
            dArray2[i] = this.volt * Math.sin(d6 * dArray[i]);
            dArray3[i] = d2 * Math.sin(d6 * dArray[i] + d4);
            dArray4[i] = d3 * Math.sin(d6 * dArray[i] + d5);
        }
        this.graph.setAutoReplaceData(1, true);
        this.graph.setAutoReplaceData(2, true);
        this.graph.setAutoReplaceData(3, true);
        this.graph.clearSeriesData(1);
        this.graph.clearSeriesData(2);
        this.graph.clearSeriesData(3);
        this.graph.addData(1, dArray, dArray2);
        this.graph.addData(2, dArray, dArray3);
        this.graph.addData(3, dArray, dArray4);
        this.graph.setSeriesStyle(1, Color.black, true, 0);
        this.graph.setSeriesStyle(2, Color.red, true, 0);
        this.graph.setSeriesStyle(3, Color.blue, true, 0);
        this.graph.setSeriesLegend(1, Color.black, 75, 20, "Vac");
        this.graph.setSeriesLegend(2, Color.red, 125, 20, "Vc");
        this.graph.setSeriesLegend(3, Color.blue, 175, 20, "Vr");
        this.graph.setAutoRefresh(this.autoRefresh);
    }

    void plotZ() {
        int n = 200;
        double d = (this.fmax - this.fmin) / (double)(n - 1);
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double d2 = Math.PI * 2 * this.capVal;
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.fmin + (double)i * d;
            double d3 = 1.0 / (d2 * dArray[i]);
            dArray2[i] = this.volt / Math.sqrt(this.resVal * this.resVal + d3 * d3);
        }
        this.graph.clearSeriesData(1);
        this.graph.clearSeriesData(2);
        this.graph.clearSeriesData(3);
        this.graph.addData(1, dArray, dArray2);
        this.graph.setSeriesStyle(1, Color.red, true, 0);
        this.graph.setSeriesLegend(1, Color.red, 75, 20, "Current");
        this.xold = -100;
        this.yold = -100;
        if (this.circuit.getOsi() == null) {
            return;
        }
        Graphics graphics = ((Component)((Object)this.graph)).getGraphics();
        graphics.setColor(Color.green);
        graphics.setXORMode(Color.red);
        double d4 = this.fSlider.getDValue();
        this.xold = this.graph.pixFromX(d4);
        this.yold = this.graph.pixFromY(this.volt / this.zMag(d4));
        graphics.fillOval(this.xold - 5, this.yold - 5, 10, 10);
        graphics.setPaintMode();
        graphics.dispose();
    }

    void adjustFreq(double d) {
        this.freqVal = d;
        if (this.freqVal < this.fmin) {
            this.freqVal = this.fmin;
            this.fSlider.setDValue(this.freqVal);
        }
        if (this.freqVal > this.fmax) {
            this.freqVal = this.fmax;
            this.fSlider.setDValue(this.freqVal);
        }
        this.xc = Math.abs(Math.PI * 2 * this.freqVal * this.capVal);
        if (this.xc != 0.0) {
            this.xc = 1.0 / this.xc;
        }
        this.clock.setTime(0.0);
        this.clearAllData();
        this.setCircuitValues();
        if (!this.showImpedance) {
            this.plotV();
            return;
        }
        double d2 = this.volt / this.zMag(this.freqVal);
        int n = this.graph.pixFromX(this.freqVal);
        int n2 = this.graph.pixFromY(d2);
        Graphics graphics = ((Component)((Object)this.graph)).getGraphics();
        graphics.setColor(Color.green);
        graphics.setXORMode(Color.red);
        graphics.fillOval(this.xold - 5, this.yold - 5, 10, 10);
        graphics.fillOval(n - 5, n2 - 5, 10, 10);
        this.xold = n;
        this.yold = n2;
        graphics.setPaintMode();
        graphics.dispose();
    }

    void fSlider_adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.adjustFreq(this.fSlider.getDValue());
    }

    void fNumber_actionPerformed(ActionEvent actionEvent) {
        if (this.fNumber.isValid()) {
            this.adjustFreq(this.fNumber.getValue());
        }
    }

    public void setPixPerCell(int n) {
        if (this.preferredPixPerCell == n) {
            return;
        }
        this.preferredPixPerCell = n;
        this.circuit.setPreferredPixPerCell(this.preferredPixPerCell);
    }

    public void setTitle(String string) {
        this.graph.setTitle(string);
    }

    public void setDefault() {
        this.oneShotMsg = null;
        this.deleteDataConnections();
        this.clock.stopClock();
        this.clock.setTime(0.0);
        this.circuit.setDefault(this.preferredPixPerCell);
        this.createCircuit();
        this.setCircuitValues();
        this.graph.setTitle(null);
    }

    public void setCapacitance(double d, boolean bl, boolean bl2, boolean bl3) {
        this.capVal = d;
        this.cap.setC(this.capVal * 1000000.0);
        this.cap.showC = bl;
        this.cap.showV = bl2;
        this.cap.showPhase = bl3;
        this.adjustFreq(this.freqVal);
    }

    public void setResistance(double d, boolean bl, boolean bl2, boolean bl3) {
        this.resVal = d;
        this.res.setR(this.resVal);
        this.res.showR = bl;
        this.res.showV = bl2;
        this.res.showPhase = bl3;
        this.adjustFreq(this.freqVal);
    }

    public void setSourceVoltage(double d, boolean bl, boolean bl2) {
        this.volt = d;
        this.bat.setVoltRMS(this.volt / sqrt2);
        this.bat.showV = bl;
        this.bat.showPhase = bl2;
        this.adjustFreq(this.freqVal);
    }

    public boolean setCapacitorHint(String string) {
        return this.circuit.setHint(this.cap.getID(), string);
    }

    public boolean setResistorHint(String string) {
        return this.circuit.setHint(this.res.getID(), string);
    }

    public boolean setACHint(String string) {
        return this.circuit.setHint(this.bat.getID(), string);
    }

    public boolean setVoltmeterHint(String string) {
        return this.circuit.setHint(this.meter.getID(), string);
    }

    public void setFrequency(double d) {
        this.fSlider.setDValue(d);
        this.adjustFreq(d);
    }

    public void setShowControls(boolean bl) {
        this.etchedBorder2.setVisible(bl);
    }

    public void setShowCheckBox(boolean bl) {
        this.checkbox1.setVisible(bl);
    }

    public void setShowGraph(boolean bl) {
        if (((Component)((Object)this.graph)).isVisible() == bl) {
            return;
        }
        this.showGraph = bl;
        ((Component)((Object)this.graph)).setVisible(bl);
        ((Container)((Object)this)).invalidate();
        ((Container)((Object)this)).validate();
    }

    public void setAutoRefresh(boolean bl) {
        if (this.autoRefresh == bl) {
            return;
        }
        this.autoRefresh = bl;
        this.graph.setAutoRefresh(this.autoRefresh);
        if (this.autoRefresh) {
            this.setShowImpedance(this.showImpedance);
        }
    }

    public void setImpedanceGraphType(boolean bl) {
        if (this.showImpedance == bl) {
            return;
        }
        this.showImpedance = bl;
        if (this.autoRefresh) {
            this.setShowImpedance(this.showImpedance);
        }
    }

    void setShowImpedance(boolean bl) {
        this.graph.setAutoRefresh(false);
        this.showImpedance = bl;
        this.graph.deleteSeries(1);
        this.graph.deleteSeries(2);
        this.graph.deleteSeries(3);
        if (this.showImpedance) {
            this.xold = -100;
            this.yold = -100;
            this.graph.setLabelY(Common.CURRENT_A);
            this.graph.setLabelX(Common.FREQUENCY_HZ);
            this.graph.setMinMaxX(this.fmin, this.fmax);
            this.graph.setMinMaxY(0.0, this.volt / this.resVal);
        } else {
            this.graph.setLabelY(Common.VOLTAGE_V);
            this.graph.setLabelX(Common.TIME_SEC);
            this.graph.setMinMaxX(0.0, this.tmax);
            this.graph.setMinMaxY(-1.1 * this.volt, 1.2 * this.volt);
        }
        this.plotFunction();
        this.graph.setAutoRefresh(this.autoRefresh);
        this.graph.repaint();
    }

    void checkbox1_itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.setShowImpedance(false);
        } else {
            this.setShowImpedance(true);
        }
    }

    static {
        pi = Math.PI;
        pi2 = Math.PI * 2;
        sqrt2 = Math.sqrt(2.0);
    }

    class RCGraph
    extends SGraph {
        RCGraph() {
        }

        public void paintLast(Graphics graphics, Rectangle rectangle) {
            super.paintLast(graphics, rectangle);
            graphics.setColor(Color.green);
            graphics.setXORMode(Color.red);
            double d = RCApplet.this.fSlider.getDValue();
            RCApplet.this.xold = RCApplet.this.graph.pixFromX(d);
            RCApplet.this.yold = RCApplet.this.graph.pixFromY(RCApplet.this.volt / RCApplet.this.zMag(d));
            graphics.fillOval(RCApplet.this.xold - 5, RCApplet.this.yold - 5, 10, 10);
            graphics.setPaintMode();
        }
    }
}

