/*
 * Decompiled with CFR 0.152.
 */
package circuit;

import circuit.Circuit;
import circuit.Common;
import circuit.Part;
import edu.davidson.tools.SApplet;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;

public class SineWave
extends Part {
    public SineWave(SApplet sApplet, Circuit circuit, int n, int n2, int n3, int n4) {
        super(sApplet, circuit, n, n2, n3, n4);
        this.label = Common.LEGEND_VAC;
        this.voltRMS = 10.0;
        this.phase = 0.0;
        this.showV = true;
        this.showZ = false;
        this.showF = true;
        this.showPhase = true;
    }

    void drawLabel(Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.label == null) {
            return;
        }
        Font font = graphics.getFont();
        graphics.setFont(this.f);
        graphics.setColor(Color.black);
        graphics.drawString(this.label, n - 10, n2 + 5);
        graphics.setFont(font);
    }

    void drawSymbol(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        graphics.setColor(this.color);
        double d = n3 - n;
        double d2 = -(n4 - n2);
        double d3 = Math.sqrt(d * d + d2 * d2);
        if (d3 < (double)2) {
            return;
        }
        double d4 = d3 / 2.0 - (double)6;
        int n6 = (int)((double)n + d * d4 / d3);
        int n7 = (int)((double)n2 - d2 * d4 / d3);
        int n8 = (int)((double)n3 - d * d4 / d3);
        int n9 = (int)((double)n4 + d2 * d4 / d3);
        graphics.drawLine(n, n2, n6, n7);
        graphics.drawLine(n3, n4, n8, n9);
        graphics.fillOval((n + n3) / 2 - 15, (n2 + n4) / 2 - 15, 30, 30);
        graphics.setColor(Color.white);
        graphics.fillOval((n + n3) / 2 - 13, (n2 + n4) / 2 - 13, 26, 26);
        Font font = graphics.getFont();
        graphics.setFont(this.f);
        graphics.setColor(Color.black);
        graphics.drawString("+", n6 + 20, n7);
        graphics.setFont(font);
    }

    String getMSHint() {
        String string = "";
        if (this.showV) {
            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(Common.LEGEND_VEQU)).concat(String.valueOf(String.valueOf(this.format.form(this.voltRMS)))))));
        }
        if (this.showF) {
            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer(" ").append(Common.LEGEND_FREQ).append(this.format.form(this.freq)).append("Hz  "))))));
        }
        if (this.showPhase) {
            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("phi=").append(this.format.form(this.phase)).append(" "))))));
        }
        if (string.trim().length() == 0) {
            string = Common.LEGEND_NOVALUE;
        }
        return string;
    }

    String getHint() {
        if (this.customHint != null) {
            return this.customHint;
        }
        if (Part.isMicrosoft()) {
            return this.getMSHint();
        }
        String string = "";
        if (this.showV) {
            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(Common.LEGEND_VEQU)).concat(String.valueOf(String.valueOf(this.format.form(this.voltRMS)))))));
        }
        if (this.showF) {
            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer(" ").append(Common.LEGEND_FREQ).append(this.format.form(this.freq)).append("Hz  "))))));
        }
        if (this.showPhase) {
            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Part.phi))).append("=").append(this.format.form(this.phase)).append(Part.degree).append("  "))))));
        }
        if (string.trim().length() == 0) {
            string = Common.LEGEND_NOVALUE;
        }
        return string;
    }
}

