/*
 * Decompiled with CFR 0.152.
 */
package circuit;

import circuit.Circuit;
import circuit.Part;
import edu.davidson.tools.SApplet;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;

public class Transformer
extends Part {
    boolean vertical = true;

    public Transformer(SApplet sApplet, Circuit circuit, int n, int n2, int n3, int n4, boolean bl) {
        super(sApplet, circuit, n, n2, n3, n4);
        this.vertical = bl;
        this.voltRMS = 0.0;
        this.res = 0.0;
        this.ind = 1.0;
        this.showV = false;
        this.showL = false;
        this.showZ = false;
    }

    void drawLabel(Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.label == null) {
            return;
        }
        Font font = graphics.getFont();
        graphics.setFont(this.f);
        graphics.setColor(Color.black);
        if (this.vertical) {
            graphics.drawString(this.label, n - 3, n2 - 25);
        } else {
            graphics.drawString(this.label, n - 30, n2 + 3);
        }
        graphics.setFont(font);
    }

    void drawSymbol(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        if (!this.vertical) {
            this.drawHorz(graphics, n, n2, n3, n4, n5);
            return;
        }
        graphics.setColor(this.color);
        double d = n3 - n;
        double d2 = -(n4 - n2);
        double d3 = Math.sqrt(d * d + d2 * d2);
        if (d3 < (double)2) {
            return;
        }
        double d4 = d3 / 2.0 - (double)30;
        int n6 = (int)((double)n + d * d4 / d3);
        int n7 = (int)((double)n2 - d2 * d4 / d3);
        int n8 = (int)((double)n3 - d * d4 / d3);
        int n9 = (int)((double)n4 + d2 * d4 / d3);
        graphics.drawLine(n, n2, n, n7);
        graphics.drawLine(n3, n2, n3, n7);
        graphics.drawLine(n, n7, n6, n7);
        graphics.drawLine(n3, n7, n8, n7);
        int n10 = 6;
        int n11 = Math.abs(n9 - n7) / (2 * n10);
        for (int i = 0; i <= n11; ++i) {
            graphics.drawArc(n6 - n10, n7 + i * 2 * n10, 2 * n10, 2 * n10, 90, -180);
            graphics.drawArc(n8 - n10, n7 + i * 2 * n10, 2 * n10, 2 * n10, 90, 180);
        }
        n9 = n7 + (n11 + 1) * 2 * n10;
        graphics.drawLine(n, n4, n, n9);
        graphics.drawLine(n3, n4, n3, n9);
        graphics.drawLine(n, n9, n6, n9);
        graphics.drawLine(n3, n9, n8, n9);
        graphics.drawLine((n + n3) / 2, n7, (n + n3) / 2, n9);
        graphics.drawLine((n + n3) / 2 - 3, n7, (n + n3) / 2 - 3, n9);
        graphics.drawLine((n + n3) / 2 + 3, n7, (n + n3) / 2 + 3, n9);
    }

    private void drawHorz(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        graphics.setColor(this.color);
        double d = n3 - n;
        double d2 = -(n4 - n2);
        double d3 = Math.sqrt(d * d + d2 * d2);
        if (d3 < (double)2) {
            return;
        }
        double d4 = d3 / 2.0 - (double)30;
        int n6 = (int)((double)n + d * d4 / d3);
        int n7 = (int)((double)n2 - d2 * d4 / d3);
        int n8 = (int)((double)n3 - d * d4 / d3);
        int n9 = (int)((double)n4 + d2 * d4 / d3);
        graphics.drawLine(n, n2, n6, n2);
        graphics.drawLine(n6, n2, n6, n7);
        graphics.drawLine(n, n4, n6, n4);
        graphics.drawLine(n6, n4, n6, n9);
        int n10 = 6;
        int n11 = Math.abs(n9 - n7) / (2 * n10);
        for (int i = 0; i <= n11; ++i) {
            graphics.drawArc(n6 + i * 2 * n10, n7 - n10, 2 * n10, 2 * n10, 0, -180);
            graphics.drawArc(n6 + i * 2 * n10, n9 - n10, 2 * n10, 2 * n10, 0, 180);
        }
        n8 = n6 + (n11 + 1) * 2 * n10;
        graphics.drawLine(n3, n2, n8, n2);
        graphics.drawLine(n8, n2, n8, n7);
        graphics.drawLine(n3, n4, n8, n4);
        graphics.drawLine(n8, n4, n8, n9);
        graphics.drawLine(n6, (n2 + n4) / 2 - 3, n8, (n2 + n4) / 2 - 3);
        graphics.drawLine(n6, (n2 + n4) / 2, n8, (n2 + n4) / 2);
        graphics.drawLine(n6, (n2 + n4) / 2 + 3, n8, (n2 + n4) / 2 + 3);
    }
}

