/*
 * Decompiled with CFR 0.152.
 */
package circuit;

import circuit.Circuit;
import circuit.Common;
import circuit.Part;
import edu.davidson.tools.SApplet;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;

public class Voltmeter
extends Part {
    public Voltmeter(SApplet sApplet, Circuit circuit, int n, int n2, int n3, int n4) {
        super(sApplet, circuit, n, n2, n3, n4);
        this.label = "V";
        this.voltRMS = 10.0;
        this.res = 1.0E64;
        this.showV = true;
        this.showZ = false;
    }

    void drawLabel(Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.label == null) {
            return;
        }
        Font font = graphics.getFont();
        graphics.setFont(this.f);
        graphics.setColor(Color.black);
        graphics.drawString(this.label, n - 4, n2 + 5);
        graphics.setFont(font);
    }

    void drawSymbol(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        graphics.setColor(this.color);
        double d = n3 - n;
        double d2 = -(n4 - n2);
        double d3 = Math.sqrt(d * d + d2 * d2);
        if (d3 < (double)2) {
            return;
        }
        double d4 = d3 / 2.0 - (double)10;
        int n6 = (int)((double)n + d * d4 / d3);
        int n7 = (int)((double)n2 - d2 * d4 / d3);
        int n8 = (int)((double)n3 - d * d4 / d3);
        int n9 = (int)((double)n4 + d2 * d4 / d3);
        graphics.drawLine(n, n2, n6, n7);
        graphics.drawLine(n3, n4, n8, n9);
        graphics.setColor(new Color(128, 255, 128));
        graphics.fillOval((n + n3) / 2 - 10, (n2 + n4) / 2 - 10, 20, 20);
        Font font = graphics.getFont();
        graphics.setFont(this.f);
        graphics.setColor(Color.black);
        graphics.drawString("+", n6 + 15, n7 + 2);
        graphics.setFont(font);
    }

    String getHint() {
        if (this.customHint != null) {
            return this.customHint;
        }
        String string = "";
        if (this.showV) {
            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Common.LEGEND_VOLTMETER))).append(this.format1.form(this.voltRMS)).append(" V"))))));
        }
        if (string.trim().length() == 0) {
            string = Common.LEGEND_NOVOLTAGE;
        }
        return string;
    }
}

