/*
 * Decompiled with CFR 0.152.
 */
package animator4;

import animator4.AnimatorCanvas;
import animator4.Thing;
import edu.davidson.numerics.Parser;
import edu.davidson.tools.SUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class Arrow
extends Thing {
    private double[] arrowVars = new double[12];
    private double[] arrow = new double[2];
    private String hStr;
    private String vStr;
    private boolean filled = false;
    Parser hFunc;
    Parser vFunc;
    int thickness = 1;

    public Arrow(AnimatorCanvas animatorCanvas, int n, String string, String string2, String string3, String string4) {
        super(animatorCanvas, string3, string4);
        this.varStrings = new String[]{"t", "x", "y", "vx", "vy", "ax", "ay", "m", "horz", "vert", "w", "h"};
        this.ds = new double[1][12];
        this.s = n;
        this.hStr = string;
        this.vStr = string2;
        this.hFunc = new Parser(12);
        this.hFunc.defineVariable(1, "t");
        this.hFunc.defineVariable(2, "x");
        this.hFunc.defineVariable(3, "y");
        this.hFunc.defineVariable(4, "vx");
        this.hFunc.defineVariable(5, "vy");
        this.hFunc.defineVariable(6, "ax");
        this.hFunc.defineVariable(7, "ay");
        this.hFunc.defineVariable(8, "m");
        this.hFunc.defineVariable(9, "fx");
        this.hFunc.defineVariable(10, "fy");
        this.hFunc.defineVariable(11, "w");
        this.hFunc.defineVariable(12, "h");
        this.hFunc.define(this.hStr);
        this.hFunc.parse();
        if (this.hFunc.getErrorCode() != 0) {
            System.out.println("Failed to parse horzizontal component of vector: ".concat(String.valueOf(String.valueOf(this.hStr))));
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Parse error: ").append(this.hFunc.getErrorString()).append(" at function 1, position ").append(this.hFunc.getErrorPosition()))));
            return;
        }
        this.vFunc = new Parser(12);
        this.vFunc.defineVariable(1, "t");
        this.vFunc.defineVariable(2, "x");
        this.vFunc.defineVariable(3, "y");
        this.vFunc.defineVariable(4, "vx");
        this.vFunc.defineVariable(5, "vy");
        this.vFunc.defineVariable(6, "ax");
        this.vFunc.defineVariable(7, "ay");
        this.vFunc.defineVariable(8, "m");
        this.vFunc.defineVariable(9, "fx");
        this.vFunc.defineVariable(10, "fy");
        this.vFunc.defineVariable(11, "w");
        this.vFunc.defineVariable(12, "h");
        this.vFunc.define(this.vStr);
        this.vFunc.parse();
        if (this.vFunc.getErrorCode() != 0) {
            System.out.println("Failed to parse vertical component of vector: ".concat(String.valueOf(String.valueOf(this.vStr))));
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Parse error: ").append(this.vFunc.getErrorString()).append(" at function 1, position ").append(this.vFunc.getErrorPosition()))));
            return;
        }
    }

    void setArrow() {
        for (int i = 0; i < 8; ++i) {
            this.arrowVars[i] = this.vars[i];
        }
        if (this.myMaster != null && !this.dynamic) {
            this.arrowVars[8] = this.myMaster.getTotalFx();
            this.arrowVars[9] = this.myMaster.getTotalFy();
        } else {
            this.arrowVars[8] = this.getTotalFx();
            this.arrowVars[9] = this.getTotalFy();
        }
        try {
            this.arrow[0] = this.hFunc.evaluate(this.arrowVars);
            this.arrow[1] = this.vFunc.evaluate(this.arrowVars);
        }
        catch (Exception exception) {
            this.arrow[0] = 0.0;
            this.arrow[1] = 0.0;
        }
    }

    double getHorz() {
        double d = 0.0;
        for (int i = 0; i < 8; ++i) {
            this.arrowVars[i] = this.vars[i];
        }
        if (this.myMaster != null && !this.dynamic) {
            this.arrowVars[8] = this.myMaster.getTotalFx();
            this.arrowVars[9] = this.myMaster.getTotalFy();
        } else {
            this.arrowVars[8] = this.getTotalFx();
            this.arrowVars[9] = this.getTotalFy();
        }
        try {
            d = this.hFunc.evaluate(this.arrowVars);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    double getVert() {
        double d = 0.0;
        for (int i = 0; i < 8; ++i) {
            this.arrowVars[i] = this.vars[i];
        }
        if (this.myMaster != null && !this.dynamic) {
            this.arrowVars[8] = this.myMaster.getTotalFx();
            this.arrowVars[9] = this.myMaster.getTotalFy();
        } else {
            this.arrowVars[8] = this.getTotalFx();
            this.arrowVars[9] = this.getTotalFy();
        }
        try {
            d = this.vFunc.evaluate(this.arrowVars);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    public void setFilled(boolean bl) {
        this.filled = bl;
    }

    public double getH() {
        return this.getVert();
    }

    public void setH(double d) {
        System.out.println("Error:  Cannot set the vertial component of a dynamic arrow.");
    }

    public double getW() {
        return this.getHorz();
    }

    public void setW(double d) {
        System.out.println("Error:  Cannot set the horizontal component of a dynamic arrow.");
    }

    public final boolean isInsideThing(int n, int n2) {
        int n3 = this.canvas.pixFromX(this.vars[1]) + this.xDisplayOff;
        int n4 = this.canvas.pixFromY(this.vars[2]) - this.yDisplayOff;
        return Math.abs(n - n3) < this.s + 1 && Math.abs(n2 - n4) < this.s + 1;
    }

    public void paint(Graphics graphics) {
        if (!this.visible) {
            return;
        }
        int n = Math.round(this.canvas.pixFromX(this.vars[1])) + this.xDisplayOff;
        int n2 = Math.round(this.canvas.pixFromY(this.vars[2])) - this.yDisplayOff;
        double d = 0.0;
        double d2 = 0.0;
        if (this.showVVector) {
            d = (double)this.canvas.pixPerUnit * this.vars[3];
            d2 = (double)this.canvas.pixPerUnit * this.vars[4];
        } else if (this.showAVector) {
            d = (double)this.canvas.pixPerUnit * this.vars[5];
            d2 = (double)this.canvas.pixPerUnit * this.vars[6];
        } else if (this.dynamic && this.showFVector) {
            d = (double)this.canvas.pixPerUnit * this.getTotalFx();
            d2 = (double)this.canvas.pixPerUnit * this.getTotalFy();
        } else if (!this.dynamic && this.showFVector) {
            d = (double)this.canvas.pixPerUnit * this.vars[5] * this.mass;
            d2 = (double)this.canvas.pixPerUnit * this.vars[6] * this.mass;
        } else {
            this.setArrow();
            d = (double)this.canvas.pixPerUnit * this.arrow[0];
            d2 = (double)this.canvas.pixPerUnit * this.arrow[1];
        }
        graphics.setColor(this.color);
        int n3 = (int)((double)n + d);
        int n4 = (int)((double)n2 - d2);
        double d3 = Math.sqrt(d * d + d2 * d2);
        if (d3 < (double)2) {
            graphics.drawLine(n, n2, n3, n4);
            return;
        }
        double d4 = d3 > (double)(3 * this.s) ? (double)this.s : d3 / (double)3;
        if (this.thickness > 1) {
            SUtil.drawThickArrow((Graphics)graphics, (int)n, (int)n2, (int)n3, (int)n4, (int)((int)d4), (int)this.thickness);
        } else if (this.filled) {
            SUtil.drawSolidArrow((Graphics)graphics, (int)n, (int)n2, (int)n3, (int)n4, (int)((int)d4));
        } else {
            graphics.drawLine(n, n2, n3, n4);
            if (d3 > 1.0) {
                double d5 = d4 * d / d3;
                double d6 = -(d4 * d2 / d3);
                double d7 = (double)n3 - (double)3 * d5;
                double d8 = (double)n4 - (double)3 * d6;
                graphics.drawLine((int)(d7 - d6), (int)(d8 + d5), n3, n4);
                graphics.drawLine((int)(d7 + d6), (int)(d8 - d5), n3, n4);
            }
        }
        if (!this.noDrag) {
            if (this.color != Color.lightGray) {
                graphics.setColor(Color.lightGray);
            } else {
                this.setColor(Color.red);
            }
            graphics.fillOval(n - 2, n2 - 2, 5, 5);
            graphics.setColor(this.color);
            graphics.drawOval(n - 2, n2 - 2, 5, 5);
        }
        if (this.label != null) {
            graphics.setColor(Color.black);
            Font font = graphics.getFont();
            graphics.setFont(this.font);
            FontMetrics fontMetrics = graphics.getFontMetrics(this.font);
            int n5 = 4 + (int)((double)(8 + fontMetrics.stringWidth(this.label)) * (-1.0 + d / d3) / 2.0);
            int n6 = (int)((double)-4 * (d2 / d3) + (double)fontMetrics.getHeight() * (1.0 - d2 / d3) / 4.0);
            graphics.drawString(this.label, n3 + n5, n4 + n6);
            graphics.setFont(font);
        }
    }

    public void paintHighlight(Graphics graphics) {
        if (!this.visible) {
            return;
        }
        int n = Math.round(this.canvas.pixFromX(this.vars[1])) + this.xDisplayOff;
        int n2 = Math.round(this.canvas.pixFromY(this.vars[2])) - this.yDisplayOff;
        double d = 0.0;
        double d2 = 0.0;
        if (this.showVVector) {
            d = (double)this.canvas.pixPerUnit * this.vars[3];
            d2 = (double)this.canvas.pixPerUnit * this.vars[4];
        } else if (this.showAVector) {
            d = (double)this.canvas.pixPerUnit * this.vars[5];
            d2 = (double)this.canvas.pixPerUnit * this.vars[6];
        } else if (this.dynamic && this.showFVector) {
            d = (double)this.canvas.pixPerUnit * this.getTotalFx();
            d2 = (double)this.canvas.pixPerUnit * this.getTotalFy();
        } else if (!this.dynamic && this.showFVector) {
            d = (double)this.canvas.pixPerUnit * this.vars[5];
            d2 = (double)this.canvas.pixPerUnit * this.vars[6];
        } else {
            this.setArrow();
            d = (double)this.canvas.pixPerUnit * this.arrow[0];
            d2 = (double)this.canvas.pixPerUnit * this.arrow[1];
        }
        graphics.setColor(this.highlightColor);
        int n3 = (int)((double)n + d);
        int n4 = (int)((double)n2 - d2);
        double d3 = Math.sqrt(d * d + d2 * d2);
        if (d3 < (double)2) {
            graphics.drawLine(n, n2, n3, n4);
            return;
        }
        double d4 = d3 > (double)(3 * this.s) ? (double)this.s : d3 / (double)3;
        if (this.filled) {
            SUtil.drawSolidArrow((Graphics)graphics, (int)n, (int)n2, (int)n3, (int)n4, (int)((int)d4));
            return;
        }
        graphics.drawLine(n, n2, n3, n4);
        if (d3 > 1.0) {
            double d5 = d4 * d / d3;
            double d6 = -(d4 * d2 / d3);
            double d7 = (double)n3 - (double)3 * d5;
            double d8 = (double)n4 - (double)3 * d6;
            graphics.drawLine((int)(d7 - d6), (int)(d8 + d5), n3, n4);
            graphics.drawLine((int)(d7 + d6), (int)(d8 - d5), n3, n4);
        }
        if (this.label != null) {
            graphics.setColor(Color.black);
            Font font = graphics.getFont();
            graphics.setFont(this.font);
            FontMetrics fontMetrics = graphics.getFontMetrics(this.font);
            int n5 = 4 + (int)((double)(8 + fontMetrics.stringWidth(this.label)) * (-1.0 + d / d3) / 2.0);
            int n6 = (int)((double)-4 * (d2 / d3) + (double)fontMetrics.getHeight() * (1.0 - d2 / d3) / 4.0);
            graphics.drawString(this.label, n3 + n5, n4 + n6);
            graphics.setFont(font);
        }
    }

    public double[][] getVariables() {
        double d = 0.0;
        double d2 = 0.0;
        if (this.showVVector) {
            d = this.vars[3];
            d2 = this.vars[4];
        } else if (this.showAVector) {
            d = (double)this.canvas.pixPerUnit * this.vars[5];
            d2 = (double)this.canvas.pixPerUnit * this.vars[6];
        } else if (this.dynamic && this.showFVector) {
            d = this.getTotalFx();
            d2 = this.getTotalFy();
        } else if (!this.dynamic && this.showFVector) {
            d = this.vars[5];
            d2 = this.vars[6];
        } else {
            this.setArrow();
            d = this.arrow[0];
            d2 = this.arrow[1];
        }
        this.ds[0][0] = this.vars[0];
        this.ds[0][1] = this.vars[1];
        this.ds[0][2] = this.vars[2];
        this.ds[0][3] = this.vars[3];
        this.ds[0][4] = this.vars[4];
        this.ds[0][5] = this.vars[5];
        this.ds[0][6] = this.vars[6];
        this.ds[0][7] = this.mass;
        this.ds[0][8] = d;
        this.ds[0][9] = d2;
        this.ds[0][10] = d;
        this.ds[0][11] = d2;
        return this.ds;
    }
}

