/*
 * Decompiled with CFR 0.152.
 */
package animator4;

import animator4.AnimatorCanvas;
import animator4.Thing;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class Protractor
extends Thing {
    private boolean insideTip1 = false;
    private boolean insideTip2 = false;
    private double angle1;
    private double angle2;
    private int spot = 4;
    boolean fixedBase = false;
    boolean fixedlength = false;
    int len;

    public Protractor(AnimatorCanvas animatorCanvas, int n, double d, double d2, String string, String string2) {
        super(animatorCanvas, string, string2);
        this.varStrings = new String[]{"t", "x", "y", "theta", "theta0"};
        this.ds = new double[1][5];
        this.s = n;
        this.len = n;
        this.angle1 = d2;
        this.angle2 = d + d2;
        this.color = Color.red;
        this.resizable = true;
    }

    public void setXY(double d, double d2) {
        if (this.insideTip1) {
            double d3 = d - this.vars[1];
            double d4 = d2 - this.vars[2];
            if (d3 == 0.0 && d4 == 0.0) {
                return;
            }
            this.angle1 = Math.atan2(d4, d3);
            return;
        }
        if (this.insideTip2) {
            double d5 = d - this.vars[1];
            double d6 = d2 - this.vars[2];
            if (!this.fixedlength) {
                if (d5 == 0.0 && d6 == 0.0) {
                    return;
                }
                this.len = (int)((double)this.canvas.pixPerUnit * Math.sqrt(d5 * d5 + d6 * d6));
                this.len = Math.max(this.len, this.spot);
            }
            if (d5 == 0.0 && d6 == 0.0) {
                return;
            }
            this.angle2 = Math.atan2(d6, d5);
            return;
        }
        super.setXY(d, d2);
    }

    public void setProperties(int n, double d, double d2) {
        if (n == 3) {
            this.angle1 = d;
            this.angle2 = d + d2;
        } else if (n == 4) {
            this.insideTip1 = true;
            this.insideTip2 = false;
            this.setXY(d, d2);
            this.insideTip1 = false;
        } else if (n == 5) {
            this.insideTip1 = false;
            this.insideTip2 = true;
            this.setXY(d, d2);
            this.insideTip2 = false;
        }
    }

    public final boolean isInsideThing(int n, int n2) {
        this.insideTip1 = false;
        this.insideTip2 = false;
        int n3 = this.canvas.pixFromX(this.vars[1]) + this.xDisplayOff;
        int n4 = this.canvas.pixFromY(this.vars[2]) - this.yDisplayOff;
        if (!this.noDrag && Math.abs(n - n3) < this.spot && Math.abs(n2 - n4) < this.spot) {
            return true;
        }
        if (this.resizable && !this.fixedBase && Math.abs((double)(n - n3) - (double)this.s * Math.cos(this.angle1)) < (double)this.spot && Math.abs((double)(n2 - n4) + (double)this.s * Math.sin(this.angle1)) < (double)this.spot) {
            this.insideTip1 = true;
            return true;
        }
        if (this.resizable && Math.abs((double)(n - n3) - (double)this.len * Math.cos(this.angle2)) < (double)this.spot && Math.abs((double)(n2 - n4) + (double)this.len * Math.sin(this.angle2)) < (double)this.spot) {
            this.insideTip2 = true;
            return true;
        }
        return false;
    }

    public void paint(Graphics graphics) {
        if (!this.visible) {
            return;
        }
        int n = Math.round(this.canvas.pixFromX(this.vars[1])) + this.xDisplayOff;
        int n2 = Math.round(this.canvas.pixFromY(this.vars[2])) - this.yDisplayOff;
        graphics.setColor(Color.black);
        int n3 = (int)((double)n + (double)this.s * Math.cos(this.angle1));
        int n4 = (int)((double)n2 - (double)this.s * Math.sin(this.angle1));
        graphics.drawLine(n, n2, n3, n4);
        n3 = (int)((double)n + (double)this.len * Math.cos(this.angle2));
        n4 = (int)((double)n2 - (double)this.len * Math.sin(this.angle2));
        graphics.setColor(this.color);
        graphics.drawLine(n, n2, n3, n4);
        n3 = (int)((double)n + (double)this.s * Math.cos(this.angle2));
        n4 = (int)((double)n2 - (double)this.s * Math.sin(this.angle2));
        int n5 = (int)((double)180 * this.angle1 / Math.PI);
        double d = this.angle2 - this.angle1;
        if (d > Math.PI) {
            d -= Math.PI * 2;
        } else if (d < -Math.PI) {
            d += Math.PI * 2;
        }
        int n6 = Math.min(this.s, this.len);
        graphics.drawArc(n - n6 / 2, n2 - n6 / 2, n6, n6, n5, (int)((double)180 * d / Math.PI));
        graphics.setColor(Color.black);
        if (!this.noDrag) {
            if (this.color != Color.lightGray) {
                graphics.setColor(Color.lightGray);
            } else {
                this.setColor(Color.red);
            }
            graphics.fillOval(n - 2, n2 - 2, 5, 5);
            graphics.setColor(this.color);
            graphics.drawOval(n - 2, n2 - 2, 5, 5);
        }
        if (this.resizable) {
            if (this.color != Color.lightGray) {
                graphics.setColor(Color.lightGray);
            } else {
                this.setColor(Color.red);
            }
            n3 = (int)((double)n + (double)this.len * Math.cos(this.angle2));
            n4 = (int)((double)n2 - (double)this.len * Math.sin(this.angle2));
            graphics.fillOval(n3 - 2, n4 - 2, 5, 5);
            graphics.setColor(this.color);
            graphics.drawOval(n3 - 2, n4 - 2, 5, 5);
        }
        if (this.resizable && !this.fixedBase) {
            if (this.color != Color.lightGray) {
                graphics.setColor(Color.lightGray);
            } else {
                this.setColor(Color.red);
            }
            n3 = (int)((double)n + (double)this.s * Math.cos(this.angle1));
            n4 = (int)((double)n2 - (double)this.s * Math.sin(this.angle1));
            graphics.fillOval(n3 - 2, n4 - 2, 5, 5);
            graphics.setColor(this.color);
            graphics.drawOval(n3 - 2, n4 - 2, 5, 5);
        }
        if (this.label != null) {
            graphics.setColor(Color.black);
            Font font = graphics.getFont();
            graphics.setFont(this.font);
            FontMetrics fontMetrics = graphics.getFontMetrics(this.font);
            graphics.drawString(this.label, n, n2);
            graphics.setFont(font);
        }
    }

    public void paintHighlight(Graphics graphics) {
    }

    public double[][] getVariables() {
        this.ds[0][0] = this.vars[0];
        this.ds[0][1] = this.vars[1];
        this.ds[0][2] = this.vars[2];
        double d = this.angle2 - this.angle1;
        if (d > Math.PI) {
            d -= Math.PI * 2;
        } else if (d < -Math.PI) {
            d += Math.PI * 2;
        }
        this.ds[0][3] = d;
        this.ds[0][4] = this.angle1;
        return this.ds;
    }
}

