/*
 * Decompiled with CFR 0.152.
 */
package circuitsimulator;

import circuitsimulator.Circuit;
import circuitsimulator.Source;
import edu.davidson.tools.SUtil;
import java.awt.Color;
import java.awt.Graphics;

public class Battery
extends Source {
    public Battery(Circuit circuit, int n, int n2, int n3, String string, double d) {
        super(circuit, n, n2, n3, string);
        if (d < 0.0) {
            d = -d;
            this.changePolarity();
        }
        this.value = d;
        this.function = "".concat(String.valueOf(String.valueOf(Double.toString(this.value))));
        this.setValueVisible(true);
    }

    Battery() {
        this.polarity = "p";
    }

    public void loadImage(Graphics graphics) {
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        int n = this.polarity.equals("p") ? this.circuit.interGrid / 2 + 1 : this.circuit.interGrid / 2 - 2;
        int n2 = this.polarity.equals("p") ? this.circuit.interGrid / 2 + 2 : this.circuit.interGrid / 2 - 3;
        graphics.setColor(Color.red);
        if (this.to.equals("h")) {
            graphics.drawLine(this.x + 3, this.y, this.x + this.circuit.interGrid / 2 - 2, this.y);
            graphics.drawLine(this.x + this.circuit.interGrid / 2 + 1, this.y, this.x + this.circuit.interGrid - 4, this.y);
            graphics.drawLine(this.x + n, this.y - 6, this.x + n, this.y + 6);
            graphics.drawLine(this.x + this.circuit.interGrid - 1 - n, this.y - 3, this.x + this.circuit.interGrid - 1 - n, this.y + 3);
            graphics.drawLine(this.x + this.circuit.interGrid - 1 - n2, this.y - 3, this.x + this.circuit.interGrid - 1 - n2, this.y + 3);
        } else {
            graphics.drawLine(this.x, this.y + 3, this.x, this.y + this.circuit.interGrid / 2 - 2);
            graphics.drawLine(this.x, this.y + this.circuit.interGrid / 2 + 1, this.x, this.y + this.circuit.interGrid - 4);
            graphics.drawLine(this.x - 6, this.y + n, this.x + 6, this.y + n);
            graphics.drawLine(this.x - 3, this.y + this.circuit.interGrid - 1 - n, this.x + 3, this.y + this.circuit.interGrid - 1 - n);
            graphics.drawLine(this.x - 3, this.y + this.circuit.interGrid - 1 - n2, this.x + 3, this.y + this.circuit.interGrid - 1 - n2);
        }
    }

    public double getV(double d) {
        return this.value;
    }

    public String valueStr() {
        return this.format.form(this.value);
    }

    public String getStringAdditions() {
        return String.valueOf(String.valueOf(new StringBuffer(",v=").append(Double.toString(this.value)).append(",r=").append(this.internalResistance)));
    }

    public void parsefunction() {
    }

    public boolean set(String string) {
        boolean bl = super.set(string);
        if (SUtil.parameterExist((String)string, (String)"v=")) {
            double d = SUtil.getParam((String)string, (String)"v=");
            if (d < 0.0) {
                d = -d;
                this.changePolarity();
            }
            this.value = d;
            this.function = "".concat(String.valueOf(String.valueOf(Double.toString(this.value))));
        }
        return bl;
    }

    public void setvalue(String string) {
        double d = Double.valueOf(string);
        if (d < 0.0) {
            d = -d;
            this.changePolarity();
        }
        this.value = d;
        this.function = "".concat(String.valueOf(String.valueOf(Double.toString(this.value))));
    }
}

