/*
 * Decompiled with CFR 0.152.
 */
package circuitsimulator;

import circuitsimulator.GridElement;

public class BranchPoint {
    int xcoord;
    int ycoord;
    int[] iIndex = new int[4];
    int[] iSign = new int[4];
    int lastDirection;
    int toDefine;

    public BranchPoint() {
        this.xcoord = 0;
        this.ycoord = 0;
        for (int i = 0; i < 4; ++i) {
            this.iIndex[i] = 0;
            this.iSign[i] = 0;
        }
        this.lastDirection = 0;
        this.toDefine = 4;
    }

    BranchPoint(GridElement gridElement, int n, int n2, int n3, int n4, int n5) {
        this.xcoord = n;
        this.ycoord = n2;
        this.iIndex[(n3 + 2) % 4] = n5;
        this.iSign[(n3 + 2) % 4] = -1;
        this.iIndex[n4] = n5 + 1;
        this.iSign[n4] = 1;
        this.lastDirection = n4;
        this.toDefine = gridElement.numberOfCons() - 2;
    }

    public int start(GridElement gridElement, int n) {
        int n2 = (this.lastDirection + 1) % 4;
        while (gridElement.connection[n2] == null | this.iSign[n2] != 0) {
            n2 = (n2 + 1) % 4;
        }
        this.iIndex[n2] = n + 1;
        this.iSign[n2] = 1;
        this.lastDirection = n2;
        --this.toDefine;
        return n2;
    }

    public void stop(int n, int n2) {
        this.iIndex[(n + 2) % 4] = n2;
        this.iSign[(n + 2) % 4] = -1;
        this.lastDirection = n;
        --this.toDefine;
    }

    public void print() {
        System.out.println(String.valueOf(String.valueOf(new StringBuffer("BranchPoint: x/y/lastDir/todefine: ").append(this.xcoord).append("/").append(this.ycoord).append("/").append(this.lastDirection).append("/").append(this.toDefine))));
        for (int i = 0; i < 4; ++i) {
            System.out.print(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.iIndex[i]))).append(" ").append(this.iSign[i]).append(" "))));
        }
        System.out.println();
    }
}

