/*
 * Decompiled with CFR 0.152.
 */
package circuitsimulator;

import circuitsimulator.Ameter;
import circuitsimulator.Battery;
import circuitsimulator.Bulb;
import circuitsimulator.Capacitor;
import circuitsimulator.Circuit;
import circuitsimulator.CircuitBuilder;
import circuitsimulator.CircuitElement;
import circuitsimulator.CurrentSource;
import circuitsimulator.Diode;
import circuitsimulator.Inductor;
import circuitsimulator.ListOutput;
import circuitsimulator.Resistor;
import circuitsimulator.Scope;
import circuitsimulator.SinWave;
import circuitsimulator.Source;
import circuitsimulator.SquareWave;
import circuitsimulator.Switch;
import circuitsimulator.TransformerCoil;
import circuitsimulator.ValueInput;
import circuitsimulator.Vmeter;
import circuitsimulator.Wire;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Point;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.beans.PropertyVetoException;
import symantec.itools.awt.BorderPanel;
import symantec.itools.awt.util.spinner.NumericSpinner;

public class BuilderPanel
extends BorderPanel {
    CircuitBuilder circuitBuilder = null;
    String selectedComponent = "";
    Button setGridButton = new Button();
    NumericSpinner rowSpin = new NumericSpinner();
    NumericSpinner colSpin = new NumericSpinner();
    Label label1 = new Label();
    Label label3 = new Label();
    Button listButton = new Button();
    Button calculateButton = new Button();
    TextField numberInput = new TextField();
    TextField dtInput = new TextField();
    Label label9 = new Label();
    Label label10 = new Label();
    Button arrows = new Button();
    Button loadButton = new Button();
    TextField inputfile = new TextField();
    Button forwarding = new Button();
    Button resetting = new Button();
    BorderPanel resistorBorder = new BorderPanel();
    BorderPanel capacitorBorder = new BorderPanel();
    BorderPanel inductorBorder = new BorderPanel();
    BorderPanel wireBorder = new BorderPanel();
    BorderPanel sourceBorder = new BorderPanel();
    BorderPanel scopeBorder = new BorderPanel();
    BorderPanel vmeterBorder = new BorderPanel();
    BorderPanel ameterBorder = new BorderPanel();
    BorderPanel switchBorder = new BorderPanel();
    BorderPanel batteryBorder = new BorderPanel();
    BorderPanel bulbBorder = new BorderPanel();
    BorderPanel currentsourceBorder = new BorderPanel();
    BorderPanel transformerBorder = new BorderPanel();
    BorderPanel sinwaveBorder = new BorderPanel();
    BorderPanel squarewaveBorder = new BorderPanel();
    BorderPanel diodeBorder = new BorderPanel();
    String coordStr;
    Wire wire = new Wire();
    Resistor resistor = new Resistor();
    Capacitor capacitor = new Capacitor();
    Inductor inductor = new Inductor();
    Switch switch1 = new Switch();
    Bulb bulb = new Bulb();
    TransformerCoil transformercoil = new TransformerCoil();
    Diode diode = new Diode();
    Source source = new Source();
    Battery battery = new Battery();
    CurrentSource currentsource = new CurrentSource();
    SinWave sinwave = new SinWave();
    SquareWave squarewave = new SquareWave();
    Vmeter vmeter = new Vmeter();
    Ameter ameter = new Ameter();
    Scope scope = new Scope();

    public BuilderPanel() {
        try {
            this.setPaddingRight(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.setBevelStyle(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.setPaddingLeft(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.setIPadBottom(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.setPaddingBottom(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.setPaddingTop(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.setIPadSides(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.setIPadTop(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.setLayout(null);
        this.setBackground(new Color(0, 143, 213));
        this.setSize(195, 401);
        this.setGridButton.setLabel("Set grid");
        this.add(this.setGridButton);
        this.setGridButton.setBackground(new Color(0, 169, 251));
        this.setGridButton.setBounds(5, 32, 59, 48);
        try {
            this.rowSpin.setMin(2);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.rowSpin.setCurrent(2);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.rowSpin.setMax(8);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.add(this.rowSpin);
        this.rowSpin.setBackground(Color.yellow);
        this.rowSpin.setForeground(Color.black);
        this.rowSpin.setBounds(64, 32, 28, 24);
        try {
            this.colSpin.setMin(2);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.colSpin.setCurrent(2);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.colSpin.setMax(5);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.add(this.colSpin);
        this.colSpin.setBackground(Color.yellow);
        this.colSpin.setBounds(64, 56, 28, 24);
        this.label1.setText("rows");
        this.add(this.label1);
        this.label1.setFont(new Font("Dialog", 0, 10));
        this.label1.setBounds(93, 32, 44, 24);
        this.label3.setText("cols");
        this.add(this.label3);
        this.label3.setFont(new Font("Dialog", 0, 10));
        this.label3.setBounds(93, 56, 44, 22);
        try {
            this.resistorBorder.setBevelStyle(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.resistorBorder.setIPadBottom(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.resistorBorder.setIPadSides(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.resistorBorder.setPaddingRight(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.resistorBorder.setPaddingBottom(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.resistorBorder.setPaddingTop(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.resistorBorder.setIPadTop(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.resistorBorder.setPaddingLeft(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.resistorBorder.setLayout(null);
        this.add(this.resistorBorder);
        this.resistorBorder.setBackground(new Color(0, 169, 251));
        this.resistorBorder.setBounds(5, 99, 56, 28);
        try {
            this.capacitorBorder.setBevelStyle(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.capacitorBorder.setIPadBottom(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.capacitorBorder.setIPadSides(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.capacitorBorder.setPaddingRight(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.capacitorBorder.setPaddingBottom(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.capacitorBorder.setPaddingTop(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.capacitorBorder.setIPadTop(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.capacitorBorder.setPaddingLeft(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.capacitorBorder.setLayout(null);
        this.add(this.capacitorBorder);
        this.capacitorBorder.setBackground(new Color(0, 169, 251));
        this.capacitorBorder.setBounds(5, 127, 56, 28);
        try {
            this.inductorBorder.setBevelStyle(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.inductorBorder.setIPadBottom(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.inductorBorder.setIPadSides(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.inductorBorder.setPaddingRight(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.inductorBorder.setPaddingBottom(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.inductorBorder.setPaddingTop(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.inductorBorder.setIPadTop(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.inductorBorder.setPaddingLeft(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.inductorBorder.setLayout(null);
        this.add(this.inductorBorder);
        this.inductorBorder.setBackground(new Color(0, 169, 251));
        this.inductorBorder.setBounds(5, 155, 56, 28);
        try {
            this.wireBorder.setBevelStyle(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.wireBorder.setIPadBottom(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.wireBorder.setIPadSides(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.wireBorder.setPaddingRight(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.wireBorder.setPaddingBottom(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.wireBorder.setPaddingTop(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.wireBorder.setIPadTop(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.wireBorder.setPaddingLeft(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.wireBorder.setLayout(null);
        this.add(this.wireBorder);
        this.wireBorder.setBackground(new Color(0, 169, 251));
        this.wireBorder.setBounds(69, 127, 56, 28);
        try {
            this.sourceBorder.setBevelStyle(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.sourceBorder.setIPadBottom(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.sourceBorder.setIPadSides(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.sourceBorder.setPaddingRight(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.sourceBorder.setPaddingBottom(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.sourceBorder.setPaddingTop(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.sourceBorder.setIPadTop(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.sourceBorder.setPaddingLeft(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.sourceBorder.setLayout(null);
        this.add(this.sourceBorder);
        this.sourceBorder.setBackground(new Color(0, 169, 251));
        this.sourceBorder.setBounds(5, 226, 56, 28);
        this.listButton.setLabel("List");
        this.add(this.listButton);
        this.listButton.setBackground(new Color(0, 169, 251));
        this.listButton.setBounds(138, 32, 51, 23);
        this.calculateButton.setLabel("Calculate");
        this.add(this.calculateButton);
        this.calculateButton.setBackground(new Color(0, 169, 251));
        this.calculateButton.setBounds(6, 372, 67, 24);
        try {
            this.scopeBorder.setBevelStyle(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.scopeBorder.setIPadBottom(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.scopeBorder.setIPadSides(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.scopeBorder.setPaddingRight(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.scopeBorder.setPaddingBottom(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.scopeBorder.setPaddingTop(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.scopeBorder.setIPadTop(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.scopeBorder.setPaddingLeft(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.scopeBorder.setLayout(null);
        this.add(this.scopeBorder);
        this.scopeBorder.setBackground(new Color(0, 169, 251));
        this.scopeBorder.setBounds(133, 226, 56, 28);
        try {
            this.vmeterBorder.setPaddingRight(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.vmeterBorder.setBevelStyle(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.vmeterBorder.setPaddingLeft(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.vmeterBorder.setIPadBottom(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.vmeterBorder.setPaddingBottom(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.vmeterBorder.setPaddingTop(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.vmeterBorder.setIPadSides(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.vmeterBorder.setIPadTop(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.vmeterBorder.setLayout(null);
        this.add(this.vmeterBorder);
        this.vmeterBorder.setBackground(new Color(0, 169, 251));
        this.vmeterBorder.setBounds(133, 254, 56, 28);
        try {
            this.ameterBorder.setPaddingRight(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.ameterBorder.setBevelStyle(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.ameterBorder.setPaddingLeft(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.ameterBorder.setIPadBottom(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.ameterBorder.setPaddingBottom(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.ameterBorder.setPaddingTop(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.ameterBorder.setIPadSides(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.ameterBorder.setIPadTop(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.ameterBorder.setLayout(null);
        this.add(this.ameterBorder);
        this.ameterBorder.setBackground(new Color(0, 169, 251));
        this.ameterBorder.setBounds(133, 282, 56, 28);
        try {
            this.switchBorder.setPaddingRight(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.switchBorder.setBevelStyle(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.switchBorder.setPaddingLeft(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.switchBorder.setIPadBottom(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.switchBorder.setPaddingBottom(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.switchBorder.setPaddingTop(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.switchBorder.setIPadSides(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.switchBorder.setIPadTop(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.switchBorder.setLayout(null);
        this.add(this.switchBorder);
        this.switchBorder.setBackground(new Color(0, 169, 251));
        this.switchBorder.setBounds(69, 155, 56, 28);
        try {
            this.batteryBorder.setPaddingRight(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.batteryBorder.setBevelStyle(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.batteryBorder.setPaddingLeft(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.batteryBorder.setIPadBottom(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.batteryBorder.setPaddingBottom(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.batteryBorder.setPaddingTop(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.batteryBorder.setIPadSides(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.batteryBorder.setIPadTop(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.batteryBorder.setLayout(null);
        this.add(this.batteryBorder);
        this.batteryBorder.setBackground(new Color(0, 169, 251));
        this.batteryBorder.setBounds(5, 254, 56, 28);
        this.numberInput.setText("1e3");
        this.add(this.numberInput);
        this.numberInput.setBackground(Color.white);
        this.numberInput.setFont(new Font("Dialog", 0, 10));
        this.numberInput.setBounds(141, 346, 47, 20);
        this.dtInput.setText("1e-6");
        this.add(this.dtInput);
        this.dtInput.setBackground(Color.white);
        this.dtInput.setFont(new Font("Dialog", 0, 10));
        this.dtInput.setBounds(40, 347, 72, 19);
        this.label9.setText("#:");
        this.add(this.label9);
        this.label9.setBounds(126, 343, 16, 23);
        this.label10.setText("dt (s):");
        this.add(this.label10);
        this.label10.setBounds(5, 344, 34, 24);
        this.arrows.setLabel("Show ->");
        this.add(this.arrows);
        this.arrows.setBackground(new Color(0, 169, 251));
        this.arrows.setBounds(139, 58, 50, 23);
        this.loadButton.setLabel("Load");
        this.add(this.loadButton);
        this.loadButton.setBackground(new Color(0, 169, 251));
        this.loadButton.setBounds(6, 5, 52, 25);
        this.inputfile.setText("lists/default.txt");
        this.add(this.inputfile);
        this.inputfile.setBackground(Color.white);
        this.inputfile.setBounds(59, 5, 129, 24);
        try {
            this.bulbBorder.setPaddingRight(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.bulbBorder.setBevelStyle(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.bulbBorder.setPaddingLeft(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.bulbBorder.setIPadBottom(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.bulbBorder.setPaddingBottom(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.bulbBorder.setPaddingTop(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.bulbBorder.setIPadSides(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.bulbBorder.setIPadTop(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.bulbBorder.setLayout(null);
        this.add(this.bulbBorder);
        this.bulbBorder.setBackground(new Color(0, 169, 251));
        this.bulbBorder.setBounds(69, 99, 56, 28);
        this.forwarding.setLabel("Start");
        this.add(this.forwarding);
        this.forwarding.setBackground(new Color(0, 169, 251));
        this.forwarding.setBounds(75, 371, 56, 25);
        this.resetting.setLabel("Reset");
        this.add(this.resetting);
        this.resetting.setBackground(new Color(0, 169, 251));
        this.resetting.setBounds(132, 371, 58, 25);
        try {
            this.currentsourceBorder.setPaddingRight(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.currentsourceBorder.setBevelStyle(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.currentsourceBorder.setPaddingLeft(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.currentsourceBorder.setIPadBottom(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.currentsourceBorder.setPaddingBottom(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.currentsourceBorder.setPaddingTop(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.currentsourceBorder.setIPadSides(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.currentsourceBorder.setIPadTop(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.currentsourceBorder.setLayout(null);
        this.add(this.currentsourceBorder);
        this.currentsourceBorder.setBackground(new Color(0, 169, 251));
        this.currentsourceBorder.setBounds(5, 282, 56, 28);
        try {
            this.transformerBorder.setPaddingRight(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.transformerBorder.setBevelStyle(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.transformerBorder.setPaddingLeft(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.transformerBorder.setIPadBottom(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.transformerBorder.setPaddingBottom(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.transformerBorder.setPaddingTop(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.transformerBorder.setIPadSides(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.transformerBorder.setIPadTop(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.transformerBorder.setLayout(null);
        this.add(this.transformerBorder);
        this.transformerBorder.setBackground(new Color(0, 169, 251));
        this.transformerBorder.setBounds(134, 99, 56, 42);
        try {
            this.sinwaveBorder.setPaddingRight(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.sinwaveBorder.setBevelStyle(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.sinwaveBorder.setPaddingLeft(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.sinwaveBorder.setIPadBottom(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.sinwaveBorder.setPaddingBottom(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.sinwaveBorder.setPaddingTop(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.sinwaveBorder.setIPadSides(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.sinwaveBorder.setIPadTop(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.sinwaveBorder.setLayout(null);
        this.add(this.sinwaveBorder);
        this.sinwaveBorder.setBackground(new Color(0, 169, 251));
        this.sinwaveBorder.setBounds(69, 226, 56, 28);
        try {
            this.squarewaveBorder.setPaddingRight(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.squarewaveBorder.setBevelStyle(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.squarewaveBorder.setPaddingLeft(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.squarewaveBorder.setIPadBottom(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.squarewaveBorder.setPaddingBottom(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.squarewaveBorder.setPaddingTop(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.squarewaveBorder.setIPadSides(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.squarewaveBorder.setIPadTop(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.squarewaveBorder.setLayout(null);
        this.add(this.squarewaveBorder);
        this.squarewaveBorder.setBackground(new Color(0, 169, 251));
        this.squarewaveBorder.setBounds(69, 254, 56, 28);
        try {
            this.diodeBorder.setPaddingRight(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.diodeBorder.setBevelStyle(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.diodeBorder.setPaddingLeft(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.diodeBorder.setIPadBottom(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.diodeBorder.setPaddingBottom(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.diodeBorder.setPaddingTop(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.diodeBorder.setIPadSides(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.diodeBorder.setIPadTop(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.diodeBorder.setLayout(null);
        this.add(this.diodeBorder);
        this.diodeBorder.setBackground(new Color(0, 169, 251));
        this.diodeBorder.setBounds(5, 191, 56, 28);
        this.wireBorder.add(this.wire);
        this.resistorBorder.add(this.resistor);
        this.inductorBorder.add(this.inductor);
        this.capacitorBorder.add(this.capacitor);
        this.switchBorder.add(this.switch1);
        this.bulbBorder.add(this.bulb);
        this.transformerBorder.add(this.transformercoil);
        this.diodeBorder.add(this.diode);
        this.sourceBorder.add(this.source);
        this.batteryBorder.add(this.battery);
        this.currentsourceBorder.add(this.currentsource);
        this.sinwaveBorder.add(this.sinwave);
        this.squarewaveBorder.add(this.squarewave);
        this.scopeBorder.add(this.scope);
        this.vmeterBorder.add(this.vmeter);
        this.ameterBorder.add(this.ameter);
        SymAction symAction = new SymAction();
        this.setGridButton.addActionListener(symAction);
        SymMouse symMouse = new SymMouse();
        this.listButton.addActionListener(symAction);
        this.calculateButton.addActionListener(symAction);
        SymText symText = new SymText();
        this.numberInput.addTextListener(symText);
        this.dtInput.addTextListener(symText);
        this.arrows.addActionListener(symAction);
        this.loadButton.addActionListener(symAction);
        this.inputfile.addActionListener(symAction);
        this.forwarding.addActionListener(symAction);
        this.resetting.addActionListener(symAction);
        this.resistor.addMouseListener(symMouse);
        this.wire.addMouseListener(symMouse);
        this.capacitor.addMouseListener(symMouse);
        this.inductor.addMouseListener(symMouse);
        this.switch1.addMouseListener(symMouse);
        this.bulb.addMouseListener(symMouse);
        this.transformercoil.addMouseListener(symMouse);
        this.diode.addMouseListener(symMouse);
        this.source.addMouseListener(symMouse);
        this.battery.addMouseListener(symMouse);
        this.currentsource.addMouseListener(symMouse);
        this.sinwave.addMouseListener(symMouse);
        this.squarewave.addMouseListener(symMouse);
        this.scope.addMouseListener(symMouse);
        this.vmeter.addMouseListener(symMouse);
        this.ameter.addMouseListener(symMouse);
    }

    public void setcircuitBuilder(CircuitBuilder circuitBuilder) {
        this.circuitBuilder = circuitBuilder;
        this.label1.setText(circuitBuilder.cirProp.getProperty("rows"));
        this.label3.setText(circuitBuilder.cirProp.getProperty("cols"));
        this.loadButton.setLabel(circuitBuilder.cirProp.getProperty("Load"));
        this.setGridButton.setLabel(circuitBuilder.cirProp.getProperty("setgrid"));
        this.listButton.setLabel(circuitBuilder.cirProp.getProperty("List"));
        this.arrows.setLabel(circuitBuilder.cirProp.getProperty("arrows"));
        this.calculateButton.setLabel(circuitBuilder.cirProp.getProperty("Calculate"));
        this.forwarding.setLabel(circuitBuilder.cirProp.getProperty("Start"));
        this.resetting.setLabel(circuitBuilder.cirProp.getProperty("Reset"));
        this.dtInput.setText(Double.toString(this.circuitBuilder.dt));
        this.numberInput.setText(Integer.toString(this.circuitBuilder.numberofdt));
    }

    public void loadImages() {
        this.resistor.setCircuit(this.circuitBuilder);
        this.wire.setCircuit(this.circuitBuilder);
        this.capacitor.setCircuit(this.circuitBuilder);
        this.inductor.setCircuit(this.circuitBuilder);
        this.switch1.setCircuit(this.circuitBuilder);
        this.bulb.setCircuit(this.circuitBuilder);
        this.transformercoil.setCircuit(this.circuitBuilder);
        this.diode.setCircuit(this.circuitBuilder);
        this.source.setCircuit(this.circuitBuilder);
        this.battery.setCircuit(this.circuitBuilder);
        this.currentsource.setCircuit(this.circuitBuilder);
        this.sinwave.setCircuit(this.circuitBuilder);
        this.squarewave.setCircuit(this.circuitBuilder);
        this.scope.setCircuit(this.circuitBuilder);
        this.vmeter.setCircuit(this.circuitBuilder);
        this.ameter.setCircuit(this.circuitBuilder);
    }

    void setGridButton_ActionPerformed(ActionEvent actionEvent) {
        int n = this.rowSpin.getCurrent();
        int n2 = this.colSpin.getCurrent();
        this.circuitBuilder.setGrid(n, n2);
    }

    void resetButtons() {
        try {
            this.resistorBorder.setBevelStyle(1);
            this.capacitorBorder.setBevelStyle(1);
            this.inductorBorder.setBevelStyle(1);
            this.wireBorder.setBevelStyle(1);
            this.switchBorder.setBevelStyle(1);
            this.bulbBorder.setBevelStyle(1);
            this.transformerBorder.setBevelStyle(1);
            this.diodeBorder.setBevelStyle(1);
            this.sourceBorder.setBevelStyle(1);
            this.batteryBorder.setBevelStyle(1);
            this.currentsourceBorder.setBevelStyle(1);
            this.sinwaveBorder.setBevelStyle(1);
            this.squarewaveBorder.setBevelStyle(1);
            this.scopeBorder.setBevelStyle(1);
            this.vmeterBorder.setBevelStyle(1);
            this.ameterBorder.setBevelStyle(1);
            this.dtInput.setText(Double.toString(this.circuitBuilder.dt));
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    void changeProperties() {
        Container container = this.getParent();
        while (!(container instanceof Frame)) {
            container = ((Component)container).getParent();
        }
        String string = "".concat(String.valueOf(String.valueOf(this.circuitBuilder.cirProp.getProperty("changevalue_title"))));
        ValueInput valueInput = new ValueInput(string, this.circuitBuilder, (Frame)container);
    }

    void listButton_ActionPerformed(ActionEvent actionEvent) {
        String string = this.circuitBuilder.cirgrid.getcomponentList();
        String string2 = this.circuitBuilder.cirProp.getProperty("circuitlist");
        Container container = this.getParent();
        while (!(container instanceof Frame)) {
            container = ((Component)container).getParent();
        }
        ListOutput listOutput = new ListOutput(string2, string, (Frame)container, this.circuitBuilder);
    }

    void parseButton_ActionPerformed(ActionEvent actionEvent) {
        this.circuitBuilder.parse();
        this.circuitBuilder.repaintMeters();
    }

    void calculateButton_ActionPerformed(ActionEvent actionEvent) {
        this.circuitBuilder.repaintMeters();
        if ((this.circuitBuilder.debugLevel & Circuit.DEBUG_IO) > 0) {
            System.out.println("Next period calculated");
        }
    }

    void arrows_ActionPerformed(ActionEvent actionEvent) {
        if (this.circuitBuilder.showCurrent) {
            this.circuitBuilder.setShowCurrent(0);
        } else {
            this.circuitBuilder.setShowCurrent(1);
        }
        this.circuitBuilder.circanvas.redraw();
    }

    public Point absoluteP(Point point, Component component) {
        Point point2 = new Point(point);
        for (Component component2 = component; component2 != this; component2 = component2.getParent()) {
            Point point3 = component2.getLocation();
            point2.setLocation(point2.x + point3.x, point2.y + point3.y);
        }
        point2.setLocation(point2.x + this.getLocation().x, point2.y + this.getLocation().y);
        if ((this.circuitBuilder.debugLevel & Circuit.DEBUG_IO) > 0) {
            System.out.println("coords : ".concat(String.valueOf(String.valueOf(point2.toString()))));
        }
        return point2;
    }

    public void updateTextFields() {
        this.dtInput.setText(Double.toString(this.circuitBuilder.dt));
        this.numberInput.setText(Integer.toString(this.circuitBuilder.numberofdt));
    }

    void numberInput_TextValueChanged(TextEvent textEvent) {
        this.circuitBuilder.setNumberOfDT(Integer.parseInt(this.numberInput.getText()));
        this.circuitBuilder.repaintMeters();
    }

    void dtInput_TextValueChanged(TextEvent textEvent) {
        this.circuitBuilder.setDT(Double.valueOf(this.dtInput.getText()));
        this.circuitBuilder.setFPS(1.0 / ((double)this.circuitBuilder.noc * this.circuitBuilder.dt));
        this.circuitBuilder.repaintMeters();
    }

    void loadButton_ActionPerformed(ActionEvent actionEvent) {
        this.circuitBuilder.reset();
        this.forwarding.setLabel(this.circuitBuilder.cirProp.getProperty("Start"));
        this.circuitBuilder.loadList(this.inputfile.getText());
        this.updateTextFields();
        this.circuitBuilder.parse();
        this.circuitBuilder.calculateCircuit();
    }

    void forwarding_ActionPerformed(ActionEvent actionEvent) {
        if (this.forwarding.getLabel().equals(this.circuitBuilder.cirProp.getProperty("Start"))) {
            this.circuitBuilder.forward();
            this.forwarding.setLabel(this.circuitBuilder.cirProp.getProperty("Pause"));
        } else {
            this.circuitBuilder.pause();
            this.forwarding.setLabel(this.circuitBuilder.cirProp.getProperty("Start"));
        }
    }

    void resetting_ActionPerformed(ActionEvent actionEvent) {
        this.circuitBuilder.pause();
        this.circuitBuilder.reset();
        this.forwarding.setLabel(this.circuitBuilder.cirProp.getProperty("Start"));
    }

    class SymText
    implements TextListener {
        SymText() {
        }

        public void textValueChanged(TextEvent textEvent) {
            Object object = textEvent.getSource();
            if (object == BuilderPanel.this.numberInput) {
                BuilderPanel.this.numberInput_TextValueChanged(textEvent);
            } else if (object == BuilderPanel.this.dtInput) {
                BuilderPanel.this.dtInput_TextValueChanged(textEvent);
            }
        }
    }

    class SymMouse
    extends MouseAdapter {
        SymMouse() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            try {
                if (object == BuilderPanel.this.resistor) {
                    BuilderPanel.this.resistorBorder.setBevelStyle(0);
                } else if (object == BuilderPanel.this.capacitor) {
                    BuilderPanel.this.capacitorBorder.setBevelStyle(0);
                } else if (object == BuilderPanel.this.inductor) {
                    BuilderPanel.this.inductorBorder.setBevelStyle(0);
                } else if (object == BuilderPanel.this.wire) {
                    BuilderPanel.this.wireBorder.setBevelStyle(0);
                } else if (object == BuilderPanel.this.switch1) {
                    BuilderPanel.this.switchBorder.setBevelStyle(0);
                } else if (object == BuilderPanel.this.bulb) {
                    BuilderPanel.this.bulbBorder.setBevelStyle(0);
                } else if (object == BuilderPanel.this.transformercoil) {
                    BuilderPanel.this.transformerBorder.setBevelStyle(0);
                } else if (object == BuilderPanel.this.diode) {
                    BuilderPanel.this.diodeBorder.setBevelStyle(0);
                } else if (object == BuilderPanel.this.source) {
                    BuilderPanel.this.sourceBorder.setBevelStyle(0);
                } else if (object == BuilderPanel.this.battery) {
                    BuilderPanel.this.batteryBorder.setBevelStyle(0);
                } else if (object == BuilderPanel.this.currentsource) {
                    BuilderPanel.this.currentsourceBorder.setBevelStyle(0);
                } else if (object == BuilderPanel.this.sinwave) {
                    BuilderPanel.this.sinwaveBorder.setBevelStyle(0);
                } else if (object == BuilderPanel.this.squarewave) {
                    BuilderPanel.this.squarewaveBorder.setBevelStyle(0);
                } else if (object == BuilderPanel.this.scope) {
                    BuilderPanel.this.scopeBorder.setBevelStyle(0);
                } else if (object == BuilderPanel.this.vmeter) {
                    BuilderPanel.this.vmeterBorder.setBevelStyle(0);
                } else if (object == BuilderPanel.this.ameter) {
                    BuilderPanel.this.ameterBorder.setBevelStyle(0);
                }
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            int n = -1;
            BuilderPanel.this.coordStr = BuilderPanel.this.circuitBuilder.coordString(BuilderPanel.this.absoluteP(mouseEvent.getPoint(), (Component)object), true);
            String string = "".concat(String.valueOf(String.valueOf(((CircuitElement)object).name())));
            n = string.equals("transformercoil") ? BuilderPanel.this.circuitBuilder.addObject("transformer", BuilderPanel.this.coordStr) : BuilderPanel.this.circuitBuilder.addObject(string, BuilderPanel.this.coordStr);
            if (n != -1) {
                BuilderPanel.this.circuitBuilder.currentElement = BuilderPanel.this.circuitBuilder.getComponent(BuilderPanel.this.coordStr);
                if (!(string.equals("wire") || string.equals("scope") || string.equals("ameter") || string.equals("vmeter"))) {
                    BuilderPanel.this.changeProperties();
                }
                BuilderPanel.this.circuitBuilder.reset();
                BuilderPanel.this.forwarding.setLabel(BuilderPanel.this.circuitBuilder.cirProp.getProperty("Start"));
                BuilderPanel.this.circuitBuilder.parse();
                BuilderPanel.this.circuitBuilder.repaintMeters();
            }
            BuilderPanel.this.resetButtons();
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == BuilderPanel.this.setGridButton) {
                BuilderPanel.this.setGridButton_ActionPerformed(actionEvent);
            } else if (object == BuilderPanel.this.listButton) {
                BuilderPanel.this.listButton_ActionPerformed(actionEvent);
            } else if (object == BuilderPanel.this.calculateButton) {
                BuilderPanel.this.calculateButton_ActionPerformed(actionEvent);
            } else if (object == BuilderPanel.this.arrows) {
                BuilderPanel.this.arrows_ActionPerformed(actionEvent);
            } else if (object == BuilderPanel.this.loadButton) {
                BuilderPanel.this.loadButton_ActionPerformed(actionEvent);
            } else if (object == BuilderPanel.this.forwarding) {
                BuilderPanel.this.forwarding_ActionPerformed(actionEvent);
            } else if (object == BuilderPanel.this.resetting) {
                BuilderPanel.this.resetting_ActionPerformed(actionEvent);
            }
        }
    }
}

