/*
 * Decompiled with CFR 0.152.
 */
package circuitsimulator;

import circuitsimulator.Circuit;
import circuitsimulator.CircuitElement;
import edu.davidson.tools.SUtil;
import java.awt.Color;
import java.awt.Graphics;

public class Bulb
extends CircuitElement {
    double volt;
    double watt;
    int colorR;
    int colorG;
    int colorB;
    int ri = 0;

    Bulb(Circuit circuit, double d, double d2, int n, int n2, String string) {
        super(circuit, n, n2, string);
        this.variableImage = true;
        this.setValueVisible(false);
        this.volt = d;
        this.watt = d2;
        this.value = this.volt * this.volt / this.watt;
        this.maxCurrentValue = this.watt / this.volt + 1.0;
        this.colorR = 0;
        this.colorG = 0;
        this.colorB = 0;
    }

    Bulb() {
    }

    public double impedance() {
        return this.value;
    }

    public String getStringAdditions() {
        return String.valueOf(String.valueOf(new StringBuffer(",v=").append(Double.toString(this.volt)).append(",w=").append(Double.toString(this.watt))));
    }

    public boolean set(String string) {
        boolean bl = super.set(string);
        if (SUtil.parameterExist((String)string, (String)"v=")) {
            this.volt = SUtil.getParam((String)string, (String)"v=");
        }
        if (SUtil.parameterExist((String)string, (String)"w=")) {
            this.watt = SUtil.getParam((String)string, (String)"w=");
        }
        this.value = this.volt * this.volt / this.watt;
        this.maxCurrentValue = this.watt / this.volt + 1.0;
        return bl;
    }

    public void loadImage(Graphics graphics) {
    }

    public String valueStr() {
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Double.toString(this.volt)))).append("V,").append(Double.toString(this.watt)).append("W")));
    }

    public void repaintImage(Graphics graphics) {
        super.repaintImage(graphics);
        int n = this.circuit.interGrid / 2;
        this.colorG = this.circuit.parsed ? Math.min(255, (int)(255.0 * Math.abs(this.getI() * this.volt / this.watt))) : 0;
        this.colorR = this.colorG < 128 ? this.colorG * 2 : 255;
        this.colorB = this.colorG < 128 ? 0 : 2 * (this.colorG - 128);
        graphics.setColor(new Color(this.colorR, this.colorG, this.colorB));
        if (this.to.equals("h")) {
            graphics.fillOval(this.x + n - 7, this.y - 6, 13, 13);
            graphics.setColor(Color.red);
            graphics.drawOval(this.x + n - 7, this.y - 6, 13, 13);
            graphics.drawLine(this.x + n - 5, this.y - 4, this.x + n + 4, this.y + 5);
            graphics.drawLine(this.x + n + 4, this.y - 4, this.x + n - 5, this.y + 5);
        } else {
            graphics.fillOval(this.x - 6, this.y + n - 7, 13, 13);
            graphics.setColor(Color.red);
            graphics.drawOval(this.x - 6, this.y + n - 7, 13, 13);
            graphics.drawLine(this.x - 4, this.y + n - 5, this.x + 5, this.y + n + 4);
            graphics.drawLine(this.x - 4, this.y + n + 4, this.x + 5, this.y + n - 5);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        graphics.setColor(Color.red);
        int n = this.circuit.interGrid / 2;
        if (this.to.equals("h")) {
            graphics.drawLine(this.x + 3, this.y, this.x + n - 7, this.y);
            graphics.drawLine(this.x + n + 6, this.y, this.x + this.circuit.interGrid - 4, this.y);
        } else {
            graphics.drawLine(this.x, this.y + 3, this.x, this.y + n - 7);
            graphics.drawLine(this.x, this.y + n + 6, this.x, this.y + this.circuit.interGrid - 4);
        }
        if (this.circuit.parsed && this.canvasElement) {
            this.repaintImage(graphics);
        } else if (this.to.equals("h")) {
            graphics.drawOval(this.x + n - 7, this.y - 6, 13, 13);
            graphics.drawLine(this.x + n - 5, this.y - 4, this.x + n + 4, this.y + 5);
            graphics.drawLine(this.x + n + 4, this.y - 4, this.x + n - 5, this.y + 5);
        } else {
            graphics.drawOval(this.x - 6, this.y + n - 7, 13, 13);
            graphics.drawLine(this.x - 4, this.y + n - 5, this.x + 5, this.y + n + 4);
            graphics.drawLine(this.x - 4, this.y + n + 4, this.x + 5, this.y + n - 5);
        }
    }
}

