/*
 * Decompiled with CFR 0.152.
 */
package circuitsimulator;

import circuitsimulator.Circuit;
import circuitsimulator.CircuitElement;
import edu.davidson.tools.SUtil;

public class Capacitor
extends CircuitElement {
    Capacitor(Circuit circuit, double d, int n, int n2, String string) {
        super(circuit, n, n2, string);
        this.value = d;
        this.unity = "F";
    }

    Capacitor() {
    }

    public double impedance() {
        return this.circuit.dt / this.value;
    }

    public double integralVHere() {
        return -1.0;
    }

    public double integralVNext() {
        return 1.0;
    }

    public String getStringAdditions() {
        return ",c=".concat(String.valueOf(String.valueOf(Double.toString(this.value))));
    }

    public boolean set(String string) {
        boolean bl = super.set(string);
        if (SUtil.parameterExist((String)string, (String)"c=")) {
            this.value = SUtil.getParam((String)string, (String)"c=");
        }
        return bl;
    }
}

