/*
 * Decompiled with CFR 0.152.
 */
package circuitsimulator;

import circuitsimulator.Ameter;
import circuitsimulator.Battery;
import circuitsimulator.Bulb;
import circuitsimulator.Capacitor;
import circuitsimulator.CircuitCanvas;
import circuitsimulator.CircuitElement;
import circuitsimulator.CircuitGrid;
import circuitsimulator.CircuitProperties;
import circuitsimulator.CurrentSource;
import circuitsimulator.Diode;
import circuitsimulator.IGeneral;
import circuitsimulator.Inductor;
import circuitsimulator.Nothing;
import circuitsimulator.Probe;
import circuitsimulator.Resistor;
import circuitsimulator.ResistorI;
import circuitsimulator.Scope;
import circuitsimulator.SinWave;
import circuitsimulator.Source;
import circuitsimulator.SquareWave;
import circuitsimulator.Switch;
import circuitsimulator.TransformerCoil;
import circuitsimulator.VEquation;
import circuitsimulator.VGeneral;
import circuitsimulator.Vmeter;
import circuitsimulator.Wire;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SStepable;
import edu.davidson.tools.SUtil;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;

public class Circuit
extends SApplet
implements SStepable,
Runnable {
    static short DEBUG_IO = 1;
    static short DEBUG_NUM = (short)2;
    public int numberofdt = 400;
    public double dt = 0.001;
    public int noc = 1;
    public double fps = 10.0;
    public double realt = 0.0;
    double[][] x;
    int interGrid = 54;
    Dimension gridZone;
    Thread runner;
    String localization;
    CircuitProperties cirProp = new CircuitProperties(new CircuitProperties());
    CircuitGrid cirgrid = new CircuitGrid(2, 2, this);
    CircuitCanvas circanvas;
    private URL imagebase;
    public String imagedir = "";
    boolean parsed = false;
    boolean showCurrent = false;
    static boolean DEBUG = false;

    public int getAppletCount() {
        if (this.firstTime) {
            return 0;
        }
        return super.getAppletCount();
    }

    public void start() {
        super.start();
        if (this.firstTime) {
            this.firstTime = false;
        }
        if (DEBUG) {
            this.build();
            this.clock.startClock();
        }
        if (this.runner == null) {
            this.runner = new Thread(this);
            this.runner.start();
        }
    }

    public void run() {
        while (true) {
            if (this.parsed) {
                this.circanvas.repaint();
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public void stop() {
        this.runner = null;
        super.stop();
    }

    public void reset() {
        super.reset();
        this.clearAllData();
        this.clock.setTime(0.0);
        this.cirgrid.reset();
    }

    public Circuit() {
        this.clock.setDt(this.dt * (double)this.noc);
        this.clock.setFPS(this.fps);
        this.clock.addClockListener((SStepable)this);
    }

    public void init() {
        this.initResources(null);
        this.gridZone = new Dimension(((Component)((Object)this)).getSize());
        String string = ((Applet)((Object)this)).getParameter("debugLevel");
        if (string != null) {
            this.debugLevel = Integer.parseInt(string);
        }
        this.interGrid = (string = ((Applet)((Object)this)).getParameter("intergrid")) == null ? 54 : Integer.parseInt(string);
        if (this.interGrid < 54) {
            this.interGrid = 54;
            System.out.println("interGrid = 54, because it can not be smaller");
        }
        this.numberofdt = (string = ((Applet)((Object)this)).getParameter("numberofdt")) == null ? 10 : Integer.parseInt(string);
        string = ((Applet)((Object)this)).getParameter("dt");
        this.dt = string == null ? 0.001 : Double.valueOf(string);
        string = ((Applet)((Object)this)).getParameter("noc");
        this.noc = string == null ? 1 : Integer.parseInt(string);
        if (this.numberofdt < this.noc) {
            this.numberofdt = this.noc;
            System.out.println("numberofdt = noc, because it can not be smaller");
        }
        this.fps = (string = ((Applet)((Object)this)).getParameter("fps")) == null ? 1.0 : Double.valueOf(string);
        this.resetTiming();
        string = ((Applet)((Object)this)).getParameter("localization");
        if (string == null) {
            string = ((Applet)((Object)this)).getParameter("Resources");
        }
        if (string != null) {
            this.localization = "".concat(String.valueOf(String.valueOf(string)));
            this.readCircuitProperties();
        }
        this.imagedir = (string = ((Applet)((Object)this)).getParameter("imagedir")) == null ? "circuitimages/" : String.valueOf(String.valueOf(this.imagedir)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(string)).concat("/"))));
        try {
            this.imagebase = new URL(String.valueOf(String.valueOf(((Applet)((Object)this)).getCodeBase().toString())).concat(String.valueOf(String.valueOf(this.imagedir))));
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("Bad URL");
        }
        this.circanvas = new CircuitCanvas(this);
        this.circanvas.setBounds(1, 1, 1, 1);
        ((Container)((Object)this)).add(this.circanvas);
    }

    void readCircuitProperties() {
        try {
            InputStream inputStream = new URL(((Applet)((Object)this)).getCodeBase(), this.localization).openStream();
            this.cirProp.load(inputStream);
            if ((this.debugLevel & DEBUG_IO) > 0) {
                System.out.println(((Hashtable)this.cirProp).toString());
            }
        }
        catch (Exception exception) {
            System.out.println("problem with circuit properties: ".concat(String.valueOf(String.valueOf(exception.getMessage()))));
        }
    }

    public void setGrid(int n, int n2) {
        this.parsed = false;
        this.circanvas.setBounds(1, 1, 1, 1);
        this.cirgrid = new CircuitGrid(n, n2, this);
        this.circanvas.reconnect();
    }

    public void setGrid(String string) {
        string = SUtil.removeWhitespace((String)string);
        int n = (int)SUtil.getParam((String)string, (String)"rows=");
        int n2 = (int)SUtil.getParam((String)string, (String)"cols=");
        this.setGrid(n, n2);
    }

    public void calculateCircuit() {
        if (this.parsed) {
            for (int i = 0; i < this.numberofdt; ++i) {
                this.cirgrid.calculateStep((double)i * this.dt);
                for (int j = 0; j < this.cirgrid.numberOfPars; ++j) {
                    this.x[j][i] = this.cirgrid.y[j];
                }
            }
        } else if ((this.debugLevel & DEBUG_IO) > 0) {
            System.out.println("Circuit not parsed");
        }
    }

    public void step(double d, double d2) {
        int n;
        if (this.parsed) {
            this.realt = d2 * this.dt * (double)this.noc / d;
            this.cirgrid.calculateStep(this.realt);
            this.updateDataConnections();
            for (n = 1; n < this.noc; ++n) {
                this.cirgrid.calculateStep(this.realt + (double)n * this.dt);
            }
        } else if ((this.debugLevel & DEBUG_IO) > 0) {
            System.out.println("Circuit not parsed");
        }
        n = 0;
        Enumeration enumeration = this.cirgrid.cirElemList.elements();
        while (enumeration.hasMoreElements()) {
            CircuitElement circuitElement = (CircuitElement)enumeration.nextElement();
            if (circuitElement.maxCurrentValue <= Math.abs(circuitElement.getI()) && !circuitElement.overloaded) {
                n = 1;
                break;
            }
            if (!(circuitElement.maxCurrentValue <= Math.abs(circuitElement.getI())) || circuitElement.overloaded) continue;
            n = 1;
            break;
        }
        if (n != 0) {
            this.circanvas.redraw();
        }
    }

    public void setIntergrid(int n) {
        this.interGrid = n;
        this.circanvas.reconnect();
    }

    public URL base() {
        return this.imagebase;
    }

    public void parse() {
        if (!this.cirgrid.constructEquationBase()) {
            return;
        }
        this.x = new double[this.cirgrid.numberOfPars][this.numberofdt];
        this.cirgrid.buildEquations();
        this.parsed = true;
        this.circanvas.redraw();
    }

    public void setDT(double d) {
        this.dt = d;
        this.resetTiming();
    }

    public void setNOC(int n) {
        this.noc = n;
        this.resetTiming();
    }

    public void setNumberOfDT(int n) {
        this.numberofdt = n;
    }

    public void setFPS(double d) {
        this.fps = d;
        this.resetTiming();
    }

    public void resetTiming() {
        this.clock.removeAllClockListeners();
        this.clock.setDt(this.dt * (double)this.noc);
        this.clock.setFPS(this.fps);
        this.clock.addClockListener((SStepable)this);
        this.cirgrid.buildEquations();
    }

    public void setShowCurrent(int n) {
        this.showCurrent = n != 0;
    }

    public double[] gett() {
        double[] dArray = new double[this.numberofdt];
        for (int i = 0; i < this.numberofdt; ++i) {
            dArray[i] = (double)i * this.dt;
        }
        return dArray;
    }

    public String getScript() {
        return this.cirgrid.getcomponentList();
    }

    public double[] getPar(int n) {
        return this.x[n];
    }

    public int getID(int n, int n2, String string) {
        return this.cirgrid.getCircuitElement(n, n2, string).hashCode();
    }

    public int getCoupledID(int n) {
        return this.cirgrid.getCircuitElement(n).getCoupledID();
    }

    public double[] getVoltage(int n, int n2, int n3, int n4) {
        double[] dArray = new double[this.numberofdt];
        int n5 = this.cirgrid.element[n][n2].getVIndex();
        int n6 = this.cirgrid.element[n3][n4].getVIndex();
        if ((this.debugLevel & DEBUG_IO) > 0) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("b,e=").append(n5).append(",").append(n6))));
        }
        for (int i = 0; i < this.numberofdt; ++i) {
            dArray[i] = this.x[n6][i] - this.x[n5][i];
        }
        return dArray;
    }

    public double[] getVoltage(int n) {
        double[] dArray = new double[this.numberofdt];
        VEquation vEquation = this.cirgrid.getCircuitElement((int)n).vequation;
        for (int i = 0; i < this.numberofdt; ++i) {
            dArray[i] = this.x[vEquation.indexV2][i] - this.x[vEquation.indexV1][i];
        }
        return dArray;
    }

    public double[] getCurrent(int n) {
        double[] dArray = new double[this.numberofdt];
        int n2 = this.cirgrid.getCircuitElement((int)n).vequation.indexI1;
        for (int i = 0; i < this.numberofdt; ++i) {
            dArray[i] = this.x[this.cirgrid.numberOfV + n2][i];
        }
        return dArray;
    }

    public double getVAmplitude(int n) {
        double d = -1.0E20;
        double d2 = 1.0E20;
        VEquation vEquation = this.cirgrid.getCircuitElement((int)n).vequation;
        for (int i = 0; i < this.numberofdt; ++i) {
            d = Math.max(this.x[vEquation.indexV2][i] - this.x[vEquation.indexV1][i], d);
            d2 = Math.min(this.x[vEquation.indexV2][i] - this.x[vEquation.indexV1][i], d2);
        }
        return (d - d2) / (double)2;
    }

    public double getIAmplitude(int n) {
        double d = -1.0E20;
        double d2 = 1.0E20;
        int n2 = this.cirgrid.getCircuitElement((int)n).vequation.indexI1;
        for (int i = 0; i < this.numberofdt; ++i) {
            d = Math.max(this.x[this.cirgrid.numberOfV + n2][i], d);
            d2 = Math.min(this.x[this.cirgrid.numberOfV + n2][i], d2);
        }
        return (d - d2) / (double)2;
    }

    public double getVMaxT(int n) {
        int n2 = 0;
        VEquation vEquation = this.cirgrid.getCircuitElement((int)n).vequation;
        for (int i = 1; i < this.numberofdt; ++i) {
            double d = this.x[vEquation.indexV2][i] - this.x[vEquation.indexV1][i];
            n2 = d > this.x[vEquation.indexV2][n2] - this.x[vEquation.indexV1][n2] ? i : n2;
        }
        return (double)n2 * this.dt;
    }

    public double getVMinT(int n) {
        int n2 = 0;
        VEquation vEquation = this.cirgrid.getCircuitElement((int)n).vequation;
        for (int i = 1; i < this.numberofdt; ++i) {
            double d = this.x[vEquation.indexV2][i] - this.x[vEquation.indexV1][i];
            n2 = d < this.x[vEquation.indexV2][n2] - this.x[vEquation.indexV1][n2] ? i : n2;
        }
        return (double)n2 * this.dt;
    }

    public double getVrms(int n) {
        VEquation vEquation = this.cirgrid.getCircuitElement((int)n).vequation;
        double d = 0.0;
        for (int i = 0; i < this.numberofdt; ++i) {
            double d2 = this.x[vEquation.indexV2][i] - this.x[vEquation.indexV1][i];
            d += d2 * d2;
        }
        return Math.sqrt(d / (double)this.numberofdt);
    }

    public double getIMaxT(int n) {
        int n2 = 0;
        int n3 = this.cirgrid.getCircuitElement((int)n).vequation.indexI1;
        for (int i = 1; i < this.numberofdt; ++i) {
            n2 = this.x[this.cirgrid.numberOfV + n3][i] > this.x[this.cirgrid.numberOfV + n3][n2] ? i : n2;
        }
        return (double)n2 * this.dt;
    }

    public double getIMinT(int n) {
        int n2 = 0;
        int n3 = this.cirgrid.getCircuitElement((int)n).vequation.indexI1;
        for (int i = 1; i < this.numberofdt; ++i) {
            n2 = this.x[this.cirgrid.numberOfV + n3][i] < this.x[this.cirgrid.numberOfV + n3][n2] ? i : n2;
        }
        return (double)n2 * this.dt;
    }

    public double getIrms(int n) {
        double d = 0.0;
        int n2 = this.cirgrid.getCircuitElement((int)n).vequation.indexI1;
        for (int i = 0; i < this.numberofdt; ++i) {
            double d2 = this.x[this.cirgrid.numberOfV + n2][i];
            d += d2 * d2;
        }
        return Math.sqrt(d / (double)this.numberofdt);
    }

    public double getDCLevel(int n) {
        double d = 0.0;
        VEquation vEquation = this.cirgrid.getCircuitElement((int)n).vequation;
        for (int i = 1; i < this.numberofdt; ++i) {
            d += this.x[vEquation.indexV2][i] - this.x[vEquation.indexV1][i];
        }
        return d /= (double)this.numberofdt;
    }

    public int addObject(String string, String string2) {
        int n;
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        String string3 = "";
        String string4 = "";
        double d = 0.0;
        double d2 = 1.0;
        double d3 = 0.0;
        double d4 = 1.0;
        double d5 = 0.5;
        String string5 = "";
        CircuitElement circuitElement = null;
        this.parsed = false;
        string = string.toLowerCase().trim();
        string = SUtil.removeWhitespace((String)string);
        string = this.cirProp.getkey(string);
        string2 = SUtil.removeWhitespace((String)string2);
        n2 = (int)SUtil.getParam((String)string2, (String)"row=");
        n3 = (int)SUtil.getParam((String)string2, (String)"col=");
        String string6 = "".concat(String.valueOf(String.valueOf(SUtil.getParamStr((String)string2, (String)"to="))));
        if (SUtil.parameterExist((String)string2, (String)"label=")) {
            string4 = String.valueOf(String.valueOf(string4)).concat(String.valueOf(String.valueOf(SUtil.getParamStr((String)string2, (String)"label="))));
        }
        if (SUtil.parameterExist((String)string2, (String)"d=")) {
            n4 = (int)SUtil.getParam((String)string2, (String)"d=");
        }
        if (SUtil.parameterExist((String)string2, (String)"r=")) {
            d = SUtil.getParam((String)string2, (String)"r=");
        }
        if (SUtil.parameterExist((String)string2, (String)"c=")) {
            d = SUtil.getParam((String)string2, (String)"c=");
        }
        if (SUtil.parameterExist((String)string2, (String)"l=")) {
            d = SUtil.getParam((String)string2, (String)"l=");
        }
        if (SUtil.parameterExist((String)string2, (String)"func=")) {
            string3 = "".concat(String.valueOf(String.valueOf(SUtil.getParamStr((String)string2, (String)"func="))));
        }
        if (SUtil.parameterExist((String)string2, (String)"freq=")) {
            d4 = SUtil.getParam((String)string2, (String)"freq=");
        }
        string5 = String.valueOf(String.valueOf(string5)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(string6))))));
        if (string.equals("nothing")) {
            circuitElement = new Nothing(this, n2, n3, string6);
        } else if (string.equals("wire")) {
            circuitElement = new Wire(this, n2, n3, string6);
        } else if (string.equals("source")) {
            if (SUtil.parameterExist((String)string2, (String)"st=")) {
                n5 = (int)SUtil.getParam((String)string2, (String)"st=");
                d2 = SUtil.getParam((String)string2, (String)"amp=");
                d3 = SUtil.getParam((String)string2, (String)"phase=");
                if (n5 != 0) {
                    d4 = SUtil.getParam((String)string2, (String)"freq=");
                }
                circuitElement = new Source(this, n4, n2, n3, string6, n5, d2, d3, d4);
            } else {
                circuitElement = SUtil.parameterExist((String)string2, (String)"freq=") ? new Source(this, n4, n2, n3, string6, string3, d4) : new Source(this, n4, n2, n3, string6, string3);
            }
            if (SUtil.parameterExist((String)string2, (String)"r=")) {
                ((Source)circuitElement).internalResistance = SUtil.getParam((String)string2, (String)"r=");
            }
        } else if (string.equals("battery")) {
            if (SUtil.parameterExist((String)string2, (String)"v=")) {
                d = SUtil.getParam((String)string2, (String)"v=");
            }
            circuitElement = new Battery(this, n4, n2, n3, string6, d);
            if (SUtil.parameterExist((String)string2, (String)"r=")) {
                ((Battery)circuitElement).internalResistance = SUtil.getParam((String)string2, (String)"r=");
            }
        } else if (string.equals("resistor")) {
            circuitElement = new Resistor(this, d, n2, n3, string6);
        } else if (string.equals("switch")) {
            n = (int)SUtil.getParam((String)string2, (String)"open=") == 1 ? 1 : 0;
            circuitElement = new Switch(this, n != 0, n2, n3, string6);
        } else if (string.equals("scope")) {
            circuitElement = new Scope(this, d, n4, n2, n3, string6);
        } else if (string.equals("ameter")) {
            circuitElement = new Ameter(this, d, n4, n2, n3, string6);
        } else if (string.equals("vmeter")) {
            circuitElement = new Vmeter(this, d, n4, n2, n3, string6);
        } else if (string.equals("bulb")) {
            double d6 = SUtil.getParam((String)string2, (String)"v=");
            double d7 = SUtil.getParam((String)string2, (String)"w=");
            circuitElement = new Bulb(this, d6, d7, n2, n3, string6);
        } else if (string.equals("resistori")) {
            circuitElement = new ResistorI(this, d, n2, n3, string6);
        } else if (string.equals("capacitor")) {
            circuitElement = new Capacitor(this, d, n2, n3, string6);
        } else if (string.equals("inductor")) {
            circuitElement = new Inductor(this, d, n2, n3, string6);
        } else if (string.equals("vgeneral")) {
            circuitElement = new VGeneral(this, string3, n2, n3, string6);
        } else if (string.equals("igeneral")) {
            circuitElement = new IGeneral(this, string3, n2, n3, string6);
        } else if (string.equals("diode")) {
            d = SUtil.getParam((String)string2, (String)"isat=");
            circuitElement = new Diode(this, d, n4, n2, n3, string6);
        } else if (string.equals("currentsource")) {
            d = SUtil.getParam((String)string2, (String)"a=");
            circuitElement = new CurrentSource(this, d, n4, n2, n3, string6);
        } else if (string.equals("sinwave")) {
            if (SUtil.parameterExist((String)string2, (String)"amp=")) {
                d2 = SUtil.getParam((String)string2, (String)"amp=");
            }
            if (SUtil.parameterExist((String)string2, (String)"phase=")) {
                d3 = SUtil.getParam((String)string2, (String)"phase=");
            }
            circuitElement = new SinWave(this, n4, n2, n3, string6, d2, d3, d4);
            if (SUtil.parameterExist((String)string2, (String)"r=")) {
                ((SinWave)circuitElement).internalResistance = SUtil.getParam((String)string2, (String)"r=");
            }
        } else if (string.equals("squarewave")) {
            if (SUtil.parameterExist((String)string2, (String)"amp=")) {
                d2 = SUtil.getParam((String)string2, (String)"amp=");
            }
            if (SUtil.parameterExist((String)string2, (String)"dutyfactor=")) {
                d5 = SUtil.getParam((String)string2, (String)"dutyfactor=");
            }
            circuitElement = new SquareWave(this, n4, n2, n3, string6, d2, d5, d4);
            if (SUtil.parameterExist((String)string2, (String)"r=")) {
                ((SquareWave)circuitElement).internalResistance = SUtil.getParam((String)string2, (String)"r=");
            }
        } else if (string.equals("probe")) {
            n = 0;
            int n6 = 0;
            String string7 = "voltage";
            if (SUtil.parameterExist((String)string2, (String)"type=")) {
                string7 = "".concat(String.valueOf(String.valueOf(SUtil.getParamStr((String)string2, (String)"type="))));
            }
            n = (int)SUtil.getParam((String)string2, (String)"row2=");
            n6 = (int)SUtil.getParam((String)string2, (String)"col2=");
            circuitElement = new Probe(this, string7, n2, n3, n, n6);
        } else if (string.equals("transformercoil")) {
            n = 1;
            if (SUtil.parameterExist((String)string2, (String)"position=")) {
                n = (int)SUtil.getParam((String)string2, (String)"position=");
            }
            circuitElement = new TransformerCoil(this, d, n2, n3, string6, n);
        } else if (string.equals("transformer")) {
            double d8;
            double d9 = d;
            if (SUtil.parameterExist((String)string2, (String)"l1=")) {
                d9 = SUtil.getParam((String)string2, (String)"l1=");
            }
            double d10 = d9;
            if (SUtil.parameterExist((String)string2, (String)"l2=")) {
                d10 = SUtil.getParam((String)string2, (String)"l1=");
            }
            if (SUtil.parameterExist((String)string2, (String)"ratio=")) {
                d8 = SUtil.getParam((String)string2, (String)"ratio=");
                d10 = d8 * d8 * d9;
            } else {
                d8 = Math.sqrt(d10 / d9);
            }
            int n7 = this.addObject("transformercoil", String.valueOf(String.valueOf(new StringBuffer("row=").append(Integer.toString(n2)).append(",col=").append(Integer.toString(n3)).append(",to=").append(string6).append(",position=1,l=").append(Double.toString(d9)).append(",ratio=").append(Double.toString(d8)))));
            int n8 = n2;
            int n9 = n3;
            if (string6.equals("h")) {
                ++n8;
            } else {
                ++n9;
            }
            int n10 = this.addObject("transformercoil", String.valueOf(String.valueOf(new StringBuffer("row=").append(Integer.toString(n8)).append(",col=").append(Integer.toString(n9)).append(",to=").append(string6).append(",position=2,l=").append(Double.toString(d10)).append(",ratio=").append(Double.toString(d8)))));
            this.couple(n7, n10);
            return n7;
        }
        if (!string4.equals("")) {
            circuitElement.setlabel(string4);
        }
        if ((this.debugLevel & DEBUG_IO) > 0) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("element made of type ").append(circuitElement.name()).append(", label: ").append(circuitElement.label))));
        }
        try {
            n = this.cirgrid.addCircuitElement(circuitElement);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            int n11 = -1;
            return n11;
        }
        this.circanvas.redraw();
        return n;
    }

    public boolean couple(int n, int n2) {
        CircuitElement circuitElement = this.cirgrid.getCircuitElement(n);
        CircuitElement circuitElement2 = this.cirgrid.getCircuitElement(n2);
        if (circuitElement == null || circuitElement2 == null) {
            return false;
        }
        circuitElement.coupledTo(circuitElement2);
        circuitElement2.coupledTo(circuitElement);
        this.cirgrid.buildEquations();
        this.circanvas.redraw();
        if ((this.debugLevel & DEBUG_IO) > 0) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("elements coupled: ").append(Integer.toString(n)).append(" and ").append(Integer.toString(n2)))));
        }
        return true;
    }

    public boolean set(int n, String string) {
        CircuitElement circuitElement = this.cirgrid.getCircuitElement(n);
        if (circuitElement == null) {
            return false;
        }
        circuitElement.set(string);
        this.cirgrid.buildEquations();
        this.circanvas.redraw();
        return true;
    }

    public String get(int n) {
        CircuitElement circuitElement = this.cirgrid.getCircuitElement(n);
        if (circuitElement == null) {
            return "";
        }
        return circuitElement.get();
    }

    public boolean setValue(int n, String string) {
        CircuitElement circuitElement = this.cirgrid.getCircuitElement(n);
        if (circuitElement == null) {
            return false;
        }
        circuitElement.setvalue(string);
        this.cirgrid.buildEquations();
        this.circanvas.redraw();
        return true;
    }

    public boolean setMaxCurrentValue(int n, String string) {
        CircuitElement circuitElement = this.cirgrid.getCircuitElement(n);
        if (circuitElement == null) {
            return false;
        }
        circuitElement.setMaxCurrentValue(string);
        this.cirgrid.buildEquations();
        this.circanvas.redraw();
        return true;
    }

    public boolean changePolarity(int n) {
        CircuitElement circuitElement = this.cirgrid.getCircuitElement(n);
        if (circuitElement == null) {
            return false;
        }
        circuitElement.changePolarity();
        this.circanvas.redraw();
        return true;
    }

    public boolean setLabel(int n, String string) {
        CircuitElement circuitElement = this.cirgrid.getCircuitElement(n);
        if (circuitElement == null) {
            return false;
        }
        circuitElement.setlabel(string);
        this.circanvas.redraw();
        return true;
    }

    public boolean setValueVisible(int n, boolean bl) {
        CircuitElement circuitElement = this.cirgrid.getCircuitElement(n);
        if (circuitElement == null) {
            return false;
        }
        circuitElement.setValueVisible(bl);
        this.circanvas.redraw();
        return true;
    }

    public boolean setImageVisible(int n, boolean bl) {
        CircuitElement circuitElement = this.cirgrid.getCircuitElement(n);
        if (circuitElement == null) {
            return false;
        }
        circuitElement.setImageVisible(bl);
        this.circanvas.redraw();
        return true;
    }

    public boolean setImage(int n, String string) {
        CircuitElement circuitElement = this.cirgrid.getCircuitElement(n);
        if (circuitElement == null) {
            return false;
        }
        circuitElement.setImage(string);
        this.circanvas.redraw();
        return true;
    }

    public boolean setFormat(int n, String string) {
        CircuitElement circuitElement = this.cirgrid.getCircuitElement(n);
        if (circuitElement == null) {
            return false;
        }
        circuitElement.setFormat(string);
        this.circanvas.redraw();
        return true;
    }

    public boolean setFont(int n, String string, int n2, int n3) {
        Font font = new Font(string, n2, n3);
        CircuitElement circuitElement = this.cirgrid.getCircuitElement(n);
        if (circuitElement == null) {
            return false;
        }
        circuitElement.setFont(font);
        this.circanvas.redraw();
        return true;
    }

    public boolean setRCTo(int n, int n2, int n3, String string) {
        boolean bl = this.cirgrid.moveCircuitElement(n, n2, n3, string);
        this.parsed = false;
        this.circanvas.redraw();
        return bl;
    }

    CircuitElement getComponent(String string) {
        int n = 0;
        int n2 = 0;
        String string2 = "";
        n = (int)SUtil.getParam((String)string, (String)"row=");
        n2 = (int)SUtil.getParam((String)string, (String)"col=");
        string2 = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(SUtil.getParamStr((String)string, (String)"to="))));
        if ((this.debugLevel & DEBUG_IO) > 0) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(n))).append(" ").append(n2).append(" ").append(string2))));
        }
        return this.cirgrid.getCircuitElement(n, n2, string2);
    }

    boolean moveComponent(CircuitElement circuitElement, String string) {
        if (circuitElement == null) {
            return false;
        }
        int n = 0;
        int n2 = 0;
        String string2 = "";
        boolean bl = true;
        n = (int)SUtil.getParam((String)string, (String)"row=");
        n2 = (int)SUtil.getParam((String)string, (String)"col=");
        string2 = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(SUtil.getParamStr((String)string, (String)"to="))));
        if ((this.debugLevel & DEBUG_IO) > 0) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(n))).append(" ").append(n2).append(" ").append(string2))));
        }
        if (!this.setRCTo(circuitElement.hashCode(), n, n2, string2)) {
            System.out.println("Moving failed");
            bl = false;
        }
        return bl;
    }

    public boolean removeObject(int n) {
        boolean bl = this.cirgrid.removeCircuitElement(n);
        this.parsed = false;
        this.circanvas.redraw();
        return bl;
    }

    void build() {
        this.setGrid(3, 2);
        this.addObject("wire", "row=0,col=0,to=h");
        this.addObject("resistor", "r=1.0E3,row=2,col=0,to=h");
        this.addObject("wire", "row=1,col=1,to=v");
        this.addObject("capacitor", "c=1.0E-7,row=0,col=1,to=v");
        this.addObject("wire", "row=1,col=0,to=v");
        this.addObject("source", "row=1,col=1,to=v,d=1,v=0,func=round(1-(t*1000-floor(t*1000)))");
        this.parse();
    }
}

