/*
 * Decompiled with CFR 0.152.
 */
package circuitsimulator;

import circuitsimulator.BuilderPanel;
import circuitsimulator.Circuit;
import circuitsimulator.CircuitElement;
import circuitsimulator.DataGraphDialog;
import circuitsimulator.Meter;
import circuitsimulator.OscilloDialog;
import circuitsimulator.PopupOnElement;
import edu.davidson.tools.SUtil;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import symantec.itools.awt.BorderPanel;

public class CircuitBuilder
extends Circuit {
    BorderPanel borderPanel = new BorderPanel();
    BuilderPanel builderPanel = new BuilderPanel();
    PopupOnElement popupOnElement;
    CircuitElement currentElement = null;
    Vector scopeList = new Vector();
    Vector meterList = new Vector();
    Vector graphList = new Vector();
    String componentList = "";
    OscilloDialog oscdiag = null;
    Meter meter = null;
    DataGraphDialog graph = null;

    public void init() {
        super.init();
        ((Container)((Object)this)).setLayout(null);
        ((Component)((Object)this)).setBackground(new Color(0, 143, 213));
        ((Component)((Object)this)).setSize(514, 445);
        try {
            this.borderPanel.setBevelStyle(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.borderPanel.setIPadBottom(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.borderPanel.setIPadSides(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.borderPanel.setPaddingRight(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.borderPanel.setPaddingBottom(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.borderPanel.setPaddingTop(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.borderPanel.setIPadTop(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.borderPanel.setPaddingLeft(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.borderPanel.setLayout(null);
        ((Container)((Object)this)).add(this.borderPanel);
        this.borderPanel.setBounds(0, 0, 514, 444);
        try {
            this.builderPanel.setPaddingRight(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.builderPanel.setBevelStyle(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.builderPanel.setPaddingLeft(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.builderPanel.setIPadBottom(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.builderPanel.setPaddingBottom(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.builderPanel.setPaddingTop(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.builderPanel.setIPadSides(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.builderPanel.setIPadTop(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.builderPanel.setLayout(null);
        this.borderPanel.add(this.builderPanel);
        this.builderPanel.setBackground(new Color(0, 143, 213));
        this.builderPanel.setBounds(313, 17, 195, 401);
        SymMouse symMouse = new SymMouse();
        this.circanvas.addMouseListener(symMouse);
        this.builderPanel.setcircuitBuilder(this);
        this.builderPanel.loadImages();
    }

    public void start() {
        super.start();
        this.gridZone.width = this.builderPanel.getBounds().x;
        this.popupOnElement = new PopupOnElement(this);
        this.loadList("/lists/default.txt");
        this.parse();
        this.calculateCircuit();
    }

    public void run() {
        while (true) {
            if (this.parsed) {
                this.circanvas.repaint();
            }
            Enumeration enumeration = this.meterList.elements();
            while (enumeration.hasMoreElements()) {
                this.meter = (Meter)enumeration.nextElement();
                this.meter.recalc();
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    void circanvas_MousePressed(MouseEvent mouseEvent) {
        this.currentElement = this.getComponent(this.coordString(mouseEvent.getPoint(), false));
        if (mouseEvent.isMetaDown() | mouseEvent.isControlDown()) {
            this.popupOnElement.selectItems();
            ((Component)((Object)this)).add(this.popupOnElement);
            this.popupOnElement.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        } else {
            this.circanvas.setCursor(Cursor.getPredefinedCursor(12));
        }
        if ((this.debugLevel & Circuit.DEBUG_IO) > 0) {
            System.out.println(this.currentElement.name());
        }
    }

    void circanvas_mouseReleased(MouseEvent mouseEvent) {
        if (!mouseEvent.isMetaDown() & !mouseEvent.isControlDown()) {
            this.moveComponent(this.currentElement, this.coordString(mouseEvent.getPoint(), false));
            this.circanvas.setCursor(Cursor.getDefaultCursor());
            this.parse();
            this.repaintMeters();
        }
    }

    public void step(double d, double d2) {
        super.step(d, d2);
        if (this.parsed && !this.graphList.isEmpty()) {
            Enumeration enumeration = this.graphList.elements();
            while (enumeration.hasMoreElements()) {
                this.graph = (DataGraphDialog)enumeration.nextElement();
                this.graph.addData();
            }
        }
    }

    public void reset() {
        super.reset();
        if (this.parsed && !this.graphList.isEmpty()) {
            Enumeration enumeration = this.graphList.elements();
            while (enumeration.hasMoreElements()) {
                this.graph = (DataGraphDialog)enumeration.nextElement();
                this.graph.clearGraph();
            }
        }
    }

    public String coordString(Point point, boolean bl) {
        int n;
        int n2;
        Point point2 = new Point(0, 0);
        if (bl) {
            point2.setLocation(this.circanvas.getLocation());
        }
        String string = "row=";
        int n3 = -1;
        int n4 = -1;
        int n5 = point.x - point2.x;
        int n6 = point.y - point2.y;
        while ((n2 = this.interGrid / 2 + this.interGrid * ++n4 - n5) < 0) {
        }
        while ((n = this.interGrid / 2 + this.interGrid * ++n3 - n6) < 0) {
        }
        if (n2 >= n & n2 + n >= this.interGrid) {
            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Integer.toString(n3 - 1)))).append(",col=").append(Integer.toString(n4 - 1)).append(",to=v"))))));
        } else if (n2 >= n & n2 + n < this.interGrid) {
            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Integer.toString(n3)))).append(",col=").append(Integer.toString(n4 - 1)).append(",to=h"))))));
        } else if (n2 < n & n + n2 >= this.interGrid) {
            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Integer.toString(n3 - 1)))).append(",col=").append(Integer.toString(n4 - 1)).append(",to=h"))))));
        } else if (n2 < n & n + n2 < this.interGrid) {
            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Integer.toString(n3 - 1)))).append(",col=").append(Integer.toString(n4)).append(",to=v"))))));
        }
        if ((this.debugLevel & Circuit.DEBUG_IO) > 0) {
            System.out.println(string);
        }
        return string;
    }

    public void repaintMeters() {
        if (this.parsed) {
            this.calculateCircuit();
            Enumeration enumeration = this.scopeList.elements();
            while (enumeration.hasMoreElements()) {
                this.oscdiag = (OscilloDialog)enumeration.nextElement();
                this.oscdiag.scopeCanvas.repaint();
            }
            enumeration = this.meterList.elements();
            while (enumeration.hasMoreElements()) {
                this.meter = (Meter)enumeration.nextElement();
                this.meter.recalc();
            }
        }
    }

    public void parseCommand(String string) {
        if (SUtil.parameterExist((String)(string = "".concat(String.valueOf(String.valueOf(SUtil.removeWhitespace((String)string))))), (String)"setGrid")) {
            String string2 = new String(string.substring(9, string.length() - 3));
            int n = (int)SUtil.getParam((String)string2, (String)"rows=");
            int n2 = (int)SUtil.getParam((String)string2, (String)"cols=");
            this.setGrid(n, n2);
        } else if (SUtil.parameterExist((String)string, (String)"setNumberOfDT")) {
            int n = Integer.parseInt(string.substring(string.indexOf("(") + 1, string.indexOf(")")));
            this.setNumberOfDT(n);
        } else if (SUtil.parameterExist((String)string, (String)"setDT")) {
            double d = Double.valueOf(string.substring(string.indexOf("(") + 1, string.indexOf(")")));
            this.setDT(d);
        } else if (SUtil.parameterExist((String)string, (String)"setNOC")) {
            int n = Integer.parseInt(string.substring(string.indexOf("(") + 1, string.indexOf(")")));
            this.setNOC(n);
        } else if (SUtil.parameterExist((String)string, (String)"setFPS")) {
            double d = Double.valueOf(string.substring(string.indexOf("(") + 1, string.indexOf(")")));
            this.setFPS(d);
        } else if (SUtil.parameterExist((String)string, (String)"addObject")) {
            String string3 = new String(string.substring(string.indexOf("(\"") + 2, string.indexOf("\",")));
            String string4 = new String(string.substring(string.indexOf(",\"") + 2, string.indexOf("\")")));
            this.addObject(string3, string4);
        }
    }

    void loadList(String string) {
        Object object;
        Closeable closeable;
        Object object2;
        String string2;
        boolean bl;
        block9: {
            bl = false;
            string2 = "";
            try {
                if (Circuit.DEBUG) {
                    System.out.println(String.valueOf(String.valueOf(new StringBuffer("loading from codebase:").append(((Applet)((Object)this)).getCodeBase().toString()).append(string))));
                }
                object2 = new URL(String.valueOf(String.valueOf(((Applet)((Object)this)).getCodeBase().toString())).concat(String.valueOf(String.valueOf(string))));
                InputStream inputStream = ((URL)object2).openStream();
                closeable = new BufferedReader(new InputStreamReader(inputStream));
                while ((object = closeable.readLine()) != null) {
                    string2 = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(object)).concat("\n"))));
                    this.parseCommand((String)object);
                }
            }
            catch (Exception exception) {
                bl = true;
                if (!Circuit.DEBUG) break block9;
                System.out.println("load failed from docbase: ".concat(String.valueOf(String.valueOf(exception.getMessage()))));
            }
        }
        if (bl) {
            string2 = "";
            try {
                String string3;
                object2 = ((Applet)((Object)this)).getDocumentBase().toString();
                if (((String)object2).endsWith(".html") || ((String)object2).endsWith(".htm")) {
                    int n = ((String)object2).lastIndexOf("/");
                    object2 = ((String)object2).substring(0, n + 1);
                }
                URL uRL = new URL(String.valueOf(String.valueOf(object2)).concat(String.valueOf(String.valueOf(string))));
                closeable = uRL.openStream();
                object = new BufferedReader(new InputStreamReader((InputStream)closeable));
                while ((string3 = ((BufferedReader)object).readLine()) != null) {
                    string2 = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(string3)).concat("\n"))));
                    this.parseCommand(string3);
                }
            }
            catch (Exception exception) {
                System.out.println("load failed: ".concat(String.valueOf(String.valueOf(exception.getMessage()))));
                this.setGrid("rows=8,cols=5");
            }
        }
    }

    class SymMouse
    extends MouseAdapter {
        SymMouse() {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (object == CircuitBuilder.this.circanvas) {
                CircuitBuilder.this.circanvas_mouseReleased(mouseEvent);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (object == CircuitBuilder.this.circanvas) {
                CircuitBuilder.this.circanvas_MousePressed(mouseEvent);
            }
        }
    }
}

