/*
 * Decompiled with CFR 0.152.
 */
package circuitsimulator;

import circuitsimulator.Circuit;
import circuitsimulator.CircuitElement;
import circuitsimulator.CircuitGrid;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.net.URL;
import java.util.Vector;

public class CircuitCanvas
extends Canvas {
    int d = 54;
    int b = 27;
    Color parsedbgColor = new Color(255, 255, 185);
    Color notparsedbgColor = new Color(192, 192, 192);
    Color bgColor;
    URL imagebase;
    CircuitGrid cirgrid;
    Circuit circuit;
    private boolean imagePainting = false;
    Image osIm = null;
    Graphics osGr = null;

    CircuitCanvas(Circuit circuit) {
        this.circuit = circuit;
        this.bgColor = this.circuit.parsed ? this.parsedbgColor : this.notparsedbgColor;
        this.setBackground(this.bgColor);
        this.d = this.circuit.interGrid;
        this.b = this.d / 2;
        this.cirgrid = this.circuit.cirgrid;
        int n = (this.circuit.gridZone.width - (int)(((double)this.cirgrid.cols + 0.5) * (double)this.d)) / 2;
        int n2 = (this.circuit.gridZone.height - this.cirgrid.rows * this.d) / 2;
        this.setBounds(n, n2, (int)(((double)this.cirgrid.cols + 0.5) * (double)this.d), this.cirgrid.rows * this.d);
        if ((this.circuit.debugLevel & Circuit.DEBUG_IO) > 0) {
            System.out.println("canvas construction completed...");
        }
        this.setSize(0, 0);
    }

    public void reconnect() {
        this.d = this.circuit.interGrid;
        this.b = this.d / 2;
        this.cirgrid = this.circuit.cirgrid;
        int n = (this.circuit.gridZone.width - (int)(((double)this.cirgrid.cols + 0.5) * (double)this.d)) / 2;
        int n2 = (this.circuit.gridZone.height - this.cirgrid.rows * this.d) / 2;
        this.setBounds(n, n2, (int)(((double)this.cirgrid.cols + 0.5) * (double)this.d), this.cirgrid.rows * this.d);
        this.bgColor = this.circuit.parsed ? this.parsedbgColor : this.notparsedbgColor;
        this.setBackground(this.bgColor);
        if (this.getSize().width >= 1 && this.getSize().height >= 1) {
            this.osIm = this.createImage(this.getSize().width, this.getSize().height);
            this.osGr = this.osIm.getGraphics();
            this.redraw();
        }
        if ((this.circuit.debugLevel & Circuit.DEBUG_IO) > 0) {
            System.out.println("canvas construction completed...");
        }
    }

    public synchronized void redraw() {
        int n;
        this.imagePainting = false;
        if (this.osGr == null || this.getSize().width < 4 || this.getSize().height < 4) {
            return;
        }
        this.bgColor = this.circuit.parsed ? this.parsedbgColor : this.notparsedbgColor;
        this.osGr.setColor(this.bgColor);
        this.osGr.fillRect(1, 1, this.getSize().width - 2, this.getSize().height - 2);
        this.osGr.setColor(Color.black);
        this.osGr.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
        for (int i = 0; i < this.cirgrid.rows; ++i) {
            for (n = 0; n < this.cirgrid.cols; ++n) {
                this.osGr.fillOval(this.b + n * this.d - 2, this.b + i * this.d - 2, 4, 4);
            }
        }
        Vector vector = (Vector)this.cirgrid.cirElemList.clone();
        int n2 = vector.size();
        for (n = 0; n < n2; ++n) {
            ((CircuitElement)vector.elementAt(n)).paint(this.osGr);
            ((CircuitElement)vector.elementAt(n)).repaintImage(this.osGr);
        }
        this.repaint();
        this.imagePainting = true;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public synchronized void paint(Graphics graphics) {
        if (this.osIm != null) {
            graphics.drawImage(this.osIm, 0, 0, this);
        }
        for (int i = 0; i < this.cirgrid.cirElemList.size(); ++i) {
            ((CircuitElement)this.cirgrid.cirElemList.elementAt(i)).repaintImage(this.osGr);
        }
    }
}

