/*
 * Decompiled with CFR 0.152.
 */
package circuitsimulator;

import circuitsimulator.Circuit;
import circuitsimulator.CircuitCanvas;
import circuitsimulator.VEquation;
import edu.davidson.display.Format;
import edu.davidson.graphics.Util;
import edu.davidson.tools.SApplet;
import edu.davidson.tools.SDataSource;
import edu.davidson.tools.SUtil;
import java.applet.Applet;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;

public class CircuitElement
extends Canvas
implements SDataSource {
    double value;
    double frequency;
    String function = "";
    int direction;
    int inputIndex;
    Image cirim;
    Font font;
    Format format;
    Circuit circuit;
    CircuitCanvas circuitCanvas;
    int x;
    int y;
    String label = "";
    String unity = "";
    String imagename = "";
    CircuitElement otherElem = null;
    boolean canvasElement = true;
    VEquation vequation;
    int numberOfNodes = 2;
    int row;
    int col;
    String to;
    String polarity;
    boolean polarized = false;
    boolean leftlinear = true;
    boolean rightlinear = true;
    boolean valueVisible = true;
    boolean imageVisible = true;
    boolean variableImage = false;
    boolean reverseEquation = false;
    boolean overloaded = false;
    double maxCurrentValue = 10.0;
    Color parsedbgColor = new Color(255, 255, 185);
    String[] varStrings = new String[]{"t", "v", "i"};
    double[][] vars = new double[1][3];

    CircuitElement() {
        this.value = 0.0;
        this.direction = 0;
        this.inputIndex = 0;
        this.col = 0;
        this.row = 0;
        this.to = "h";
        this.cirim = null;
        this.vequation = null;
        this.font = new Font("TimesRoman", 0, 10);
        this.format = new Format("%.3g");
        this.imagename = String.valueOf(String.valueOf(this.imagename)).concat(String.valueOf(String.valueOf(this.name())));
        this.canvasElement = false;
        this.setValueVisible(false);
        this.setBounds(0, 2, 52, 22);
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    CircuitElement(Circuit circuit) {
        this.circuit = circuit;
        this.circuitCanvas = circuit.circanvas;
        this.value = 0.0;
        this.direction = 0;
        this.inputIndex = 0;
        this.col = 0;
        this.row = 0;
        this.to = "";
        this.cirim = null;
        this.vequation = null;
        this.font = new Font("TimesRoman", 0, 10);
        this.format = new Format("%.3g");
        this.imagename = String.valueOf(String.valueOf(this.imagename)).concat(String.valueOf(String.valueOf(this.name())));
        this.canvasElement = false;
        this.setValueVisible(false);
        this.setBounds(0, 2, 52, 22);
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    CircuitElement(Circuit circuit, int n, int n2, String string) {
        this.circuit = circuit;
        this.circuitCanvas = circuit.circanvas;
        this.value = 1.0;
        this.direction = 0;
        this.inputIndex = 0;
        this.row = n;
        this.col = n2;
        this.to = "".concat(String.valueOf(String.valueOf(string)));
        this.vequation = null;
        this.imagename = String.valueOf(String.valueOf(this.imagename)).concat(String.valueOf(String.valueOf(this.name())));
        this.font = new Font("TimesRoman", 0, 10);
        this.format = new Format("%.3g");
        this.cirim = null;
        try {
            SApplet.addDataSource((Object)this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    CircuitElement(Circuit circuit, int n, int n2, int n3, String string) {
        this(circuit, n2, n3, string);
        this.polarized = true;
        if (n == 1) {
            this.polarity = "p";
            this.direction = this.to.equals("h") ? 2 : 1;
        } else {
            this.polarity = "m";
            this.direction = this.to.equals("h") ? 0 : 3;
        }
    }

    public void setCircuit(Circuit circuit) {
        this.circuit = circuit;
        this.repaint();
    }

    public boolean set(String string) {
        string = string.toLowerCase().trim();
        if (SUtil.parameterExist((String)(string = SUtil.removeWhitespace((String)string)), (String)"row=")) {
            this.row = (int)SUtil.getParam((String)string, (String)"row=");
        }
        if (SUtil.parameterExist((String)string, (String)"col=")) {
            this.col = (int)SUtil.getParam((String)string, (String)"col=");
        }
        if (SUtil.parameterExist((String)string, (String)"to=")) {
            this.to = "".concat(String.valueOf(String.valueOf(SUtil.getParamStr((String)string, (String)"to="))));
        }
        if (SUtil.parameterExist((String)string, (String)"d=")) {
            int n = (int)SUtil.getParam((String)string, (String)"d=");
            if (n == 1) {
                this.polarity = "p";
                this.direction = this.to.equals("h") ? 2 : 1;
            } else {
                this.polarity = "m";
                int n2 = this.direction = this.to.equals("h") ? 0 : 3;
            }
        }
        if (SUtil.parameterExist((String)string, (String)"func=")) {
            this.function = "".concat(String.valueOf(String.valueOf(SUtil.getParamStr((String)string, (String)"func="))));
        }
        if (SUtil.parameterExist((String)string, (String)"freq=")) {
            this.frequency = SUtil.getParam((String)string, (String)"freq=");
        }
        return true;
    }

    public String valueStr() {
        return this.format.form(this.value);
    }

    public void setValueVisible(boolean bl) {
        this.valueVisible = bl;
    }

    public void setImageVisible(boolean bl) {
        this.imageVisible = bl;
    }

    public boolean setImage(String string) {
        if (string.equals("")) {
            this.setImageVisible(false);
        } else {
            this.imagename = String.valueOf(String.valueOf(this.imagename)).concat(String.valueOf(String.valueOf(string)));
        }
        return true;
    }

    public void changePolarity() {
        if (this.polarized) {
            if (this.polarity.equals("m")) {
                this.polarity = "p";
                this.direction = this.to.equals("h") ? 2 : 1;
            } else {
                this.polarity = "m";
                this.direction = this.to.equals("h") ? 0 : 3;
            }
        }
    }

    public void setFormat(String string) {
        this.format = new Format(string);
    }

    public void setFont(Font font) {
        this.font = new Font(font.getFamily(), font.getStyle(), font.getSize());
    }

    public void setvalue(String string) {
        this.value = Double.valueOf(string);
    }

    public void setFrequency(double d) {
        this.frequency = d;
    }

    public void setlabel(String string) {
        this.label = "".concat(String.valueOf(String.valueOf(string)));
    }

    public void setdirection(int n) {
        this.direction = n;
    }

    public void setMaxCurrentValue(String string) {
        this.maxCurrentValue = Double.valueOf(string);
    }

    public void move(int n, int n2, String string) {
        if (!string.equals(this.to)) {
            this.cirim = null;
        }
        this.row = n;
        this.col = n2;
        this.to = "".concat(String.valueOf(String.valueOf(string)));
    }

    public double impedance() {
        return this.reverseEquation ? 1.0 : 0.0;
    }

    public double impedanceCoupled() {
        return 0.0;
    }

    public double indexVHere() {
        return this.reverseEquation ? 0.0 : -1.0;
    }

    public double indexVNext() {
        return this.reverseEquation ? 0.0 : 1.0;
    }

    public double integralVHere() {
        return 0.0;
    }

    public double integralVNext() {
        return 0.0;
    }

    public double input(double d) {
        return 0.0;
    }

    public double differential() {
        return 0.0;
    }

    public double differentialCoupled() {
        return 0.0;
    }

    public double rightFunction(double d) {
        return 0.0;
    }

    public void coupledTo(CircuitElement circuitElement) {
        this.otherElem = circuitElement;
    }

    public int indexIcoupled() {
        return this.otherElem.vequation.indexI1;
    }

    public String getvalue() {
        return Double.toString(this.value);
    }

    public String getlabel() {
        return this.label;
    }

    public String getunity() {
        return this.unity;
    }

    public double getI() {
        double d = 0.0;
        try {
            d = this.circuit.cirgrid.y[this.circuit.cirgrid.numberOfV + this.vequation.indexI1];
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    public double getV() {
        double d = 0.0;
        try {
            d = this.circuit.cirgrid.y[this.vequation.indexV2] - this.circuit.cirgrid.y[this.vequation.indexV1];
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    public double gett() {
        return this.circuit.realt;
    }

    public String name() {
        String string = this.getClass().getName().toLowerCase();
        return string.substring(string.indexOf(".") + 1);
    }

    public String getAddObjectString() {
        String string = String.valueOf(String.valueOf(new StringBuffer("addObject(\"").append(this.circuit.cirProp.getProperty(this.name())).append("\",\"row=").append(this.row).append(",col=").append(this.col).append(",to=").append(this.to).append(",label=").append(this.label)));
        if (this.polarized) {
            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(this.polarity.equals("p") ? ",d=1" : ",d=-1")));
        }
        string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(this.getStringAdditions())).concat("\");\n"))));
        return string;
    }

    public String getStringAdditions() {
        return "";
    }

    public String get() {
        if (this.getStringAdditions().length() == 0) {
            return "";
        }
        return this.getStringAdditions().substring(1);
    }

    public void loadImage(Graphics graphics) {
        if (this.cirim == null || this.overloaded) {
            this.overloaded = false;
            this.cirim = Util.getImage((String)String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.circuit.imagedir))).append(this.imagename).append(this.to).append(".gif"))), (Applet)((Object)this.circuit));
        }
        if (this.cirim != null) {
            int n;
            if (this.to.equals("h")) {
                graphics.drawLine(this.x + 3, this.y, this.x + this.circuit.interGrid / 2 - 24, this.y);
                graphics.drawLine(this.x + this.circuit.interGrid / 2 + 24, this.y, this.x + this.circuit.interGrid - 4, this.y);
            } else {
                graphics.drawLine(this.x, this.y + 3, this.x, this.y + this.circuit.interGrid / 2 - 24);
                graphics.drawLine(this.x, this.y + this.circuit.interGrid / 2 + 24, this.x, this.y + this.circuit.interGrid - 4);
            }
            int n2 = this.to.equals("h") ? this.circuit.interGrid / 2 - 24 : -6;
            int n3 = n = this.to.equals("h") ? -6 : this.circuit.interGrid / 2 - 24;
            while (!graphics.drawImage(this.cirim, this.x + n2, this.y + n, this.circuitCanvas)) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        } else {
            graphics.setColor(Color.red);
            graphics.setFont(new Font("TimesRoman", 1, 22));
            if (this.to.equals("h")) {
                graphics.drawLine(this.x + 3, this.y, this.x + this.circuit.interGrid / 2 - 6, this.y);
                graphics.drawLine(this.x + this.circuit.interGrid / 2 + 6, this.y, this.x + this.circuit.interGrid - 4, this.y);
                graphics.setColor(Color.black);
                graphics.drawString("?", this.x - 6 + this.circuit.interGrid / 2, this.y + 6);
            } else {
                graphics.drawLine(this.x, this.y + 3, this.x, this.y + this.circuit.interGrid / 2 - 10);
                graphics.drawLine(this.x, this.y + this.circuit.interGrid / 2 + 10, this.x, this.y + this.circuit.interGrid - 4);
                graphics.setColor(Color.black);
                graphics.drawString("?", this.x - 4, this.y + 8 + this.circuit.interGrid / 2);
            }
            graphics.setColor(Color.red);
            graphics.setFont(this.font);
        }
    }

    public void overload(Graphics graphics) {
        int n = this.to.equals("h") ? this.circuit.interGrid / 2 - 24 : -24;
        int n2 = this.to.equals("h") ? -24 : this.circuit.interGrid / 2 - 24;
        this.cirim = Util.getImage((String)String.valueOf(String.valueOf(this.circuit.imagedir)).concat("fire.gif"), (Applet)((Object)this.circuit));
        if (this.cirim != null) {
            while (!graphics.drawImage(this.cirim, this.x + n, this.y + n2, this.circuitCanvas)) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.overloaded = true;
    }

    public void unknownImage(Graphics graphics) {
        graphics.setColor(Color.red);
        graphics.setFont(new Font("TimesRoman", 1, 12));
        if (this.to.equals("h")) {
            graphics.drawLine(this.x + 3, this.y, this.x + this.circuit.interGrid / 2 - 13, this.y);
            graphics.drawLine(this.x + this.circuit.interGrid / 2 + 13, this.y, this.x + this.circuit.interGrid - 4, this.y);
            graphics.drawRect(this.x + this.circuit.interGrid / 2 - 13, this.y - 6, 25, 13);
            graphics.setColor(Color.black);
            graphics.drawString("Z", this.x - 4 + this.circuit.interGrid / 2, this.y + 6);
        } else {
            graphics.drawLine(this.x, this.y + 3, this.x, this.y + this.circuit.interGrid / 2 - 13);
            graphics.drawLine(this.x, this.y + this.circuit.interGrid / 2 + 13, this.x, this.y + this.circuit.interGrid - 4);
            graphics.drawRect(this.x - 6, this.y + this.circuit.interGrid / 2 - 13, 13, 25);
            graphics.setColor(Color.black);
            graphics.drawString("Z", this.x - 2, this.y + 5 + this.circuit.interGrid / 2);
        }
        graphics.setColor(Color.red);
        graphics.setFont(this.font);
    }

    private void showArrows(Graphics graphics) {
        graphics.setColor(Color.white);
        if (this.getI() != 0.0) {
            if (this.to.equals("h")) {
                graphics.fillRect(this.x + 22, this.y + 6, 11, 5);
                graphics.setColor(Color.blue);
                graphics.drawLine(this.x + 22, this.y + 8, this.x + 32, this.y + 8);
                if (this.vequation.direction == 2 && this.getI() > 0.0 || this.vequation.direction == 0 && this.getI() < 0.0) {
                    graphics.drawLine(this.x + 29, this.y + 6, this.x + 32, this.y + 8);
                    graphics.drawLine(this.x + 29, this.y + 10, this.x + 32, this.y + 8);
                } else {
                    graphics.drawLine(this.x + 22, this.y + 8, this.x + 25, this.y + 6);
                    graphics.drawLine(this.x + 22, this.y + 8, this.x + 25, this.y + 10);
                }
            } else {
                graphics.fillRect(this.x - 10, this.y + 22, 5, 11);
                graphics.setColor(Color.blue);
                graphics.drawLine(this.x - 8, this.y + 22, this.x - 8, this.y + 32);
                if (this.vequation.direction == 1 && this.getI() > 0.0 || this.vequation.direction == 3 && this.getI() < 0.0) {
                    graphics.drawLine(this.x - 6, this.y + 29, this.x - 8, this.y + 32);
                    graphics.drawLine(this.x - 10, this.y + 29, this.x - 8, this.y + 32);
                } else {
                    graphics.drawLine(this.x - 8, this.y + 22, this.x - 6, this.y + 25);
                    graphics.drawLine(this.x - 8, this.y + 22, this.x - 10, this.y + 25);
                }
            }
        }
    }

    void showValue(Graphics graphics) {
        graphics.setColor(Color.blue);
        if (this.to.equals("h")) {
            graphics.drawString(this.valueStr(), this.x + this.circuit.interGrid / 2 - 17, this.y - 6);
        } else {
            graphics.drawString(this.valueStr(), this.x + 7, this.y + this.circuit.interGrid / 2 - 1);
        }
    }

    void showSigns(Graphics graphics) {
        int n = this.polarity.equals("p") ? this.circuit.interGrid - 11 : 6;
        graphics.setColor(Color.red);
        if (this.to.equals("h")) {
            graphics.fillRect(this.x + n, this.y - 4, 6, 2);
            graphics.fillRect(this.x + n + 2, this.y - 6, 2, 6);
            graphics.setColor(Color.black);
            graphics.fillRect(this.x + this.circuit.interGrid - 5 - n, this.y - 4, 6, 2);
        } else {
            graphics.fillRect(this.x + 2, this.y + n, 6, 2);
            graphics.fillRect(this.x + 4, this.y + n - 2, 2, 6);
            graphics.setColor(Color.black);
            graphics.fillRect(this.x + 2, this.y + this.circuit.interGrid - 5 - n + 2, 6, 2);
        }
    }

    public void repaintImage(Graphics graphics) {
        if (this.circuit.parsed && this.circuit.showCurrent) {
            this.showArrows(graphics);
        }
    }

    public void paint(Graphics graphics) {
        graphics.setColor(Color.red);
        if (this.circuit != null && this.canvasElement) {
            this.x = (int)((double)this.circuit.interGrid * ((double)this.col + 0.5));
            this.y = (int)((double)this.circuit.interGrid * ((double)this.row + 0.5));
            int n = this.circuit.interGrid / 2;
            graphics.setFont(this.font);
            if (this.imageVisible) {
                this.loadImage(graphics);
            } else {
                this.unknownImage(graphics);
            }
            if (this.valueVisible) {
                this.showValue(graphics);
            }
            graphics.setColor(Color.black);
            if (this.to.equals("h")) {
                graphics.drawString(this.label, this.x + n - 4, this.y - 14);
            } else {
                graphics.drawString(this.label, this.x + 7, this.y + n + 7);
            }
            if (this.circuit.parsed && this.circuit.showCurrent) {
                this.showArrows(graphics);
            }
            graphics.setColor(Color.red);
            if (this.circuit.parsed && this.maxCurrentValue <= Math.abs(this.getI())) {
                this.overload(graphics);
                this.circuit.pause();
            }
            if (this.polarized) {
                this.showSigns(graphics);
            }
        } else {
            this.x = 0;
            this.y = 10;
            this.loadImage(graphics);
        }
    }

    public int getCoupledID() {
        return this.otherElem.getID();
    }

    public double[][] getVariables() {
        this.vars[0][0] = this.circuit.clock.getTime();
        this.vars[0][1] = this.getV();
        this.vars[0][2] = this.getI();
        return this.vars;
    }

    public String[] getVarStrings() {
        return this.varStrings;
    }

    public int getID() {
        return this.hashCode();
    }

    public void setOwner(SApplet sApplet) {
        this.circuit = (Circuit)sApplet;
    }

    public SApplet getOwner() {
        return this.circuit;
    }
}

