/*
 * Decompiled with CFR 0.152.
 */
package circuitsimulator;

import circuitsimulator.BranchPoint;
import circuitsimulator.Circuit;
import circuitsimulator.CircuitElement;
import circuitsimulator.Constraints;
import circuitsimulator.GridElement;
import circuitsimulator.Matrix;
import circuitsimulator.Source;
import circuitsimulator.VEquation;
import java.util.Enumeration;
import java.util.Vector;

public class CircuitGrid {
    int rows;
    int cols;
    private int bpStartVEquation = 0;
    private int nextBranchPoint = 0;
    private int startIIndex = 0;
    private int currow = 0;
    private int curcol = 0;
    private int startVIndex = 0;
    private int curVIndex = 0;
    private int curIIndex = 0;
    private int numberOfI;
    private int numberOfVE;
    private int lastVIndex;
    private int lastIIndex;
    private int numberOfCirc;
    int numberOfV;
    int numberOfPars;
    private int direction;
    private int dirold;
    private Circuit circuit;
    GridElement[][] element;
    Vector vEquations = new Vector();
    private Vector branchPoints = new Vector();
    Vector cirElemList = new Vector();
    Vector sourceContainer = new Vector();
    private Vector constraints = new Vector();
    double[] y;
    private Matrix a;
    private Matrix aInv;
    private Matrix b;
    private Matrix multip;
    boolean leftlinear = true;
    boolean rightlinear = true;
    private VEquation vEquationPtr;
    private BranchPoint branchPointPtr;

    CircuitGrid(int n, int n2, Circuit circuit) {
        this.circuit = circuit;
        this.rows = n;
        this.cols = n2;
        this.element = new GridElement[this.rows][this.cols];
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                this.element[i][j] = new GridElement();
            }
        }
        if ((this.circuit.debugLevel & Circuit.DEBUG_IO) > 0) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.rows))).append("x").append(this.cols).append(" elements made"))));
        }
    }

    public boolean constructEquationBase() {
        if (!this.initDefinition()) {
            return false;
        }
        int n = this.currow;
        int n2 = this.curcol;
        boolean bl = true;
        do {
            if (this.element[this.currow][this.curcol].defined) {
                if (this.element[this.currow][this.curcol].nOfUntreatedCons > 2) {
                    this.stopBranchCorrections();
                } else {
                    this.firstLoopCorrections();
                }
                bl = this.startNextBranchPoint();
                continue;
            }
            this.findNextDirection();
            if (this.element[this.currow][this.curcol].nOfUntreatedCons > 2) {
                this.addNewBranchPoint();
            }
            this.addNewVEquation();
            this.changeCoords();
            bl = false;
        } while (!bl || this.findNextCircuit());
        if ((this.circuit.debugLevel & Circuit.DEBUG_NUM) > 0) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("end of construction: lastVIndex=").append(this.lastVIndex).append(", lastIIndex=").append(this.lastIIndex))));
        }
        this.numberOfV = this.lastVIndex + 1;
        this.numberOfI = this.lastIIndex + 1;
        this.numberOfPars = this.numberOfV + this.numberOfI;
        this.reset();
        return true;
    }

    public void reset() {
        this.y = new double[this.numberOfPars + this.sourceContainer.size() + 1];
        for (int i = 0; i <= this.numberOfPars + this.sourceContainer.size(); ++i) {
            this.y[i] = 0.0;
        }
    }

    private boolean initDefinition() {
        this.numberOfCirc = 0;
        this.startVIndex = 0;
        this.startIIndex = 0;
        if (this.cirElemList.isEmpty()) {
            System.out.println("No elements found !");
            return false;
        }
        if ((this.circuit.debugLevel & Circuit.DEBUG_IO) > 0) {
            System.out.println("Parse initialization started");
        }
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                this.element[i][j].nOfUntreatedCons = this.element[i][j].numberOfCons();
                if (this.element[i][j].nOfUntreatedCons == 1) {
                    if ((this.circuit.debugLevel & Circuit.DEBUG_IO) > 0) {
                        System.out.println("Open loop found !");
                    }
                    return false;
                }
                this.element[i][j].defined = false;
            }
        }
        if ((this.circuit.debugLevel & Circuit.DEBUG_IO) > 0) {
            System.out.println("Loop is closed, all grid points initialized");
        }
        this.currow = 0;
        this.curcol = 0;
        while (this.element[this.currow][this.curcol].numberOfCons() == 0) {
            this.currow = 0;
            while (this.element[this.currow][this.curcol].numberOfCons() == 0 && this.currow < this.rows - 1) {
                ++this.currow;
            }
            if (this.element[this.currow][this.curcol].numberOfCons() != 0) continue;
            ++this.curcol;
        }
        if ((this.circuit.debugLevel & Circuit.DEBUG_NUM) > 0) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("first element found: ").append(this.currow).append(",").append(this.curcol))));
        }
        this.direction = 3;
        this.constraints.removeAllElements();
        this.vEquations.removeAllElements();
        this.branchPoints.removeAllElements();
        this.lastVIndex = 0;
        this.lastIIndex = 0;
        this.curIIndex = 0;
        this.curVIndex = 0;
        ++this.numberOfCirc;
        return true;
    }

    private boolean findNextCircuit() {
        this.currow = 0;
        this.curcol = 0;
        while (this.element[this.currow][this.curcol].numberOfCons() == 0 || this.element[this.currow][this.curcol].defined) {
            this.currow = 0;
            while ((this.element[this.currow][this.curcol].numberOfCons() == 0 || this.element[this.currow][this.curcol].defined) && this.currow < this.rows - 1) {
                ++this.currow;
            }
            if (this.element[this.currow][this.curcol].numberOfCons() == 0 || this.element[this.currow][this.curcol].defined) {
                ++this.curcol;
            }
            if (this.curcol != this.cols - 1) continue;
            if ((this.circuit.debugLevel & Circuit.DEBUG_NUM) > 0) {
                System.out.println(String.valueOf(String.valueOf(new StringBuffer("no additional circuits found: ").append(this.currow).append(",").append(this.curcol))));
            }
            return false;
        }
        if ((this.circuit.debugLevel & Circuit.DEBUG_NUM) > 0) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("next circuit found: ").append(this.currow).append(",").append(this.curcol))));
        }
        this.direction = 3;
        ++this.lastVIndex;
        ++this.lastIIndex;
        this.startVIndex = this.lastVIndex;
        this.startIIndex = this.lastIIndex;
        ++this.numberOfCirc;
        this.constraints.addElement(new Constraints(0, this.lastVIndex, 0));
        return true;
    }

    private boolean startNextBranchPoint() {
        boolean bl = true;
        this.nextBranchPoint = 0;
        this.bpStartVEquation = this.vEquations.size();
        if (this.branchPoints.size() > 0) {
            while (this.nextBranchPoint < this.branchPoints.size() && ((BranchPoint)this.branchPoints.elementAt((int)this.nextBranchPoint)).toDefine == 0) {
                ++this.nextBranchPoint;
            }
            if (this.nextBranchPoint < this.branchPoints.size()) {
                BranchPoint branchPoint = (BranchPoint)this.branchPoints.elementAt(this.nextBranchPoint);
                this.currow = branchPoint.xcoord;
                this.curcol = branchPoint.ycoord;
                this.curVIndex = this.element[this.currow][this.curcol].getVIndex();
                this.direction = branchPoint.start(this.element[this.currow][this.curcol], this.lastIIndex);
                if ((this.circuit.debugLevel & Circuit.DEBUG_NUM) > 0) {
                    System.out.println(String.valueOf(String.valueOf(new StringBuffer("next branch started at ").append(this.currow).append(",").append(this.curcol).append(", lastVIndex/lastIIndex: ").append(this.lastVIndex).append("/").append(this.lastIIndex))));
                }
                if ((this.circuit.debugLevel & Circuit.DEBUG_NUM) > 0) {
                    branchPoint.print();
                }
                ++this.lastIIndex;
                this.addNewVEquation();
                this.changeCoords();
                bl = false;
            }
        }
        return bl;
    }

    private void stopBranchCorrections() {
        int n = this.curVIndex;
        this.branchPointPtr = (BranchPoint)this.branchPoints.elementAt(this.element[this.currow][this.curcol].bpIndex);
        this.branchPointPtr.stop(this.direction, this.lastIIndex);
        this.curVIndex = this.element[this.currow][this.curcol].getVIndex();
        if (this.lastVIndex > 0) {
            int n2 = this.vEquations.size() - 1;
            VEquation vEquation = (VEquation)this.vEquations.elementAt(n2);
            vEquation.indexV2 = this.curVIndex;
            while (vEquation.indexV1 == this.lastVIndex) {
                vEquation.indexV1 = this.curVIndex;
                if ((this.circuit.debugLevel & Circuit.DEBUG_NUM) > 0) {
                    vEquation.print();
                }
                vEquation = (VEquation)this.vEquations.elementAt(--n2);
                vEquation.indexV2 = this.curVIndex;
            }
            if ((this.circuit.debugLevel & Circuit.DEBUG_NUM) > 0) {
                vEquation.print();
            }
        }
        if (((VEquation)this.vEquations.elementAt((int)this.bpStartVEquation)).indexV1 != n) {
            --this.lastVIndex;
        } else {
            this.constraints.addElement(new Constraints(n, this.curVIndex, this.lastIIndex));
            if ((this.circuit.debugLevel & Circuit.DEBUG_NUM) > 0) {
                System.out.println(String.valueOf(String.valueOf(new StringBuffer("Equality for V-indices: ").append(n).append("=").append(this.curVIndex).append(", with I-index=").append(this.lastIIndex))));
            }
        }
        if ((this.circuit.debugLevel & Circuit.DEBUG_NUM) > 0) {
            this.branchPointPtr.print();
        }
    }

    private void firstLoopCorrections() {
        if (this.lastVIndex > 0) {
            VEquation vEquation;
            int n;
            if (!this.branchPoints.isEmpty()) {
                this.branchPointPtr.iIndex[this.branchPointPtr.lastDirection] = this.startIIndex;
                --this.lastIIndex;
                if ((this.circuit.debugLevel & Circuit.DEBUG_NUM) > 0) {
                    System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.bpStartVEquation))).append("/").append(this.vEquations.size()))));
                }
                for (n = this.bpStartVEquation; n < this.vEquations.size(); ++n) {
                    vEquation = (VEquation)this.vEquations.elementAt(n);
                    vEquation.indexI1 = this.startIIndex;
                    if ((this.circuit.debugLevel & Circuit.DEBUG_NUM) <= 0) continue;
                    vEquation.print();
                }
            }
            n = this.vEquations.size() - 1;
            vEquation = (VEquation)this.vEquations.elementAt(n);
            vEquation.indexV2 = this.startVIndex;
            if ((this.circuit.debugLevel & Circuit.DEBUG_NUM) > 0) {
                vEquation.print();
            }
            while (vEquation.indexV1 == this.lastVIndex) {
                vEquation.indexV1 = this.startVIndex;
                if ((this.circuit.debugLevel & Circuit.DEBUG_NUM) > 0) {
                    vEquation.print();
                }
                vEquation = (VEquation)this.vEquations.elementAt(--n);
                vEquation.indexV2 = this.startVIndex;
            }
            --this.lastVIndex;
        } else {
            this.constraints.addElement(new Constraints(0, 0, 0));
            if ((this.circuit.debugLevel & Circuit.DEBUG_NUM) > 0) {
                System.out.println("Equality for V-indices: 0=0, with I-index=0");
            }
        }
    }

    private void addNewVEquation() {
        if (!this.element[this.currow][this.curcol].connection[this.direction].name().equals("wire")) {
            ++this.lastVIndex;
            this.vEquations.addElement(new VEquation(this.element[this.currow][this.curcol], this.direction, this.curVIndex, this.lastVIndex, this.lastIIndex));
            this.curVIndex = this.lastVIndex;
            if (!this.element[this.currow][this.curcol].connection[this.direction].leftlinear) {
                this.leftlinear = false;
            }
            if (!this.element[this.currow][this.curcol].connection[this.direction].rightlinear) {
                this.rightlinear = false;
            }
        } else {
            this.vEquations.addElement(new VEquation(this.element[this.currow][this.curcol], this.direction, this.curVIndex, this.curVIndex, this.lastIIndex));
        }
        this.vEquationPtr = (VEquation)this.vEquations.lastElement();
        if ((this.circuit.debugLevel & Circuit.DEBUG_NUM) > 0) {
            System.out.print(String.valueOf(String.valueOf(new StringBuffer("In direction ").append(this.direction).append(": "))));
            this.vEquationPtr.print();
        }
        this.element[this.currow][this.curcol].connected(this.vEquationPtr);
    }

    private void addNewBranchPoint() {
        this.branchPoints.addElement(new BranchPoint(this.element[this.currow][this.curcol], this.currow, this.curcol, this.dirold, this.direction, this.lastIIndex));
        this.branchPointPtr = (BranchPoint)this.branchPoints.lastElement();
        this.element[this.currow][this.curcol].bpIndex = this.branchPoints.size() - 1;
        if ((this.circuit.debugLevel & Circuit.DEBUG_NUM) > 0) {
            this.branchPointPtr.print();
        }
        this.bpStartVEquation = this.vEquations.size();
        ++this.lastIIndex;
    }

    private void findNextDirection() {
        this.dirold = this.direction;
        this.direction = (this.direction + 3) % 4;
        while (this.element[this.currow][this.curcol].connection[this.direction] == null) {
            this.direction = (this.direction + 1) % 4;
        }
    }

    private void changeCoords() {
        switch (this.direction) {
            case 0: {
                --this.curcol;
                break;
            }
            case 1: {
                ++this.currow;
                break;
            }
            case 2: {
                ++this.curcol;
                break;
            }
            case 3: {
                --this.currow;
            }
        }
    }

    public void buildEquations() {
        this.a = new Matrix(this.numberOfPars, this.numberOfPars);
        this.leftEquationMatrix(this.a);
        if ((this.circuit.debugLevel & Circuit.DEBUG_NUM) > 0) {
            System.out.println("Matrix a:");
            this.a.print();
        }
        this.aInv = new Matrix(this.numberOfPars, this.numberOfPars);
        this.aInv.matinv(this.a);
        if ((this.circuit.debugLevel & Circuit.DEBUG_NUM) > 0) {
            System.out.println("Matrix a Inverted:");
            this.aInv.print();
        }
        this.b = new Matrix(this.numberOfPars, this.numberOfPars + this.sourceContainer.size() + 1);
        this.rightEquationMatrix(this.b);
        if ((this.circuit.debugLevel & Circuit.DEBUG_NUM) > 0) {
            System.out.println("Matrix b:");
            this.b.print();
        }
        this.multip = new Matrix(this.numberOfPars, this.numberOfPars + this.sourceContainer.size() + 1);
        this.multip.matmul(this.aInv, this.b);
        if ((this.circuit.debugLevel & Circuit.DEBUG_NUM) > 0) {
            System.out.println("Matrix a Inverted . b:");
            this.multip.print();
        }
    }

    private void leftEquationMatrix(Matrix matrix) {
        int n;
        matrix.set_elem(0, 0, 1.0);
        this.numberOfVE = 0;
        for (int i = 0; i < this.vEquations.size(); ++i) {
            this.vEquationPtr = (VEquation)this.vEquations.elementAt(i);
            if (this.vEquationPtr.z.name().equals("wire")) continue;
            this.vEquationPtr.leftValue(this.numberOfV, matrix, ++this.numberOfVE);
        }
        int n2 = this.constraints.size();
        for (n = 0; n < this.constraints.size(); ++n) {
            Constraints constraints = (Constraints)this.constraints.elementAt(n);
            constraints.leftValue(this.numberOfVE, matrix, n);
        }
        n = this.numberOfVE + 1 + n2;
        if (!this.branchPoints.isEmpty()) {
            for (int i = n; i < this.numberOfPars; ++i) {
                this.branchPointPtr = (BranchPoint)this.branchPoints.elementAt(i - n);
                for (int j = 0; j < 4; ++j) {
                    if (this.branchPointPtr.iSign[j] == 0) continue;
                    matrix.set_elem(i, this.numberOfV + this.branchPointPtr.iIndex[j], this.branchPointPtr.iSign[j]);
                }
            }
        }
    }

    private void rightEquationMatrix(Matrix matrix) {
        int n = 0;
        for (int i = 0; i < this.vEquations.size(); ++i) {
            this.vEquationPtr = (VEquation)this.vEquations.elementAt(i);
            if (this.vEquationPtr.z.name().equals("wire")) continue;
            this.vEquationPtr.rightValue(this.numberOfV, this.numberOfPars, matrix, ++n);
        }
    }

    public void calculateStep(double d) {
        this.y[this.numberOfPars] = 1.0;
        for (int i = 1; i <= this.sourceContainer.size(); ++i) {
            this.y[this.numberOfPars + i] = ((Source)this.sourceContainer.elementAt(i - 1)).getV(d);
        }
        if (!this.leftlinear) {
            this.leftEquationMatrix(this.a);
            this.aInv.matinv(this.a);
        }
        if (!this.rightlinear) {
            this.rightEquationMatrix(this.b);
        }
        if (!this.leftlinear || !this.rightlinear) {
            this.multip.matmul(this.aInv, this.b);
        }
        this.multip.resolve(this.y);
    }

    public int addCircuitElement(CircuitElement circuitElement) {
        int n;
        int n2;
        if (circuitElement.name().equals("probe")) {
            this.cirElemList.addElement(circuitElement);
            return circuitElement.hashCode();
        }
        int n3 = circuitElement.row;
        int n4 = n3++;
        int n5 = circuitElement.col;
        int n6 = n5++;
        if (circuitElement.to.equals("h")) {
            n2 = 2;
            n = 0;
        } else {
            n2 = 1;
            n = 3;
        }
        if (n3 < this.rows & n4 < this.rows & n5 < this.cols & n6 < this.cols & n3 >= 0 & n5 >= 0 & n4 >= 0 & n4 >= 0) {
            if (this.element[n3][n5].connection[n] != null) {
                this.cirElemList.removeElement(this.element[n3][n5].connection[n]);
            }
            if (!circuitElement.name().equals("nothing")) {
                this.element[n3][n5].connection[n] = this.element[n4][n6].connection[n2] = circuitElement;
                this.cirElemList.addElement(circuitElement);
            } else {
                this.element[n4][n6].connection[n2] = null;
                this.element[n3][n5].connection[n] = null;
            }
            if (circuitElement.numberOfNodes == 4) {
                // empty if block
            }
            return circuitElement.hashCode();
        }
        return -1;
    }

    public boolean removeCircuitElement(int n) {
        int n2;
        int n3;
        CircuitElement circuitElement = this.getCircuitElement(n);
        if (circuitElement == null) {
            return false;
        }
        int n4 = circuitElement.row;
        int n5 = n4++;
        int n6 = circuitElement.col;
        int n7 = n6++;
        if (circuitElement.to.equals("h")) {
            n3 = 2;
            n2 = 0;
        } else {
            n3 = 1;
            n2 = 3;
        }
        this.element[n5][n7].connection[n3] = null;
        this.element[n4][n6].connection[n2] = null;
        this.cirElemList.removeElement(circuitElement);
        if ((this.circuit.debugLevel & Circuit.DEBUG_IO) > 0) {
            System.out.println("Element removed: ".concat(String.valueOf(String.valueOf(circuitElement.name()))));
        }
        return true;
    }

    public boolean moveCircuitElement(int n, int n2, int n3, String string) {
        int n4;
        int n5;
        int n6;
        int n7;
        CircuitElement circuitElement = this.getCircuitElement(n);
        if (circuitElement == null) {
            return false;
        }
        int n8 = circuitElement.row;
        int n9 = n8++;
        int n10 = circuitElement.col;
        int n11 = n10++;
        if (circuitElement.to.equals("h")) {
            n7 = 2;
            n6 = 0;
        } else {
            n7 = 1;
            n6 = 3;
        }
        int n12 = n2;
        int n13 = n3;
        if (string.equals("h")) {
            n5 = 2;
            n4 = 0;
            ++n13;
        } else {
            n5 = 1;
            n4 = 3;
            ++n12;
        }
        if (n12 < this.rows & n2 < this.rows & n13 < this.cols & n3 < this.cols & n12 >= 0 & n13 >= 0 & n2 >= 0 & n2 >= 0) {
            this.element[n9][n11].connection[n7] = null;
            this.element[n8][n10].connection[n6] = null;
            if (this.element[n2][n3].connection[n5] != null) {
                this.cirElemList.removeElement(this.element[n2][n3].connection[n5]);
            }
            circuitElement.move(n2, n3, string);
            if ((this.circuit.debugLevel & Circuit.DEBUG_IO) > 0) {
                System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(circuitElement.name()))).append(" moved to: ").append(n2).append(" ").append(n3).append(" ").append(string))));
            }
            this.element[n12][n13].connection[n4] = this.element[n2][n3].connection[n5] = circuitElement;
            return true;
        }
        return false;
    }

    public CircuitElement getCircuitElement(int n) {
        CircuitElement circuitElement = null;
        Enumeration enumeration = this.cirElemList.elements();
        while (enumeration.hasMoreElements()) {
            circuitElement = (CircuitElement)enumeration.nextElement();
            if (circuitElement.hashCode() != n) continue;
            return circuitElement;
        }
        if (Circuit.DEBUG) {
            System.out.println("getCircuitElement method: No element found");
        }
        return null;
    }

    public CircuitElement getCircuitElement(int n, int n2, String string) {
        CircuitElement circuitElement = null;
        Enumeration enumeration = this.cirElemList.elements();
        while (enumeration.hasMoreElements()) {
            circuitElement = (CircuitElement)enumeration.nextElement();
            if (!(circuitElement.row == n & circuitElement.col == n2 & circuitElement.to.equals(string))) continue;
            return circuitElement;
        }
        if (Circuit.DEBUG) {
            System.out.println("getCircuitElement method: No element found");
        }
        return null;
    }

    public String getcomponentList() {
        CircuitElement circuitElement = null;
        String string = String.valueOf(String.valueOf(new StringBuffer("setGrid(\"rows=").append(this.rows).append(",cols=").append(this.cols).append("\");\n")));
        string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("setNumberOfDT(").append(this.circuit.numberofdt).append(");\n"))))));
        string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("setDT(").append(this.circuit.dt).append(");\n"))))));
        string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("setNOC(").append(this.circuit.noc).append(");\n"))))));
        string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("setFPS(").append(this.circuit.fps).append(");\n"))))));
        Enumeration enumeration = this.cirElemList.elements();
        while (enumeration.hasMoreElements()) {
            circuitElement = (CircuitElement)enumeration.nextElement();
            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(circuitElement.getAddObjectString())));
        }
        return string;
    }
}

