/*
 * Decompiled with CFR 0.152.
 */
package circuitsimulator;

import circuitsimulator.CircuitBuilder;
import circuitsimulator.CircuitElement;
import edu.davidson.display.SGraph;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Point;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import symantec.itools.awt.BorderPanel;

public class DataGraphDialog
extends Dialog {
    public String type;
    CircuitBuilder cb;
    CircuitElement ce;
    boolean fComponentsAdjusted = false;
    BorderPanel borderCanvas = new BorderPanel();
    Button stripChart = new Button();
    TextField periodInput = new TextField();
    Label label1 = new Label();
    SGraph dataGraph = new SGraph();

    public DataGraphDialog(Frame frame, CircuitBuilder circuitBuilder, String string) {
        super(frame);
        this.cb = circuitBuilder;
        this.ce = this.cb.currentElement;
        this.type = "".concat(String.valueOf(String.valueOf(string)));
        String string2 = this.type.equals("v") ? this.cb.cirProp.getProperty("vgraph_title") : this.cb.cirProp.getProperty("igraph_title");
        this.setTitle(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string2))).append(" ").append(this.cb.cirProp.getProperty(this.ce.name())).append(" ").append(this.ce.getlabel()))));
        this.periodInput.setText(Double.toString((double)this.cb.numberofdt * this.cb.dt));
        this.setLayout(null);
        ((Component)this).setBackground(new Color(220, 200, 160));
        ((Component)this).setSize(550, 393);
        this.setVisible(false);
        try {
            this.borderCanvas.setBevelStyle(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.borderCanvas.setIPadBottom(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.borderCanvas.setIPadSides(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.borderCanvas.setPaddingRight(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.borderCanvas.setPaddingBottom(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.borderCanvas.setPaddingTop(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.borderCanvas.setIPadTop(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        try {
            this.borderCanvas.setPaddingLeft(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.borderCanvas.setLayout(null);
        this.add(this.borderCanvas);
        this.borderCanvas.setBackground(Color.white);
        this.borderCanvas.setBounds(10, 8, 525, 344);
        this.add(this.stripChart);
        this.stripChart.setBackground(Color.lightGray);
        this.stripChart.setBounds(11, 359, 107, 24);
        this.add(this.periodInput);
        this.periodInput.setBounds(248, 362, 119, 21);
        this.label1.setAlignment(2);
        this.add(this.label1);
        this.label1.setBounds(132, 361, 110, 23);
        this.borderCanvas.add((Component)this.dataGraph);
        this.dataGraph.setBounds(15, 18, 500, 320);
        SymWindow symWindow = new SymWindow();
        this.addWindowListener(symWindow);
        SymAction symAction = new SymAction();
        this.stripChart.addActionListener(symAction);
        this.stripChart.setLabel(this.cb.cirProp.getProperty("gmode_strip"));
        this.label1.setText(this.cb.cirProp.getProperty("twindow"));
        this.dataGraph.clearSeries(1);
        this.dataGraph.setSeriesStyle(1, true, 0);
        this.dataGraph.setLabelX(this.cb.cirProp.getProperty("taxis"));
        if (this.type.equals("v")) {
            this.dataGraph.setLabelY(this.cb.cirProp.getProperty("vaxis"));
        } else {
            this.dataGraph.setLabelY(this.cb.cirProp.getProperty("iaxis"));
        }
    }

    public DataGraphDialog(CircuitBuilder circuitBuilder) {
        this(null, circuitBuilder, "v");
    }

    public void addNotify() {
        Dimension dimension = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        Insets insets = this.getInsets();
        ((Component)this).setSize(insets.left + insets.right + dimension.width, insets.top + insets.bottom + dimension.height);
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Point point = componentArray[i].getLocation();
            point.translate(insets.left, insets.top);
            componentArray[i].setLocation(point);
        }
        this.fComponentsAdjusted = true;
    }

    public void setVisible(boolean bl) {
        if (bl) {
            ((Component)this).setLocation(100, 100);
        }
        super.setVisible(bl);
    }

    public void addData() {
        this.dataGraph.addDatum(1, this.cb.realt, this.type.equals("v") ? this.ce.getV() : this.ce.getI());
    }

    public void clearGraph() {
        this.dataGraph.setAutoReplaceData(1, false);
        this.dataGraph.clearSeriesData(1);
        this.dataGraph.setAutoRefresh(true);
        this.dataGraph.setAutoReplaceData(1, true);
    }

    void stripChart_ActionPerformed(ActionEvent actionEvent) {
        if (this.stripChart.getLabel().equals(this.cb.cirProp.getProperty("gmode_strip"))) {
            int n = (int)(Double.valueOf(this.periodInput.getText()) / (this.cb.dt * (double)this.cb.noc));
            this.dataGraph.setSeriesStripChart(1, n, true);
            this.stripChart.setLabel(this.cb.cirProp.getProperty("gmode_full"));
        } else {
            this.dataGraph.setSeriesStripChart(1, 100, false);
            this.stripChart.setLabel(this.cb.cirProp.getProperty("gmode_strip"));
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == DataGraphDialog.this.stripChart) {
                DataGraphDialog.this.stripChart_ActionPerformed(actionEvent);
            }
        }
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            if (object == DataGraphDialog.this) {
                DataGraphDialog.this.setVisible(false);
            }
        }
    }
}

