/*
 * Decompiled with CFR 0.152.
 */
package circuitsimulator;

import circuitsimulator.Circuit;
import circuitsimulator.CircuitElement;
import edu.davidson.tools.SUtil;

public class Diode
extends CircuitElement {
    double nv;
    double ov = 0.0;

    Diode(Circuit circuit, double d, int n, int n2, int n3, String string) {
        super(circuit, n, n2, n3, string);
        this.value = d;
        this.unity = "A";
        this.leftlinear = false;
    }

    Diode() {
    }

    public double impedance() {
        this.nv = this.ov;
        this.ov = this.getV();
        this.nv = this.nv == 0.0 ? 1.0 / (this.value * 38.9) : this.nv / (this.value * (Math.exp(38.9 * this.nv) - 1.0));
        return Math.abs(this.nv);
    }

    public double rightFunction(double d) {
        return 0.0;
    }

    public String valueStr() {
        return this.function;
    }

    public String getStringAdditions() {
        return ",isat=".concat(String.valueOf(String.valueOf(Double.toString(this.value))));
    }

    public boolean set(String string) {
        boolean bl = super.set(string);
        if (SUtil.parameterExist((String)string, (String)"isat=")) {
            this.value = SUtil.getParam((String)string, (String)"isat=");
        }
        return bl;
    }
}

