/*
 * Decompiled with CFR 0.152.
 */
package circuitsimulator;

import circuitsimulator.Circuit;
import circuitsimulator.CircuitElement;
import edu.davidson.tools.SUtil;

public class Inductor
extends CircuitElement {
    Inductor(Circuit circuit, double d, int n, int n2, String string) {
        super(circuit, n, n2, string);
        this.value = d;
        this.unity = "H";
    }

    Inductor() {
    }

    public double impedance() {
        return this.value / this.circuit.dt;
    }

    public double differential() {
        return this.value / this.circuit.dt;
    }

    public String getStringAdditions() {
        return ",l=".concat(String.valueOf(String.valueOf(Double.toString(this.value))));
    }

    public boolean set(String string) {
        boolean bl = super.set(string);
        if (SUtil.parameterExist((String)string, (String)"l=")) {
            this.value = SUtil.getParam((String)string, (String)"l=");
        }
        return bl;
    }
}

