/*
 * Decompiled with CFR 0.152.
 */
package circuitsimulator;

public class Matrix {
    int rows;
    int cols;
    double[][] data;

    public Matrix(int n, int n2) {
        this.data = new double[n][n2];
        this.rows = n;
        this.cols = n2;
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                this.data[i][j] = 0.0;
            }
        }
    }

    public Matrix(int n, int n2, double[][] dArray) {
        this.data = new double[n][n2];
        this.rows = n;
        this.cols = n2;
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                this.data[i][j] = dArray[i][j];
            }
        }
    }

    public double get_elem(int n, int n2) {
        if (n < 0 || n >= this.rows) {
            return 0.0;
        }
        if (n2 < 0 || n2 >= this.cols) {
            return 0.0;
        }
        return this.data[n][n2];
    }

    public void set_elem(int n, int n2, double d) {
        if (n < 0 || n >= this.rows) {
            return;
        }
        if (n2 < 0 || n2 >= this.cols) {
            return;
        }
        this.data[n][n2] = d;
    }

    public void print() {
        System.out.println(String.valueOf(String.valueOf(new StringBuffer("Rows = ").append(this.rows).append(" Cols = ").append(this.cols))));
        for (int i = 0; i < this.rows; ++i) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int j = 0; j < this.cols; ++j) {
                stringBuffer.append(this.get_elem(i, j));
                if (j >= this.cols - 1) continue;
                stringBuffer.append(",\t");
            }
            System.out.println(stringBuffer.toString());
        }
    }

    public void matmul(Matrix matrix, Matrix matrix2) {
        if (matrix.cols != matrix2.rows || matrix.rows != this.rows || matrix2.cols != this.cols) {
            return;
        }
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                double d = 0.0;
                for (int k = 0; k < matrix.cols; ++k) {
                    d += matrix.data[i][k] * matrix2.data[k][j];
                }
                this.set_elem(i, j, d);
            }
        }
    }

    public double[] matmul(double[] dArray) {
        double[] dArray2 = new double[this.rows];
        for (int i = 0; i < this.rows; ++i) {
            dArray2[i] = 0.0;
            for (int j = 0; j < this.cols; ++j) {
                int n = i;
                dArray2[n] = dArray2[n] + this.data[i][j] * dArray[j];
            }
        }
        return dArray2;
    }

    public void resolve(double[] dArray) {
        for (int i = 0; i < this.rows; ++i) {
            double d = 0.0;
            for (int j = 0; j < this.cols; ++j) {
                d += this.data[i][j] * dArray[j];
            }
            dArray[i] = d;
        }
    }

    public void copy(Matrix matrix) {
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                this.set_elem(i, j, matrix.get_elem(i, j));
            }
        }
    }

    public void matinv(Matrix matrix) {
        int n;
        if (matrix.rows < 1 || matrix.rows != matrix.cols || matrix.rows != this.rows || matrix.cols != this.cols) {
            return;
        }
        if (matrix.rows == 1) {
            double d = matrix.get_elem(0, 0);
            this.set_elem(0, 0, 1.0 / (d == 0.0 ? 1.0E-30 : d));
            return;
        }
        Matrix matrix2 = new Matrix(this.rows, this.cols);
        matrix2.copy(matrix);
        int n2 = this.rows;
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n2; ++i) {
                if (n == i) {
                    this.set_elem(n, i, 1.0);
                    continue;
                }
                this.set_elem(n, i, 0.0);
            }
        }
        for (n = 0; n < n2; ++n) {
            double d;
            int n3;
            double d2 = 0.0;
            int n4 = -1;
            for (n3 = n; n3 < n2; ++n3) {
                d = Math.abs(matrix2.get_elem(n3, n));
                if (!(d > d2)) continue;
                d2 = d;
                n4 = n3;
            }
            if (n4 == -1 || d2 == 0.0) {
                return;
            }
            if (n4 != n) {
                int n5;
                for (n5 = n; n5 < n2; ++n5) {
                    double d3 = matrix2.get_elem(n, n5);
                    matrix2.set_elem(n, n5, matrix2.get_elem(n4, n5));
                    matrix2.set_elem(n4, n5, d3);
                }
                for (n5 = 0; n5 < n2; ++n5) {
                    double d4 = this.get_elem(n, n5);
                    this.set_elem(n, n5, this.get_elem(n4, n5));
                    this.set_elem(n4, n5, d4);
                }
            }
            d2 = (d2 = matrix2.get_elem(n, n)) == 0.0 ? 1.0E-30 : d2;
            for (n3 = n; n3 < n2; ++n3) {
                matrix2.set_elem(n, n3, matrix2.get_elem(n, n3) / d2);
            }
            for (n3 = 0; n3 < n2; ++n3) {
                this.set_elem(n, n3, this.get_elem(n, n3) / d2);
            }
            for (n3 = 0; n3 < n2; ++n3) {
                int n6;
                if (n3 == n) continue;
                d = matrix2.get_elem(n3, n);
                for (n6 = n; n6 < n2; ++n6) {
                    matrix2.set_elem(n3, n6, matrix2.get_elem(n3, n6) - d * matrix2.get_elem(n, n6));
                }
                for (n6 = 0; n6 < n2; ++n6) {
                    this.set_elem(n3, n6, this.get_elem(n3, n6) - d * this.get_elem(n, n6));
                }
            }
        }
    }
}

