/*
 * Decompiled with CFR 0.152.
 */
package circuitsimulator;

import circuitsimulator.CircuitBuilder;
import circuitsimulator.CircuitElement;
import edu.davidson.display.Format;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyVetoException;
import symantec.itools.awt.util.spinner.ListSpinner;

public class Meter
extends Dialog {
    CircuitBuilder cb = null;
    int elementID;
    CircuitElement ce;
    Format format;
    String type = "";
    boolean fComponentsAdjusted = false;
    Label numeric = new Label();
    Label scale = new Label();
    ListSpinner mode = new ListSpinner();

    public Meter(Frame frame) {
        super(frame);
        Object object;
        this.setLayout(null);
        ((Component)this).setSize(192, 77);
        this.setVisible(false);
        this.numeric.setText("0.0");
        this.numeric.setAlignment(2);
        this.add(this.numeric);
        this.numeric.setBackground(Color.black);
        this.numeric.setForeground(Color.yellow);
        this.numeric.setFont(new Font("MonoSpaced", 1, 12));
        this.numeric.setBounds(12, 12, 144, 24);
        this.scale.setText("V");
        this.scale.setAlignment(2);
        this.add(this.scale);
        this.scale.setBackground(Color.black);
        this.scale.setForeground(Color.yellow);
        this.scale.setFont(new Font("MonoSpaced", 1, 12));
        this.scale.setBounds(156, 12, 24, 24);
        try {
            object = new String[]{"DC", "AC"};
            this.mode.setListItems((String[])object);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.add(this.mode);
        this.mode.setBounds(68, 46, 61, 22);
        this.setTitle("Meter");
        this.format = new Format("%6.4f");
        object = new SymWindow();
        this.addWindowListener((WindowListener)object);
        SymAction symAction = new SymAction();
        this.mode.addActionListener(symAction);
    }

    public Meter(Frame frame, boolean bl) {
        this(frame);
        this.setModal(bl);
    }

    public Meter(Frame frame, String string, boolean bl) {
        this(frame, bl);
        this.setTitle(string);
    }

    public Meter(String string, CircuitBuilder circuitBuilder, Frame frame) {
        this(frame);
        this.cb = circuitBuilder;
        this.elementID = this.cb.currentElement.hashCode();
        this.ce = this.cb.currentElement;
        this.type = String.valueOf(String.valueOf(this.type)).concat(String.valueOf(String.valueOf(string)));
        this.recalc();
        this.setTitle(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.cb.cirProp.getProperty(this.ce.name())))).append(" ").append(this.ce.getlabel()))));
        this.setVisible(true);
    }

    public void addNotify() {
        Dimension dimension = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        Insets insets = this.getInsets();
        ((Component)this).setSize(insets.left + insets.right + dimension.width, insets.top + insets.bottom + dimension.height);
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Point point = componentArray[i].getLocation();
            point.translate(insets.left, insets.top);
            componentArray[i].setLocation(point);
        }
        this.fComponentsAdjusted = true;
    }

    public void setVisible(boolean bl) {
        if (bl) {
            Rectangle rectangle = this.getParent().getBounds();
            Rectangle rectangle2 = this.getBounds();
            ((Component)this).setLocation(rectangle.x + (rectangle.width - rectangle2.width) / 2, rectangle.y + (rectangle.height - rectangle2.height) / 2);
        }
        super.setVisible(bl);
    }

    void Meter_WindowClosing(WindowEvent windowEvent) {
        this.cb.meterList.removeElement(this);
        this.dispose();
    }

    public void setDisplay(double d) {
        if (Math.abs(d) < 1.0E-8) {
            this.scale.setText("n".concat(String.valueOf(String.valueOf(this.type))));
            this.numeric.setText(this.format.form(d * 1.0E9));
        } else if (Math.abs(d) < 1.0E-4) {
            this.scale.setText("\u00b5".concat(String.valueOf(String.valueOf(this.type))));
            this.numeric.setText(this.format.form(d * 1000000.0));
        } else if (Math.abs(d) < 0.1) {
            this.scale.setText("m".concat(String.valueOf(String.valueOf(this.type))));
            this.numeric.setText(this.format.form(d * 1000.0));
        } else if (Math.abs(d) < 1000.0) {
            this.scale.setText(this.type);
            this.numeric.setText(this.format.form(d));
        } else if (Math.abs(d) < 1000000.0) {
            this.scale.setText("k".concat(String.valueOf(String.valueOf(this.type))));
            this.numeric.setText(this.format.form(d * 0.001));
        } else {
            this.scale.setText("M".concat(String.valueOf(String.valueOf(this.type))));
            this.numeric.setText(this.format.form(d * 1.0E-6));
        }
    }

    public void recalc() {
        double d = 0.0;
        if (this.mode.getCurrentText().equals("AC")) {
            if (this.type.equals("V")) {
                d = this.cb.getVrms(this.elementID);
            } else if (this.type.equals("A")) {
                d = this.cb.getIrms(this.elementID);
            }
        } else {
            if (this.type.equals("V")) {
                d = this.ce.getV();
            } else if (this.type.equals("A")) {
                d = this.ce.getI();
            }
            d *= (double)(this.ce.direction == this.ce.vequation.direction ? 1 : -1);
        }
        this.setDisplay(d);
    }

    void mode_actionPerformed(ActionEvent actionEvent) {
        this.recalc();
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == Meter.this.mode) {
                Meter.this.mode_actionPerformed(actionEvent);
            }
        }
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            if (object == Meter.this) {
                Meter.this.Meter_WindowClosing(windowEvent);
            }
        }
    }
}

