/*
 * Decompiled with CFR 0.152.
 */
package circuitsimulator;

import circuitsimulator.CircuitBuilder;
import circuitsimulator.DataGraphDialog;
import circuitsimulator.Meter;
import circuitsimulator.OscilloDialog;
import circuitsimulator.Switch;
import circuitsimulator.ValueInput;
import circuitsimulator.ValueKnob;
import java.awt.Component;
import java.awt.Frame;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class PopupOnElement
extends PopupMenu {
    CircuitBuilder cb;
    MenuItem delete = new MenuItem();
    MenuItem changevalue = new MenuItem();
    MenuItem knobvalue = new MenuItem();
    MenuItem knobfrequency = new MenuItem();
    MenuItem showvalue = new MenuItem();
    MenuItem changeswitch = new MenuItem();
    MenuItem changepolarity = new MenuItem();
    MenuItem elemlabel = new MenuItem();
    MenuItem msep = new MenuItem("-");
    MenuItem getvoltage = new MenuItem();
    MenuItem voltmeter = new MenuItem();
    MenuItem ammeter = new MenuItem();
    MenuItem vgraph = new MenuItem();
    MenuItem igraph = new MenuItem();

    PopupOnElement(CircuitBuilder circuitBuilder) {
        this.cb = circuitBuilder;
        this.vcInit();
        this.delete.setLabel(this.cb.cirProp.getProperty("menu_delete"));
        this.changevalue.setLabel(this.cb.cirProp.getProperty("menu_changevalue"));
        this.knobvalue.setLabel(this.cb.cirProp.getProperty("menu_knobvalue"));
        this.knobfrequency.setLabel(this.cb.cirProp.getProperty("menu_knobfrequency"));
        this.showvalue.setLabel(this.cb.cirProp.getProperty("menu_showvalue"));
        this.changeswitch.setLabel(this.cb.cirProp.getProperty("menu_changeswitch"));
        this.changepolarity.setLabel(this.cb.cirProp.getProperty("menu_changepolarity"));
        this.elemlabel.setLabel(this.cb.cirProp.getProperty("menu_elemlabel"));
        this.getvoltage.setLabel(this.cb.cirProp.getProperty("menu_getvoltage"));
        this.voltmeter.setLabel(this.cb.cirProp.getProperty("menu_voltmeter"));
        this.ammeter.setLabel(this.cb.cirProp.getProperty("menu_ammeter"));
        this.vgraph.setLabel(this.cb.cirProp.getProperty("menu_vgraph"));
        this.igraph.setLabel(this.cb.cirProp.getProperty("menu_igraph"));
    }

    public void vcInit() {
        this.setLabel("Select Action");
        this.add(this.delete);
        this.add(this.changevalue);
        this.add(this.knobvalue);
        this.add(this.knobfrequency);
        this.add(this.showvalue);
        this.add(this.elemlabel);
        this.add(this.msep);
        this.add(this.getvoltage);
        this.add(this.voltmeter);
        this.add(this.ammeter);
        this.add(this.vgraph);
        this.add(this.igraph);
        this.add(this.changeswitch);
        this.add(this.changepolarity);
        SymAction symAction = new SymAction();
        this.delete.addActionListener(symAction);
        this.changevalue.addActionListener(symAction);
        this.knobvalue.addActionListener(symAction);
        this.knobfrequency.addActionListener(symAction);
        this.showvalue.addActionListener(symAction);
        this.elemlabel.addActionListener(symAction);
        this.getvoltage.addActionListener(symAction);
        this.voltmeter.addActionListener(symAction);
        this.ammeter.addActionListener(symAction);
        this.vgraph.addActionListener(symAction);
        this.igraph.addActionListener(symAction);
        this.changeswitch.addActionListener(symAction);
        this.changepolarity.addActionListener(symAction);
        this.enableItems();
    }

    public void enableItems() {
        this.changevalue.setEnabled(true);
        this.knobvalue.setEnabled(false);
        this.showvalue.setEnabled(true);
        this.knobfrequency.setEnabled(false);
        this.getvoltage.setEnabled(false);
        this.voltmeter.setEnabled(false);
        this.ammeter.setEnabled(false);
        this.changeswitch.setEnabled(false);
        this.changepolarity.setEnabled(false);
    }

    public void selectItems() {
        if (this.cb == null) {
            return;
        }
        String string = "".concat(String.valueOf(String.valueOf(this.cb.currentElement.name())));
        this.enableItems();
        if (string.equals("switch")) {
            this.changeswitch.setEnabled(true);
            this.changevalue.setEnabled(false);
        } else if (string.equals("scope")) {
            if (this.cb.parsed) {
                this.getvoltage.setEnabled(true);
            }
        } else if (string.equals("vmeter")) {
            if (this.cb.parsed) {
                this.voltmeter.setEnabled(true);
            }
        } else if (string.equals("ameter")) {
            if (this.cb.parsed) {
                this.ammeter.setEnabled(true);
            }
        } else if (string.equals("resistor") || string.equals("capacitor") || string.equals("inductor") || string.equals("currentsource") || string.equals("battery")) {
            this.knobvalue.setEnabled(true);
        } else if ((string.equals("source") || string.equals("sinwave") || string.equals("squarewave")) && this.cb.parsed) {
            this.knobfrequency.setEnabled(true);
        }
        if (this.cb.currentElement.polarized) {
            this.changepolarity.setEnabled(true);
        }
    }

    void delete_ActionPerformed(ActionEvent actionEvent) {
        this.cb.removeObject(this.cb.currentElement.hashCode());
        this.cb.parse();
        this.cb.repaintMeters();
    }

    void changevalue_ActionPerformed(ActionEvent actionEvent) {
        MenuContainer menuContainer = ((MenuComponent)this).getParent();
        while (!(menuContainer instanceof Frame)) {
            menuContainer = ((Component)menuContainer).getParent();
        }
        ValueInput valueInput = new ValueInput(this.cb.cirProp.getProperty("changevalue_title"), this.cb, (Frame)menuContainer);
    }

    void knobvalue_ActionPerformed(ActionEvent actionEvent) {
        String string = "".concat(String.valueOf(String.valueOf(this.cb.currentElement.getvalue())));
        MenuContainer menuContainer = ((MenuComponent)this).getParent();
        while (!(menuContainer instanceof Frame)) {
            menuContainer = ((Component)menuContainer).getParent();
        }
        ValueKnob valueKnob = new ValueKnob("", this.cb, (Frame)menuContainer);
    }

    void knobfrequency_ActionPerformed(ActionEvent actionEvent) {
        String string = "".concat(String.valueOf(String.valueOf(this.cb.currentElement.getvalue())));
        MenuContainer menuContainer = ((MenuComponent)this).getParent();
        while (!(menuContainer instanceof Frame)) {
            menuContainer = ((Component)menuContainer).getParent();
        }
        ValueKnob valueKnob = new ValueKnob("Hz", this.cb, (Frame)menuContainer);
    }

    void showvalue_ActionPerformed(ActionEvent actionEvent) {
        this.cb.currentElement.setValueVisible(!this.cb.currentElement.valueVisible);
        this.cb.circanvas.redraw();
    }

    void elemlabel_ActionPerformed(ActionEvent actionEvent) {
        MenuContainer menuContainer = ((MenuComponent)this).getParent();
        while (!(menuContainer instanceof Frame)) {
            menuContainer = ((Component)menuContainer).getParent();
        }
        ValueInput valueInput = new ValueInput(this.cb.cirProp.getProperty("elemlabel_title"), this.cb, (Frame)menuContainer);
    }

    void getvoltage_ActionPerformed(ActionEvent actionEvent) {
        MenuContainer menuContainer = ((MenuComponent)this).getParent();
        while (!(menuContainer instanceof Frame)) {
            menuContainer = ((Component)menuContainer).getParent();
        }
        OscilloDialog oscilloDialog = new OscilloDialog((Frame)menuContainer, this.cb);
        this.cb.scopeList.addElement(oscilloDialog);
        oscilloDialog.setVisible(true);
    }

    void voltmeter_ActionPerformed(ActionEvent actionEvent) {
        MenuContainer menuContainer = ((MenuComponent)this).getParent();
        while (!(menuContainer instanceof Frame)) {
            menuContainer = ((Component)menuContainer).getParent();
        }
        Meter meter = new Meter("V", this.cb, (Frame)menuContainer);
        this.cb.meterList.addElement(meter);
        meter.setVisible(true);
    }

    void ammeter_ActionPerformed(ActionEvent actionEvent) {
        MenuContainer menuContainer = ((MenuComponent)this).getParent();
        while (!(menuContainer instanceof Frame)) {
            menuContainer = ((Component)menuContainer).getParent();
        }
        Meter meter = new Meter("A", this.cb, (Frame)menuContainer);
        this.cb.meterList.addElement(meter);
        meter.setVisible(true);
    }

    void vgraph_ActionPerformed(ActionEvent actionEvent) {
        MenuContainer menuContainer = ((MenuComponent)this).getParent();
        while (!(menuContainer instanceof Frame)) {
            menuContainer = ((Component)menuContainer).getParent();
        }
        DataGraphDialog dataGraphDialog = new DataGraphDialog((Frame)menuContainer, this.cb, "v");
        this.cb.graphList.addElement(dataGraphDialog);
        dataGraphDialog.setVisible(true);
    }

    void igraph_ActionPerformed(ActionEvent actionEvent) {
        MenuContainer menuContainer = ((MenuComponent)this).getParent();
        while (!(menuContainer instanceof Frame)) {
            menuContainer = ((Component)menuContainer).getParent();
        }
        DataGraphDialog dataGraphDialog = new DataGraphDialog((Frame)menuContainer, this.cb, "i");
        this.cb.graphList.addElement(dataGraphDialog);
        dataGraphDialog.setVisible(true);
    }

    void changeswitch_ActionPerformed(ActionEvent actionEvent) {
        MenuContainer menuContainer = ((MenuComponent)this).getParent();
        while (!(menuContainer instanceof Frame)) {
            menuContainer = ((Component)menuContainer).getParent();
        }
        ((Switch)this.cb.currentElement).change();
        this.cb.cirgrid.buildEquations();
        this.cb.calculateCircuit();
        this.cb.circanvas.redraw();
        this.cb.repaintMeters();
    }

    void changepolarity_ActionPerformed(ActionEvent actionEvent) {
        MenuContainer menuContainer = ((MenuComponent)this).getParent();
        while (!(menuContainer instanceof Frame)) {
            menuContainer = ((Component)menuContainer).getParent();
        }
        this.cb.currentElement.changePolarity();
        this.cb.parse();
        this.cb.circanvas.redraw();
        this.cb.repaintMeters();
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == PopupOnElement.this.delete) {
                PopupOnElement.this.delete_ActionPerformed(actionEvent);
            } else if (object == PopupOnElement.this.changevalue) {
                PopupOnElement.this.changevalue_ActionPerformed(actionEvent);
            } else if (object == PopupOnElement.this.knobvalue) {
                PopupOnElement.this.knobvalue_ActionPerformed(actionEvent);
            } else if (object == PopupOnElement.this.knobfrequency) {
                PopupOnElement.this.knobfrequency_ActionPerformed(actionEvent);
            } else if (object == PopupOnElement.this.showvalue) {
                PopupOnElement.this.showvalue_ActionPerformed(actionEvent);
            } else if (object == PopupOnElement.this.elemlabel) {
                PopupOnElement.this.elemlabel_ActionPerformed(actionEvent);
            } else if (object == PopupOnElement.this.getvoltage) {
                PopupOnElement.this.getvoltage_ActionPerformed(actionEvent);
            } else if (object == PopupOnElement.this.voltmeter) {
                PopupOnElement.this.voltmeter_ActionPerformed(actionEvent);
            } else if (object == PopupOnElement.this.ammeter) {
                PopupOnElement.this.ammeter_ActionPerformed(actionEvent);
            } else if (object == PopupOnElement.this.vgraph) {
                PopupOnElement.this.vgraph_ActionPerformed(actionEvent);
            } else if (object == PopupOnElement.this.igraph) {
                PopupOnElement.this.igraph_ActionPerformed(actionEvent);
            } else if (object == PopupOnElement.this.changeswitch) {
                PopupOnElement.this.changeswitch_ActionPerformed(actionEvent);
            } else if (object == PopupOnElement.this.changepolarity) {
                PopupOnElement.this.changepolarity_ActionPerformed(actionEvent);
            }
        }
    }
}

