/*
 * Decompiled with CFR 0.152.
 */
package circuitsimulator;

import circuitsimulator.Circuit;
import circuitsimulator.CircuitElement;
import edu.davidson.tools.SUtil;
import java.awt.Color;
import java.awt.Graphics;

public class Probe
extends CircuitElement {
    String type = "voltage";
    int row2;
    int col2;

    Probe(Circuit circuit, String string, int n, int n2, int n3, int n4) {
        super(circuit, n, n2, "h");
        this.type = "".concat(String.valueOf(String.valueOf(string)));
        this.row2 = n3;
        this.col2 = n4;
    }

    public boolean set(String string) {
        string = string.toLowerCase().trim();
        if (SUtil.parameterExist((String)(string = SUtil.removeWhitespace((String)string)), (String)"type=")) {
            this.type = "".concat(String.valueOf(String.valueOf(SUtil.getParamStr((String)string, (String)"type="))));
        }
        if (SUtil.parameterExist((String)string, (String)"row=")) {
            this.row = (int)SUtil.getParam((String)string, (String)"row=");
        }
        if (SUtil.parameterExist((String)string, (String)"col=")) {
            this.col = (int)SUtil.getParam((String)string, (String)"col=");
        }
        if (SUtil.parameterExist((String)string, (String)"row2=")) {
            this.row2 = (int)SUtil.getParam((String)string, (String)"row2=");
        }
        if (SUtil.parameterExist((String)string, (String)"col2=")) {
            this.col2 = (int)SUtil.getParam((String)string, (String)"col2=");
        }
        return true;
    }

    public double getI() {
        return 0.0;
    }

    public double getV() {
        int n = this.circuit.cirgrid.element[this.row][this.col].getVIndex();
        int n2 = this.circuit.cirgrid.element[this.row2][this.col2].getVIndex();
        return this.circuit.cirgrid.y[n2] - this.circuit.cirgrid.y[n];
    }

    public String getAddObjectString() {
        String string = String.valueOf(String.valueOf(new StringBuffer("addObject(\"").append(this.name()).append("\",\"type=").append(this.type).append(",row=").append(this.row).append(",col=").append(this.col).append(",row2=").append(this.row2).append(",col2=").append(this.col2).append("\");\n")));
        return string;
    }

    public void loadImage(Graphics graphics) {
    }

    public void paint(Graphics graphics) {
        int n = this.circuit.interGrid;
        int n2 = n / 2;
        graphics.setFont(this.font);
        graphics.setColor(Color.blue);
        graphics.fillOval(n2 + this.col * n - 3, n2 + this.row * n - 3, 6, 6);
        graphics.drawString(String.valueOf(String.valueOf(this.label)).concat("-"), n2 + this.col * n + 3, n2 + this.row * n - 3);
        graphics.fillOval(n2 + this.col2 * n - 3, n2 + this.row2 * n - 3, 6, 6);
        graphics.drawString(String.valueOf(String.valueOf(this.label)).concat("+"), n2 + this.col2 * n + 3, n2 + this.row2 * n - 3);
    }
}

