/*
 * Decompiled with CFR 0.152.
 */
package circuitsimulator;

import circuitsimulator.Circuit;
import circuitsimulator.CircuitBuilder;
import circuitsimulator.CircuitElement;
import circuitsimulator.OscilloDialog;
import edu.davidson.display.Format;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;

public class ScopeCanvas
extends Canvas {
    Color bgColor = new Color(77, 57, 7);
    Color gridColor = new Color(162, 145, 117);
    Graphics g0;
    Image grid;
    int width = 351;
    int height = 281;
    CircuitBuilder cb;
    OscilloDialog oscilloDialog;
    int elementID;
    CircuitElement ce;
    Format format = new Format("%6.4f");

    ScopeCanvas() {
        this.setBackground(this.bgColor);
        this.setBounds(20, 20, this.width, this.height);
        this.setSize(0, 0);
    }

    ScopeCanvas(CircuitBuilder circuitBuilder, OscilloDialog oscilloDialog) {
        this();
        this.cb = circuitBuilder;
        this.oscilloDialog = oscilloDialog;
        this.elementID = this.cb.currentElement.hashCode();
        this.ce = this.cb.currentElement;
    }

    public void setCircuit(CircuitBuilder circuitBuilder, OscilloDialog oscilloDialog) {
        this.cb = circuitBuilder;
        this.oscilloDialog = oscilloDialog;
        this.elementID = this.cb.currentElement.hashCode();
        this.ce = this.cb.currentElement;
    }

    public void paint(Graphics graphics) {
        double[] dArray = new double[this.cb.numberofdt];
        dArray = this.cb.getVoltage(this.elementID);
        int n = this.ce.direction != this.ce.vequation.direction ? -1 : 1;
        if ((this.cb.debugLevel & Circuit.DEBUG_IO) > 0) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(n))).append(" ").append(this.ce.direction).append(" ").append(this.ce.vequation.direction))));
        }
        graphics.setColor(this.gridColor);
        int n2 = 0;
        int n3 = 0;
        do {
            graphics.drawLine(0, n2, 350, n2);
            n2 += 35;
        } while (++n3 < 9);
        int n4 = 0;
        n3 = 0;
        do {
            graphics.drawLine(n4, 0, n4, 280);
            n4 += 35;
        } while (++n3 < 11);
        n2 = 7;
        n3 = 1;
        do {
            graphics.drawLine(173, n2, 178, n2);
            n2 += 7;
        } while (++n3 < 40);
        n4 = 7;
        n3 = 1;
        do {
            graphics.drawLine(n4, 138, n4, 143);
            n4 += 7;
        } while (++n3 < 50);
        double d = (double)this.height / ((double)8 * this.oscilloDialog.voltageScaling);
        double d2 = (double)this.width * this.cb.dt / ((double)10 * this.oscilloDialog.timeScaling);
        int n5 = (int)this.oscilloDialog.verOffset;
        int n6 = (int)this.oscilloDialog.horOffset;
        double d3 = 0.0;
        graphics.setColor(Color.yellow);
        int n7 = 1;
        if (this.oscilloDialog.mode.equals("Ground")) {
            graphics.drawLine(n6, this.height / 2 - n5, n6 + this.width, this.height / 2 - n5);
        } else {
            if (this.oscilloDialog.mode.equals("AC")) {
                d3 = this.cb.getDCLevel(this.elementID) * (double)n;
            }
            if ((this.cb.debugLevel & Circuit.DEBUG_IO) > 0) {
                System.out.println("DC Level = ".concat(String.valueOf(String.valueOf(d3))));
            }
            for (int i = 1; i < this.cb.numberofdt; ++i) {
                graphics.drawLine(n6 + (int)((double)(i - 1) * d2), this.height / 2 - n5 - (int)((dArray[i - 1] * (double)n - d3) * d), n6 + (int)((double)i * d2), this.height / 2 - n5 - (int)((dArray[i] * (double)n - d3) * d));
            }
            while ((double)n7 * this.cb.dt * (double)this.cb.numberofdt < (double)10 * this.oscilloDialog.timeScaling) {
                double d4 = dArray[this.cb.numberofdt - 1] * (double)n - d3;
                int n8 = n7 * this.cb.numberofdt;
                ++n7;
                this.cb.calculateCircuit();
                dArray = this.cb.getVoltage(this.elementID);
                if (this.oscilloDialog.mode.equals("AC")) {
                    d3 = this.cb.getDCLevel(this.elementID) * (double)n;
                }
                graphics.drawLine(n6 + (int)((double)(n8 - 1) * d2), this.height / 2 - n5 - (int)(d4 * d), n6 + (int)((double)n8 * d2), this.height / 2 - n5 - (int)((dArray[0] * (double)n - d3) * d));
                for (int i = 1; i < this.cb.numberofdt; ++i) {
                    graphics.drawLine(n6 + (int)((double)(n8 + i - 1) * d2), this.height / 2 - n5 - (int)((dArray[i - 1] * (double)n - d3) * d), n6 + (int)((double)(n8 + i) * d2), this.height / 2 - n5 - (int)((dArray[i] * (double)n - d3) * d));
                }
            }
        }
    }

    String getCoords(Point point) {
        double d = (double)(this.height - 1) / ((double)8 * this.oscilloDialog.voltageScaling);
        double d2 = (double)(this.width - 1) / ((double)10 * this.oscilloDialog.timeScaling);
        double d3 = ((double)point.x - this.oscilloDialog.horOffset) / d2;
        double d4 = ((double)(this.height / 2 - point.y) - this.oscilloDialog.verOffset) / d;
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.scaled(d3, "s")))).append(", ").append(this.scaled(d4, "V"))));
    }

    String scaled(double d, String string) {
        if (Math.abs(d) < 1.0E-8) {
            return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.format.form(d * 1.0E9)))).append(" n").append(string)));
        }
        if (Math.abs(d) < 1.0E-4) {
            return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.format.form(d * 1000000.0)))).append(" \u00b5").append(string)));
        }
        if (Math.abs(d) < 0.1) {
            return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.format.form(d * 1000.0)))).append(" m").append(string)));
        }
        if (Math.abs(d) < 1000.0) {
            return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.format.form(d)))).append(" ").append(string)));
        }
        if (Math.abs(d) < 1000000.0) {
            return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.format.form(d * 0.001)))).append(" k").append(string)));
        }
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.format.form(d * 1.0E-6)))).append(" M").append(string)));
    }
}

