/*
 * Decompiled with CFR 0.152.
 */
package circuitsimulator;

import circuitsimulator.Circuit;
import circuitsimulator.Source;
import edu.davidson.tools.SUtil;

public class SinWave
extends Source {
    SinWave(Circuit circuit, int n, int n2, int n3, String string, double d, double d2, double d3) {
        super(circuit, n, n2, n3, string);
        this.amplitude = d;
        this.phase = d2;
        this.frequency = d3;
        this.function = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Double.toString(this.amplitude)))).append("*sin(2*pi*").append(Double.toString(this.frequency)).append("*(t+").append(Double.toString(this.phase)).append("))")));
    }

    SinWave() {
    }

    public String getStringAdditions() {
        return String.valueOf(String.valueOf(new StringBuffer(",amp=").append(this.amplitude).append(",phase=").append(this.phase).append(",freq=").append(this.frequency)));
    }

    public boolean set(String string) {
        double d = this.gett();
        double d2 = this.getV(d);
        double d3 = this.getV(d - this.circuit.dt);
        boolean bl = super.set(string);
        double d4 = 0.0;
        if (SUtil.parameterExist((String)string, (String)"amp=")) {
            this.amplitude = SUtil.getParam((String)string, (String)"amp=");
        }
        if (SUtil.parameterExist((String)string, (String)"phase=")) {
            this.phase = SUtil.getParamStr((String)string, (String)"phase=").equals("continuous") ? this.getPhase(d, d2, d3) : SUtil.getParam((String)string, (String)"phase=");
        }
        this.function = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Double.toString(this.amplitude)))).append("*sin(2*pi*").append(Double.toString(this.frequency)).append("*(t+").append(Double.toString(this.phase)).append("))")));
        return bl;
    }

    public double getV(double d) {
        return this.amplitude * Math.sin(Math.PI * 2 * this.frequency * (d + this.phase));
    }

    public void parsefunction() {
    }

    public double getPhase(double d, double d2, double d3) {
        if (d2 > d3) {
            return (Math.asin(d2 / this.amplitude) / (Math.PI * 2) - this.frequency * d % 1.0) / this.frequency;
        }
        return (0.5 - Math.asin(d2 / this.amplitude) / (Math.PI * 2) - this.frequency * d % 1.0) / this.frequency;
    }
}

