/*
 * Decompiled with CFR 0.152.
 */
package circuitsimulator;

import circuitsimulator.Circuit;
import circuitsimulator.CircuitElement;
import edu.davidson.numerics.Parser;
import edu.davidson.tools.SUtil;

public class Source
extends CircuitElement {
    double amplitude = 0.0;
    double phase = 0.0;
    int sourcetype = -1;
    Parser parser = new Parser(3);
    double[] pvars = new double[3];
    double internalResistance = 1.0E-9;

    Source(Circuit circuit, int n, int n2, int n3, String string) {
        super(circuit, n, n2, n3, string);
        this.frequency = 1.0;
        this.inputIndex = this.circuit.cirgrid.sourceContainer.size() + 1;
        this.circuit.cirgrid.sourceContainer.addElement(this);
        this.setValueVisible(false);
        this.unity = "V";
    }

    Source() {
    }

    Source(Circuit circuit, int n, int n2, int n3, String string, String string2) {
        this(circuit, n, n2, n3, string);
        this.function = "".concat(String.valueOf(String.valueOf(string2)));
        this.parsefunction();
    }

    Source(Circuit circuit, int n, int n2, int n3, String string, String string2, double d) {
        this(circuit, n, n2, n3, string, string2);
        this.frequency = d;
    }

    Source(Circuit circuit, int n, int n2, int n3, String string, int n4, double d, double d2, double d3) {
        this(circuit, n, n2, n3, string);
        this.frequency = d3;
        this.amplitude = d;
        this.phase = d2;
        this.sourcetype = n4;
        this.setfunction();
        this.parsefunction();
    }

    public void parsefunction() {
        this.parser.defineVariable(1, "t");
        this.parser.defineVariable(2, "f");
        this.parser.defineVariable(3, "p");
        this.parser.define(this.function.toLowerCase());
        this.parser.parse();
        if (this.parser.getErrorCode() != 0) {
            System.out.println("Failed to parse function: ".concat(String.valueOf(String.valueOf(this.function))));
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Parse error: ").append(this.parser.getErrorString()).append(" function position ").append(this.parser.getErrorPosition()))));
        }
    }

    public String valueStr() {
        return this.function;
    }

    public void setfunction() {
        switch (this.sourcetype) {
            case 0: {
                this.function = Double.toString(this.amplitude);
                break;
            }
            case 1: {
                this.function = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Double.toString(this.amplitude)))).append("*round(1-t*").append(Double.toString(this.frequency)).append(")+floor(t*").append(Double.toString(this.frequency)).append("))")));
                break;
            }
            case 2: {
                this.function = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Double.toString(this.amplitude)))).append("*sin(2*pi*").append(Double.toString(this.frequency)).append("*(t+").append(Double.toString(this.phase)).append("))")));
                break;
            }
            case 3: {
                this.function = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Double.toString(this.amplitude)))).append("*cos(2*pi*").append(Double.toString(this.frequency)).append("*(t+").append(Double.toString(this.phase)).append("))")));
            }
        }
    }

    public double getV(double d) {
        this.pvars[0] = d;
        this.pvars[1] = this.frequency;
        this.pvars[2] = 1.0 / this.frequency;
        return this.parser.evaluate(this.pvars);
    }

    public boolean set(String string) {
        boolean bl = super.set(string);
        if (SUtil.parameterExist((String)string, (String)"r=")) {
            this.internalResistance = SUtil.getParam((String)string, (String)"r=");
        }
        this.parsefunction();
        return bl;
    }

    public void setvalue(String string) {
        this.function = "".concat(String.valueOf(String.valueOf(string)));
        this.parsefunction();
    }

    public String getvalue() {
        return this.function;
    }

    public double input(double d) {
        return d;
    }

    public double impedance() {
        return this.internalResistance;
    }

    public String getStringAdditions() {
        return String.valueOf(String.valueOf(new StringBuffer(",func=").append(this.function).append(",freq=").append(this.frequency).append(",r=").append(this.internalResistance)));
    }
}

