/*
 * Decompiled with CFR 0.152.
 */
package circuitsimulator;

import circuitsimulator.Circuit;
import circuitsimulator.CircuitElement;
import edu.davidson.tools.SUtil;
import java.awt.Color;
import java.awt.Graphics;

public class TransformerCoil
extends CircuitElement {
    int position;
    double ratio;

    TransformerCoil(Circuit circuit, double d, int n, int n2, String string, int n3) {
        super(circuit, n, n2, string);
        this.numberOfNodes = 4;
        this.value = d;
        this.position = n3;
        this.ratio = 1.0;
        this.unity = "H";
        this.setValueVisible(false);
    }

    TransformerCoil(Circuit circuit, double d, int n, int n2, String string, int n3, double d2) {
        this(circuit, d, n, n2, string, n3);
        this.ratio = this.position == 1 ? Math.sqrt(this.otherElem.value / this.value) : Math.sqrt(this.value / this.otherElem.value);
    }

    TransformerCoil() {
        this.position = 1;
        this.ratio = 1.0;
        this.setBounds(0, 1, 52, 40);
    }

    public double impedance() {
        return this.value / this.circuit.dt;
    }

    public double differential() {
        return this.value / this.circuit.dt;
    }

    public double impedanceCoupled() {
        return Math.sqrt(this.value * this.otherElem.value) / this.circuit.dt;
    }

    public double differentialCoupled() {
        return Math.sqrt(this.value * this.otherElem.value) / this.circuit.dt;
    }

    public String getStringAdditions() {
        return String.valueOf(String.valueOf(new StringBuffer(",position=").append(this.position).append(",l=").append(this.value).append(",ratio=").append(this.ratio)));
    }

    public boolean set(String string) {
        boolean bl = super.set(string);
        if (SUtil.parameterExist((String)string, (String)"l=")) {
            this.value = SUtil.getParam((String)string, (String)"l=");
        }
        double d = this.ratio = this.position == 1 ? Math.sqrt(this.otherElem.value / this.value) : Math.sqrt(this.value / this.otherElem.value);
        if (SUtil.parameterExist((String)string, (String)"ratio=")) {
            this.ratio = SUtil.getParam((String)string, (String)"ratio=");
            this.otherElem.value = this.value * (this.position == 1 ? this.ratio * this.ratio : 1.0 / (this.ratio * this.ratio));
            ((TransformerCoil)this.otherElem).ratio = this.ratio;
        }
        return bl;
    }

    public void coupledTo(CircuitElement circuitElement) {
        super.coupledTo(circuitElement);
        this.ratio = this.position == 1 ? Math.sqrt(this.otherElem.value / this.value) : Math.sqrt(this.value / this.otherElem.value);
    }

    public void loadImage(Graphics graphics) {
    }

    void showValue(Graphics graphics) {
        graphics.setColor(Color.blue);
        if (this.to.equals("h")) {
            graphics.drawString(this.valueStr(), this.x + this.circuit.interGrid / 2 - 17, this.y + 3);
        } else {
            graphics.drawString(this.valueStr(), this.x - 7, this.y + this.circuit.interGrid / 2 - 1);
        }
    }

    public void paint(Graphics graphics) {
        int n;
        super.paint(graphics);
        graphics.setColor(Color.red);
        int n2 = this.position == 1 ? 0 : 90;
        int n3 = this.position == 1 ? -1 : 1;
        int n4 = this.position == 1 ? this.circuit.interGrid / 2 - 4 : 4 - this.circuit.interGrid / 2;
        int n5 = this.x + this.circuit.interGrid / 2;
        int n6 = this.y + this.circuit.interGrid / 2;
        int n7 = this.position == 1 ? this.x + this.circuit.interGrid / 2 - 20 : this.x - this.circuit.interGrid / 2 + 10;
        int n8 = n = this.position == 1 ? this.y + this.circuit.interGrid / 2 - 20 : this.y - this.circuit.interGrid / 2 + 10;
        if (this.canvasElement) {
            if (this.to.equals("h")) {
                graphics.drawLine(this.x, this.y - 3 * n3, this.x, n + 5);
                graphics.drawLine(this.x, n + 5, n5 - 23, n + 5);
                graphics.drawArc(n5 - 23, n, 10, 10, 180, -225 * n3);
                graphics.drawArc(n5 - 16, n, 10, 10, 135 + n2, -270 * n3);
                graphics.drawArc(n5 - 9, n, 10, 10, 135 + n2, -270 * n3);
                graphics.drawArc(n5 - 2, n, 10, 10, 135 + n2, -270 * n3);
                graphics.drawArc(n5 + 5, n, 10, 10, 135 + n2, -270 * n3);
                graphics.drawArc(n5 + 12, n, 10, 10, 135 + n2, -225 * n3);
                graphics.drawLine(n5 + 23, n + 5, this.x + this.circuit.interGrid, n + 5);
                graphics.drawLine(this.x + this.circuit.interGrid, this.y - 3 * n3, this.x + this.circuit.interGrid, n + 5);
                graphics.drawLine(n5 - 20, this.y + n4, n5 + 20, this.y + n4);
            } else {
                graphics.drawLine(this.x - 3 * n3, this.y, n7 + 5, this.y);
                graphics.drawLine(n7 + 5, this.y, n7 + 5, n6 - 23);
                graphics.drawArc(n7, n6 - 23, 10, 10, 90, 225 * n3);
                graphics.drawArc(n7, n6 - 16, 10, 10, 135 - n2, 270 * n3);
                graphics.drawArc(n7, n6 - 9, 10, 10, 135 - n2, 270 * n3);
                graphics.drawArc(n7, n6 - 2, 10, 10, 135 - n2, 270 * n3);
                graphics.drawArc(n7, n6 + 5, 10, 10, 135 - n2, 270 * n3);
                graphics.drawArc(n7, n6 + 12, 10, 10, 135 - n2, 225 * n3);
                graphics.drawLine(n7 + 5, n6 + 23, n7 + 5, this.y + this.circuit.interGrid);
                graphics.drawLine(this.x - 3 * n3, this.y + this.circuit.interGrid, n7 + 5, this.y + this.circuit.interGrid);
                graphics.drawLine(this.x + n4, n6 - 20, this.x + n4, n6 + 20);
            }
            return;
        }
        graphics.drawLine(2, 5, 4, 5);
        graphics.drawArc(4, 0, 10, 10, 180, 225);
        graphics.drawArc(11, 0, 10, 10, 135, 270);
        graphics.drawArc(18, 0, 10, 10, 135, 270);
        graphics.drawArc(25, 0, 10, 10, 135, 270);
        graphics.drawArc(32, 0, 10, 10, 135, 270);
        graphics.drawArc(39, 0, 10, 10, 135, 225);
        graphics.drawLine(50, 5, 52, 5);
        graphics.drawLine(4, 15, 48, 15);
        graphics.drawLine(4, 20, 48, 20);
        graphics.drawLine(2, 30, 4, 30);
        graphics.drawArc(4, 25, 10, 10, 180, -225);
        graphics.drawArc(11, 25, 10, 10, 225, -270);
        graphics.drawArc(18, 25, 10, 10, 225, -270);
        graphics.drawArc(25, 25, 10, 10, 225, -270);
        graphics.drawArc(32, 25, 10, 10, 225, -270);
        graphics.drawArc(39, 25, 10, 10, 225, -225);
        graphics.drawLine(50, 30, 52, 30);
    }
}

