/*
 * Decompiled with CFR 0.152.
 */
package circuitsimulator;

import circuitsimulator.CircuitElement;
import circuitsimulator.GridElement;
import circuitsimulator.Matrix;

public class VEquation {
    int indexV1;
    int indexV2;
    int indexI1;
    int indexI2;
    int sign;
    CircuitElement z;
    int fromr;
    int fromc;
    int tor;
    int toc;
    int direction;

    public VEquation() {
        this.indexI2 = 0;
        this.indexI1 = 0;
        this.indexV2 = 0;
        this.indexV1 = 0;
        this.toc = 0;
        this.tor = 0;
        this.fromc = 0;
        this.fromr = 0;
        this.z = null;
        this.sign = 1;
        this.direction = 0;
    }

    VEquation(GridElement gridElement, int n, int n2, int n3, int n4) {
        this.z = gridElement.connection[n];
        this.direction = n;
        this.sign = n != gridElement.connection[n].direction ? -1 : 1;
        this.indexV1 = n2;
        this.indexV2 = n3;
        this.indexI1 = n4;
        gridElement.connection[n].vequation = this;
    }

    public void leftValue(int n, Matrix matrix, int n2) {
        matrix.set_elem(n2, this.indexV1, this.z.indexVHere());
        matrix.set_elem(n2, this.indexV2, this.z.indexVNext());
        matrix.set_elem(n2, n + this.indexI1, this.z.impedance());
        if (this.z.numberOfNodes == 4) {
            matrix.set_elem(n2, n + this.z.indexIcoupled(), this.z.impedanceCoupled());
        }
    }

    public void rightValue(int n, int n2, Matrix matrix, int n3) {
        matrix.set_elem(n3, n2 + this.z.inputIndex, this.z.input(this.sign));
        matrix.set_elem(n3, n2, (double)-1 * this.z.rightFunction(this.sign));
        matrix.set_elem(n3, this.indexV1, this.z.integralVHere());
        matrix.set_elem(n3, this.indexV2, this.z.integralVNext());
        matrix.set_elem(n3, n + this.indexI1, this.z.differential());
        if (this.z.numberOfNodes == 4) {
            matrix.set_elem(n3, n + this.z.indexIcoupled(), this.z.differentialCoupled());
        }
    }

    public void print() {
        System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.z.name()))).append(" in VEquation: indexV1/indexV2/indexI1: ").append(this.indexV1).append("/").append(this.indexV2).append("/").append(this.indexI1))));
    }
}

