/*
 * Decompiled with CFR 0.152.
 */
package circuitsimulator;

import circuitsimulator.CircuitBuilder;
import circuitsimulator.CircuitElement;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class ValueInput
extends Dialog {
    boolean changeOK = false;
    CircuitBuilder cb = null;
    CircuitElement ce = null;
    String mode = "Properties";
    boolean fComponentsAdjusted = false;
    Button buttonOK = new Button();
    Button buttonCancel = new Button();
    TextArea textInput = new TextArea("", 0, 0, 1);

    public ValueInput(Frame frame) {
        super(frame);
        this.setLayout(null);
        ((Component)this).setSize(306, 120);
        this.setVisible(false);
        this.add(this.buttonOK);
        this.buttonOK.setBackground(Color.lightGray);
        this.buttonOK.setBounds(68, 85, 68, 24);
        this.add(this.buttonCancel);
        this.buttonCancel.setBackground(Color.lightGray);
        this.buttonCancel.setBounds(158, 84, 71, 24);
        this.add(this.textInput);
        this.textInput.setBounds(7, 7, 287, 71);
        SymAction symAction = new SymAction();
        this.buttonOK.addActionListener(symAction);
        this.buttonCancel.addActionListener(symAction);
    }

    public ValueInput() {
        this((Frame)null);
    }

    public ValueInput(String string, CircuitBuilder circuitBuilder, Frame frame) {
        this(frame);
        this.cb = circuitBuilder;
        this.ce = this.cb.currentElement;
        this.setTitle(string);
        if (this.getTitle().equals(this.cb.cirProp.getProperty("changevalue_title"))) {
            this.textInput.setText(this.ce.get());
            this.mode = "Properties";
        } else if (this.getTitle().equals(this.cb.cirProp.getProperty("elemlabel_title"))) {
            this.textInput.setText(this.ce.getlabel());
            this.mode = "Label";
        }
        this.buttonOK.setLabel(this.cb.cirProp.getProperty("OK"));
        this.buttonCancel.setLabel(this.cb.cirProp.getProperty("Cancel"));
        this.setTitle(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.cb.cirProp.getProperty(this.ce.name())))).append(": ").append(string))));
        this.setVisible(true);
    }

    public void addNotify() {
        Dimension dimension = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        Insets insets = this.getInsets();
        ((Component)this).setSize(insets.left + insets.right + dimension.width, insets.top + insets.bottom + dimension.height);
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Point point = componentArray[i].getLocation();
            point.translate(insets.left, insets.top);
            componentArray[i].setLocation(point);
        }
        this.fComponentsAdjusted = true;
    }

    public void setVisible(boolean bl) {
        if (bl) {
            Rectangle rectangle = this.getParent().getBounds();
            Rectangle rectangle2 = this.getBounds();
            ((Component)this).setLocation(rectangle.x + (rectangle.width - rectangle2.width) / 2, rectangle.y + (rectangle.height - rectangle2.height) / 2);
        }
        super.setVisible(bl);
    }

    void buttonOK_ActionPerformed(ActionEvent actionEvent) {
        this.changeOK = true;
        if (this.mode.equals("Properties")) {
            this.cb.set(this.cb.currentElement.hashCode(), this.textInput.getText());
            this.cb.calculateCircuit();
            this.cb.repaintMeters();
        } else if (this.mode.equals("Label")) {
            this.cb.setLabel(this.cb.currentElement.hashCode(), this.textInput.getText());
        }
        this.setVisible(false);
    }

    void buttonCancel_ActionPerformed(ActionEvent actionEvent) {
        this.changeOK = false;
        this.setVisible(false);
    }

    public boolean getchangeOK() {
        return this.changeOK;
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == ValueInput.this.buttonOK) {
                ValueInput.this.buttonOK_ActionPerformed(actionEvent);
            } else if (object == ValueInput.this.buttonCancel) {
                ValueInput.this.buttonCancel_ActionPerformed(actionEvent);
            }
        }
    }
}

