/*
 * Decompiled with CFR 0.152.
 */
package circuitsimulator;

import circuitsimulator.CircuitBuilder;
import circuitsimulator.CircuitElement;
import edu.davidson.display.Format;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyVetoException;
import symantec.itools.awt.util.spinner.ListSpinner;

public class ValueKnob
extends Dialog {
    CircuitBuilder cb = null;
    int elementID;
    CircuitElement ce;
    Format format;
    String type = "";
    double initialv = 1.0;
    boolean fComponentsAdjusted = false;
    Label numeric = new Label();
    Label scale = new Label();
    ListSpinner mode = new ListSpinner();
    Scrollbar scrollbar = new Scrollbar(0, 50, 1, 1, 101);

    public ValueKnob(Frame frame) {
        super(frame);
        Object object;
        this.setLayout(null);
        ((Component)this).setSize(180, 57);
        this.setVisible(false);
        this.numeric.setText("0.0");
        this.numeric.setAlignment(2);
        this.add(this.numeric);
        this.numeric.setBackground(Color.black);
        this.numeric.setForeground(Color.yellow);
        this.numeric.setFont(new Font("MonoSpaced", 1, 12));
        this.numeric.setBounds(6, 27, 133, 24);
        this.add(this.scale);
        this.scale.setBackground(Color.black);
        this.scale.setForeground(Color.yellow);
        this.scale.setFont(new Font("MonoSpaced", 1, 12));
        this.scale.setBounds(139, 27, 35, 24);
        try {
            object = new String[]{"lin", "log"};
            this.mode.setListItems((String[])object);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.add(this.mode);
        this.mode.setFont(new Font("Dialog", 0, 10));
        this.mode.setBounds(4, 1, 54, 25);
        this.add(this.scrollbar);
        this.scrollbar.setBounds(60, 3, 117, 21);
        this.setTitle("Meter");
        this.format = new Format("%6.4f");
        object = new SymWindow();
        this.addWindowListener((WindowListener)object);
        SymAction symAction = new SymAction();
        this.mode.addActionListener(symAction);
        SymAdjustment symAdjustment = new SymAdjustment();
        this.scrollbar.addAdjustmentListener(symAdjustment);
    }

    public ValueKnob(Frame frame, boolean bl) {
        this(frame);
        this.setModal(bl);
    }

    public ValueKnob(Frame frame, String string, boolean bl) {
        this(frame, bl);
        this.setTitle(string);
    }

    public ValueKnob(String string, CircuitBuilder circuitBuilder, Frame frame) {
        this(frame);
        this.cb = circuitBuilder;
        this.elementID = this.cb.currentElement.hashCode();
        this.ce = this.cb.currentElement;
        this.type = string.equals("Hz") ? String.valueOf(String.valueOf(this.type)).concat(String.valueOf(String.valueOf(string))) : String.valueOf(String.valueOf(this.type)).concat(String.valueOf(String.valueOf(this.ce.getunity())));
        this.initialv = this.type.equals("Hz") ? this.ce.frequency : Double.valueOf(this.ce.getvalue());
        this.recalc();
        this.setTitle(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.cb.cirProp.getProperty(this.ce.name())))).append(" ").append(this.ce.getlabel()))));
        this.setVisible(true);
    }

    public void addNotify() {
        Dimension dimension = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        Insets insets = this.getInsets();
        ((Component)this).setSize(insets.left + insets.right + dimension.width, insets.top + insets.bottom + dimension.height);
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Point point = componentArray[i].getLocation();
            point.translate(insets.left, insets.top);
            componentArray[i].setLocation(point);
        }
        this.fComponentsAdjusted = true;
    }

    public void setVisible(boolean bl) {
        if (bl) {
            Rectangle rectangle = this.getParent().getBounds();
            Rectangle rectangle2 = this.getBounds();
            ((Component)this).setLocation(rectangle.x + (rectangle.width - rectangle2.width) / 2, rectangle.y + (rectangle.height - rectangle2.height) / 2);
        }
        super.setVisible(bl);
    }

    void Meter_WindowClosing(WindowEvent windowEvent) {
        this.dispose();
    }

    public void setDisplay(double d) {
        if (Math.abs(d) < 1.0E-8) {
            this.scale.setText("n".concat(String.valueOf(String.valueOf(this.type))));
            this.numeric.setText(this.format.form(d * 1.0E9));
        } else if (Math.abs(d) < 1.0E-4) {
            this.scale.setText("\u00b5".concat(String.valueOf(String.valueOf(this.type))));
            this.numeric.setText(this.format.form(d * 1000000.0));
        } else if (Math.abs(d) < 0.1) {
            this.scale.setText("m".concat(String.valueOf(String.valueOf(this.type))));
            this.numeric.setText(this.format.form(d * 1000.0));
        } else if (Math.abs(d) < 1000.0) {
            this.scale.setText(this.type);
            this.numeric.setText(this.format.form(d));
        } else if (Math.abs(d) < 1000000.0) {
            this.scale.setText("k".concat(String.valueOf(String.valueOf(this.type))));
            this.numeric.setText(this.format.form(d * 0.001));
        } else {
            this.scale.setText("M".concat(String.valueOf(String.valueOf(this.type))));
            this.numeric.setText(this.format.form(d * 1.0E-6));
        }
    }

    public void recalc() {
        double d = 0.0;
        double d2 = (double)this.scrollbar.getValue() * 2.0 / (double)(this.scrollbar.getMaximum() - 1);
        if (this.mode.getCurrentText().equals("lin")) {
            d = this.initialv * d2;
        } else {
            double d3 = Math.rint(Math.log(this.initialv) / Math.log(10.0));
            double d4 = this.initialv / Math.exp(d3 * Math.log(10.0));
            double d5 = d3 + 5.0 * (d2 - 1.0);
            d = d4 * Math.exp(d5 * Math.log(10.0));
        }
        if (this.type.equals("Hz")) {
            this.cb.setDT(0.001 / d);
            this.cb.set(this.ce.hashCode(), "freq=".concat(String.valueOf(String.valueOf(Double.toString(d)))));
            this.cb.builderPanel.updateTextFields();
        } else {
            this.cb.setValue(this.ce.hashCode(), Double.toString(d));
        }
        this.cb.calculateCircuit();
        this.cb.repaintMeters();
        this.setDisplay(d);
    }

    void mode_actionPerformed(ActionEvent actionEvent) {
        this.recalc();
    }

    void scrollbar_AdjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.recalc();
    }

    class SymAdjustment
    implements AdjustmentListener {
        SymAdjustment() {
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            Object object = adjustmentEvent.getSource();
            if (object == ValueKnob.this.scrollbar) {
                ValueKnob.this.scrollbar_AdjustmentValueChanged(adjustmentEvent);
            }
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == ValueKnob.this.mode) {
                ValueKnob.this.mode_actionPerformed(actionEvent);
            }
        }
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            if (object == ValueKnob.this) {
                ValueKnob.this.Meter_WindowClosing(windowEvent);
            }
        }
    }
}

