/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.util.ResourceBundle;
import java.util.Vector;
import symantec.itools.awt.AlignStyle;
import symantec.itools.awt.BevelStyle;
import symantec.itools.awt.util.ColorUtils;
import symantec.itools.beans.PropertyChangeSupport;
import symantec.itools.beans.VetoableChangeSupport;
import symantec.itools.util.GeneralUtils;

public class BorderPanel
extends Panel
implements AlignStyle,
BevelStyle,
ContainerListener {
    Dimension oldSize = new Dimension();
    protected static final int labelpadx = 10;
    protected static final int labelipadx = 4;
    protected Color cachedBackground;
    protected Color borderColor;
    protected Color bevelLighterColor;
    protected Color bevelDarkerColor;
    protected Color labelColor;
    protected int padtop = 10;
    protected int padbottom = 6;
    protected int padleft = 6;
    protected int padright = 6;
    protected int ixPad = 4;
    protected int iyPadTop = 2;
    protected int iyPadBottom = 7;
    protected int style;
    protected String label;
    protected int labelAlignment;
    protected Insets internalInsets;
    protected Panel panel;
    protected transient ResourceBundle errors;
    private Vector cListeners;
    private Veto veto;
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public BorderPanel() {
        this(null, 1, 2);
    }

    public BorderPanel(int n) {
        this(null, 1, n);
    }

    public BorderPanel(String string) {
        this(string, 1, 2);
    }

    public BorderPanel(String string, int n) {
        this(string, n, 2);
    }

    public BorderPanel(String string, int n, int n2) {
        this.borderColor = Color.black;
        this.labelColor = Color.black;
        this.cachedBackground = this.getBackground();
        this.label = string != null && string.length() == 0 ? null : string;
        this.labelAlignment = n;
        this.internalInsets = new Insets(10, 10, 10, 10);
        this.style = n2;
        super.setLayout(null);
        this.panel = new Panel();
        super.add(this.panel);
        if (this.panel != null) {
            this.panel.setLayout(null);
        }
        this.sizepanel(true);
        this.cListeners = new Vector();
    }

    public void setPaddingTop(int n) throws PropertyVetoException {
        if (this.padtop != n) {
            Integer n2 = new Integer(this.padtop);
            Integer n3 = new Integer(n);
            this.vetos.fireVetoableChange("paddingTop", n2, n3);
            this.padtop = n;
            this.sizepanel(true);
            this.invalidate();
            this.repaint();
            this.changes.firePropertyChange("paddingTop", n2, n3);
        }
    }

    public int getPaddingTop() {
        return this.padtop;
    }

    public void setPaddingBottom(int n) throws PropertyVetoException {
        if (this.padbottom != n) {
            Integer n2 = new Integer(this.padbottom);
            Integer n3 = new Integer(n);
            this.vetos.fireVetoableChange("paddingBottom", n2, n3);
            this.padbottom = n;
            this.sizepanel(true);
            this.invalidate();
            this.repaint();
            this.changes.firePropertyChange("paddingBottom", n2, n3);
        }
    }

    public int getPaddingBottom() {
        return this.padbottom;
    }

    public void setPaddingLeft(int n) throws PropertyVetoException {
        if (this.padleft != n) {
            Integer n2 = new Integer(this.padleft);
            Integer n3 = new Integer(n);
            this.vetos.fireVetoableChange("paddingLeft", n2, n3);
            this.padleft = n;
            this.sizepanel(true);
            this.invalidate();
            this.repaint();
            this.changes.firePropertyChange("paddingLeft", n2, n3);
        }
    }

    public int getPaddingLeft() {
        return this.padleft;
    }

    public void setPaddingRight(int n) throws PropertyVetoException {
        if (this.padright != n) {
            Integer n2 = new Integer(this.padright);
            Integer n3 = new Integer(n);
            this.vetos.fireVetoableChange("paddingRight", n2, n3);
            this.padright = n;
            this.sizepanel(true);
            this.invalidate();
            this.repaint();
            this.changes.firePropertyChange("paddingRight", n2, n3);
        }
    }

    public int getPaddingRight() {
        return this.padright;
    }

    public void setIPadTop(int n) throws PropertyVetoException {
        if (this.iyPadTop != n) {
            Integer n2 = new Integer(this.iyPadTop);
            Integer n3 = new Integer(n);
            this.vetos.fireVetoableChange("iPadTop", n2, n3);
            this.iyPadTop = n;
            this.changes.firePropertyChange("iPadTop", n2, n3);
            this.sizepanel(true);
            this.invalidate();
        }
    }

    public int getIPadTop() {
        return this.iyPadTop;
    }

    public void setIPadBottom(int n) throws PropertyVetoException {
        if (this.iyPadBottom != n) {
            Integer n2 = new Integer(this.iyPadBottom);
            Integer n3 = new Integer(n);
            this.vetos.fireVetoableChange("iPadBottom", n2, n3);
            this.iyPadBottom = n;
            this.changes.firePropertyChange("iPadBottom", n2, n3);
            this.sizepanel(true);
            this.invalidate();
        }
    }

    public int getIPadBottom() {
        return this.iyPadBottom;
    }

    public void setIPadSides(int n) throws PropertyVetoException {
        if (this.ixPad != n) {
            Integer n2 = new Integer(this.ixPad);
            Integer n3 = new Integer(n);
            this.vetos.fireVetoableChange("iPadSides", n2, n3);
            this.ixPad = n;
            this.changes.firePropertyChange("iPadSides", n2, n3);
            this.sizepanel(true);
            this.invalidate();
        }
    }

    public int getIPadSides() {
        return this.ixPad;
    }

    public void setLabel(String string) throws PropertyVetoException {
        if (string != null && string.length() == 0) {
            string = null;
        }
        if (!GeneralUtils.objectsEqual(this.label, string)) {
            String string2 = this.label;
            this.vetos.fireVetoableChange("label", string2, string);
            this.label = string;
            this.changes.firePropertyChange("label", string2, string);
            this.sizepanel(true);
            this.repaint();
        }
    }

    public String getLabel() {
        return this.label;
    }

    public void setBorderColor(Color color) throws PropertyVetoException {
        if (!GeneralUtils.objectsEqual(this.borderColor, color)) {
            Color color2 = this.borderColor;
            this.vetos.fireVetoableChange("borderColor", color2, color);
            this.borderColor = color;
            this.changes.firePropertyChange("borderColor", color2, color);
            this.repaint();
        }
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setLabelColor(Color color) throws PropertyVetoException {
        if (!GeneralUtils.objectsEqual(this.labelColor, color)) {
            Color color2 = this.labelColor;
            this.vetos.fireVetoableChange("labelColor", color2, color);
            this.labelColor = color;
            this.changes.firePropertyChange("labelColor", color2, color);
            this.repaint();
        }
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setAlignStyle(int n) throws PropertyVetoException {
        if (this.labelAlignment != n) {
            Integer n2 = new Integer(this.labelAlignment);
            Integer n3 = new Integer(n);
            this.vetos.fireVetoableChange("alignStyle", n2, n3);
            this.labelAlignment = n;
            this.changes.firePropertyChange("alignStyle", n2, n3);
            this.sizepanel(true);
            this.repaint();
        }
    }

    public int getAlignStyle() {
        return this.labelAlignment;
    }

    public void setBevelStyle(int n) throws PropertyVetoException {
        if (this.style != n) {
            Integer n2 = new Integer(this.style);
            Integer n3 = new Integer(n);
            this.vetos.fireVetoableChange("bevelStyle", n2, n3);
            this.style = n;
            this.changes.firePropertyChange("bevelStyle", n2, n3);
            this.repaint();
        }
    }

    public int getBevelStyle() {
        return this.style;
    }

    public void setInternalInsets(Insets insets) throws PropertyVetoException {
        if (!GeneralUtils.objectsEqual(this.internalInsets, insets)) {
            Insets insets2 = this.internalInsets;
            this.vetos.fireVetoableChange("internalInsets", insets2, insets);
            this.internalInsets = insets;
            this.changes.firePropertyChange("internalInsets", insets2, insets);
            this.sizepanel(true);
            this.invalidate();
        }
    }

    public Insets getInternalInsets() {
        return this.internalInsets;
    }

    public void setPadding(int n, int n2, int n3, int n4) throws PropertyVetoException {
        this.setPaddingTop(n);
        this.setPaddingBottom(n2);
        this.setPaddingLeft(n3);
        this.setPaddingRight(n4);
    }

    public void setBorderColor(Color color, boolean bl) throws PropertyVetoException {
        this.setBorderColor(color);
        if (bl) {
            this.setLabelColor(color);
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.size();
        Dimension dimension2 = this.getMinimumSize();
        return new Dimension(Math.max(dimension.width, dimension2.width), Math.max(dimension.height, dimension2.height));
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        return new Dimension(20, 40);
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public void setLayout(LayoutManager layoutManager) {
        if (this.panel != null) {
            this.panel.setLayout(layoutManager);
        }
    }

    public LayoutManager getLayout() {
        return this.panel.getLayout();
    }

    public Component getComponent(int n) {
        return this.panel.getComponent(n);
    }

    public Component[] getComponents() {
        return this.panel.getComponents();
    }

    public int getComponentCount() {
        return this.panel.getComponentCount();
    }

    public boolean isValidBevelStyle(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public synchronized void addNotify() {
        super.addNotify();
        this.errors = ResourceBundle.getBundle("symantec.itools.resources.ErrorsBundle");
        this.sizepanel(true);
        if (this.veto == null) {
            this.veto = new Veto();
            this.addBevelStyleListener(this.veto);
        }
        if (this.panel != null) {
            this.panel.addContainerListener(this);
        }
    }

    public synchronized void removeNotify() {
        if (this.veto != null) {
            this.removeBevelStyleListener(this.veto);
            this.veto = null;
        }
        if (this.panel != null) {
            this.panel.removeContainerListener(this);
        }
        super.removeNotify();
    }

    public void layout() {
        this.sizepanel(false);
        this.panel.layout();
    }

    protected void addImpl(Component component, Object object, int n) {
        if (component == this.panel) {
            super.addImpl(component, object, n);
            return;
        }
        this.panel.add(component, object, n);
    }

    public void remove(int n) {
        this.panel.remove(n);
    }

    public void remove(Component component) {
        this.panel.remove(component);
    }

    public void removeAll() {
        this.panel.removeAll();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.sizepanel(false);
    }

    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        this.sizepanel(false);
    }

    public void update(Graphics graphics) {
        Dimension dimension = this.size();
        Insets insets = this.insets();
        graphics.setColor(this.getBackground());
        if (insets.left > 0) {
            graphics.fillRect(0, 0, insets.left, dimension.height);
        }
        if (insets.top > 0) {
            graphics.fillRect(0, 0, dimension.width, insets.top);
        }
        if (insets.bottom > 0) {
            graphics.fillRect(0, dimension.height - insets.bottom, dimension.width, insets.bottom);
        }
        if (insets.right > 0) {
            graphics.fillRect(dimension.width - insets.right, 0, insets.right, dimension.height);
        }
        this.paint(graphics);
        this.panel.repaint();
    }

    public int countComponents() {
        return this.panel.countComponents();
    }

    public Insets insets() {
        int n = this.getLabelTopMargin();
        Insets insets = this.getInternalInsets();
        return new Insets(n + insets.top, insets.left, insets.bottom, insets.right);
    }

    public void paint(Graphics graphics) {
        this.sizepanel(false);
        Color color = this.getBackground();
        if (!GeneralUtils.objectsEqual(color, this.cachedBackground)) {
            this.cachedBackground = color;
            this.calculateHilightColors(color);
        }
        graphics.setColor(color);
        this.draw(graphics);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.panel.setBackground(color);
    }

    public void componentAdded(ContainerEvent containerEvent) {
        if (containerEvent.getSource() == this.panel) {
            int n = 0;
            while (n < this.cListeners.size()) {
                ((ContainerListener)this.cListeners.elementAt(n)).componentAdded(new ContainerEvent(this, 300, containerEvent.getChild()));
                ++n;
            }
        }
    }

    public void componentRemoved(ContainerEvent containerEvent) {
        if (containerEvent.getSource() == this.panel) {
            int n = 0;
            while (n < this.cListeners.size()) {
                ((ContainerListener)this.cListeners.elementAt(n)).componentRemoved(new ContainerEvent(this, 301, containerEvent.getChild()));
                ++n;
            }
        }
    }

    public synchronized void addContainerListener(ContainerListener containerListener) {
        if (this.panel != null) {
            this.panel.addContainerListener(containerListener);
            this.cListeners.addElement(containerListener);
        }
    }

    public synchronized void removeContainerListener(ContainerListener containerListener) {
        if (this.panel != null) {
            this.panel.removeContainerListener(containerListener);
            this.cListeners.removeElement(containerListener);
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.addVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.removeVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized void addBevelStyleListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener("bevelStyle", propertyChangeListener);
    }

    public synchronized void removeBevelStyleListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener("bevelStyle", propertyChangeListener);
    }

    public synchronized void addBevelStyleListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.addVetoableChangeListener("bevelStyle", vetoableChangeListener);
    }

    public synchronized void removeBevelStyleListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.removeVetoableChangeListener("bevelStyle", vetoableChangeListener);
    }

    protected void sizepanel(boolean bl) {
        Dimension dimension = this.size();
        if (bl || this.oldSize.width != dimension.width || this.oldSize.height != dimension.height) {
            this.oldSize = dimension;
            this.panel.setBounds(this.padleft + this.ixPad, this.getLabelTopMargin() + this.iyPadTop, dimension.width - this.padright - this.padleft - this.ixPad * 2 - 1, dimension.height - this.padbottom - this.getLabelTopMargin() - this.iyPadBottom - this.iyPadTop - 1);
        }
    }

    protected void draw(Graphics graphics) {
        Dimension dimension = this.size();
        int n = this.padtop;
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        graphics.clipRect(0, 0, dimension.width, dimension.height);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        if (this.label != null && fontMetrics != null) {
            n = (fontMetrics.getAscent() + fontMetrics.getDescent() + this.padtop) / 2;
        }
        int n2 = this.padleft;
        int n3 = n;
        int n4 = dimension.width - this.padleft - this.padright - 1;
        int n5 = dimension.height - 1 - n - this.padbottom;
        this.drawBorder(graphics, n2, n3, n4, n5);
        this.drawLabel(graphics, fontMetrics);
    }

    protected void drawBorder(Graphics graphics, int n, int n2, int n3, int n4) {
        switch (this.style) {
            case 1: {
                graphics.setColor(this.bevelLighterColor);
                graphics.drawLine(n, n2, n + n3, n2);
                graphics.drawLine(n, n2, n, n2 + n4);
                graphics.setColor(this.bevelDarkerColor);
                graphics.drawLine(n, n2 + n4, n + n3, n2 + n4);
                graphics.drawLine(n + n3, n2, n + n3, n2 + n4);
                return;
            }
            case 0: {
                graphics.setColor(this.bevelDarkerColor);
                graphics.drawLine(n, n2, n + n3, n2);
                graphics.drawLine(n, n2, n, n2 + n4);
                graphics.setColor(this.bevelLighterColor);
                graphics.drawLine(n, n2 + n4, n + n3, n2 + n4);
                graphics.drawLine(n + n3, n2, n + n3, n2 + n4);
                return;
            }
            case 2: {
                graphics.setColor(this.borderColor);
                graphics.drawRect(n, n2, n3, n4);
                return;
            }
            default: {
                graphics.setColor(this.borderColor);
                graphics.drawRect(n, n2, n3, n4);
            }
            case 3: 
        }
    }

    protected void drawLabel(Graphics graphics, FontMetrics fontMetrics) {
        if (this.label != null && fontMetrics != null) {
            int n;
            int n2 = 10;
            Dimension dimension = this.size();
            if (this.getFont().getSize() > n2) {
                n2 += this.getFont().getSize() / 2;
            }
            int n3 = fontMetrics.stringWidth(this.label);
            int n4 = fontMetrics.getAscent();
            int n5 = fontMetrics.getDescent();
            switch (this.labelAlignment) {
                case 1: {
                    n = this.padleft + (dimension.width - this.padleft - this.padright - n3) / 2;
                    break;
                }
                case 2: {
                    n = dimension.width - n2 - (n3 + 7) - this.padright;
                    break;
                }
                default: {
                    n = n2 + 7 + this.padleft;
                }
            }
            int n6 = n4 + n5 + this.padtop;
            int n7 = (n2 - n6) / 2 + (this.padtop + n4);
            graphics.setColor(this.getBackground());
            graphics.fillRect(n - 2, n7 - 1 - n4 - this.padtop / 2, n3 + 4, n6);
            graphics.setColor(this.labelColor);
            graphics.drawString(this.label, n, n7 - 1);
        }
    }

    protected int getLabelTopMargin() {
        if (this.label == null) {
            return this.padtop;
        }
        int n = this.padtop;
        Font font = this.getFont();
        if (font != null) {
            FontMetrics fontMetrics = this.getFontMetrics(font);
            n = fontMetrics.getAscent() + fontMetrics.getDescent() + this.padtop;
        }
        return n;
    }

    protected int getLabelWidthMargin() {
        if (this.label == null) {
            return 0;
        }
        int n = 2 + this.internalInsets.left + this.internalInsets.right;
        Font font = this.getFont();
        if (font != null) {
            FontMetrics fontMetrics = this.getFontMetrics(font);
            n = Math.max(n, 2 + fontMetrics.stringWidth(this.label) + 10 + 4);
        }
        return n;
    }

    protected void calculateHilightColors(Color color) {
        this.bevelLighterColor = ColorUtils.calculateHilightColor(color);
        this.bevelDarkerColor = ColorUtils.calculateShadowColor(color);
    }

    class Veto
    implements VetoableChangeListener,
    Serializable {
        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            int n = (Integer)propertyChangeEvent.getNewValue();
            if (!BorderPanel.this.isValidBevelStyle(n)) {
                throw new PropertyVetoException(String.valueOf(BorderPanel.this.errors.getString("InvalidBevelStyle")) + n, propertyChangeEvent);
            }
        }

        Veto() {
            BorderPanel.this = BorderPanel.this;
        }
    }
}

