/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt.shape;

import java.awt.Graphics;
import symantec.itools.awt.shape.Shape;

public class Ellipse
extends Shape {
    public boolean contains(int n, int n2) {
        if (!super.contains(n, n2)) {
            return false;
        }
        double d = (double)this.width / 2.0;
        double d2 = (double)this.height / 2.0;
        double d3 = ((double)n - d) * ((double)this.height / (double)this.width);
        double d4 = (double)n2 - d2;
        if (this.fill) {
            return d3 * d3 + d4 * d4 <= d2 * d2;
        }
        return Math.abs(d3 * d3 + d4 * d4 + 30.0 - d2 * d2) < 60.0;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        graphics.clipRect(0, 0, this.width, this.height);
        int n = this.width - 1;
        int n2 = this.height - 1;
        switch (this.style) {
            case 2: {
                if (this.fill) {
                    graphics.setColor(this.fillColor);
                    graphics.fillOval(0, 0, this.width, this.height);
                }
                graphics.setColor(this.getForeground());
                graphics.drawOval(0, 0, n, n2);
                return;
            }
            case 0: {
                if (this.fill) {
                    graphics.setColor(this.fillColor);
                    graphics.fillOval(0, 0, this.width, this.height);
                }
                graphics.setColor(this.bevelDarkerColor);
                graphics.drawArc(0, 0, n, n2, 45, 180);
                graphics.setColor(this.bevelLighterColor);
                graphics.drawArc(0, 0, n, n2, 225, 180);
                return;
            }
            case 1: {
                if (this.fill) {
                    graphics.setColor(this.fillColor);
                    graphics.fillOval(0, 0, this.width, this.height);
                }
                graphics.setColor(this.bevelLighterColor);
                graphics.drawArc(0, 0, n, n2, 45, 180);
                graphics.setColor(this.bevelDarkerColor);
                graphics.drawArc(0, 0, n, n2, 225, 180);
                return;
            }
        }
        if (this.fill) {
            graphics.setColor(this.fillColor);
            graphics.fillOval(0, 0, this.width, this.height);
            return;
        }
        graphics.setColor(this.getForeground());
        graphics.drawOval(0, 0, n, n2);
    }
}

