/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt.util.spinner;

import java.awt.FontMetrics;
import java.awt.TextComponent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.Enumeration;
import java.util.Vector;
import symantec.itools.awt.util.spinner.Spinner;
import symantec.itools.beans.PropertyChangeSupport;
import symantec.itools.beans.VetoableChangeSupport;
import symantec.itools.util.GeneralUtils;

public class ListSpinner
extends Spinner {
    protected Vector list;
    protected boolean dynamicResizing;
    protected int internalMax;
    protected String oldText = "";
    protected boolean isPossibleEdit = false;
    private boolean editAdding = false;
    private Focus focus;
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public ListSpinner() {
        this.list = new Vector();
        try {
            this.setAllowDynamicResizing(false);
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.max = 10;
        this.updateInternalMax();
        this.updateButtonStatus();
    }

    public void setListItems(String[] stringArray) throws PropertyVetoException {
        String[] stringArray2 = this.getListItems();
        if (!GeneralUtils.objectsEqual(stringArray2, stringArray)) {
            this.vetos.fireVetoableChange("listItems", stringArray2, stringArray);
            this.list = new Vector();
            int n = 0;
            while (n < stringArray.length) {
                this.addItem(stringArray[n]);
                ++n;
            }
            this.updateInternalMax();
            if (!this.isValidCurrentValue(this.getCurrent())) {
                this.setCurrent(this.internalMax);
            }
            this.updateButtonStatus();
            this.updateText(false);
            this.changes.firePropertyChange("listItems", stringArray2, stringArray);
        }
    }

    public String[] getListItems() {
        int n = this.list.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = (String)this.list.elementAt(n2);
            ++n2;
        }
        return stringArray;
    }

    public void setAllowDynamicResizing(boolean bl) throws PropertyVetoException {
        if (this.dynamicResizing != bl) {
            Boolean bl2 = new Boolean(this.dynamicResizing);
            Boolean bl3 = new Boolean(bl);
            this.vetos.fireVetoableChange("allowDynamicResizing", bl2, bl3);
            this.dynamicResizing = bl;
            this.changes.firePropertyChange("allowDynamicResizing", bl2, bl3);
        }
    }

    public boolean isAllowDynamicResizing() {
        return this.dynamicResizing;
    }

    public String getCurrentText() {
        if (this.list.size() > 0) {
            return (String)this.list.elementAt(this.current);
        }
        return "";
    }

    public void setMax(int n) throws PropertyVetoException {
        if (this.max != n) {
            Integer n2 = new Integer(this.max);
            Integer n3 = new Integer(n);
            this.vetos.fireVetoableChange("max", n2, n3);
            this.max = n;
            if (this.getCurrent() > this.max) {
                this.setCurrent(this.max);
            } else {
                this.updateInternalMax();
                this.updateButtonStatus();
            }
            this.changes.firePropertyChange("max", n2, n3);
        }
    }

    public void addNotify() {
        super.addNotify();
        if (this.focus == null) {
            this.focus = new Focus();
            this.textFld.addFocusListener(this.focus);
        }
        if (this.list.size() > 0) {
            Enumeration enumeration = this.list.elements();
            while (enumeration.hasMoreElements()) {
                this.textWidth = Math.max(this.textWidth, ((String)enumeration.nextElement()).length());
            }
            this.text = (String)this.list.elementAt(this.current);
        }
    }

    public synchronized void removeNotify() {
        if (this.focus != null) {
            this.textFld.removeFocusListener(this.focus);
            this.focus = null;
        }
        super.removeNotify();
    }

    public void addItem(String string) {
        this.list.addElement(string);
        this.textWidth = Math.max(this.textWidth, string.length());
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(propertyChangeListener);
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.removePropertyChangeListener(propertyChangeListener);
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        super.addVetoableChangeListener(vetoableChangeListener);
        this.vetos.addVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        super.removeVetoableChangeListener(vetoableChangeListener);
        this.vetos.removeVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized void addMaxListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener("max", propertyChangeListener);
    }

    public synchronized void removeMaxListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener("max", propertyChangeListener);
    }

    public synchronized void addMaxListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.addVetoableChangeListener("max", vetoableChangeListener);
    }

    public synchronized void removeMaxListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.removeVetoableChangeListener("max", vetoableChangeListener);
    }

    protected String truncateContents(String string) {
        if (this.added) {
            FontMetrics fontMetrics = this.getFontMetrics(this.textFld.getFont());
            int n = fontMetrics.stringWidth(string);
            if (n <= 0) {
                return "";
            }
            int n2 = fontMetrics.stringWidth("W");
            int n3 = this.textFld.getPreferredSize((int)1).width - n2;
            int n4 = this.textFld.getSize().width - n3;
            if (n4 < 0) {
                n4 = 0;
            }
            String string2 = string;
            int n5 = string2.length();
            while (n5 > 0 && fontMetrics.stringWidth(string2) > n4 - n2) {
                string2 = string.substring(0, n5);
                --n5;
            }
            if (n5 != string.length()) {
                string2 = String.valueOf(string2) + "...";
                while (n5 > 0 && fontMetrics.stringWidth(string2) > n4 - n2) {
                    string2 = String.valueOf(string.substring(0, n5)) + "...";
                    --n5;
                }
            }
            return string2;
        }
        return "";
    }

    protected void scrollUp() {
        try {
            this.setCurrent(this.current + this.increment);
        }
        catch (PropertyVetoException propertyVetoException) {
            if (this.isWrappable()) {
                try {
                    this.setCurrent(this.min);
                }
                catch (PropertyVetoException propertyVetoException2) {}
            }
            try {
                this.setCurrent(this.internalMax);
            }
            catch (PropertyVetoException propertyVetoException3) {}
        }
        this.updateText(true);
    }

    protected void scrollDown() {
        try {
            this.setCurrent(this.current - this.increment);
        }
        catch (PropertyVetoException propertyVetoException) {
            if (this.isWrappable()) {
                try {
                    this.setCurrent(this.internalMax);
                }
                catch (PropertyVetoException propertyVetoException2) {}
            }
            try {
                this.setCurrent(this.min);
            }
            catch (PropertyVetoException propertyVetoException3) {}
        }
        this.updateText(false);
    }

    protected void updateText(boolean bl) {
        boolean bl2;
        String string = this.getCurrentText();
        String string2 = this.truncateContents(string);
        String string3 = this.textFld.getText();
        boolean bl3 = bl2 = this.list == null || this.list.size() <= 0;
        if (!string3.equals(string2)) {
            if (this.isPossibleEdit && !this.list.contains(string3) && !string3.equals("")) {
                this.editAdding = true;
                this.addItem(string3);
                this.updateInternalMax();
                this.updateButtonStatus();
                string2 = this.truncateContents(this.getCurrentText());
                bl2 = false;
            } else {
                this.editAdding = false;
            }
            if (!bl2) {
                ((TextComponent)this.textFld).setText(string2);
            }
        }
        if (bl2) {
            ((TextComponent)this.textFld).setText("");
        }
    }

    protected boolean isValidCurrentValue(int n) {
        return n >= this.min && n <= this.internalMax;
    }

    protected boolean isValidMaxValue(int n) {
        return n >= this.min && n >= 0;
    }

    protected boolean isValidMinValue(int n) {
        return n <= this.internalMax && n >= 0;
    }

    protected void updateInternalMax() {
        this.internalMax = 0;
        int n = this.list.size();
        if (this.max >= n) {
            if (n > 0) {
                this.internalMax = n - 1;
                return;
            }
        } else {
            this.internalMax = this.max;
        }
    }

    protected void updateButtonStatus() {
        if (this.buttons != null) {
            if (this.isWrappable()) {
                this.buttons.setUpButtonEnabled(true);
                this.buttons.setDownButtonEnabled(true);
                return;
            }
            if (this.current == this.internalMax && this.current == this.min) {
                this.buttons.setUpButtonEnabled(false);
                this.buttons.setDownButtonEnabled(false);
                return;
            }
            if (this.current == this.internalMax) {
                this.buttons.setUpButtonEnabled(false);
                this.buttons.setDownButtonEnabled(true);
                return;
            }
            if (this.current == this.min) {
                this.buttons.setUpButtonEnabled(true);
                this.buttons.setDownButtonEnabled(false);
                return;
            }
            this.buttons.setUpButtonEnabled(true);
            this.buttons.setDownButtonEnabled(true);
        }
    }

    class Focus
    implements FocusListener {
        public void focusGained(FocusEvent focusEvent) {
            if (ListSpinner.this.textFld.isEditable()) {
                ListSpinner.this.isPossibleEdit = true;
                ListSpinner.this.oldText = ListSpinner.this.textFld.getText();
                ((TextComponent)ListSpinner.this.textFld).setText(ListSpinner.this.getCurrentText());
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            ListSpinner.this.updateText(false);
            ListSpinner.this.isPossibleEdit = false;
        }

        Focus() {
            ListSpinner.this = ListSpinner.this;
        }
    }
}

