/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt.util.spinner;

import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import symantec.itools.awt.util.spinner.Spinner;
import symantec.itools.beans.PropertyChangeSupport;
import symantec.itools.beans.VetoableChangeSupport;

public class NumericSpinner
extends Spinner
implements Serializable {
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public NumericSpinner() {
        try {
            this.setIncrement(1);
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.min = 0;
        this.max = 10;
    }

    public void setMin(int n) throws PropertyVetoException {
        super.setMin(n);
        if (this.added) {
            this.textWidth = Math.max(Integer.toString(this.min).length(), Integer.toString(this.max).length());
        }
    }

    public void setMax(int n) throws PropertyVetoException {
        super.setMax(n);
        if (this.added) {
            this.textWidth = Math.max(Integer.toString(this.min).length(), Integer.toString(this.max).length());
        }
    }

    public void setIncrement(int n) throws PropertyVetoException {
        if (this.increment != n) {
            Integer n2 = new Integer(this.increment);
            Integer n3 = new Integer(n);
            this.vetos.fireVetoableChange("increment", n2, n3);
            this.increment = n;
            this.changes.firePropertyChange("increment", n2, n3);
        }
    }

    public int getIncrement() {
        return this.increment;
    }

    public String getCurrentText() {
        return Integer.toString(this.current);
    }

    public void addNotify() {
        this.textWidth = Math.max(Integer.toString(this.min).length(), Integer.toString(this.max).length());
        this.text = Integer.toString(this.current);
        super.addNotify();
        this.updateText(false);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(propertyChangeListener);
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.removePropertyChangeListener(propertyChangeListener);
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        super.addVetoableChangeListener(vetoableChangeListener);
        this.vetos.addVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        super.removeVetoableChangeListener(vetoableChangeListener);
        this.vetos.removeVetoableChangeListener(vetoableChangeListener);
    }

    protected boolean validateText() {
        boolean bl = false;
        try {
            String string = this.textFld.getText();
            Integer n = new Integer(string);
            if (n >= this.min && n <= this.max) {
                bl = true;
            }
        }
        catch (Exception exception) {}
        return bl;
    }
}

