/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt.util.spinner;

import java.awt.AWTEventMulticaster;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import symantec.itools.awt.DirectionButton;
import symantec.itools.awt.Orientation;
import symantec.itools.beans.PropertyChangeSupport;
import symantec.itools.beans.VetoableChangeSupport;

public class SpinButtonPanel
extends Panel
implements Orientation {
    protected int orientation;
    protected boolean notifyWhilePressed;
    protected int delay;
    DirectionButton incBtn;
    DirectionButton decBtn;
    protected ActionListener actionListener;
    private Action action;
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public SpinButtonPanel() {
        super.setLayout(new GridLayout(2, 1, 0, 0));
        this.setSize(104, 51);
        this.incBtn = new DirectionButton();
        try {
            this.incBtn.setDirection(2);
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.incBtn.setBounds(0, 0, 104, 25);
        this.add(this.incBtn);
        this.decBtn = new DirectionButton();
        try {
            this.decBtn.setDirection(3);
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.decBtn.setBounds(0, 25, 104, 25);
        this.add(this.decBtn);
    }

    public void setOrientation(int n) {
        if (n != this.orientation) {
            this.orientation = n;
            switch (this.orientation) {
                case 0: {
                    super.setLayout(new GridLayout(2, 1, 0, 0));
                    break;
                }
                case 1: {
                    super.setLayout(new GridLayout(1, 2, 0, 0));
                    break;
                }
            }
            this.invalidate();
            this.validate();
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setNotifyWhilePressed(boolean bl) throws PropertyVetoException {
        this.incBtn.setNotifyWhilePressed(bl);
        this.decBtn.setNotifyWhilePressed(bl);
    }

    public boolean isNotifyWhilePressed() {
        return this.incBtn.isNotifyWhilePressed();
    }

    public boolean getNotifyWhilePressed() {
        return this.isNotifyWhilePressed();
    }

    public void setDelay(int n) throws PropertyVetoException {
        this.incBtn.setNotifyDelay(n);
        this.decBtn.setNotifyDelay(n);
    }

    public int getDelay() {
        return this.incBtn.getNotifyDelay();
    }

    public void setLayout(LayoutManager layoutManager) {
    }

    public synchronized void setEnabled(boolean bl) {
        if (this.isEnabled() != bl) {
            if (bl) {
                super.enable();
                this.incBtn.setEnabled(true);
                this.decBtn.setEnabled(true);
                return;
            }
            super.disable();
            this.incBtn.setEnabled(false);
            this.decBtn.setEnabled(false);
        }
    }

    public synchronized void enable() {
        this.setEnabled(true);
    }

    public synchronized void disable() {
        this.setEnabled(false);
    }

    public synchronized void setUpButtonEnabled(boolean bl) {
        if (this.isUpButtonEnabled() != bl) {
            if (bl) {
                this.incBtn.setEnabled(true);
                return;
            }
            this.incBtn.setEnabled(false);
        }
    }

    public boolean isUpButtonEnabled() {
        return this.incBtn.isEnabled();
    }

    public synchronized void setDownButtonEnabled(boolean bl) {
        if (this.isDownButtonEnabled() != bl) {
            if (bl) {
                this.decBtn.setEnabled(true);
                return;
            }
            this.decBtn.setEnabled(false);
        }
    }

    public boolean isDownButtonEnabled() {
        return this.decBtn.isEnabled();
    }

    public synchronized void enableUpButton() {
        this.setUpButtonEnabled(true);
    }

    public synchronized void enableDownButton() {
        this.setDownButtonEnabled(true);
    }

    public synchronized void disableUpButton() {
        this.setUpButtonEnabled(false);
    }

    public synchronized void disableDownButton() {
        this.setDownButtonEnabled(false);
    }

    public synchronized void addNotify() {
        super.addNotify();
        if (this.action == null) {
            this.action = new Action();
            this.incBtn.addActionListener(this.action);
            this.decBtn.addActionListener(this.action);
        }
    }

    public synchronized void removeNotify() {
        if (this.action != null) {
            this.incBtn.removeActionListener(this.action);
            this.decBtn.removeActionListener(this.action);
            this.action = null;
        }
        super.removeNotify();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.addVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.removeVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public Dimension getPreferredSize() {
        int n = 0;
        int n2 = 0;
        switch (this.orientation) {
            case 0: {
                n2 = Math.max(this.incBtn.getPreferredSize().width, this.decBtn.getPreferredSize().width);
                n = this.incBtn.getPreferredSize().height + this.decBtn.getPreferredSize().height;
                break;
            }
            case 1: {
                n2 = this.incBtn.getPreferredSize().width + this.decBtn.getPreferredSize().width;
                n = Math.max(this.incBtn.getPreferredSize().height, this.decBtn.getPreferredSize().height);
                break;
            }
        }
        return new Dimension(n2, n);
    }

    protected void sourceActionEvent(String string) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, string));
        }
    }

    class Action
    implements ActionListener,
    Serializable {
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == SpinButtonPanel.this.incBtn) {
                SpinButtonPanel.this.sourceActionEvent("Increment");
                return;
            }
            if (object == SpinButtonPanel.this.decBtn) {
                SpinButtonPanel.this.sourceActionEvent("Decrement");
            }
        }

        Action() {
            SpinButtonPanel.this = SpinButtonPanel.this;
        }
    }
}

