/*
 * Decompiled with CFR 0.152.
 */
package hydrogenic;

public class SpecialFunctions {
    public static final double ln2 = 0.69314718056;
    public static final double EulerG = 0.577215664902;
    public static final double hlfLn2Pi = 0.918938533205;
    public static final double[] b = new double[]{0.0, 0.0833333333333, -0.00277777777778, 7.93650793651E-4, -5.95238095238E-4, 8.41750841751E-4};
    private boolean invokedStandalone = false;

    static double laguerre(int n, int n2, double d) {
        double d2 = 0.0;
        if (n2 < 1) {
            return 1.0;
        }
        if (n2 < 2) {
            return 1.0 + (double)n - d;
        }
        if (n2 < 3) {
            return 1.0 + 0.5 * (double)n * (3.0 + (double)n) - d * (2.0 + (double)n - 0.5 * d);
        }
        double d3 = 1.0 + (double)n - d;
        double d4 = 1.0 + 0.5 * (double)n * (3.0 + (double)n) - d * (2.0 + (double)n - 0.5 * d);
        for (int i = 3; i <= n2; ++i) {
            double d5 = i;
            d2 = ((2.0 * d5 + (double)n - 1.0 - d) * d4 - (d5 + (double)n - 1.0) * d3) / d5;
            d3 = d4;
            d4 = d2;
        }
        return d2;
    }

    static double factorial(int n) {
        double d = 1.0;
        int n2 = n;
        if (n <= 20) {
            for (int i = 1; i <= n2; ++i) {
                d *= (double)n;
                --n;
            }
        } else {
            d = Math.pow(n, n) * Math.exp(-n) * Math.sqrt(Math.PI * 2 * (double)n);
        }
        return d;
    }

    static double legendre(int n, int n2, double d) {
        double d2 = 0.0;
        if (n2 < 0) {
            n2 = -n2;
        }
        if (n2 > n) {
            return 0.0;
        }
        if (n == 0) {
            return 1.0;
        }
        int n3 = n - n2;
        if (d < 0.0) {
            d = -d;
            if (n3 > 2 * (n3 / 2)) {
                return -SpecialFunctions.legendre(n, n2, d);
            }
            return SpecialFunctions.legendre(n, n2, d);
        }
        double d3 = d * d;
        double d4 = 1.0 - d3;
        double d5 = Math.sqrt(d4);
        if (n == 1) {
            if (n2 == 0) {
                return d;
            }
            if (n2 == 1) {
                return d5;
            }
        }
        if (n == 2) {
            if (n2 == 0) {
                return 1.5 * d3 - 0.5;
            }
            if (n2 == 1) {
                return 3.0 * d * d5;
            }
            if (n2 == 2) {
                return 3.0 * d4;
            }
        }
        int n4 = n2 * n2;
        double d6 = n2;
        if (n == n2) {
            return Math.exp(SpecialFunctions.logGamma(2.0 * d6 + 1.0) - d6 * 0.69314718056 - SpecialFunctions.logGamma(d6 + 1.0)) * Math.pow(d5, d6);
        }
        double d7 = 0.0;
        double d8 = Math.exp(0.5 * SpecialFunctions.logGamma(2.0 * d6 + 1.0) - d6 * 0.69314718056 - SpecialFunctions.logGamma(d6 + 1.0)) * Math.pow(d5, d6);
        double d9 = 2 * n2 + 1;
        double d10 = 0.0;
        double d11 = Math.sqrt(d9);
        for (int i = n2 + 1; i <= n; ++i) {
            d2 = (d9 * d * d8 - d10 * d7) / d11;
            d9 += 2.0;
            d10 = d11;
            d11 = Math.sqrt((i + 1) * (i + 1) - n4);
            d7 = d8;
            d8 = d2;
        }
        return Math.exp(0.5 * (SpecialFunctions.logGamma(n + n2 + 1) - SpecialFunctions.logGamma(n - n2 + 1))) * d2;
    }

    static double logGamma(double d) {
        if (d > 10.0) {
            double d2 = 1.0 / (d * d);
            double d3 = d;
            double d4 = (d - 0.5) * Math.log(d) - d + 0.918938533205;
            for (int i = 1; i <= 5; ++i) {
                d4 += b[i] * (d3 *= d2);
            }
            return d4;
        }
        if (d > 0.0) {
            int n = (int)((double)11 - (d -= 1.0));
            double d5 = d + (double)n;
            int n2 = (int)d;
            double d6 = 0.0;
            for (int i = 1; i <= n - 1; ++i) {
                d6 -= Math.log(d5 - (double)i);
            }
            return d6 + SpecialFunctions.logGamma(d5);
        }
        if (d == 0.0) {
            return 0.0;
        }
        return 0.0;
    }

    public static void main(String[] stringArray) {
        SpecialFunctions specialFunctions = new SpecialFunctions();
        specialFunctions.invokedStandalone = true;
    }
}

