/*
 * Decompiled with CFR 0.152.
 */
package sTools;

import sTools.Parser;
import sTools.SDataListener;
import sTools.SDataSource;

public class SDataConnection {
    int series;
    SDataSource ds = null;
    SDataListener dl = null;
    String xStr;
    String yStr;
    Parser xparser = null;
    Parser yparser = null;
    String[] vars = null;

    public SDataConnection(SDataSource sDataSource, SDataListener sDataListener, int n, String string, String string2) {
        this.series = n;
        this.ds = sDataSource;
        this.dl = sDataListener;
        this.xStr = string;
        this.yStr = string2;
        this.vars = sDataSource.getVarStrings();
        this.setXStr(string);
        this.setYStr(string2);
        sDataListener.clearSeries(n);
    }

    public boolean setXStr(String string) {
        this.xStr = string.trim();
        if (this.xStr.equals("") || this.xStr.equals("0")) {
            this.xparser = null;
            return true;
        }
        this.xparser = new Parser(this.vars.length);
        for (int i = 0; i < this.vars.length; ++i) {
            this.xparser.defineVariable(i + 1, this.vars[i]);
        }
        this.xparser.define(this.xStr);
        this.xparser.parse();
        if (this.xparser.getErrorCode() != 0) {
            System.out.println(String.valueOf("Failed to parse horizontal datasource): ").concat(String.valueOf(this.xparser)));
            System.out.println(String.valueOf(String.valueOf(String.valueOf("Parse error: ").concat(String.valueOf(this.xparser.getErrorString()))).concat(String.valueOf(" at function 1, position "))).concat(String.valueOf(this.xparser.getErrorPosition())));
            return false;
        }
        return true;
    }

    public boolean setYStr(String string) {
        this.yStr = string.trim();
        if (this.yStr.equals("") || this.yStr.equals("0")) {
            this.yparser = null;
            return true;
        }
        this.yparser = new Parser(this.vars.length);
        for (int i = 0; i < this.vars.length; ++i) {
            this.yparser.defineVariable(i + 1, this.vars[i]);
        }
        this.yparser.define(this.yStr);
        this.yparser.parse();
        if (this.yparser.getErrorCode() != 0) {
            System.out.println(String.valueOf("Failed to parse vertical datasource: ").concat(String.valueOf(this.yparser)));
            System.out.println(String.valueOf(String.valueOf(String.valueOf("Parse error: ").concat(String.valueOf(this.yparser.getErrorString()))).concat(String.valueOf(" at function 1, position "))).concat(String.valueOf(this.yparser.getErrorPosition())));
            return false;
        }
        return true;
    }

    public void registerDatum() {
        double[][] dArray = this.ds.getVariables();
        if (dArray == null) {
            return;
        }
        int n = dArray.length;
        if (n == 1) {
            double d = 0.0;
            double d2 = 0.0;
            if (this.xparser != null) {
                d = this.xparser.evaluate(dArray[0]);
            }
            if (this.yparser != null) {
                d2 = this.yparser.evaluate(dArray[0]);
            }
            this.dl.addDatum(this.series, d, d2);
            return;
        }
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            if (this.xparser != null) {
                dArray2[i] = this.xparser.evaluate(dArray[i]);
            }
            if (this.yparser == null) continue;
            dArray3[i] = this.yparser.evaluate(dArray[i]);
        }
        this.dl.addData(this.series, dArray2, dArray3);
    }

    public void clearData() {
        this.dl.clearSeries(this.series);
    }

    public void deleteData() {
        this.dl.deleteSeries(this.series);
    }

    public final SDataSource getDataSource() {
        return this.ds;
    }

    public final SDataListener getDataListener() {
        return this.dl;
    }
}

