/*
 * Decompiled with CFR 0.152.
 */
package sTools;

import java.awt.Color;
import java.awt.Component;
import java.awt.SystemColor;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.TextEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import sTools.Format;
import sTools.SNumber_this_textAdapter;

public class SNumber
extends TextField
implements PropertyChangeListener {
    protected PropertyChangeSupport boundSupport;
    private double value = 0.0;
    private String formStr = "%-+6.3g";
    private Format valFormat = new Format("%-+6.3g");
    private boolean validData = true;
    private boolean noColor = false;

    public SNumber(double d) {
        this.boundSupport = new PropertyChangeSupport(this);
        this.value = d;
        ((TextComponent)this).setText(this.valFormat.form(this.value));
        this.addTextListener(new SNumber_this_textAdapter(this));
    }

    public SNumber() {
        this(0.0);
    }

    public void setFormat(String string) {
        if (this.formStr.equals(string)) {
            return;
        }
        this.formStr = string;
        this.valFormat = new Format(string);
        ((TextComponent)this).setText(this.valFormat.form(this.value));
    }

    public String getFormat() {
        return this.formStr;
    }

    public void setValue(double d) {
        this.validData = true;
        if (d == this.value) {
            return;
        }
        double d2 = this.value;
        this.value = d;
        ((TextComponent)this).setText(this.valFormat.form(this.value));
        this.boundSupport.firePropertyChange("DValue", new Double(d2), new Double(this.value));
        if (this.isEditable()) {
            ((Component)this).setBackground(Color.white);
        } else {
            ((Component)this).setBackground(SystemColor.control);
        }
    }

    public double getValue() {
        if (this.noColor) {
            return this.value;
        }
        if (!this.isEditable()) {
            ((Component)this).setBackground(SystemColor.control);
        } else if (!this.validData) {
            ((Component)this).setBackground(Color.red);
        } else {
            ((Component)this).setBackground(Color.white);
        }
        return this.value;
    }

    public boolean isValid() {
        return this.validData;
    }

    public boolean isNoColor() {
        return this.noColor;
    }

    public void setNoColor(boolean bl) {
        this.noColor = bl;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.boundSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.boundSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!this.isEditable()) {
            ((Component)this).setBackground(SystemColor.control);
        } else {
            ((Component)this).setBackground(Color.white);
        }
        if (propertyChangeEvent.getPropertyName().equals("DValue")) {
            Double d = (Double)propertyChangeEvent.getNewValue();
            try {
                if (d == this.value) {
                    return;
                }
                String string = this.valFormat.form(d);
                this.value = Double.valueOf(string);
                ((TextComponent)this).setText(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void this_textValueChanged(TextEvent textEvent) {
        double d = this.value;
        String string = this.getText().trim();
        try {
            this.validData = true;
            if (string != null && string != "") {
                this.value = Double.valueOf(string);
                if (!this.noColor) {
                    ((Component)this).setBackground(Color.yellow);
                }
                if (this.value == d) {
                    return;
                }
                this.boundSupport.firePropertyChange("DValue", new Double(d), new Double(this.value));
            } else {
                if (!this.noColor) {
                    ((Component)this).setBackground(Color.red);
                }
                this.validData = false;
                this.value = d;
            }
        }
        catch (NumberFormatException numberFormatException) {
            if (!this.noColor) {
                ((Component)this).setBackground(Color.red);
            }
            this.validData = false;
            this.value = d;
        }
    }
}

