/*
 * Decompiled with CFR 0.152.
 */
package optics;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import optics.Bench;
import optics.OpticElement;

public final class BeamStop
extends OpticElement {
    int topBlock;
    int bottomBlock;

    public BeamStop(Bench bench, int n, int n2, int n3, int n4, boolean bl, boolean bl2, double d, boolean bl3) {
        super(bench);
        this.resizable = bl3;
        this.info = bl;
        this.noDrag = !bl2;
        this.xPosition = n;
        this.yPosition = n2;
        this.setX((double)this.xPosition / (double)this.bench.pixPerUnit);
        this.setY(((double)this.bench.iheight / 2.0 - (double)this.yPosition) / (double)this.bench.pixPerUnit);
        if (n4 > n3) {
            this.topBlock = n3;
            this.bottomBlock = n4;
        } else {
            this.topBlock = n4;
            this.bottomBlock = n3;
        }
    }

    public double[] transform(double[] dArray, Rectangle rectangle, int n) {
        double d = dArray[0] - (double)(rectangle.height / 2);
        dArray[0] = dArray[0] * this.mat[0][0] + dArray[1] * this.mat[0][1];
        dArray[1] = d * this.mat[1][0] + dArray[1] * this.mat[1][1];
        return dArray;
    }

    public void paint(Graphics graphics, Rectangle rectangle) {
        graphics.setColor(Color.yellow);
        graphics.drawLine(this.xPosition, this.bottomBlock, this.xPosition, this.topBlock);
    }

    public void paintActive(Graphics graphics, Rectangle rectangle) {
        if (!this.noDrag) {
            graphics.setColor(Color.white);
            graphics.fillOval(this.xPosition - 3, this.topBlock - 3, 6, 6);
            graphics.fillOval(this.xPosition - 3, this.bottomBlock - 3, 6, 6);
        }
        if (this.info) {
            graphics.setColor(Color.white);
            graphics.drawString("x = ".concat(String.valueOf(String.valueOf(this.df.format(1.0 * (double)this.xPosition / (double)this.pixPerUnit)))), this.xPosition, rectangle.height - 50);
            graphics.drawString(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.bench.owner.label_top))).append(" ").append(this.df.format(1.0 * (double)this.topBlock / (double)this.pixPerUnit)))), this.xPosition, rectangle.height - 30);
            graphics.drawString(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.bench.owner.label_top))).append(" ").append(this.df.format(1.0 * (double)this.bottomBlock / (double)this.pixPerUnit)))), this.xPosition, rectangle.height - 10);
        }
    }

    public void setBottomBlock(int n) {
        this.bottomBlock = n <= 0 ? 0 : n;
    }

    public void setTopBlock(int n) {
        this.topBlock = n <= 0 ? this.bench.iheight : n;
    }

    public int getBottomBlock() {
        return this.bottomBlock;
    }

    public int getTopBlock() {
        return this.topBlock;
    }

    public int isInside(int n, int n2, Rectangle rectangle) {
        if (n > this.xPosition - 10 && n < this.xPosition + 10 && (n2 > this.topBlock - 5 || n2 < this.bottomBlock + 5)) {
            return 1;
        }
        if (!this.noDrag && n > this.xPosition - 10 && n < this.xPosition + 10 && n2 > this.topBlock - 5 && n2 < this.topBlock + 5) {
            return 2;
        }
        if (!this.noDrag && n > this.xPosition - 10 && n < this.xPosition + 10 && n2 > this.bottomBlock - 5 && n2 < this.bottomBlock + 5) {
            return 3;
        }
        return 0;
    }

    public String getType() {
        return "aperature";
    }
}

