/*
 * Decompiled with CFR 0.152.
 */
package optics;

import java.awt.Rectangle;
import optics.Bench;
import optics.Dielectric;

public final class Refraction
extends Dielectric {
    public Refraction(Bench bench, int n, int n2, double d, int n3, boolean bl, boolean bl2, double d2, boolean bl3) {
        super(bench, n, n2, d, n3, bl, bl2, d2, bl3);
    }

    /*
     * Enabled aggressive block sorting
     */
    public double[] transform(double[] dArray, Rectangle rectangle, int n) {
        if (this.delN == 0.0) {
            return dArray;
        }
        if (this.focalLength == 0.0) {
            return super.transform(dArray, rectangle, n);
        }
        double d = dArray[0] - (double)rectangle.height / 2.0;
        double d2 = Math.atan(dArray[1]);
        double d3 = -Math.atan(Math.abs(d / (double)this.R));
        this.errCode = 0;
        if (Math.abs(d) >= (double)Math.abs(this.R)) {
            this.errCode = 1;
            dArray[1] = 0.0;
            return dArray;
        }
        if (this.R > 0) {
            d3 = -d3;
        }
        if (d < 0.0) {
            d3 = -d3;
        }
        if (Math.abs(d2 += d3) > 1.5707963267948966) {
            dArray[1] = 0.0;
            this.errCode = 1;
            return dArray;
        }
        double d4 = this.indexOfRefraction / (this.delN + this.indexOfRefraction);
        if (n == 1) {
            if (!(Math.abs(d4 * Math.sin(d2)) < 1.0)) {
                dArray[1] = 0.0;
                this.errCode = 1;
                return dArray;
            }
            d2 = Math.asin(Math.sin(d2) * d4);
            d2 -= d3;
        } else {
            if (!(Math.abs(Math.sin(d2) / d4) < 1.0)) {
                dArray[1] = 0.0;
                this.errCode = 1;
                return dArray;
            }
            d2 = Math.asin(Math.sin(d2) / d4);
            d2 -= d3;
        }
        if (Math.abs(d2) > 1.5707963267948966) {
            dArray[1] = 0.0;
            this.errCode = 1;
            return dArray;
        }
        dArray[1] = Math.tan(d2);
        return dArray;
    }
}

