/*
 * Decompiled with CFR 0.152.
 */
package sync;

import java.awt.Graphics;

class Generation {
    static final int numPts = 20;
    private double theta = 0.0;
    private double dTheta = 0.3141592653589793;
    private double x0;
    private double y0;
    private double vx;
    private double vy;
    private double beta;
    private double gamma;
    private int t0;
    public double[] xPts = new double[20];
    public double[] yPts = new double[20];

    public Generation(int n, int n2, int n3) {
        this.x0 = n2;
        this.y0 = n3;
        this.t0 = n;
        this.vx = 0.0;
        this.vx = 0.0;
        this.beta = 0.0;
        this.gamma = 1.0;
    }

    public Generation(int n, double d, double d2, double d3, double d4) {
        this.x0 = d;
        this.y0 = d2;
        this.t0 = n;
        this.vx = d3;
        this.vy = d4;
        this.beta = Math.sqrt(this.vx * this.vx + this.vy * this.vy);
        if (this.beta >= 1.0) {
            this.beta = 0.9999;
        }
        this.gamma = 1.0 / Math.sqrt(1.0 - this.beta * this.beta);
    }

    public void shift(int n, int n2) {
        this.x0 += (double)n;
        this.y0 += (double)n2;
    }

    public void draw(int n, Generation generation, Graphics graphics) {
        if (generation == null) {
            System.out.println("Error:Null nextgen");
        }
        if (graphics == null) {
            return;
        }
        int n2 = n - this.t0;
        double d = n2;
        double d2 = this.vx * (double)n2;
        double d3 = this.vy * (double)n2;
        this.theta = 1.0E-4;
        for (int i = 0; i < 20; ++i) {
            double d4 = Math.atan2(this.vy, this.vx);
            double d5 = Math.atan2(this.gamma * Math.sin(this.theta - d4), Math.cos(this.theta - d4));
            double d6 = Math.cos(d5 + d4);
            double d7 = d6 != 0.0 ? Math.tan(d5 + d4) : (d5 + d4 > 0.0 ? 1000.0 : -1000.0);
            double d8 = d3 - d2 * d7;
            double d9 = (double)4 * d7 * d7 * d8 * d8 - (double)4 * (1.0 + d7 * d7) * (d8 * d8 - d * d);
            double d10 = d6 > 0.0 ? ((double)-2 * d7 * d8 + Math.sqrt(d9)) / ((double)2 * (1.0 + d7 * d7)) : ((double)-2 * d7 * d8 - Math.sqrt(d9)) / ((double)2 * (1.0 + d7 * d7));
            double d11 = d7 * d10 + d8;
            this.xPts[i] = this.x0 + d10;
            this.yPts[i] = this.y0 + d11;
            this.theta += this.dTheta;
            graphics.drawLine((int)this.xPts[i], (int)this.yPts[i], (int)generation.xPts[i], (int)generation.yPts[i]);
        }
    }

    public void draw(int n, int n2, int n3, Graphics graphics) {
        if (graphics == null) {
            return;
        }
        int n4 = n - this.t0;
        double d = n4;
        double d2 = this.vx * (double)n4;
        double d3 = this.vy * (double)n4;
        this.theta = 1.0E-4;
        for (int i = 0; i < 20; ++i) {
            double d4 = Math.atan2(this.vy, this.vx);
            double d5 = Math.atan2(this.gamma * Math.sin(this.theta - d4), Math.cos(this.theta - d4));
            double d6 = Math.cos(d5 + d4);
            double d7 = d6 != 0.0 ? Math.tan(d5 + d4) : (d5 + d4 > 0.0 ? 1000.0 : -1000.0);
            double d8 = d3 - d2 * d7;
            double d9 = (double)4 * d7 * d7 * d8 * d8 - (double)4 * (1.0 + d7 * d7) * (d8 * d8 - d * d);
            double d10 = d6 > 0.0 ? ((double)-2 * d7 * d8 + Math.sqrt(d9)) / ((double)2 * (1.0 + d7 * d7)) : ((double)-2 * d7 * d8 - Math.sqrt(d9)) / ((double)2 * (1.0 + d7 * d7));
            double d11 = d7 * d10 + d8;
            this.xPts[i] = this.x0 + d10;
            this.yPts[i] = this.y0 + d11;
            this.theta += this.dTheta;
            graphics.drawLine((int)this.xPts[i], (int)this.yPts[i], n2, n3);
        }
    }

    static {
        numPts = 20;
    }
}

